/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.DeployCacheHandler;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.Platform;
import com.sun.deploy.config.WebStartConfig;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceObject;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.nativesandbox.NativeSandboxJNLPService;
import com.sun.deploy.net.cookie.DeployCookieSelector;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.net.proxy.DeployProxySelector;
import com.sun.deploy.net.proxy.StaticProxyManager;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.trace.FileTraceListener;
import com.sun.deploy.trace.LoggerTraceListener;
import com.sun.deploy.trace.SocketTraceListener;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.trace.TraceListener;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.ui.ConsoleController;
import com.sun.deploy.uitoolkit.ui.ConsoleTraceListener;
import com.sun.deploy.uitoolkit.ui.ConsoleWindow;
import com.sun.deploy.util.Base64Wrapper;
import com.sun.deploy.util.DeploySysRun;
import com.sun.deploy.util.DeployUIManager;
import com.sun.deploy.util.DialogListener;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.SessionState;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.CacheUtil;
import com.sun.javaws.Globals;
import com.sun.javaws.HtmlOptions;
import com.sun.javaws.JAuthenticator;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.Launcher;
import com.sun.javaws.exceptions.CacheAccessException;
import com.sun.javaws.exceptions.CouldNotLoadArgumentException;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.FailedDownloadingResourceException;
import com.sun.javaws.exceptions.InvalidArgumentException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.JNLParseException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.security.AppContextUtil;
import com.sun.javaws.ui.JavawsSysRun;
import com.sun.javaws.ui.LaunchErrorDialog;
import com.sun.javaws.ui.SplashScreen;
import com.sun.javaws.util.JavawsConsoleController;
import com.sun.javaws.util.JavawsDialogListener;
import com.sun.jnlp.JNLPClassLoader;
import com.sun.jnlp.JnlpLookupStub;
import com.sun.jnlp.NativeSandboxJNLPServiceImpl;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import javax.jnlp.ServiceManager;
import javax.jnlp.ServiceManagerStub;
import javax.net.ssl.SSLException;

public class Main {
    private static boolean _isViewer = false;
    private static boolean _silent = false;
    private static boolean _environmentInitialized = false;
    private static boolean _baselineUpdate = false;
    private static ThreadGroup _mainTG = null;
    private static ThreadGroup _systemTG;
    private static ThreadGroup _securityTG;
    private static ClassLoader _secureContextClassLoader;
    private static ThreadGroup _launchTG;
    private static String _tempfile;
    private static DataInputStream _tckStream;
    private static boolean _verbose;
    private static boolean uninstall;
    private static boolean includeInstalled;
    private static boolean _fix;
    private static boolean _fixShortcut;
    private static boolean _fixPermissions;

    public static void launchApp(String arg, boolean exit) {
        LaunchDesc ld = Main.prepareLaunchDesc(arg, exit);
        if (ld.getLaunchType() == 5) {
            JnlpxArgs.removeArgumentFile(arg);
            String tab = ld.getInternalCommand();
            String[] argv = tab != null && !tab.equals("player") && !tab.equals("viewer") ? new String[]{"-tab", ld.getInternalCommand()} : new String[]{"-viewer"};
            SplashScreen.hide();
            Main.launchJavaControlPanel(argv);
        } else if (Config.get().isValid()) {
            String[] args = new String[]{arg};
            new Launcher(ld).launch(args, exit);
        } else {
            LaunchErrorDialog.show(null, new LaunchDescException(ld, ResourceManager.getString((String)"enterprize.cfg.mandatory", (Object[])new Object[]{Config.get().getEnterpriseString()}), null), exit);
        }
    }

    private static LaunchDesc fromEmbedded(String jnlp, URL docbase, String embedded) {
        if (embedded == null) {
            return null;
        }
        try {
            URL jnlpURL = null;
            try {
                jnlpURL = new URL(jnlp);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            byte[] bytes = Base64Wrapper.decodeFromString((String)embedded);
            return LaunchDownload.updateLaunchDescInCache(LaunchDescFactory.buildDescriptor(bytes, docbase, docbase, jnlpURL), docbase, docbase);
        }
        catch (Exception e) {
            Trace.ignored((Throwable)e);
            return null;
        }
    }

    static void importApp(String app) {
        boolean wasImport = Environment.isImportMode();
        Environment.setImportMode((boolean)true);
        boolean wasSilent = Globals.isSilentMode();
        Globals.setSilentMode(true);
        boolean wasShortcutMode = Globals.isShortcutMode();
        Globals.setCreateShortcut(true);
        Main.launchApp(app, false);
        Environment.setImportMode((boolean)wasImport);
        Globals.setSilentMode(wasSilent);
        Globals.setCreateShortcut(wasShortcutMode);
    }

    public static void launchJavaControlPanel(String[] args) {
        Platform.get().openControlPanel(args);
    }

    public static void uninstallCache(String path) {
        int uninstall_ret = -1;
        try {
            uninstall_ret = Main.uninstall(includeInstalled, path);
        }
        catch (Exception e) {
            LaunchErrorDialog.show(null, e, !Globals.isSilentMode() || Globals.isQuietMode());
        }
        _tempfile = null;
        try {
            Main.systemExit(uninstall_ret);
        }
        catch (ExitException ee) {
            Trace.println((String)("systemExit: " + ee), (TraceLevel)TraceLevel.BASIC);
            Trace.ignoredException((Exception)ee);
        }
    }

    private static Date parseDate(String dateString) {
        Date date = null;
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yy hh:mm a");
        try {
            date = formatter.parse(dateString);
        }
        catch (ParseException pe) {
            ParseException datePE = new ParseException(pe.getMessage() + " " + ResourceManager.getString((String)"launch.error.dateformat"), pe.getErrorOffset());
            LaunchErrorDialog.show(null, datePE, true);
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] parseArgs(String[] args) {
        ArrayList<String> remain = new ArrayList<String>();
        for (int argIndex = 0; argIndex < args.length; ++argIndex) {
            String dateString;
            Date date;
            if (!args[argIndex].startsWith("-")) {
                remain.add(args[argIndex]);
                continue;
            }
            if (args[argIndex].equals("-offline")) {
                JnlpxArgs.SetIsOffline();
                DeployOfflineManager.setForcedOffline((boolean)true);
                continue;
            }
            if (args[argIndex].equals("-online") || args[argIndex].equals("-Xnosplash")) continue;
            if (args[argIndex].equals("-installer")) {
                Environment.setInstallMode((boolean)true);
                continue;
            }
            if (args[argIndex].equals("-uninstall")) {
                uninstall = true;
                includeInstalled = true;
                Environment.setInstallMode((boolean)true);
                Environment.setImportMode((boolean)true);
                continue;
            }
            if (args[argIndex].equals("-clearcache")) {
                uninstall = true;
                includeInstalled = false;
                Environment.setInstallMode((boolean)true);
                Environment.setImportMode((boolean)true);
                continue;
            }
            if (args[argIndex].equals("-import")) {
                Environment.setImportMode((boolean)true);
                continue;
            }
            if (args[argIndex].equals("-quiet")) {
                Globals.setQuietMode(true);
                continue;
            }
            if (args[argIndex].equals("-silent")) {
                _silent = true;
                Globals.setSilentMode(true);
                continue;
            }
            if (args[argIndex].equals("-reverse")) {
                Globals.setReverseMode(true);
                continue;
            }
            if (args[argIndex].equals("-shortcut")) {
                Globals.setCreateShortcut(true);
                if (!_fix) continue;
                _fixShortcut = true;
                continue;
            }
            if (args[argIndex].equals("-association")) {
                Globals.setCreateAssoc(true);
                continue;
            }
            if (args[argIndex].equals("-prompt")) {
                Globals.setShowPrompts(true);
                continue;
            }
            if (args[argIndex].equals("-nocodebase")) {
                Globals.setNoCodebaseMode(true);
                if (argIndex + 1 >= args.length) continue;
                String launchFilePath = args[++argIndex];
                String jnlpHref = null;
                File launchFile = new File(launchFilePath);
                try {
                    HtmlOptions o = HtmlOptions.create(new FileInputStream(launchFile));
                    LaunchDescFactory.setDocBase(o.getDocBase());
                    jnlpHref = o.getAbsoluteHref(LaunchDescFactory.getDerivedCodebase());
                }
                catch (IOException e) {
                    LaunchErrorDialog.show(null, new Throwable("Launch file error", e), true);
                }
                finally {
                    try {
                        Trace.println((String)("Remove LaunchPropFile: " + launchFilePath), (TraceLevel)TraceLevel.BASIC);
                        launchFile.delete();
                    }
                    catch (Exception e) {
                        Trace.ignored((Throwable)e);
                    }
                }
                if (jnlpHref == null) continue;
                remain.add(jnlpHref);
                continue;
            }
            if (args[argIndex].equals("-docbase")) {
                if (argIndex + 1 >= args.length) continue;
                String docbase = args[++argIndex];
                try {
                    LaunchDescFactory.setDocBase(new URL(docbase));
                }
                catch (MalformedURLException mue) {
                    Trace.ignoredException((Exception)mue);
                }
                continue;
            }
            if (args[argIndex].equals("-codebase")) {
                if (argIndex + 1 >= args.length) continue;
                String codebase = args[++argIndex];
                try {
                    new URL(codebase);
                }
                catch (MalformedURLException mue) {
                    LaunchErrorDialog.show(null, mue, true);
                }
                Environment.setImportModeCodebaseOverride((String)codebase);
                continue;
            }
            if (args[argIndex].equals("-timestamp")) {
                if (argIndex + 1 >= args.length || (date = Main.parseDate(dateString = args[++argIndex])) == null) continue;
                Environment.setImportModeTimestamp((Date)date);
                continue;
            }
            if (args[argIndex].equals("-expiration")) {
                if (argIndex + 1 >= args.length || (date = Main.parseDate(dateString = args[++argIndex])) == null) continue;
                Environment.setImportModeExpiration((Date)date);
                continue;
            }
            if (args[argIndex].equals("-system")) {
                Environment.setSystemCacheMode((boolean)true);
                Cache.resetSystemCache();
                continue;
            }
            if (args[argIndex].equals("-secure")) {
                Globals.setSecureMode(true);
                continue;
            }
            if (args[argIndex].equals("-open") || args[argIndex].equals("-print")) {
                if (argIndex + 1 >= args.length) continue;
                String[] applicationArgs = new String[]{args[argIndex++], args[argIndex]};
                Globals.setApplicationArgs(applicationArgs);
                SingleInstanceManager.setActionName((String)applicationArgs[0]);
                SingleInstanceManager.setOpenPrintFilePath((String)applicationArgs[1]);
                continue;
            }
            if (args[argIndex].equals("-viewer")) {
                _isViewer = true;
                continue;
            }
            if (args[argIndex].equals("-verbose")) {
                _verbose = true;
                continue;
            }
            if (args[argIndex].equals("-SSVBaselineUpdate")) {
                _baselineUpdate = true;
                continue;
            }
            if (args[argIndex].equals("-notWebJava")) continue;
            if (args[argIndex].equals("-fix")) {
                _fix = true;
                continue;
            }
            if (args[argIndex].equals("-permissions")) {
                if (!_fix) continue;
                _fixPermissions = true;
                continue;
            }
            Trace.println((String)("unsupported option: " + args[argIndex]), (TraceLevel)TraceLevel.BASIC);
        }
        String[] remaining = new String[remain.size()];
        for (int i = 0; i < remaining.length; ++i) {
            remaining[i] = (String)remain.get(i);
        }
        return remaining;
    }

    private static void initTrace() {
        FileTraceListener ftl;
        SocketTraceListener stl;
        Trace.redirectStdioStderr();
        Trace.resetTraceLevel();
        Trace.clearTraceListeners();
        Trace.setInitialTraceLevel((boolean)Globals.TCKHarnessRun);
        if (_verbose || Globals.TraceBasic) {
            Trace.setEnabled((TraceLevel)TraceLevel.BASIC, (boolean)true);
        }
        if (_verbose || Globals.TraceNetwork) {
            Trace.setEnabled((TraceLevel)TraceLevel.NETWORK, (boolean)true);
        }
        if (_verbose || Globals.TraceCache) {
            Trace.setEnabled((TraceLevel)TraceLevel.CACHE, (boolean)true);
        }
        if (_verbose || Globals.TraceSecurity) {
            Trace.setEnabled((TraceLevel)TraceLevel.SECURITY, (boolean)true);
        }
        if (_verbose || Globals.TraceExtensions) {
            Trace.setEnabled((TraceLevel)TraceLevel.EXTENSIONS, (boolean)true);
        }
        if (_verbose || Globals.TraceTemp) {
            Trace.setEnabled((TraceLevel)TraceLevel.TEMP, (boolean)true);
        }
        if (Config.getStringProperty((String)"deployment.console.startup.mode").equals("SHOW") && !ToolkitStore.get().isHeadless() && !Globals.isQuietMode()) {
            JavawsConsoleController controller = JavawsConsoleController.getInstance();
            ConsoleTraceListener ctl = new ConsoleTraceListener();
            ConsoleWindow console = ToolkitStore.getUI().getConsole((ConsoleController)controller);
            controller.setConsole(console);
            ctl.setConsole(console);
            Trace.addTraceListener((TraceListener)ctl);
            console.clear();
        }
        if ((stl = Main.initSocketTrace()) != null) {
            Trace.addTraceListener((TraceListener)stl);
        }
        if ((ftl = Main.initFileTrace()) != null) {
            Trace.addTraceListener((TraceListener)ftl);
        }
        JavawsConsoleController controller = JavawsConsoleController.getInstance();
        if (Config.getBooleanProperty((String)"deployment.log")) {
            File logFile = null;
            try {
                LoggerTraceListener ltl;
                boolean customedLog = false;
                String logFilename = Config.getStringProperty((String)"deployment.javaws.logFileName");
                File logFileParentDir = new File(Config.getLogDirectory());
                if (logFilename != null && !"".equals(logFilename)) {
                    logFile = new File(logFilename);
                    if (logFile.isDirectory()) {
                        logFile = null;
                    } else {
                        customedLog = true;
                    }
                }
                if ((ltl = LoggerTraceListener.getOrCreateSharedInstance((String)"com.sun.deploy", logFile, (File)logFileParentDir, (String)"javaws", (String)".log", (boolean)customedLog)) != null) {
                    ltl.getLogger().setLevel(Level.ALL);
                    controller.setLogger(ltl.getLogger());
                    Trace.addTraceListener((TraceListener)ltl);
                }
            }
            catch (SecurityException e) {
                Trace.println((String)("can not create log file in directory: " + Config.getLogDirectory()), (TraceLevel)TraceLevel.BASIC);
            }
        }
    }

    private static FileTraceListener initFileTrace() {
        if (Config.getBooleanProperty((String)"deployment.trace")) {
            File traceFile = null;
            String logDir = Config.getLogDirectory();
            String traceFilename = Config.getStringProperty((String)"deployment.javaws.traceFileName");
            boolean customedTrace = false;
            try {
                if (traceFilename != null && !"".equals(traceFilename) && traceFilename.compareToIgnoreCase("TEMP") != 0) {
                    traceFile = new File(traceFilename);
                    if (!traceFile.isDirectory()) {
                        int index = traceFilename.lastIndexOf(File.separator);
                        if (index != -1) {
                            logDir = traceFilename.substring(0, index);
                        }
                        customedTrace = true;
                    } else {
                        traceFile = null;
                    }
                }
                return FileTraceListener.getOrCreateSharedInstance(traceFile, (File)new File(logDir), (String)"javaws", (String)".trace", (boolean)true, (boolean)customedTrace);
            }
            catch (Exception ioe) {
                Trace.println((String)("cannot create trace file in Directory: " + logDir), (TraceLevel)TraceLevel.BASIC);
            }
        }
        return null;
    }

    private static SocketTraceListener initSocketTrace() {
        if (Globals.LogToHost != null) {
            int port;
            String hNamePort = Globals.LogToHost;
            int hostStartidx = 0;
            int hostEndidx = 0;
            if (hNamePort.charAt(0) == '[' && (hostEndidx = hNamePort.indexOf(1, 93)) != -1) {
                hostStartidx = 1;
            } else {
                hostEndidx = hNamePort.indexOf(":");
            }
            String host = hNamePort.substring(hostStartidx, hostEndidx);
            if (host == null) {
                return null;
            }
            try {
                String portS = hNamePort.substring(hNamePort.lastIndexOf(58) + 1);
                port = Integer.parseInt(portS);
            }
            catch (NumberFormatException nfe) {
                port = -1;
            }
            if (port < 0) {
                return null;
            }
            SocketTraceListener stl = new SocketTraceListener(host, port);
            Socket logsocket = stl.getSocket();
            if (Globals.TCKResponse && logsocket != null) {
                try {
                    _tckStream = new DataInputStream(logsocket.getInputStream());
                }
                catch (IOException ioe) {
                    Trace.ignoredException((Exception)ioe);
                }
            }
            return stl;
        }
        return null;
    }

    private static int uninstall(boolean includeInstalled, String arg) {
        if (arg == null) {
            Trace.println((String)"Uninstall all!", (TraceLevel)TraceLevel.BASIC);
            CacheUtil.remove(includeInstalled);
            if (Globals.TCKHarnessRun) {
                Main.tckprintln("Cache Clear Success");
            }
        } else {
            Trace.println((String)("Uninstall: " + arg), (TraceLevel)TraceLevel.BASIC);
            LaunchDesc ld = null;
            try {
                ld = LaunchDescFactory.buildDescriptor(arg);
            }
            catch (IOException io) {
                Trace.ignoredException((Exception)io);
            }
            catch (JNLPException jnlpe) {
                Trace.ignoredException((Exception)jnlpe);
            }
            if (ld != null) {
                if (Globals.showPrompts()) {
                    String appTitle = ld.getInformation().getTitle();
                    String dlgTitle = ResourceManager.getString((String)"uninstall.app.prompt.title");
                    String message = ResourceManager.getString((String)"uninstall.app.prompt.message", (Object[])new Object[]{appTitle});
                    String okBtn = ResourceManager.getString((String)"common.ok_btn");
                    String cancelBtn = ResourceManager.getString((String)"common.cancel_btn");
                    if (ToolkitStore.getUI().showMessageDialog(null, ld.getAppInfo(), 3, dlgTitle, null, message, null, okBtn, cancelBtn, null) != 0) {
                        Trace.println((String)"Uninstall canceled by user.", (TraceLevel)TraceLevel.BASIC);
                        return 0;
                    }
                }
                LocalApplicationProperties lap = null;
                if ((ld.isInstaller() || ld.isLibrary()) && ResourceProvider.get().getResourceObject(arg) != null) {
                    ResourceObject ro = ResourceProvider.get().getResourceObject(arg);
                    lap = ResourceProvider.get().getLocalApplicationProperties(ro.getResourceURL(), ro.getResourceVersion(), true);
                } else {
                    lap = ResourceProvider.get().getLocalApplicationProperties(ld.getCanonicalHome(), null, true);
                }
                if (lap != null) {
                    File jnlpFile = null;
                    try {
                        jnlpFile = new File(arg);
                        if (!jnlpFile.exists()) {
                            URL ref = new URL(arg);
                            jnlpFile = ResourceProvider.get().getCachedJNLPFile(ref, null);
                        }
                    }
                    catch (Exception e) {
                        Trace.ignored((Throwable)e);
                    }
                    if (jnlpFile != null && jnlpFile.exists()) {
                        CacheUtil.remove(jnlpFile, ld, new ArrayList<File>());
                    }
                    if (Globals.TCKHarnessRun) {
                        Main.tckprintln("Cache Clear Success");
                    }
                    return 0;
                }
            }
            Trace.println((String)"Error uninstalling!", (TraceLevel)TraceLevel.BASIC);
            if (Globals.TCKHarnessRun) {
                Main.tckprintln("Cache Clear Failed");
            }
            if (!Globals.isSilentMode() || Globals.isQuietMode()) {
                SplashScreen.hide();
                String title = ResourceManager.getString((String)"uninstall.failedMessageTitle");
                String msg = ResourceManager.getString((String)"uninstall.failedMessage");
                String okBtn = ResourceManager.getString((String)"common.ok_btn");
                String detailBtn = ResourceManager.getString((String)"common.detail.button");
                ToolkitStore.getUI().showMessageDialog(null, null, 0, title, null, msg, null, okBtn, detailBtn, null);
            }
        }
        return 0;
    }

    public static void initializeExecutionEnvironment() {
        String jnlpx_vmargs_encoded;
        if (_environmentInitialized) {
            return;
        }
        _environmentInitialized = true;
        boolean isWindows = Config.getOSName().contains("Windows");
        boolean isMacOSX = Config.getOSName().contains("OS X");
        Environment.setUserAgent((String)Globals.getUserAgent());
        if (isWindows) {
            com.sun.deploy.services.ServiceManager.setService((int)33024);
        } else if (isMacOSX) {
            com.sun.deploy.services.ServiceManager.setService((int)40960);
        } else {
            com.sun.deploy.services.ServiceManager.setService((int)36864);
        }
        Properties p = System.getProperties();
        p.put("http.auth.serializeRequests", "true");
        if (Config.installDeployRMIClassLoaderSpi()) {
            p.put("java.rmi.server.RMIClassLoaderSpi", "com.sun.jnlp.JNLPRMIClassLoaderSpi");
        }
        SystemUtils.installWebstartProtocolHandlers();
        p.setProperty("javawebstart.version", Globals.getComponentName());
        try {
            DeployProxySelector.reset();
            DeployCookieSelector.reset();
        }
        catch (Throwable e) {
            StaticProxyManager.reset();
        }
        DeployOfflineManager.reset();
        if (Config.getBooleanProperty((String)"deployment.security.authenticator")) {
            JAuthenticator ja = JAuthenticator.getInstance(null);
            Authenticator.setDefault((Authenticator)((Object)ja));
        }
        ServiceManager.setServiceManagerStub((ServiceManagerStub)new JnlpLookupStub());
        if (Config.useNativeSandbox(null) && !Platform.get().isNativeSandbox()) {
            Platform.get().setNativeSandboxJNLPService((NativeSandboxJNLPService)new NativeSandboxJNLPServiceImpl());
        }
        Config.setupPackageAccessRestriction();
        UIFactory.setDialogListener((DialogListener)new JavawsDialogListener());
        SystemUtils.setHttpsProtocols((Properties)p);
        JVMParameters jvmParams = new JVMParameters();
        long heapSize = JnlpxArgs.getMaxHeapSize();
        if (heapSize <= 0L) {
            heapSize = JVMParameters.getDefaultHeapSize();
        }
        jvmParams.setMaxHeapSize(heapSize);
        heapSize = JnlpxArgs.getInitialHeapSize();
        if (heapSize > 0L && heapSize != JVMParameters.getDefaultHeapSize()) {
            jvmParams.parse("-Xms" + JVMParameters.unparseMemorySpec((long)heapSize));
        }
        if ((jnlpx_vmargs_encoded = JnlpxArgs.getVMArgs()) != null) {
            jvmParams.addEncodedArguments(jnlpx_vmargs_encoded, true, true, false);
        }
        jvmParams.setDefault(true);
        JVMParameters.setRunningJVMParameters((JVMParameters)jvmParams);
        if (Trace.isEnabled((TraceLevel)TraceLevel.BASIC)) {
            Trace.println((String)("Running JVMParams: " + jvmParams + "\n\t-> " + JVMParameters.getRunningJVMParameters()), (TraceLevel)TraceLevel.BASIC);
        }
    }

    public static void systemExit(int status) throws ExitException {
        try {
            JnlpxArgs.removeArgumentFile(_tempfile);
            SplashScreen.hide();
        }
        catch (Exception e) {
            Trace.ignored((Throwable)e);
        }
        Trace.flush();
        if (!_environmentInitialized && Environment.isJavaPlugin() || "true".equals(System.getProperty("junit.in.progress"))) {
            ExitException ee = new ExitException(new RuntimeException("exit(" + status + ")"), 4);
            throw ee;
        }
        System.exit(status);
    }

    public static boolean isSilent() {
        return _silent;
    }

    public static boolean isUninstall() {
        return uninstall;
    }

    public static boolean isViewer() {
        return _isViewer;
    }

    public static boolean needToFixShortcut() {
        return _fixShortcut;
    }

    public static boolean needToFixPermissions() {
        return _fixPermissions;
    }

    public static boolean needToUpdateBaseline() {
        return _baselineUpdate;
    }

    public static ThreadGroup getLaunchThreadGroup() {
        return _launchTG;
    }

    public static ThreadGroup getSecurityThreadGroup() {
        return _securityTG;
    }

    public static ClassLoader getSecureContextClassLoader() {
        return _secureContextClassLoader;
    }

    public static ThreadGroup getMainThreadGroup() {
        return _mainTG;
    }

    private static void initializeThreadGroups() {
        if (_mainTG == null) {
            _mainTG = Thread.currentThread().getThreadGroup();
        }
        if (_securityTG == null) {
            _systemTG = Thread.currentThread().getThreadGroup();
            while (_systemTG.getParent() != null) {
                _systemTG = _systemTG.getParent();
            }
            _securityTG = new ThreadGroup(_systemTG, "javawsSecurityThreadGroup");
            DeploySysRun.setOverride((DeploySysRun)new JavawsSysRun());
            _launchTG = new ThreadGroup(_systemTG, "javawsApplicationThreadGroup");
        }
    }

    public static synchronized void tckprintln(String msg) {
        String TCK_PREAMBLE = "##TCKHarnesRun##";
        long datetime = System.currentTimeMillis();
        Trace.println((String)("##TCKHarnesRun##:" + datetime + ":" + Runtime.getRuntime().hashCode() + ":" + Thread.currentThread() + ":" + msg));
        if (_tckStream != null) {
            try {
                while (_tckStream.readLong() < datetime) {
                }
            }
            catch (IOException ioe) {
                System.err.println("Warning:Exceptions occurred, while logging to logSocket");
                ioe.printStackTrace(System.err);
            }
        }
        Trace.flush();
    }

    public static void initApp(String[] args) {
        Environment.setEnvironmentType((int)1);
        Platform.get().loadDeployNativeLib();
        for (String arg : args) {
            if (!"-notWebJava".equals(arg)) continue;
            Environment.setIsWebJava((boolean)false);
        }
        Config.get();
        Config.setInstance((Config)new WebStartConfig());
        _secureContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)((Object)JNLPClassLoader.createClassLoader()));
        System.setProperty("javawebstart.version", Globals.getComponentName());
        AppContextUtil.createMainAppContext();
        ToolkitStore.get().warmup();
        Main.initializeThreadGroups();
        try {
            DeployCacheHandler.reset();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void initEnvironment() {
        JnlpxArgs.verify();
        Main.initializeExecutionEnvironment();
    }

    public static String[] prepareArguments(String[] argsin) {
        if (System.getProperty("jnlpx.session.data") != null) {
            SessionState.init((String)System.getProperty("jnlpx.session.data"));
            System.setProperty("jnlpx.session.data", "");
        }
        String[] args = Globals.parseOptions(argsin);
        DeployUIManager.setLookAndFeel();
        args = Main.parseArgs(args);
        if (args.length > 0) {
            _tempfile = args[args.length - 1];
        } else if (!(_fix || uninstall || _isViewer || _baselineUpdate || Environment.isSystemCacheMode())) {
            LaunchErrorDialog.show(null, new InvalidArgumentException(argsin), true);
        }
        if (!_isViewer) {
            Main.initTrace();
        }
        boolean cacheWritable = Cache.canWrite();
        if (Environment.isSystemCacheMode() && (Config.getSystemCacheDirectory() == null || !cacheWritable)) {
            if (Environment.isImportMode() && Globals.isSilentMode()) {
                Environment.setSystemCacheMode((boolean)false);
            } else {
                LaunchErrorDialog.show(null, new CacheAccessException(true), true);
            }
        }
        if (Environment.isImportMode() && !ResourceProvider.get().canCache(null)) {
            if (Globals.isSilentMode()) {
                try {
                    Main.systemExit(-1);
                }
                catch (ExitException ee) {
                    Trace.println((String)("systemExit: " + ee), (TraceLevel)TraceLevel.BASIC);
                    Trace.ignoredException((Exception)ee);
                }
            } else {
                LaunchErrorDialog.show(null, new CacheAccessException(Environment.isSystemCacheMode(), true), true);
            }
        }
        Config.validateSystemCacheDirectory();
        return args;
    }

    public static LaunchDesc prepareLaunchDesc(String arg, boolean exit) {
        Config.get().updateJREs();
        LaunchDesc ld = null;
        try {
            File f;
            JREInfo homeJREInfo = JREInfo.getHomeJRE();
            if (homeJREInfo == null) {
                throw new ExitException(new Exception("Internal Error: no running JRE"), 3);
            }
            String href = System.getProperty("jnlp.application.href");
            if (href != null && !(f = new File(arg)).exists()) {
                arg = href;
            }
            URL docbase = LaunchDescFactory.getDocBase();
            if (HtmlOptions.get() != null) {
                ld = Main.fromEmbedded(arg, docbase, HtmlOptions.get().getEmbedded());
            }
            if (ld == null) {
                ld = docbase != null ? LaunchDescFactory.buildDescriptor(arg, (URL)null, docbase, true) : LaunchDescFactory.buildDescriptor(arg);
            }
            try {
                Resource ce;
                URL fileURL = new URL(arg);
                if ((ld.getRealLocation() == null || Environment.isImportMode() && !URLUtil.sameURLs((URL)fileURL, (URL)ld.getRealLocation())) && (ce = ResourceProvider.get().getCachedResource(fileURL, null)) != null) {
                    ResourceProvider.get().markRetired(ce, true);
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        catch (IOException ioe) {
            JnlpxArgs.removeArgumentFile(arg);
            JNLPException e = new CouldNotLoadArgumentException(arg, ioe);
            if (ioe instanceof SSLException || ioe.getMessage() != null && ioe.getMessage().toLowerCase().indexOf("https") != -1) {
                try {
                    e = new FailedDownloadingResourceException(new URL(arg), null, ioe);
                }
                catch (MalformedURLException mue) {
                    Trace.ignoredException((Exception)mue);
                }
            }
            LaunchErrorDialog.show(null, e, exit);
            return null;
        }
        catch (JNLParseException jpe) {
            JnlpxArgs.removeArgumentFile(arg);
            LaunchErrorDialog.show(null, jpe, exit);
            return null;
        }
        catch (LaunchDescException lde) {
            Trace.println((String)("Error parsing " + arg + ". Try to parse again with codebase from LAP"), (TraceLevel)TraceLevel.BASIC);
            try {
                ld = LaunchDescFactory.buildDescriptor(new File(arg));
                if (ld == null) {
                    throw lde;
                }
            }
            catch (Exception e) {
                JnlpxArgs.removeArgumentFile(arg);
                LaunchErrorDialog.show(null, lde, exit);
                return null;
            }
        }
        catch (Exception e) {
            Trace.ignoredException((Exception)e);
            JnlpxArgs.removeArgumentFile(arg);
            LaunchErrorDialog.show(null, e, exit);
            return null;
        }
        if (Environment.isImportMode()) {
            Environment.setImportModeCodebase((URL)ld.getCodebase());
        }
        return ld;
    }

    static {
        _tempfile = null;
        _tckStream = null;
        _verbose = false;
        uninstall = false;
        includeInstalled = false;
        _fix = false;
        _fixShortcut = false;
        _fixPermissions = false;
    }
}

