/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.exceptions;

import com.sun.deploy.resources.ResourceManager;
import com.sun.javaws.exceptions.DownloadException;
import java.net.URL;

public class ErrorCodeResponseException
extends DownloadException {
    private static final long serialVersionUID = 8579952110318695604L;
    private String _errorLine;
    private int _errorCode;
    private boolean _jreDownload;
    public static final int ERR_10_NO_RESOURCE = 10;
    public static final int ERR_11_NO_VERSION = 11;
    public static final int ERR_20_UNSUP_OS = 20;
    public static final int ERR_21_UNSUP_ARCH = 21;
    public static final int ERR_22_UNSUP_LOCALE = 22;
    public static final int ERR_23_UNSUP_JRE = 23;
    public static final int ERR_99_UNKNOWN = 99;

    public ErrorCodeResponseException(URL location, String versionID, String errorLine) {
        super(location, versionID);
        this._errorLine = errorLine;
        this._jreDownload = false;
        this._errorCode = 99;
        if (this._errorLine != null) {
            try {
                int idx = this._errorLine.indexOf(32);
                if (idx != -1) {
                    this._errorCode = Integer.parseInt(this._errorLine.substring(0, idx));
                }
            }
            catch (NumberFormatException e) {
                this._errorCode = 99;
            }
        }
    }

    public void setJreDownload(boolean flag) {
        this._jreDownload = flag;
    }

    public int getErrorCode() {
        return this._errorCode;
    }

    @Override
    public String getRealMessage() {
        String msg;
        String string = msg = this._jreDownload ? ResourceManager.getString((String)"launch.error.noJre") : "";
        if (this._errorCode != 99) {
            return msg + ResourceManager.getString((String)"launch.error.errorcoderesponse-known", (Object[])new Object[]{this.getResourceString(), this._errorCode, this._errorLine});
        }
        return msg + ResourceManager.getString((String)"launch.error.errorcoderesponse-unknown", (Object[])new Object[]{this.getResourceString()});
    }
}

