/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.xml.XMLAttribute;
import com.sun.deploy.xml.XMLAttributeBuilder;
import com.sun.deploy.xml.XMLNode;
import com.sun.deploy.xml.XMLNodeBuilder;
import com.sun.deploy.xml.XMLable;
import com.sun.javaws.jnl.ParamFilter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;

public class ApplicationDesc
implements XMLable {
    private String _mainClass;
    private String _progressClass;
    private String[] _arguments;
    private String _type;
    private Properties _params;
    private ParamFilter paramFilter;

    public ApplicationDesc(String mainClass, String progressClass, String[] arguments, String type, Properties params) {
        this._mainClass = mainClass;
        this._progressClass = progressClass;
        if (arguments != null) {
            this._arguments = Arrays.copyOf(arguments, arguments.length);
        }
        this._type = type;
        this._params = params;
    }

    public String getMainClass() {
        return this._mainClass;
    }

    public String getProgressClass() {
        return this._progressClass;
    }

    public String getType() {
        return this._type;
    }

    public Properties getParameters() {
        return (Properties)this._params.clone();
    }

    public void setFilteredParams(ParamFilter filter) {
        this.paramFilter = filter;
    }

    public String[] getArguments() {
        return this._arguments == null ? null : Arrays.copyOf(this._arguments, this._arguments.length);
    }

    public void setArguments(String[] arguments) {
        this._arguments = arguments == null ? null : Arrays.copyOf(arguments, arguments.length);
    }

    public XMLNode asXML() {
        XMLAttributeBuilder ab = new XMLAttributeBuilder();
        ab.add("type", this._type);
        ab.add("main-class", this._mainClass);
        ab.add("progress-class", this._progressClass);
        XMLNodeBuilder nb = new XMLNodeBuilder("application-desc", ab.getAttributeList());
        if (this._arguments != null) {
            for (String _argument : this._arguments) {
                nb.add(new XMLNode("argument", null, new XMLNode(_argument), null));
            }
        }
        if (this._params != null) {
            Enumeration<Object> keys = this._params.keys();
            while (keys.hasMoreElements()) {
                String name = (String)keys.nextElement();
                String value = this._params.getProperty(name);
                if (this.paramFilter != null && this.paramFilter.isFiltered(name)) continue;
                nb.add(new XMLNode("param", new XMLAttribute("name", name, new XMLAttribute("value", value)), null, null));
            }
        }
        return nb.getNode();
    }
}

