/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.config.JREInfo;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.URLUtil;
import com.sun.deploy.xml.XMLAttributeBuilder;
import com.sun.deploy.xml.XMLNode;
import com.sun.deploy.xml.XMLNodeBuilder;
import com.sun.deploy.xml.XMLable;
import com.sun.javaws.jnl.ExtDownloadDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.ResourceType;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

public class ExtensionDesc
implements ResourceType {
    private String _name;
    private URL _location;
    private URL _codebase;
    private String _version;
    private ExtDownloadDesc[] _extDownloadDescs;
    private LaunchDesc _extensionLd;

    public ExtensionDesc(String name, URL location, String version, ExtDownloadDesc[] extDownloadDescs) {
        this._name = name;
        this._location = location;
        this._codebase = URLUtil.asPathURL((URL)URLUtil.getBase((URL)location));
        this._version = version;
        if (extDownloadDescs == null) {
            extDownloadDescs = new ExtDownloadDesc[]{};
        }
        this._extDownloadDescs = extDownloadDescs;
        this._extensionLd = null;
    }

    public boolean isInstaller() {
        if (this.getExtensionDesc() != null) {
            return this._extensionLd.isInstaller();
        }
        return false;
    }

    public String getVersion() {
        return this._version;
    }

    public URL getLocation() {
        return this._location;
    }

    public URL getCodebase() {
        return this._codebase;
    }

    public String getName() {
        return this._name;
    }

    ExtDownloadDesc[] getExtDownloadDescs() {
        return this._extDownloadDescs;
    }

    public LaunchDesc getExtensionDesc() {
        if (this._extensionLd == null) {
            try {
                File cachedFile;
                Resource r;
                boolean download = true;
                if (ResourceProvider.get().isCached(this.getLocation(), this.getVersion())) {
                    download = false;
                }
                if ((r = ResourceProvider.get().getJreResource(this.getLocation(), this.getVersion(), download, false, JREInfo.getKnownPlatforms())) != null && (cachedFile = r.getDataFile()) != null) {
                    this._extensionLd = LaunchDescFactory.buildDescriptor(cachedFile, this.getCodebase(), this.getLocation(), this.getLocation());
                }
            }
            catch (Exception e) {
                Trace.ignoredException((Exception)e);
            }
        }
        return this._extensionLd;
    }

    public void setExtensionDesc(LaunchDesc desc) {
        this._extensionLd = desc;
    }

    ResourcesDesc getExtensionResources() {
        return this._extensionLd.getResources();
    }

    Set<String> getExtensionPackages(Set<String> parts, boolean includeEager) {
        HashSet<String> map = new HashSet<String>();
        for (ExtDownloadDesc edd : this._extDownloadDescs) {
            boolean isEager;
            boolean bl = isEager = includeEager && !edd.isLazy();
            if (!isEager && (parts == null || !parts.contains(edd.getPart()))) continue;
            map.add(edd.getExtensionPart());
        }
        return map;
    }

    @Override
    public void visit(ResourceVisitor rv) {
        rv.visitExtensionDesc(this);
    }

    public XMLNode asXML() {
        XMLAttributeBuilder ab = new XMLAttributeBuilder();
        ab.add("href", this._location);
        ab.add("version", this._version);
        ab.add("name", this._name);
        XMLNodeBuilder nb = new XMLNodeBuilder("extension", ab.getAttributeList());
        for (int i = 0; i < this._extDownloadDescs.length; ++i) {
            nb.add((XMLable)this._extDownloadDescs[i]);
        }
        return nb.getNode();
    }
}

