/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.javaws.exceptions.FailedDownloadingResourceException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ResourcesDesc;
import java.io.IOException;
import java.net.URL;

public class JARUpdater {
    private JARDesc _jar = null;
    private boolean _updateChecked = false;
    private boolean _updateAvailable = false;

    public JARUpdater(JARDesc jar) {
        this._jar = jar;
    }

    public synchronized boolean isUpdateAvailable() throws Exception {
        if (!this._updateChecked) {
            Trace.println((String)("JARUpdater: update check for " + this._jar.getLocation().toString()), (TraceLevel)TraceLevel.NETWORK);
            try {
                this._updateAvailable = this.updateCheck();
                this._updateChecked = true;
            }
            catch (Exception e) {
                Trace.ignored((Throwable)e);
                throw e;
            }
        }
        return this._updateAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Resource downloadUpdate() throws Exception {
        if (this.isUpdateAvailable()) {
            Resource r = this.download();
            JARUpdater jARUpdater = this;
            synchronized (jARUpdater) {
                this._updateAvailable = false;
            }
            return r;
        }
        return null;
    }

    private boolean updateCheck() throws JNLPException {
        URL location = this._jar.getLocation();
        String version = this._jar.getVersion();
        boolean update = false;
        if (version != null) {
            return false;
        }
        try {
            update = ResourceProvider.get().isUpdateAvailable(location, version, this.getDownloadType(), null);
        }
        catch (IOException ioe) {
            ResourcesDesc parent = this._jar.getParent();
            LaunchDesc ld = parent == null ? null : parent.getParent();
            throw new FailedDownloadingResourceException(ld, location, null, ioe);
        }
        return update;
    }

    private Resource download() throws JNLPException {
        int downloadType = this.getDownloadType();
        URL location = this._jar.getLocation();
        String version = this._jar.getVersion();
        try {
            return ResourceProvider.get().downloadUpdate(location, version, downloadType, false);
        }
        catch (IOException ioe) {
            throw new FailedDownloadingResourceException(location, version, ioe);
        }
    }

    private int getDownloadType() {
        int downloadType = 256;
        if (this._jar.isNativeLib()) {
            downloadType |= 0x10;
        }
        if (this._jar.isPack200Enabled()) {
            downloadType |= 0x1000;
        }
        return downloadType;
    }
}

