/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.ref.AppModel;
import com.sun.deploy.ref.AppRef;
import com.sun.deploy.ref.CodeInstance;
import com.sun.deploy.ref.CodeRef;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CachedCertificatesHelper;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.ArrayUtil;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.URLUtil;
import com.sun.deploy.util.VersionID;
import com.sun.deploy.util.VersionString;
import com.sun.deploy.xml.XMLAttributeBuilder;
import com.sun.deploy.xml.XMLNode;
import com.sun.deploy.xml.XMLNodeBuilder;
import com.sun.deploy.xml.XMLable;
import com.sun.javaws.HtmlOptions;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.exceptions.JNLPSigningException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.jnl.AppletDesc;
import com.sun.javaws.jnl.ApplicationDesc;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.InstallerDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.JREMatcher;
import com.sun.javaws.jnl.JavaFXAppDesc;
import com.sun.javaws.jnl.JavaFXRuntimeDesc;
import com.sun.javaws.jnl.LDUpdater;
import com.sun.javaws.jnl.LaunchSelection;
import com.sun.javaws.jnl.LibraryDesc;
import com.sun.javaws.jnl.ParamFilter;
import com.sun.javaws.jnl.ResourceType;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.jnl.UpdateDesc;
import com.sun.javaws.jnl.XMLFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

public class LaunchDesc
implements XMLable {
    private final String _specVersion;
    private final String _version;
    private final URL _home;
    private final URL _codebase;
    private final InformationDesc _information;
    private final int _securityModel;
    private final UpdateDesc _update;
    private final ResourcesDesc _resources;
    private final ResourcesDesc _rawResources;
    private final int _launchType;
    private final ApplicationDesc _applicationDesc;
    private final AppletDesc _appletDesc;
    private final JavaFXAppDesc _jfxDesc;
    private final LibraryDesc _libraryDesc;
    private final InstallerDesc _installerDesc;
    private final String _internalCommand;
    private volatile String _source;
    private volatile String _filteredSource;
    private volatile boolean _propsSet;
    private volatile JREInfo _selectedJRE;
    private volatile boolean _signed;
    private volatile LDUpdater _updater;
    private final XMLNode _xmlNode;
    private final CachedCertificatesHelper[] _certificates;
    private volatile String _hashString;
    private volatile boolean _trusted;
    private Object lock = new Object();
    private Object jreMatcherLock = new Object();
    private volatile JARDesc _mainJar;
    private volatile DeploymentRuleSet _drs;
    private volatile JREMatcher _jreMatcher;
    private volatile boolean nestedResourcesProcessed;
    private volatile URL _originalURL;
    private volatile URL _parentURL;
    public static final int SANDBOX_SECURITY = 0;
    public static final int ALLPERMISSIONS_SECURITY = 1;
    public static final int J2EE_APP_CLIENT_SECURITY = 2;
    public static final String SECURE_PARAM_PREFIX = "jnlp.secure.parameter.";
    public static final int APPLICATION_DESC_TYPE = 1;
    public static final int APPLET_DESC_TYPE = 2;
    public static final int LIBRARY_DESC_TYPE = 3;
    public static final int INSTALLER_DESC_TYPE = 4;
    public static final int INTERNAL_TYPE = 5;
    public static final int FXAPP_TYPE = 6;

    public LaunchDesc(String specVersion, URL codebase, URL home, String version, InformationDesc information, int securityModel, CachedCertificatesHelper[] certificates, UpdateDesc update, ResourcesDesc resources, int launchType, ApplicationDesc applicationDesc, AppletDesc appletDesc, JavaFXAppDesc jfxDesc, LibraryDesc libraryDesc, InstallerDesc installerDesc, String internalCommand, XMLNode xmlNode, String source) {
        this(specVersion, codebase, home, version, information, securityModel, certificates, update, resources, launchType, applicationDesc, appletDesc, jfxDesc, libraryDesc, installerDesc, internalCommand, xmlNode, source, null);
    }

    public JARDesc getMainJar() {
        if (this._mainJar == null && this._resources != null) {
            this.addNestedResourcesForRunningJRE();
            this._mainJar = this._resources.getMainJar();
            if (this._mainJar != null) {
                this._mainJar.setLazyDownload(false);
            }
            this.storeVersionsInAppContext();
        }
        return this._mainJar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNestedResourcesForRunningJRE() {
        if (!this.nestedResourcesProcessed) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.nestedResourcesProcessed) {
                    LaunchSelection.addNestedResourcesForRunningJRE(this);
                    this.nestedResourcesProcessed = true;
                }
            }
        }
    }

    public String getDownloadHost() {
        URL location;
        JARDesc jd = this.getMainJar();
        if (jd != null && (location = jd.getLocation()) != null) {
            return location.getHost();
        }
        if (this._codebase != null) {
            return this._codebase.getHost();
        }
        return null;
    }

    public LaunchDesc(String specVersion, URL codebase, URL home, String version, InformationDesc information, int securityModel, CachedCertificatesHelper[] certificates, UpdateDesc update, ResourcesDesc resources, int launchType, ApplicationDesc applicationDesc, AppletDesc appletDesc, JavaFXAppDesc jfxDesc, LibraryDesc libraryDesc, InstallerDesc installerDesc, String internalCommand, XMLNode xmlNode, String source, JREMatcher jreMatcher) {
        this._specVersion = specVersion;
        this._version = version;
        this._codebase = codebase;
        this._home = home;
        this._information = information;
        this._securityModel = securityModel;
        this._update = update;
        this._resources = resources;
        this._launchType = launchType;
        this._applicationDesc = applicationDesc;
        this._appletDesc = appletDesc;
        this._jfxDesc = jfxDesc;
        this._libraryDesc = libraryDesc;
        this._installerDesc = installerDesc;
        this._internalCommand = internalCommand;
        this._xmlNode = xmlNode;
        this._source = source;
        this._signed = false;
        CachedCertificatesHelper[] cachedCertificatesHelperArray = this._certificates = certificates == null ? null : this.cloneCachedCertificates(certificates);
        if (this._resources != null) {
            this._resources.setParent(this);
            this._rawResources = this._resources.clone();
        } else {
            this._rawResources = null;
        }
    }

    public CachedCertificatesHelper[] getCachedCertificates() {
        return this.cloneCachedCertificates(this._certificates);
    }

    private CachedCertificatesHelper[] cloneCachedCertificates(CachedCertificatesHelper[] source) {
        if (source == null) {
            return null;
        }
        CachedCertificatesHelper[] cachedCertificates = new CachedCertificatesHelper[source.length];
        for (int i = 0; i < source.length; ++i) {
            cachedCertificates[i] = new CachedCertificatesHelper(source[i].getTimestamp(), source[i].getCertPath(), source[i].isSignedJNLP());
        }
        return cachedCertificates;
    }

    public URL getSourceURL() {
        return this._originalURL;
    }

    public void setSourceURL(URL u) {
        this._originalURL = u;
    }

    public void setParentURL(URL u) {
        this._parentURL = u;
    }

    public URL getParentURL() {
        return this._parentURL;
    }

    public JREInfo getHomeJRE() {
        return HomeJreInitializer.homeJRE;
    }

    public JREMatcher getJREMatcher() {
        JREMatcher matchImpl = this.getMatchImpl();
        if (!matchImpl.hasBeenRun()) {
            this.selectJRE(matchImpl.getSecureOnly());
        }
        return matchImpl;
    }

    public JREInfo selectJRE(boolean forceSecure) {
        JREMatcher matcher = this.getMatchImpl();
        matcher.setSecureOnly(forceSecure);
        this._selectedJRE = LaunchSelection.selectJRE(this, matcher);
        JREDesc selectedDesc = matcher.getSelectedJREDesc();
        Trace.println((String)("LaunchDesc.selectJRE( returning selected jre: " + this._selectedJRE), (TraceLevel)TraceLevel.BASIC);
        if (0 == this.getSecurityModel() && selectedDesc != null) {
            String badArg = Config.findSecureSignedVmArg((String)selectedDesc.getVmArgs());
            AppInfo ai = this.getAppInfo();
            if (badArg != null) {
                String message = ResourceManager.getString((String)"deployment.blocked.secure.vmarg", (Object[])new Object[]{badArg});
                LaunchDescException lde = new LaunchDescException(this, message, null);
                throw new SecurityException(message, lde);
            }
        }
        return this._selectedJRE;
    }

    public String getSpecVersion() {
        return this._specVersion;
    }

    public URL getCodebase() {
        return this._codebase;
    }

    public URL getDocumentBase() {
        URL docbase;
        if (this.getLaunchType() == 2 && (docbase = this.getAppletDescriptor().getDocumentBase()) != null) {
            return docbase;
        }
        return this.getCodebase();
    }

    public URL getLocation() {
        return this._home;
    }

    public URL getCanonicalHome() {
        if (this._home != null) {
            return this._home;
        }
        if (this._originalURL != null && Environment.isJavaPlugin() && !Environment.isJavawsAppletLifecycle()) {
            return URLUtil.filterProtocols((URL)this._originalURL);
        }
        if (this._resources != null) {
            JARDesc jd = this.getMainJar();
            try {
                if (jd != null) {
                    URL u = HttpUtils.removeQueryStringFromURL((URL)jd.getLocation());
                    return new URL(u.toString() + "jnlp");
                }
                ExtensionDesc[] ed = this._resources.getExtensionDescs();
                if (ed.length > 0) {
                    URL u = HttpUtils.removeQueryStringFromURL((URL)ed[0].getLocation());
                    return new URL(u.toString() + ".jarjnlp");
                }
            }
            catch (MalformedURLException mue) {
                Trace.ignoredException((Exception)mue);
            }
        }
        return null;
    }

    public final URL getRealLocation() {
        if (this._home != null) {
            return this._home;
        }
        if (this._originalURL != null) {
            return URLUtil.filterProtocols((URL)this._originalURL);
        }
        return null;
    }

    private URL getJNLPSrcForAppInfo() {
        URL best = this.getRealLocation();
        if (best == null) {
            best = AppInfo.getJNLPFromUnknownSource();
        }
        return best;
    }

    private URL getAppFromLocation() {
        URL fromLocation = this._home;
        if (fromLocation == null && this._resources != null) {
            JARDesc jd = this.getMainJar();
            try {
                if (jd != null) {
                    URL u = HttpUtils.removeQueryStringFromURL((URL)jd.getLocation());
                    fromLocation = new URL(u.toString() + "jnlp");
                } else {
                    fromLocation = this.getCodebase();
                }
            }
            catch (MalformedURLException mue) {
                Trace.ignoredException((Exception)mue);
            }
        }
        if (fromLocation == null) {
            fromLocation = this._originalURL != null ? URLUtil.filterProtocols((URL)this._originalURL) : this._home;
        }
        return fromLocation;
    }

    public String getSplashCanonicalHome() {
        if (this._home == null) {
            if (this._resources == null) {
                return null;
            }
            JARDesc jd = this.getMainJar();
            return jd != null ? jd.getLocation().toString() + "jnlp" : null;
        }
        return this._home.toString();
    }

    public InformationDesc getInformation() {
        return this._information;
    }

    public String getInternalCommand() {
        return this._internalCommand;
    }

    public int getSecurityModel() {
        return this._securityModel;
    }

    public UpdateDesc getUpdate() {
        return this._update;
    }

    public boolean isSigned() {
        return this._signed;
    }

    public boolean hasIdenticalContent(LaunchDesc other) {
        return this._xmlNode != null && other != null && this._xmlNode.equals((Object)other._xmlNode);
    }

    public boolean hasIdenticalContent(File f) {
        try {
            byte[] bytes = SystemUtils.readBytes((InputStream)new FileInputStream(f), (long)f.length());
            XMLNode node = XMLFormat.parseBits(bytes);
            return this._xmlNode.equals((Object)node);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean equalsTemplate(XMLNode templateNode) {
        return this._xmlNode != null && !XMLFormat.isBlacklisted(templateNode) && this._xmlNode.equalsTemplate((Object)templateNode);
    }

    public boolean checkSigningTemplate(byte[] bytes) throws JNLPSigningException {
        XMLNode node = null;
        try {
            node = XMLFormat.parseBits(bytes);
            if (this.equalsTemplate(node)) {
                this._signed = true;
                return true;
            }
        }
        catch (Exception e) {
            Trace.ignored((Throwable)e);
        }
        throw new JNLPSigningException(this, node == null ? new String(bytes) : node.toString(true));
    }

    public void setTrusted() {
        Trace.println((String)("Mark trusted: " + this._home), (TraceLevel)TraceLevel.SECURITY);
        this._trusted = true;
    }

    public boolean isTrusted() {
        Trace.println((String)("Istrusted: " + this._home + " " + this._trusted), (TraceLevel)TraceLevel.SECURITY);
        return this._trusted;
    }

    public boolean isSecure() {
        return 0 == this.getSecurityModel();
    }

    public boolean isSecureJVMArgs() {
        return this.getJREMatcher().getSelectedJVMParameters().isSecure();
    }

    public ResourcesDesc getResources() {
        return this._resources;
    }

    public boolean arePropsSet() {
        return this._propsSet;
    }

    public void setPropsSet(boolean propsSet) {
        this._propsSet = propsSet;
    }

    public ResourcesDesc getRawResources() {
        return this._rawResources;
    }

    public JREInfo getSelectedJRE() {
        if (this._selectedJRE == null) {
            this.selectJRE(this.getMatchImpl().getSecureOnly());
        }
        return this._selectedJRE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JREMatcher getMatchImpl() {
        if (this._jreMatcher == null) {
            DeploymentRuleSet drs = this.getMainDeploymentRuleSet();
            Object object = this.jreMatcherLock;
            synchronized (object) {
                if (this._jreMatcher == null) {
                    this._jreMatcher = new JREMatcher();
                    this._jreMatcher.setDRSVersion(drs.getVersionString(), drs.isVersionForced());
                }
            }
        }
        return this._jreMatcher;
    }

    public int getLaunchType() {
        return this._launchType;
    }

    public ApplicationDesc getApplicationDescriptor() {
        return this._applicationDesc;
    }

    public AppletDesc getAppletDescriptor() {
        return this._appletDesc;
    }

    public JavaFXAppDesc getJavaFXAppDescriptor() {
        return this._jfxDesc;
    }

    public InstallerDesc getInstallerDescriptor() {
        return this._installerDesc;
    }

    public final boolean isApplication() {
        return this._launchType == 1;
    }

    public final boolean isApplet() {
        return this._launchType == 2;
    }

    public final boolean isLibrary() {
        return this._launchType == 3;
    }

    public final boolean isInstaller() {
        return this._launchType == 4;
    }

    public final boolean isFXAppOnly() {
        return this._launchType == 6;
    }

    public final boolean isFXApp() {
        if (this.getJavaFXAppDescriptor() != null) {
            return true;
        }
        return this._applicationDesc != null && "JavaFx".equalsIgnoreCase(this._applicationDesc.getType());
    }

    public final boolean needFX() {
        return this.isFXApp() || null != this.getJavaFXRuntimeDescriptor();
    }

    public final boolean isApplicationDescriptor() {
        return this.isApplication() || this.isApplet() || this.isFXAppOnly();
    }

    public final String getFXRequest() {
        JavaFXRuntimeDesc jfxd = this.getJavaFXRuntimeDescriptor();
        if (jfxd != null) {
            return jfxd.getVersion();
        }
        if (this.isFXApp()) {
            return "2.0+";
        }
        return null;
    }

    public String getMainClassName() {
        if (this.getJavaFXAppDescriptor() != null) {
            return this.getJavaFXAppDescriptor().getMainClass();
        }
        switch (this.getLaunchType()) {
            case 1: {
                return this.getApplicationDescriptor().getMainClass();
            }
            case 4: {
                return this.getInstallerDescriptor().getMainClass();
            }
            case 2: {
                return this.getAppletDescriptor().getAppletClass();
            }
        }
        return null;
    }

    public String getArgumentsString() {
        Object argString = "";
        String[] args = this.getAppArguments();
        Properties params = this.getAppParameters();
        if (args != null) {
            argString = (String)argString + ArrayUtil.arrayToString((String[])args) + " ";
        }
        if (params != null) {
            argString = (String)argString + ArrayUtil.propertiesToString((Properties)params);
        }
        return argString;
    }

    public String[] getAppArguments() {
        if (this.getJavaFXAppDescriptor() != null) {
            return this.getJavaFXAppDescriptor().getArguments();
        }
        if (this.getApplicationDescriptor() != null) {
            return this.getApplicationDescriptor().getArguments();
        }
        return null;
    }

    public Properties getAppParameters() {
        if (this.getJavaFXAppDescriptor() != null) {
            return this.getJavaFXAppDescriptor().getParameters();
        }
        if (this.getApplicationDescriptor() != null) {
            return this.getApplicationDescriptor().getParameters();
        }
        if (this.getAppletDescriptor() != null) {
            return this.getAppletDescriptor().getParameters();
        }
        return null;
    }

    private void setFilteredParameterList(ParamFilter filtered) {
        if (this.getJavaFXAppDescriptor() != null) {
            this.getJavaFXAppDescriptor().setFilteredParams(filtered);
        } else if (this.getApplicationDescriptor() != null) {
            this.getApplicationDescriptor().setFilteredParams(filtered);
        } else if (this.getAppletDescriptor() != null) {
            this.getAppletDescriptor().setFilteredParams(filtered);
        }
    }

    public boolean isHttps() {
        if (this._codebase != null) {
            return this._codebase.getProtocol().equals("https");
        }
        this.getCanonicalHome();
        if (this._home != null) {
            return this._home.getProtocol().equals("https");
        }
        return false;
    }

    public String getSource() {
        if (this._source == null) {
            this._source = this._xmlNode.toString();
        }
        return this._source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilteredSource() {
        if (this._filteredSource == null) {
            Properties props = new Properties();
            ResourcesDesc rds = this.getResources();
            if (rds != null) {
                props = rds.getResourceProperties();
            }
            Enumeration<?> keys = props.propertyNames();
            ArrayList<String> secureParamKeys = new ArrayList<String>();
            ArrayList<String> insecureParamKeys = new ArrayList<String>();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (!key.startsWith(SECURE_PARAM_PREFIX) || key.length() <= SECURE_PARAM_PREFIX.length()) continue;
                String name = key.substring(SECURE_PARAM_PREFIX.length());
                if ("true".equals(props.getProperty(key))) {
                    secureParamKeys.add(name);
                    continue;
                }
                insecureParamKeys.add(name);
            }
            if (secureParamKeys.isEmpty()) {
                this._filteredSource = this.getSource();
            } else {
                LaunchDesc launchDesc = this;
                synchronized (launchDesc) {
                    this.setFilteredParameterList(new ParamFilter(secureParamKeys, insecureParamKeys));
                    this._filteredSource = this.asXML().toString();
                    this.setFilteredParameterList(null);
                }
            }
        }
        return this._filteredSource;
    }

    public XMLNode getXmlNode() {
        return this._xmlNode;
    }

    public void checkSigning(LaunchDesc signedLd) throws JNLPSigningException {
        if (signedLd == null || !signedLd.getXmlNode().equals((Object)this.getXmlNode())) {
            throw new JNLPSigningException(this, signedLd.getXmlNode().toString(true));
        }
        this._signed = true;
    }

    public boolean isJRESpecified() {
        final boolean[] hasJre = new boolean[1];
        final boolean[] needJre = new boolean[1];
        if (this.getResources() != null) {
            this.getResources().visit(new ResourceVisitor(){

                @Override
                public void visitJARDesc(JARDesc jad) {
                    needJre[0] = true;
                }

                @Override
                public void visitExtensionDesc(ExtensionDesc ed) {
                    needJre[0] = true;
                }

                @Override
                public void visitJREDesc(JREDesc jrd) {
                    hasJre[0] = true;
                }
            });
        }
        if (this._launchType == 1 || this._launchType == 2) {
            needJre[0] = true;
        }
        return hasJre[0] || !needJre[0];
    }

    public AppInfo getAppInfo() {
        String[] appArgs;
        AppInfo ainfo = new AppInfo(this.getLaunchType(), this._information.getTitle(), this._information.getVendor(), this.getAppFromLocation(), this.getJNLPSrcForAppInfo(), null, null, false, false, null, null);
        ainfo.setSecurity(this.isSecure() ? 1 : 2);
        ainfo.setLapURL(this.getCanonicalHome());
        ainfo.setDocumentBase(this._parentURL);
        IconDesc icon = this._information.getIconLocation(48, 0);
        if (icon != null) {
            ainfo.setIconRef(icon.getLocation());
            ainfo.setIconVersion(icon.getVersion());
        }
        ainfo.setSignedJNLPL(this.isSigned());
        JARDesc main = this.getMainJar();
        if (main != null) {
            ainfo.setEMURL(main.getLocation());
            ainfo.setEMVersion(main.getVersion());
        }
        Object ainfoAppArgs = this.getFilteredSource();
        if (HtmlOptions.get() != null && (appArgs = HtmlOptions.get().getHtmlApplicationArgs()) != null) {
            for (int i = 0; i < appArgs.length; ++i) {
                ainfoAppArgs = (String)ainfoAppArgs + "," + appArgs[i];
            }
        }
        ainfo.setAppArgs((String)ainfoAppArgs);
        ainfo.setAppModel(this.getAppModel());
        return ainfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDUpdater getUpdater() {
        if (this._updater == null) {
            LaunchDesc launchDesc = this;
            synchronized (launchDesc) {
                if (this._updater == null) {
                    this._updater = new LDUpdater(this);
                }
            }
        }
        return this._updater;
    }

    protected boolean isNestedResourcesProcessed() {
        return this.nestedResourcesProcessed;
    }

    protected void setNestedResourcesProcessed(boolean value) {
        this.nestedResourcesProcessed = value;
    }

    public String getProgressClassName() {
        String result = null;
        result = this._jfxDesc != null ? this._jfxDesc.getPreloaderClass() : (this._applicationDesc != null ? this._applicationDesc.getProgressClass() : (this._appletDesc != null ? this._appletDesc.getProgressClass() : (this._libraryDesc != null ? this._libraryDesc.getProgressClass() : null)));
        if (result != null) {
            return result;
        }
        final String[] results = new String[1];
        if (this.getResources() != null) {
            this.getResources().visit(new ResourceVisitor(){

                @Override
                public void visitExtensionDesc(ExtensionDesc ed) {
                    LaunchDesc ld = ed.getExtensionDesc();
                    if (ld != null && results[0] == null) {
                        results[0] = ld.getProgressClassName();
                    }
                }
            });
        }
        return results[0];
    }

    public JavaFXRuntimeDesc getJavaFXRuntimeDescriptor() {
        final JavaFXRuntimeDesc[] jfxd = new JavaFXRuntimeDesc[]{null};
        if (this.getResources() != null) {
            this.getResources().visit(new ResourceVisitor(){

                @Override
                public void visitJFXDesc(JavaFXRuntimeDesc jfx) {
                    jfxd[0] = jfx;
                }
            });
        }
        return jfxd[0];
    }

    public boolean isValidSpecificationVersion() {
        VersionString version = new VersionString(this.getSpecVersion());
        return version.contains(new VersionID("9")) || version.contains(new VersionID("8.20")) || version.contains(new VersionID("7.0")) || version.contains(new VersionID("6.0.18")) || version.contains(new VersionID("6.0.10")) || version.contains(new VersionID("6.0")) || version.contains(new VersionID("1.5")) || version.contains(new VersionID("1.0"));
    }

    public URL getHtmlLocation() {
        URL docbase;
        if (this.getLaunchType() == 2 && (docbase = this.getAppletDescriptor().getDocumentBase()) != null) {
            return docbase;
        }
        return null;
    }

    public URL getAnchorURL() {
        JARDesc jd;
        URL loc = this.getRealLocation();
        if (loc == null && (jd = this.getMainJar()) != null) {
            loc = jd.getLocation();
        }
        return loc;
    }

    public URL getMainJarURL() {
        JARDesc jd = this._resources.getMainJar();
        if (jd != null) {
            URL loc = jd.getLocation();
            return URLUtil.getBase((URL)loc);
        }
        return null;
    }

    public static AppRef getJNLPAppRef(LaunchDesc ld) {
        URL loc = ld.getRealLocation();
        URL jnlpLoc = loc != null ? loc : null;
        URL htmlLoc = ld.getHtmlLocation();
        return new AppRef(AppRef.Type.JNLP, ld.getInformation().getTitle(), htmlLoc, jnlpLoc, ld.getAnchorURL(), ld.getHash());
    }

    public String getHash() {
        if (this._hashString == null) {
            this._hashString = SystemUtils.getChecksum((byte[])this.getSource().getBytes(), (String)"SHA-256");
        }
        return this._hashString;
    }

    public DeploymentRuleSet getMainDeploymentRuleSet() {
        if (this._drs == null) {
            JARDesc main = this.getMainJar();
            CodeRef codeRef = main != null ? main.getCodeRef() : new CodeRef(null, null, false, false);
            AppRef appRef = LaunchDesc.getJNLPAppRef(this);
            Trace.println((String)("Jnlp based appRef: " + appRef), (TraceLevel)TraceLevel.RULESET);
            Trace.println((String)("Jnlp based codeRef: " + codeRef), (TraceLevel)TraceLevel.RULESET);
            this._drs = DeploymentRuleSet.findDRS((CodeInstance)new CodeInstance(appRef, codeRef));
        }
        return this._drs;
    }

    public void storeVersionsInAppContext() {
        JARDesc[] jds;
        ResourcesDesc rds = this.getResources();
        if (rds == null) {
            return;
        }
        if (this._updater != null) {
            this._updater.disableUpdatePerPolicyIfNeeded();
        }
        if ((jds = rds.getEagerOrAllJarDescs(true)) == null) {
            return;
        }
        for (int i = 0; i < jds.length; ++i) {
            if (jds[i] == null) continue;
            String ver = jds[i].getVersion();
            URL loc = jds[i].getLocation();
            if (ver != null) {
                ToolkitStore.get().getAppContext().put((Object)("deploy-" + loc.toString()), (Object)ver);
                if (jds[i].isPack200Enabled() || jds[i].isVersionEnabled()) {
                    if (jds[i].isVersionEnabled()) {
                        loc = URLUtil.getEmbeddedVersionURL((URL)loc, (String)ver);
                    }
                    if (jds[i].isPack200Enabled()) {
                        loc = URLUtil.getPack200URL((URL)loc, (boolean)false);
                    }
                    ToolkitStore.get().getAppContext().put((Object)("deploy-" + loc.toString()), (Object)ver);
                }
            }
            if (!jds[i].isLazyDownload()) continue;
            Integer downloadType = LaunchDownload.getDownloadType(jds[i]);
            ToolkitStore.get().getAppContext().put((Object)("deploy-download-type-" + loc.toString()), (Object)downloadType);
        }
    }

    public XMLNode asXML() {
        XMLAttributeBuilder ab = new XMLAttributeBuilder();
        ab.add("spec", this._specVersion);
        ab.add("codebase", this._codebase);
        ab.add("version", this._version);
        ab.add("href", this._home);
        XMLNodeBuilder nb = new XMLNodeBuilder("jnlp", ab.getAttributeList());
        nb.add((XMLable)this._information);
        if (this._securityModel != 0) {
            XMLNode securityNode = null;
            String type = "all-permissions";
            if (this._securityModel == 2) {
                type = "j2ee-application-client-permissions";
            }
            if (this._certificates != null) {
                XMLAttributeBuilder ab1 = new XMLAttributeBuilder();
                ab1.add("signedjnlp", this._certificates[0].isSignedJNLP());
                XMLNodeBuilder sNode = new XMLNodeBuilder("security", null);
                XMLNodeBuilder detailsNode = new XMLNodeBuilder("jfx:details", ab1.getAttributeList());
                for (int i = 0; i < this._certificates.length; ++i) {
                    XMLAttributeBuilder ab2 = new XMLAttributeBuilder();
                    if (this._certificates[i].getTimestamp() != null) {
                        ab2.add("timestamp", "" + this._certificates[i].getTimestamp().getTime());
                    }
                    XMLNodeBuilder n = new XMLNodeBuilder("jfx:certificate-path", ab2.getAttributeList());
                    n.add(new XMLNode(this._certificates[i].exportCertificatesToBase64()));
                    detailsNode.add(n.getNode());
                }
                sNode.add(new XMLNode(type, null));
                sNode.add(detailsNode.getNode());
                securityNode = sNode.getNode();
            } else {
                securityNode = new XMLNode("security", null, new XMLNode(type, null), null);
            }
            nb.add(securityNode);
        }
        nb.add((XMLable)this._update);
        nb.add((XMLable)this._resources);
        nb.add((XMLable)this._applicationDesc);
        nb.add((XMLable)this._appletDesc);
        nb.add((XMLable)this._jfxDesc);
        nb.add((XMLable)this._libraryDesc);
        nb.add((XMLable)this._installerDesc);
        return nb.getNode();
    }

    public String toString() {
        return this.asXML().toString();
    }

    public String getVersion() {
        return this._version;
    }

    private AppModel.SecurityMode getSecurityMode() {
        switch (this.getSecurityModel()) {
            case 0: {
                return AppModel.SecurityMode.SANDBOX;
            }
            case 1: {
                return AppModel.SecurityMode.ALL_PERMISSIONS;
            }
            case 2: {
                return AppModel.SecurityMode.J2EE_APPLICATION_CLIENT_PERMISSIONS;
            }
        }
        return null;
    }

    public AppModel getAppModel() {
        AppModel appModel = new AppModel();
        appModel.setType(this.isApplication() ? AppModel.Type.APPLICATION : AppModel.Type.APPLET);
        appModel.setSecurityMode(this.getSecurityMode());
        appModel.setTitle(this.getInformation().getTitle());
        appModel.setVendor(this.getInformation().getVendor());
        appModel.setDescription(this.getInformation().getDescription(0));
        appModel.setLocation(this.getLocation());
        appModel.setCodebase(this.getCodebase());
        appModel.setMainClass(this.getMainClassName());
        if (this.getResources() != null) {
            for (JARDesc jARDesc : this.getResources().getLocalJarDescs()) {
                appModel.addJarResource(jARDesc.getLocation(), jARDesc.getVersion());
            }
            for (ResourceType resourceType : this.getResources().getExtensionDescs()) {
                appModel.addExtensionResource(((ExtensionDesc)resourceType).getLocation(), ((ExtensionDesc)resourceType).getName());
            }
        }
        return appModel;
    }

    private static class HomeJreInitializer {
        static final JREInfo homeJRE = JREInfo.getHomeJRE();

        private HomeJreInitializer() {
        }
    }
}

