/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.progress;

import com.sun.applet2.preloader.CancelException;
import com.sun.applet2.preloader.Preloader;
import com.sun.applet2.preloader.event.AppletInitEvent;
import com.sun.applet2.preloader.event.ApplicationExitEvent;
import com.sun.applet2.preloader.event.ConfigEvent;
import com.sun.applet2.preloader.event.DownloadErrorEvent;
import com.sun.applet2.preloader.event.DownloadEvent;
import com.sun.applet2.preloader.event.ErrorEvent;
import com.sun.applet2.preloader.event.InitEvent;
import com.sun.applet2.preloader.event.PreloaderEvent;
import com.sun.applet2.preloader.event.UserDeclinedEvent;
import com.sun.deploy.config.Config;
import com.sun.deploy.security.BlockedVersionException;
import com.sun.deploy.security.DeployURLClassLoader;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.Applet2Adapter;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.ui.ComponentRef;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.progress.CustomProgress2PreloaderAdapter;
import com.sun.javaws.progress.PreloaderPostEventListener;
import com.sun.javaws.security.AppContextUtil;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.security.AccessControlContext;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.jnlp.DownloadServiceListener;

public class PreloaderDelegate
extends Preloader
implements DownloadServiceListener {
    private Preloader _pl = null;
    protected ThreadGroup _appThreadGroup = null;
    private boolean isLoaded = true;
    private Exception loadingException = null;
    private boolean isReady = false;
    private boolean okToShutdown = true;
    private static ThreadLocal<Boolean> isUserDeclinedPreloader = new ThreadLocal();
    private final List<PreloaderEvent> pendingEvents = new LinkedList<PreloaderEvent>();
    private PreloaderPostEventListener _listener = null;
    private long lastPercentage = -1L;
    WeakReference<Applet2Adapter> hostAdapterRef = null;
    private String preloaderClassName = null;
    private boolean canStop = false;
    private final ArrayList<Runnable> queue = new ArrayList();
    private Thread progressThread = null;
    private ProgressQueueChecker checker = null;
    private boolean disposed = false;
    int rescaleBaseline = -1;
    private CancelException ce = null;
    private boolean seenUserDeclined = false;

    public void setPostEventListener(PreloaderPostEventListener l) {
        this._listener = l;
    }

    public PreloaderDelegate(Applet2Adapter adapter) {
        Trace.println((String)"Construct preloader delegate", (TraceLevel)TraceLevel.PRELOADER);
        if (adapter != null) {
            Trace.println((String)("Construct preloader delegate adapter=" + adapter.getClass()), (TraceLevel)TraceLevel.PRELOADER);
            this.hostAdapterRef = new WeakReference<Applet2Adapter>(adapter);
            adapter.addCleanupAction(new Runnable(){

                @Override
                public void run() {
                    PreloaderDelegate.this.shutdown();
                }
            });
        }
    }

    private Applet2Adapter getHostAdapter() {
        if (null == this.hostAdapterRef) {
            return null;
        }
        return (Applet2Adapter)this.hostAdapterRef.get();
    }

    public void setPreloaderClass(String clsname) {
        this.preloaderClassName = clsname;
    }

    public Preloader get() {
        return this._pl;
    }

    private synchronized void set(Preloader pl) {
        this._pl = pl;
    }

    public PreloaderDelegate(Preloader preloader) {
        this.set(preloader);
        this._appThreadGroup = Thread.currentThread().getThreadGroup();
        this.markLoaded(null);
        this.markReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initPreloader(final ClassLoader cl, ThreadGroup threadGroup) {
        ToolkitStore.get().getAppContext().put((Object)"preloader_key", (Object)this);
        Runnable constructor = new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setContextClassLoader(cl);
                AppContextUtil.createApplicationAppContext();
                PreloaderDelegate.this.doInitPreloader(cl);
            }
        };
        Thread constructorThread = new Thread(threadGroup, constructor, "preloaderMain");
        constructorThread.setDaemon(true);
        constructorThread.start();
        try {
            constructorThread.join();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this._appThreadGroup = threadGroup;
            this.markReady();
        }
    }

    private Object createUsingDefaultConstructor(Class<?> progressClass) throws Exception {
        return progressClass.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInitPreloader(ClassLoader cl) {
        block22: {
            Exception pendingError = null;
            try {
                Trace.println((String)("Using preloader class: " + this.preloaderClassName + " " + this.getHostAdapter()), (TraceLevel)TraceLevel.PRELOADER);
                if (this.preloaderClassName == null) break block22;
                Trace.println((String)("Checking package name of preloader class: " + this.preloaderClassName), (TraceLevel)TraceLevel.PRELOADER);
                if (!Config.checkPackageAccess((String)this.preloaderClassName, (AccessControlContext)Config.getNoPermissionACC())) {
                    throw new SecurityException("Bad package name of progress-class");
                }
                isUserDeclinedPreloader.set(Boolean.FALSE);
                Class<?> progressClass = Class.forName(this.preloaderClassName, false, cl);
                ClassLoader progressCL = progressClass.getClassLoader();
                if (progressCL == null || !(progressCL instanceof DeployURLClassLoader)) {
                    throw new SecurityException("Invalid preloader-class or progress-class - not using deploy class loader");
                }
                if (isUserDeclinedPreloader.get() == Boolean.TRUE) break block22;
                Trace.println((String)"User accept signed preloader or preloader not signed", (TraceLevel)TraceLevel.PRELOADER);
                if (this.getHostAdapter() != null) {
                    this.set(this.getHostAdapter().instantiatePreloader(progressClass));
                    break block22;
                }
                if (Preloader.class.isAssignableFrom(progressClass)) {
                    Trace.println((String)("Preloader class: " + this.preloaderClassName), (TraceLevel)TraceLevel.PRELOADER);
                    this.set((Preloader)this.createUsingDefaultConstructor(progressClass));
                    break block22;
                }
                if (DownloadServiceListener.class.isAssignableFrom(progressClass)) {
                    Trace.println((String)("CustomProgress: " + this.preloaderClassName), (TraceLevel)TraceLevel.PRELOADER);
                    DownloadServiceListener ds = (DownloadServiceListener)this.createUsingDefaultConstructor(progressClass);
                    this.set(new CustomProgress2PreloaderAdapter(ds));
                    break block22;
                }
                throw new SecurityException("Invalid preloader-class or progress-class");
            }
            catch (BlockedVersionException bve) {
                Trace.print((String)("Skip initialization of custom preloader " + this.preloaderClassName), (TraceLevel)TraceLevel.PRELOADER);
                Trace.ignored((Throwable)bve);
                this.setPreloaderClass(null);
            }
            catch (Exception e) {
                Trace.println((String)("Failure in initialization of custom preloader: " + this.preloaderClassName), (TraceLevel)TraceLevel.PRELOADER);
                Trace.ignored((Throwable)e);
                pendingError = e;
            }
            finally {
                if (this.get() == null) {
                    this.installDefaultPreloader();
                    if (pendingError != null) {
                        try {
                            this.handleEvent((PreloaderEvent)new ErrorEvent(null, "Failed to initialize custom preloader", (Throwable)pendingError));
                            this.filterPendingEventsOnError();
                        }
                        catch (CancelException bve) {}
                    }
                }
                isUserDeclinedPreloader.set(null);
            }
        }
    }

    private synchronized void installDefaultPreloader() {
        Trace.println((String)"Using default preloader", (TraceLevel)TraceLevel.PRELOADER);
        if (this.getHostAdapter() != null) {
            this.set(this.getHostAdapter().instantiatePreloader(null));
        } else {
            this.set(ToolkitStore.get().getDefaultPreloader());
        }
    }

    public ComponentRef getOwnerRef() {
        return new ComponentRef(){

            public Object get() {
                return PreloaderDelegate.this.getOwner();
            }
        };
    }

    public Object getOwner() {
        if (this.get() == null) {
            return null;
        }
        return this.get().getOwner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canStop() {
        ArrayList<Runnable> arrayList = this.queue;
        synchronized (arrayList) {
            return this.canStop;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markCanStop(boolean mode) {
        ArrayList<Runnable> arrayList = this.queue;
        synchronized (arrayList) {
            this.canStop = mode;
            this.queue.notifyAll();
        }
    }

    private synchronized void startProcessingIfNeeded() {
        if (this.progressThread == null) {
            if (this.checker == null) {
                this.checker = new ProgressQueueChecker();
            }
            this.progressThread = new Thread(this._appThreadGroup, this.checker, "ProgressReporter");
            this.progressThread.setDaemon(true);
            this.progressThread.start();
        }
        this.markCanStop(false);
    }

    private synchronized void markReady() {
        this.isReady = true;
        ListIterator<PreloaderEvent> li = this.pendingEvents.listIterator();
        PreloaderEvent de = null;
        while (li.hasNext()) {
            PreloaderEvent pe = li.next();
            if (!(pe instanceof DownloadEvent)) continue;
            de = pe;
        }
        li = this.pendingEvents.listIterator();
        int cnt = 0;
        while (li.hasNext()) {
            PreloaderEvent pe = li.next();
            if (!(pe instanceof DownloadEvent) || pe == de) {
                try {
                    this.deliver(pe);
                }
                catch (CancelException e) {
                    Trace.println((String)("CancelException when preloader is being created. " + e), (TraceLevel)TraceLevel.PRELOADER);
                }
                continue;
            }
            ++cnt;
        }
        Trace.println((String)("Skipped all (" + cnt + ") download events prior to " + de), (TraceLevel)TraceLevel.PRELOADER);
        this.pendingEvents.clear();
    }

    public synchronized void waitTillLoaded() throws IOException, JNLPException, ExitException {
        Trace.println((String)"Enter wait for preloader jars to be loaded ", (TraceLevel)TraceLevel.PRELOADER);
        while (!this.isLoaded && this.loadingException == null) {
            try {
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException ioe) {
                if (this.getHostAdapter().isAlive()) continue;
                return;
            }
        }
        Trace.println((String)("Done with loading of preloader jars. Error=" + this.loadingException), (TraceLevel)TraceLevel.PRELOADER);
        if (this.loadingException != null) {
            if (this.loadingException instanceof IOException) {
                throw (IOException)this.loadingException;
            }
            if (this.loadingException instanceof JNLPException) {
                throw (JNLPException)this.loadingException;
            }
            if (this.loadingException instanceof RuntimeException) {
                if (this.loadingException.getCause() instanceof IOException) {
                    throw (IOException)this.loadingException.getCause();
                }
                if (this.loadingException.getCause() instanceof JNLPException) {
                    throw (JNLPException)this.loadingException.getCause();
                }
                throw new RuntimeException(this.loadingException);
            }
            if (this.loadingException instanceof ExitException) {
                throw (ExitException)this.loadingException;
            }
            throw new RuntimeException(this.loadingException);
        }
    }

    public synchronized void markLoadingStarted() {
        this.isLoaded = false;
    }

    public synchronized void markLoaded(Exception error) {
        Trace.println((String)("Preloader jars loaded. Error state=" + error), (TraceLevel)TraceLevel.PRELOADER);
        this.isLoaded = true;
        this.loadingException = error;
        ((Object)((Object)this)).notifyAll();
    }

    public void upgradingArchive(URL url, String version, int patchPercent, int overall) {
        try {
            this.handleEvent((PreloaderEvent)new DownloadEvent(2, url, version, null, (long)patchPercent, (long)overall, overall));
        }
        catch (CancelException e) {
            throw new RuntimeException(this.ce);
        }
    }

    public void progress(URL url, String version, long readSoFar, long total, int overall) {
        try {
            this.handleEvent((PreloaderEvent)new DownloadEvent(0, url, version, null, readSoFar, total, overall));
        }
        catch (CancelException e) {
            throw new RuntimeException(this.ce);
        }
    }

    public void validating(URL url, String version, long entry, long total, int overall) {
        try {
            this.handleEvent((PreloaderEvent)new DownloadEvent(1, url, version, null, entry, total, overall));
        }
        catch (CancelException e) {
            throw new RuntimeException(this.ce);
        }
    }

    public void downloadFailed(URL url, String version) {
        try {
            this.handleEvent((PreloaderEvent)new DownloadErrorEvent(url, version));
        }
        catch (CancelException e) {
            throw new RuntimeException(this.ce);
        }
    }

    public void extensionDownload(String name, int remaining) {
    }

    public void jreDownload(String versionId, URL location) {
    }

    public void setHeading(String text, boolean singleLine) {
    }

    public void setStatus(String text) {
    }

    public void setVisible(boolean show) {
    }

    public void setProgressBarVisible(boolean isVisible) {
    }

    public void setProgressBarValue(int value) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceFlushForTCK() {
        while (true) {
            ArrayList<Runnable> arrayList = this.queue;
            synchronized (arrayList) {
                block7: {
                    if (this.queue.isEmpty()) {
                        return;
                    }
                    try {
                        this.queue.wait(50L);
                    }
                    catch (InterruptedException e) {
                        if (this.getHostAdapter().isAlive()) break block7;
                        return;
                    }
                }
            }
        }
    }

    private synchronized boolean isOkToShutdown() {
        return this.okToShutdown;
    }

    private synchronized void markOkToShutdown() {
        this.okToShutdown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void shutdown() {
        if (!this.isOkToShutdown()) {
            Trace.println((String)"Preloader not ok to shutdown", (TraceLevel)TraceLevel.PRELOADER);
            return;
        }
        this.markCanStop(true);
        ArrayList<Runnable> arrayList = this.queue;
        synchronized (arrayList) {
            this.queue.clear();
            this.queue.notifyAll();
        }
        this.checker = null;
        this.progressThread = null;
        this.disposed = true;
        this._listener = null;
        this._pl = null;
    }

    private synchronized boolean isReady() {
        return this.isReady;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enQueue(Runnable action) {
        ArrayList<Runnable> arrayList = this.queue;
        synchronized (arrayList) {
            if (!this.disposed) {
                this.queue.add(action);
                Trace.println((String)("Enqueue: " + action.toString()), (TraceLevel)TraceLevel.PRELOADER);
                this.queue.notifyAll();
            }
        }
    }

    synchronized void setPendingException(CancelException ce) {
        this.ce = ce;
    }

    private synchronized CancelException getPendingException() {
        return this.ce;
    }

    private void deliver(final PreloaderEvent pe) throws CancelException {
        if (this.disposed) {
            Trace.println((String)("Preloader disposed, dropping: " + pe), (TraceLevel)TraceLevel.PRELOADER);
            return;
        }
        CancelException e = this.getPendingException();
        if (e != null) {
            this.setPendingException(null);
            throw e;
        }
        final Preloader preloader = this.get();
        if (preloader != null) {
            this.startProcessingIfNeeded();
            if (pe instanceof DownloadEvent) {
                DownloadEvent de = (DownloadEvent)pe;
                if (this.rescaleBaseline == -1) {
                    this.rescaleBaseline = de.getOverallPercentage();
                }
                if (!de.isExplicit()) {
                    de.normalize(this.rescaleBaseline);
                }
            }
            Trace.println((String)("Delivering: " + pe), (TraceLevel)TraceLevel.PRELOADER);
            this.enQueue(new Runnable(){

                @Override
                public void run() {
                    if (pe instanceof ApplicationExitEvent) {
                        PreloaderDelegate.this.shutdown();
                        return;
                    }
                    if (pe instanceof InitEvent && pe.getType() == 1) {
                        PreloaderDelegate.this.markOkToShutdown();
                    }
                    boolean consumed = true;
                    try {
                        try {
                            consumed = preloader.handleEvent(pe);
                        }
                        catch (CancelException ce) {
                            PreloaderDelegate.this.setPendingException(ce);
                        }
                        if (!consumed) {
                            PreloaderDelegate.this.doDefaultEventProcessing(pe);
                        }
                    }
                    catch (Throwable t) {
                        Trace.println((String)("Preloader failed to handle " + pe), (TraceLevel)TraceLevel.PRELOADER);
                        PreloaderDelegate.this.doDefaultEventProcessing((PreloaderEvent)new ErrorEvent(null, t));
                    }
                    if (pe instanceof UserDeclinedEvent) {
                        PreloaderDelegate.this.seenUserDeclined = true;
                    }
                    if (PreloaderDelegate.this._listener != null) {
                        PreloaderDelegate.this._listener.eventHandled(pe);
                    }
                    if (pe instanceof ErrorEvent) {
                        PreloaderDelegate.this.shutdown();
                        Trace.println((String)"Preloader shutdown after ErrorEvent", (TraceLevel)TraceLevel.PRELOADER);
                    }
                }
            });
        } else {
            Trace.println((String)("Dropping " + pe + " because preloader was not created"), (TraceLevel)TraceLevel.PRELOADER);
        }
    }

    private void doDefaultEventProcessing(PreloaderEvent pe) {
        if (this.getHostAdapter() != null) {
            AppletInitEvent aie;
            if (pe instanceof ErrorEvent) {
                ErrorEvent ee = (ErrorEvent)pe;
                Throwable ex = ee.getException();
                if (ex instanceof ExitException) {
                    ex = ((ExitException)ex).getException();
                }
                this.getHostAdapter().doShowError(ee.getValue(), ex, this.seenUserDeclined);
            }
            if (pe instanceof AppletInitEvent && (aie = (AppletInitEvent)pe).getSubtype() == 3) {
                this.getHostAdapter().doShowApplet();
            }
        }
    }

    private synchronized void filterPendingEventsOnError() {
        ListIterator<PreloaderEvent> it = this.pendingEvents.listIterator();
        while (it.hasNext()) {
            PreloaderEvent o = it.next();
            if (!(o instanceof DownloadEvent)) continue;
            it.remove();
        }
    }

    public synchronized boolean handleEvent(PreloaderEvent event) throws CancelException {
        ConfigEvent ce;
        if (event instanceof DownloadEvent) {
            DownloadEvent de = (DownloadEvent)event;
            int p = de.getOverallPercentage();
            if ((long)p == this.lastPercentage && p != 100) {
                return true;
            }
            this.lastPercentage = p;
        } else if (event instanceof ConfigEvent && (ce = (ConfigEvent)event).getAction() == 5) {
            this.lastPercentage = -1L;
        }
        if (this.isReady() && this.get() != null) {
            this.deliver(event);
        } else {
            this.pendingEvents.add(event);
            Trace.println((String)("Added pending event " + this.pendingEvents.size() + ": " + event), (TraceLevel)TraceLevel.PRELOADER);
        }
        return true;
    }

    static /* synthetic */ ArrayList access$600(PreloaderDelegate x0) {
        return x0.queue;
    }

    static /* synthetic */ Applet2Adapter access$700(PreloaderDelegate x0) {
        return x0.getHostAdapter();
    }

    static /* synthetic */ boolean access$800(PreloaderDelegate x0) {
        return x0.canStop();
    }

    static /* synthetic */ Thread access$902(PreloaderDelegate x0, Thread x1) {
        x0.progressThread = x1;
        return x0.progressThread;
    }

    static /* synthetic */ void access$1000(PreloaderDelegate x0) {
        x0.startProcessingIfNeeded();
    }

    public class ProgressQueueChecker
    implements Runnable {
        static final int WAIT_CYCLES = 10;
        private int waitCycles;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public void run() {
            AppContextUtil.createApplicationAppContext();
            Trace.println((String)"Start progressCheck thread", (TraceLevel)TraceLevel.PRELOADER);
            action = null;
            this.waitCycles = 10;
            shouldContinue = true;
            while (shouldContinue) {
                var3_3 = PreloaderDelegate.access$600(PreloaderDelegate.this);
                synchronized (var3_3) {
                    if (PreloaderDelegate.access$600(PreloaderDelegate.this).isEmpty()) {
                        try {
                            PreloaderDelegate.access$600(PreloaderDelegate.this).wait(500L);
                            --this.waitCycles;
                        }
                        catch (InterruptedException ie) {
                            if (PreloaderDelegate.access$700(PreloaderDelegate.this).isAlive()) ** GOTO lbl27
                            return;
                        }
                    } else {
                        try {
                            action = (Runnable)PreloaderDelegate.access$600(PreloaderDelegate.this).remove(0);
                        }
                        catch (ClassCastException cce) {
                            cce.printStackTrace();
                        }
                        finally {
                            PreloaderDelegate.access$600(PreloaderDelegate.this).notifyAll();
                        }
                    }
                }
                try {
                    if (action != null) {
                        action.run();
                        this.waitCycles = 10;
                        action = null;
                    }
                }
                catch (Exception e) {
                    System.err.println("Unexpected exception from progress handler: " + e);
                    e.printStackTrace();
                }
                e /* !! */  = PreloaderDelegate.access$600(PreloaderDelegate.this);
                synchronized (e /* !! */ ) {
                    shouldContinue = PreloaderDelegate.access$800(PreloaderDelegate.this) == false && this.waitCycles != 0 || PreloaderDelegate.access$600(PreloaderDelegate.this).isEmpty() == false;
                }
            }
            Trace.println((String)("Stop progressCheck thread queue.size()=" + PreloaderDelegate.access$600(PreloaderDelegate.this).size()), (TraceLevel)TraceLevel.PRELOADER);
            e /* !! */  = PreloaderDelegate.this;
            synchronized (e /* !! */ ) {
                PreloaderDelegate.access$902(PreloaderDelegate.this, null);
            }
            mayNeedRespawn = false;
            var4_6 = PreloaderDelegate.access$600(PreloaderDelegate.this);
            synchronized (var4_6) {
                mayNeedRespawn = PreloaderDelegate.access$600(PreloaderDelegate.this).isEmpty() == false;
            }
            if (mayNeedRespawn) {
                PreloaderDelegate.access$1000(PreloaderDelegate.this);
            }
        }
    }
}

