/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.security;

import com.sun.applet2.preloader.Preloader;
import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.ref.AppRef;
import com.sun.deploy.ref.CodeInstance;
import com.sun.deploy.ref.CodeRef;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BadCertificateDialog;
import com.sun.deploy.security.BlockedDialog;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.CeilingPolicy;
import com.sun.deploy.security.DeployManifestChecker;
import com.sun.deploy.security.SandboxSecurity;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.javaws.Globals;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.Main;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ShortcutDesc;
import com.sun.jnlp.JNLPClassLoader;
import com.sun.jnlp.JNLPClassLoaderIf;
import com.sun.jnlp.JNLPClassLoaderUtil;
import java.awt.AWTPermission;
import java.io.File;
import java.io.FilePermission;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.cert.CertificateException;
import java.security.cert.CertificateRevokedException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.PropertyPermission;

public class AppPolicy {
    private String _host = null;
    private File _extensionDir = null;
    private static AppPolicy _instance = null;

    public static AppPolicy getInstance() {
        return _instance;
    }

    public static AppPolicy createInstance(String host) {
        if (_instance == null) {
            _instance = new AppPolicy(host);
        }
        return _instance;
    }

    private AppPolicy(String host) {
        this._host = host;
        this._extensionDir = new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "ext");
    }

    public boolean addPermissions(JNLPClassLoaderIf cl, PermissionCollection perms, CodeSource target, boolean addPermissionsFromJNLPFile) throws ExitException {
        Trace.println((String)("JAVAWS AppPolicy Permission requested for: " + target.getLocation()), (TraceLevel)TraceLevel.SECURITY);
        DeploymentRuleSet drs = cl.getDeploymentRuleSet(target.getLocation());
        JARDesc jd = cl.getJarDescFromURL(target.getLocation());
        LaunchDesc ld = null;
        int access = 0;
        boolean trusted = false;
        if (jd != null && jd.getParent() != null) {
            ld = jd.getParent().getParent();
            if (ld != null) {
                access = ld.getSecurityModel();
            }
        } else {
            ld = cl.getLaunchDesc();
            if (target.getCertificates() == null) {
                access = 0;
            } else if (ld != null) {
                access = ld.getSecurityModel();
            }
        }
        if (addPermissionsFromJNLPFile) {
            if (access == 0) {
                this.grantRestrictedAccess(ld, drs, target, cl.getPreloader());
            } else {
                this.grantUnrestrictedAccess(ld, drs, target, cl.getPreloader(), false);
                trusted = true;
                if (access == 1) {
                    CeilingPolicy.addTrustedPermissions((PermissionCollection)perms);
                } else {
                    this.addJ2EEApplicationClientPermissionsObject(perms);
                }
            }
        }
        if (!perms.implies(new AllPermission())) {
            this.addSandboxPermissionsObject(perms, ld != null && ld.getLaunchType() == 2);
        }
        if (ld != null && !ld.arePropsSet()) {
            Properties props = ld.getResources().getResourceProperties();
            Enumeration<Object> keys = props.keys();
            while (keys.hasMoreElements()) {
                String value;
                String name = (String)keys.nextElement();
                if (!Config.isSecureProperty((String)name, (String)(value = props.getProperty(name))) && !ld.isSigned()) continue;
                PropertyPermission perm = new PropertyPermission(name, "write");
                PermissionCollection policyPerms = Policy.getPolicy().getPermissions(target);
                if (perms.implies(perm) || policyPerms.implies(perm)) {
                    System.setProperty(name, value);
                    continue;
                }
                Trace.ignoredException((Exception)new AccessControlException("access denied " + perm, perm));
            }
            ld.setPropsSet(true);
        }
        return trusted;
    }

    private boolean isSuspiciousProperty(String name) {
        if ("javaplugin.user.profile".equals(name)) {
            Trace.println((String)"Property javaplugin.user.profile can not be set as trusted", (TraceLevel)TraceLevel.SECURITY);
            return true;
        }
        return false;
    }

    private void setUnrestrictedProps(LaunchDesc ld) {
        if (!ld.arePropsSet()) {
            Properties props = ld.getResources().getResourceProperties();
            Enumeration<Object> keys = props.keys();
            URL loc = ld.getLocation() != null ? ld.getLocation() : ld.getSourceURL();
            DeploymentRuleSet locDRS = null;
            AppRef appRef = new AppRef(AppRef.Type.DOCBASE, null, loc, null, (URL)null, ld.getHash());
            locDRS = DeploymentRuleSet.findDRS((CodeInstance)new CodeInstance(appRef, new CodeRef(null, null, false, false)));
            while (keys.hasMoreElements()) {
                String value;
                String name = (String)keys.nextElement();
                if (Config.isSecureProperty((String)name, (String)(value = props.getProperty(name))) || ld.isSigned() || locDRS != null && locDRS.allowInsecureProperties() && !Globals.isNoCodebaseMode()) {
                    if (this.isSuspiciousProperty(name)) continue;
                    System.setProperty(name, value);
                    continue;
                }
                Trace.println((String)("Insecure property: (" + name + ", " + value + ") specified in unsigned jnlp file will not be set."));
            }
            ld.setPropsSet(true);
        }
    }

    public void grantRestrictedAccess(LaunchDesc ld, DeploymentRuleSet drs, CodeSource cs, Preloader p) throws ExitException {
        if (ld != null) {
            AppInfo ainfo = ld.getAppInfo();
            try {
                SandboxSecurity.isPermissionGranted((CodeSource)cs, (AppInfo)ainfo, (DeploymentRuleSet)drs, (Preloader)p);
            }
            catch (Exception ex) {
                throw new ExitException("Sandbox permissions not granted", ex, 0);
            }
            catch (Throwable t) {
                Trace.ignored((Throwable)t);
                throw new ExitException("Problem granting sandbox permissions", null, 0);
            }
        }
    }

    public long grantUnrestrictedAccess(LaunchDesc ld, DeploymentRuleSet drs, CodeSource cs, Preloader p, boolean progressOnly) throws ExitException {
        try {
            return this.grantAllPermissions(ld, drs, cs, p, progressOnly);
        }
        catch (JARSigningException jse) {
            BadCertificateDialog.showDialog((CodeSource)cs, (AppInfo)ld.getAppInfo(), (Exception)((Object)jse));
            Main.systemExit(-1);
            return 0L;
        }
    }

    protected void setupAppInfoDTI(AppInfo ainfo, LaunchDesc ld) {
        boolean dti = false;
        if (ld.isApplicationDescriptor()) {
            LocalApplicationProperties lap;
            LocalInstallHandler lih = LocalInstallHandler.getInstance();
            if (lih.isLocalInstallSupported() && (lap = ResourceProvider.get().getLocalApplicationProperties(ld.getCanonicalHome(), null, true)) != null && !lap.getAskedForInstall()) {
                dti = true;
            }
            if (dti) {
                ShortcutDesc sd = ld.getInformation().getShortcut();
                String title = ld.getInformation().getTitle();
                switch (Config.getShortcutValue()) {
                    default: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 1: 
                    case 3: {
                        if (sd != null && title != null && title.length() > 0) {
                            ainfo.setDesktopHint(sd.getDesktop());
                            ainfo.setMenuHint(sd.getMenu());
                            ainfo.setSubmenu(sd.getSubmenu());
                            break;
                        }
                        ainfo.setDesktopHint(false);
                        ainfo.setMenuHint(false);
                    }
                }
                if (lih.isAssociationSupported() && Config.getAssociationValue() == 4) {
                    ainfo.setAssociations(ld.getInformation().getAssociations());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long grantAllPermissions(LaunchDesc ld, DeploymentRuleSet drs, CodeSource cs, Preloader p, boolean progressOnly) throws ExitException, JARSigningException {
        try {
            DeployManifestChecker.verify((DeploymentRuleSet)drs, (URL)cs.getLocation(), (boolean)true, (AppInfo)ld.getAppInfo());
        }
        catch (SecurityException se) {
            Trace.ignored((Throwable)se);
            BlockedDialog.show((AppInfo)ld.getAppInfo(), null, null, (Exception)se, (CodeSource)cs, (DeploymentRuleSet)drs);
        }
        AppInfo ainfo = null;
        try {
            long r;
            boolean fasttrack;
            boolean bl = fasttrack = ld.isTrusted() || Globals.isSecureMode() && ld.isInstaller();
            if (fasttrack) {
                this.setUnrestrictedProps(ld);
                long l = 0L;
                return l;
            }
            ainfo = ld.getAppInfo();
            this.setupAppInfoDTI(ainfo, ld);
            if (ainfo != null && progressOnly) {
                ainfo.setPermissionAttrOverride();
            }
            if ((r = TrustDecider.isAllPermissionGranted((CodeSource)cs, (AppInfo)ainfo, (DeploymentRuleSet)drs, (Preloader)p)) != 0L) {
                this.setUnrestrictedProps(ld);
                if (r != 1L) {
                    long l = r;
                    return l;
                }
                long l = 0L;
                return l;
            }
            Trace.println((String)"We were not granted permission, exiting", (TraceLevel)TraceLevel.SECURITY);
        }
        catch (BlockedException be) {
            throw be;
        }
        catch (CertificateException ce) {
            if (ce.getCause() != null && ce.getCause() instanceof JARSigningException) {
                throw (JARSigningException)ce.getCause();
            }
            if (ce instanceof CertificateRevokedException) {
                BlockedException be = new BlockedException(ResourceManager.getString((String)"security.badcert.blocked.revoked.reason"), (Throwable)ce, cs, ainfo);
                if (Environment.isJavaPlugin()) {
                    throw be;
                }
                BadCertificateDialog.showDialog((CodeSource)cs, (AppInfo)ainfo, (Exception)((Object)be));
            } else {
                BadCertificateDialog.showDialog((CodeSource)cs, (AppInfo)ainfo, (Exception)ce);
            }
        }
        catch (Exception exception) {
            BadCertificateDialog.showDialog((CodeSource)cs, ainfo, (Exception)exception);
        }
        finally {
            if (ainfo != null) {
                ainfo.unsetPermissionAttrOverride();
            }
        }
        Main.systemExit(-1);
        return 0L;
    }

    private void addJ2EEApplicationClientPermissionsObject(PermissionCollection perms) {
        Trace.println((String)"Creating J2EE-application-client-permisisons object", (TraceLevel)TraceLevel.SECURITY);
        perms.add(new AWTPermission("accessClipboard"));
        perms.add(new AWTPermission("accessEventQueue"));
        perms.add(new AWTPermission("showWindowWithoutWarningBanner"));
        perms.add(new RuntimePermission("exitVM"));
        perms.add(new RuntimePermission("loadLibrary"));
        perms.add(new RuntimePermission("queuePrintJob"));
        perms.add(new SocketPermission("*", "connect"));
        perms.add(new SocketPermission("localhost:1024-", "accept,listen"));
        perms.add(new FilePermission("*", "read,write"));
        perms.add(new PropertyPermission("*", "read"));
    }

    private void addSandboxPermissionsObject(PermissionCollection perms, boolean isApplet) {
        String[] secureProps;
        Trace.println((String)"Add sandbox permissions", (TraceLevel)TraceLevel.SECURITY);
        perms.add(new PropertyPermission("java.version", "read"));
        perms.add(new PropertyPermission("java.vendor", "read"));
        perms.add(new PropertyPermission("java.vendor.url", "read"));
        perms.add(new PropertyPermission("java.class.version", "read"));
        perms.add(new PropertyPermission("os.name", "read"));
        perms.add(new PropertyPermission("os.arch", "read"));
        perms.add(new PropertyPermission("os.version", "read"));
        perms.add(new PropertyPermission("file.separator", "read"));
        perms.add(new PropertyPermission("path.separator", "read"));
        perms.add(new PropertyPermission("line.separator", "read"));
        perms.add(new PropertyPermission("java.specification.version", "read"));
        perms.add(new PropertyPermission("java.specification.vendor", "read"));
        perms.add(new PropertyPermission("java.specification.name", "read"));
        perms.add(new PropertyPermission("java.vm.specification.version", "read"));
        perms.add(new PropertyPermission("java.vm.specification.vendor", "read"));
        perms.add(new PropertyPermission("java.vm.specification.name", "read"));
        perms.add(new PropertyPermission("java.vm.version", "read"));
        perms.add(new PropertyPermission("java.vm.vendor", "read"));
        perms.add(new PropertyPermission("java.vm.name", "read"));
        perms.add(new PropertyPermission("mrj.version", "read"));
        perms.add(new PropertyPermission("javawebstart.version", "read"));
        if (JNLPClassLoaderUtil.getInstance() instanceof JNLPClassLoader) {
            perms.add(new RuntimePermission("exitVM"));
        }
        String warningString = "Java " + (isApplet ? "Applet" : "Application") + " Window";
        if (Config.getBooleanProperty((String)"deployment.security.sandbox.awtwarningwindow")) {
            System.setProperty("awt.appletWarning", warningString);
        } else {
            perms.add(new AWTPermission("showWindowWithoutWarningBanner"));
        }
        perms.add(new PropertyPermission("jnlp.*", "read,write"));
        perms.add(new PropertyPermission("javaws.*", "read,write"));
        perms.add(new PropertyPermission("javapi.*", "read,write"));
        for (String secureProp : secureProps = Config.getSecureProperties()) {
            perms.add(new PropertyPermission(secureProp, "read,write"));
        }
        String[] args = Globals.getApplicationArgs();
        if (args != null && args.length == 2) {
            if (args[0].equals("-open")) {
                perms.add(new FilePermission(args[1], "read, write"));
            } else if (args[0].equals("-print")) {
                perms.add(new FilePermission(args[1], "read, write"));
                perms.add(new RuntimePermission("queuePrintJob"));
            }
        }
    }
}

