/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.applet2.preloader.CancelException;
import com.sun.applet2.preloader.Preloader;
import com.sun.applet2.preloader.event.ConfigEvent;
import com.sun.applet2.preloader.event.InitEvent;
import com.sun.applet2.preloader.event.PreloaderEvent;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.javaws.CacheUtil;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.progress.CustomProgress2PreloaderAdapter;
import com.sun.javaws.progress.PreloaderDelegate;
import com.sun.jnlp.JNLPClassLoaderIf;
import com.sun.jnlp.JNLPClassLoaderUtil;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.jar.JarFile;
import javax.jnlp.DownloadService;
import javax.jnlp.DownloadServiceListener;

public final class DownloadServiceImpl
implements DownloadService {
    private static DownloadServiceImpl _sharedInstance = null;
    private DownloadServiceListener _defaultProgressHelper = null;
    private static final AccessControlContext ACC_DOWNLOAD_INSTANCE = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

        @Override
        public AccessControlContext run() {
            Permissions perms = new Permissions();
            FilePermission perm1 = new FilePermission("<<ALL FILES>>", "read,write,delete");
            ((PermissionCollection)perms).add(perm1);
            SocketPermission perm2 = new SocketPermission("*", "connect,resolve");
            ((PermissionCollection)perms).add(perm2);
            RuntimePermission perm3 = new RuntimePermission("modifyThread");
            ((PermissionCollection)perms).add(perm3);
            RuntimePermission perm4 = new RuntimePermission("modifyThreadGroup");
            ((PermissionCollection)perms).add(perm4);
            return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        }
    });

    private DownloadServiceImpl() {
    }

    static synchronized void reset() {
        _sharedInstance = null;
    }

    public static synchronized DownloadServiceImpl getInstance() {
        DownloadServiceImpl.initialize();
        return _sharedInstance;
    }

    public static synchronized void initialize() {
        if (_sharedInstance == null) {
            _sharedInstance = new DownloadServiceImpl();
        }
    }

    public DownloadServiceListener getDefaultProgressWindow() {
        if (this._defaultProgressHelper == null) {
            this._defaultProgressHelper = AccessController.doPrivileged(new PrivilegedAction<DownloadServiceListener>(){

                @Override
                public DownloadServiceListener run() {
                    Preloader dw = ToolkitStore.get().getDefaultPreloader();
                    try {
                        dw.handleEvent((PreloaderEvent)new ConfigEvent(3, JNLPClassLoaderUtil.getInstance().getLaunchDesc().getAppInfo()));
                        dw.handleEvent((PreloaderEvent)new InitEvent(1));
                    }
                    catch (CancelException ce) {
                        Trace.ignoredException((Exception)((Object)ce));
                    }
                    return new PreloaderDelegate(dw);
                }
            }, ACC_DOWNLOAD_INSTANCE);
        }
        return this._defaultProgressHelper;
    }

    public boolean isResourceCached(final URL ref, final String version) {
        Boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                if (DownloadServiceImpl.this.isResourceValid(ref, version) && ResourceProvider.get().isCached(ref, version)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        }, ACC_DOWNLOAD_INSTANCE);
        return result;
    }

    public boolean isPartCached(String part) {
        return this.isPartCached(new String[]{part});
    }

    public boolean isPartCached(final String[] parts) {
        Boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                LaunchDesc ld = JNLPClassLoaderUtil.getInstance().getLaunchDesc();
                ResourcesDesc rd = ld.getResources();
                if (rd == null) {
                    return Boolean.FALSE;
                }
                JARDesc[] jardescs = rd.getPartJars(parts);
                return DownloadServiceImpl.this.isJARInCache(jardescs, true);
            }
        }, ACC_DOWNLOAD_INSTANCE);
        return result;
    }

    public boolean isExtensionPartCached(URL ref, String version, String part) {
        return this.isExtensionPartCached(ref, version, new String[]{part});
    }

    public boolean isExtensionPartCached(final URL ref, final String version, final String[] parts) {
        Boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                LaunchDesc ld = JNLPClassLoaderUtil.getInstance().getLaunchDesc();
                ResourcesDesc resources = ld.getResources();
                if (resources == null) {
                    return Boolean.FALSE;
                }
                JARDesc[] jardescs = resources.getExtensionPart(ref, version, parts);
                return DownloadServiceImpl.this.isJARInCache(jardescs, true);
            }
        }, ACC_DOWNLOAD_INSTANCE);
        return result;
    }

    public void loadResource(final URL ref, final String version, final DownloadServiceListener progress) throws IOException {
        Trace.println((String)(this.getClass().getName() + ".loadResource(" + ref + "," + progress.getClass().getName() + ")"));
        if (this.isResourceValid(ref, version)) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException {
                        CustomProgress2PreloaderAdapter cppa = new CustomProgress2PreloaderAdapter(progress);
                        PreloaderDelegate ph = DownloadServiceImpl.this.getProgressHelper(cppa);
                        ResourceProvider provider = ResourceProvider.get();
                        int level = provider.incrementInternalUse();
                        try {
                            JNLPClassLoaderIf cl = JNLPClassLoaderUtil.getInstance();
                            if (ref.toString().endsWith(".jar")) {
                                cl.addResource(ref, version, null);
                                if (!DownloadServiceImpl.this.isResourceCached(ref, version)) {
                                    LaunchDownload.downloadResource(cl.getLaunchDesc(), ref, version, ph, true);
                                }
                            } else {
                                Resource r = provider.getResource(ref, version);
                                if (r.isJNLPFile()) {
                                    DownloadServiceImpl.this.loadResourceRecursivly(r, progress);
                                } else if (r.isJarFile()) {
                                    cl.addResource(ref, version, null);
                                }
                            }
                        }
                        catch (Exception e) {
                            throw new IOException(e.getMessage());
                        }
                        finally {
                            ph.forceFlushForTCK();
                            provider.decrementInternalUse(level);
                        }
                        return null;
                    }
                }, ACC_DOWNLOAD_INSTANCE);
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getException();
            }
        }
    }

    private void loadResourceRecursivly(Resource ceJnlp, final DownloadServiceListener progress) {
        try {
            File jnlpFile = new File(ceJnlp.getResourceFilename());
            URL jnlpUrl = new URL(ceJnlp.getURL());
            LaunchDesc ld = LaunchDescFactory.buildDescriptor(jnlpFile, null, null, jnlpUrl);
            ResourcesDesc rsd = ld.getResources();
            if (rsd != null) {
                rsd.visit(new ResourceVisitor(){

                    @Override
                    public void visitJARDesc(JARDesc jad) {
                        try {
                            DownloadServiceImpl.this.loadResource(jad.getLocation(), jad.getVersion(), progress);
                        }
                        catch (IOException ioe) {
                            Trace.ignored((Throwable)ioe);
                        }
                    }

                    @Override
                    public void visitExtensionDesc(ExtensionDesc ed) {
                        try {
                            DownloadServiceImpl.this.loadResource(ed.getLocation(), ed.getVersion(), progress);
                        }
                        catch (IOException ioe) {
                            Trace.ignored((Throwable)ioe);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            Trace.ignored((Throwable)e);
        }
    }

    public void loadPart(String part, DownloadServiceListener progress) throws IOException {
        this.loadPart(new String[]{part}, progress);
    }

    public void loadPart(final String[] parts, final DownloadServiceListener progress) throws IOException {
        Trace.println((String)(this.getClass().getName() + ".loadPart(" + Arrays.asList(parts) + "," + progress.getClass().getName() + ")"), (TraceLevel)TraceLevel.TEMP);
        if (this.isPartCached(parts)) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    CustomProgress2PreloaderAdapter cppa = new CustomProgress2PreloaderAdapter(progress);
                    PreloaderDelegate ph = DownloadServiceImpl.this.getProgressHelper(cppa);
                    try {
                        LaunchDownload.downloadParts(JNLPClassLoaderUtil.getInstance().getLaunchDesc(), parts, ph, true);
                    }
                    catch (Exception e) {
                        throw new IOException(e.getMessage());
                    }
                    finally {
                        ph.forceFlushForTCK();
                    }
                    return null;
                }
            }, ACC_DOWNLOAD_INSTANCE);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    public void loadExtensionPart(URL ref, String version, String part, DownloadServiceListener progress) throws IOException {
        this.loadExtensionPart(ref, version, new String[]{part}, progress);
    }

    public void loadExtensionPart(final URL ref, final String version, final String[] parts, final DownloadServiceListener progress) throws IOException {
        try {
            Trace.println((String)(this.getClass().getName() + ".loadExtensionPart(" + Arrays.asList(parts) + "," + progress.getClass().getName() + ")"));
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    CustomProgress2PreloaderAdapter cppa = new CustomProgress2PreloaderAdapter(progress);
                    PreloaderDelegate ph = DownloadServiceImpl.this.getProgressHelper(cppa);
                    try {
                        LaunchDownload.downloadExtensionPart(JNLPClassLoaderUtil.getInstance().getLaunchDesc(), ref, version, parts, ph, true);
                    }
                    catch (Exception e) {
                        throw new IOException(e.getMessage());
                    }
                    finally {
                        ph.forceFlushForTCK();
                    }
                    return null;
                }
            }, ACC_DOWNLOAD_INSTANCE);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    public void removeResource(final URL ref, final String version) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    if (DownloadServiceImpl.this.isResourceValid(ref, version)) {
                        Resource r;
                        if (ref.toString().endsWith("jnlp")) {
                            CacheUtil.remove(Cache.getCacheEntry((URL)ref, (String)version));
                        }
                        if ((r = ResourceProvider.get().getCachedResource(ref, version)) != null) {
                            ResourceProvider.get().markRetired(r, true);
                        }
                    }
                    return null;
                }
            }, ACC_DOWNLOAD_INSTANCE);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    public void removePart(String part) throws IOException {
        this.removePart(new String[]{part});
    }

    public void removePart(final String[] parts) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    LaunchDesc ld = JNLPClassLoaderUtil.getInstance().getLaunchDesc();
                    ResourcesDesc rd = ld.getResources();
                    if (rd == null) {
                        return null;
                    }
                    JARDesc[] jardescs = rd.getPartJars(parts);
                    DownloadServiceImpl.this.removeJARFromCache(jardescs);
                    return null;
                }
            }, ACC_DOWNLOAD_INSTANCE);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    public void removeExtensionPart(URL ref, String version, String part) throws IOException {
        this.removeExtensionPart(ref, version, new String[]{part});
    }

    public void removeExtensionPart(final URL ref, final String version, final String[] parts) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    LaunchDesc ld = JNLPClassLoaderUtil.getInstance().getLaunchDesc();
                    ResourcesDesc resources = ld.getResources();
                    if (resources == null) {
                        return null;
                    }
                    JARDesc[] jardescs = resources.getExtensionPart(ref, version, parts);
                    DownloadServiceImpl.this.removeJARFromCache(jardescs);
                    return null;
                }
            }, ACC_DOWNLOAD_INSTANCE);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    private void removeJARFromCache(JARDesc[] jardescs) throws IOException {
        if (jardescs == null) {
            return;
        }
        if (jardescs.length == 0) {
            return;
        }
        for (JARDesc jardesc : jardescs) {
            Resource r = ResourceProvider.get().getCachedResource(jardesc.getLocation(), jardesc.getVersion());
            ResourceProvider.get().markRetired(r, true);
        }
    }

    private boolean isJARInCache(JARDesc[] jardescs, boolean logical_and) {
        if (jardescs == null) {
            return false;
        }
        if (jardescs.length == 0) {
            return false;
        }
        boolean result = true;
        for (JARDesc jardesc : jardescs) {
            JarFile jf = ResourceProvider.get().getCachedJarFile(jardesc.getLocation(), jardesc.getVersion());
            if (jf != null) {
                if (logical_and) continue;
                return true;
            }
            result = false;
        }
        return result;
    }

    private boolean isResourceValid(URL ref, String version) {
        LaunchDesc ld = JNLPClassLoaderUtil.getInstance().getLaunchDesc();
        JARDesc[] jars = ld.getResources().getEagerOrAllJarDescs(true);
        if (ld.getSecurityModel() != 0) {
            return true;
        }
        for (JARDesc jar : jars) {
            if (!ref.toString().equals(jar.getLocation().toString()) || version != null && !version.equals(jar.getVersion())) continue;
            return true;
        }
        URL mainJarURL = ld.getMainJarURL();
        return mainJarURL != null && ref != null && ref.toString().startsWith(mainJarURL.toString());
    }

    private PreloaderDelegate getProgressHelper(CustomProgress2PreloaderAdapter cppa) {
        return new PreloaderDelegate(cppa);
    }
}

