/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import com.sun.deploy.util.Waiter;
import com.sun.jnlp.FileContentsImpl;
import com.sun.jnlp.FileSaveServiceImpl;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import javax.jnlp.FileContents;
import javax.jnlp.FileSaveService;

public final class FileSaveServiceNSBImpl
implements FileSaveService {
    private final FileSaveServiceImpl service;
    private static final AccessControlContext ACC_DIALOG_INSTANCE = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

        @Override
        public AccessControlContext run() {
            Permissions perms = new Permissions();
            FilePermission perm = new FilePermission("<<ALL FILES>>", "read,write");
            ((PermissionCollection)perms).add(perm);
            RuntimePermission perm2 = new RuntimePermission("setContextClassLoader");
            ((PermissionCollection)perms).add(perm2);
            return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        }
    });

    public FileSaveServiceNSBImpl(FileSaveServiceImpl service) {
        this.service = service;
    }

    public FileContents saveFileDialog(final String pathHint, final String[] extensions, final InputStream stream, final String filename) throws IOException {
        if (!this.service.askUser()) {
            return null;
        }
        Waiter.WaiterTask task = new Waiter.WaiterTask(){

            public Object run() throws Exception {
                Object res = DeploySysRun.executePrivileged((DeploySysAction)new DeploySysAction(){

                    public Object execute() {
                        String filePath = Platform.get().getNativeSandboxBroker().saveFile(pathHint, extensions, filename);
                        if (filePath == null) {
                            return null;
                        }
                        File file = new File(filePath);
                        if (file != null) {
                            try {
                                byte[] buffer = new byte[8192];
                                OutputStream os = Platform.get().getNativeSandboxBroker().getOutputStream(file, true);
                                BufferedInputStream bis = new BufferedInputStream(stream);
                                int n = bis.read(buffer);
                                while (n != -1) {
                                    os.write(buffer, 0, n);
                                    n = bis.read(buffer);
                                }
                                os.flush();
                                os.close();
                                return new FileContentsImpl(file, FileSaveServiceImpl.computeMaxLength(file.length()));
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        return null;
                    }
                }, null, (AccessControlContext)ACC_DIALOG_INSTANCE);
                if (res instanceof IOException) {
                    throw (IOException)res;
                }
                return (FileContents)res;
            }
        };
        try {
            return (FileContents)Waiter.runAndWait((Waiter.WaiterTask)task);
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            Trace.ignored((Throwable)ex);
            return null;
        }
    }

    public FileContents saveAsFileDialog(String pathHint, String[] extensions, FileContents fileContents) throws IOException {
        return this.saveFileDialog(pathHint, extensions, fileContents.getInputStream(), fileContents.getName());
    }
}

