/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.applet2.preloader.Preloader;
import com.sun.deploy.config.OSType;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.ref.AppRef;
import com.sun.deploy.ref.CodeInstance;
import com.sun.deploy.ref.CodeRef;
import com.sun.deploy.security.CPCallbackHandler;
import com.sun.deploy.security.DeployURLClassLoader;
import com.sun.deploy.security.DeployURLClassPath;
import com.sun.deploy.security.Resource;
import com.sun.deploy.security.SandboxSecurity;
import com.sun.deploy.security.SecureCookiePermission;
import com.sun.deploy.security.SecureStaticVersioning;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.FXLoader;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.progress.Progress;
import com.sun.javaws.security.AppPolicy;
import com.sun.javaws.util.JNLPUtils;
import com.sun.jnlp.BasicServiceImpl;
import com.sun.jnlp.ClipboardServiceImpl;
import com.sun.jnlp.DownloadService2Impl;
import com.sun.jnlp.DownloadServiceImpl;
import com.sun.jnlp.ExtendedServiceImpl;
import com.sun.jnlp.ExtensionInstallerServiceImpl;
import com.sun.jnlp.FileOpenServiceImpl;
import com.sun.jnlp.FileSaveServiceImpl;
import com.sun.jnlp.IntegrationServiceImpl;
import com.sun.jnlp.IntegrationServiceNSBImpl;
import com.sun.jnlp.JNLPClassLoaderIf;
import com.sun.jnlp.PersistenceServiceImpl;
import com.sun.jnlp.PrintServiceImpl;
import com.sun.jnlp.SingleInstanceServiceImpl;
import java.awt.AWTPermission;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import javax.jnlp.BasicService;
import javax.jnlp.ClipboardService;
import javax.jnlp.DownloadService;
import javax.jnlp.DownloadService2;
import javax.jnlp.ExtendedService;
import javax.jnlp.ExtensionInstallerService;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.IntegrationService;
import javax.jnlp.PersistenceService;
import javax.jnlp.PrintService;
import javax.jnlp.SingleInstanceService;

public final class JNLPClassLoader
extends DeployURLClassLoader
implements JNLPClassLoaderIf {
    private static JNLPClassLoader _instance = null;
    private LaunchDesc _launchDesc = null;
    private AppPolicy _appPolicy;
    private AccessControlContext _acc = null;
    private boolean _initialized = false;
    private Map<String, JARDesc> _jarsInURLClassLoader = new HashMap<String, JARDesc>();
    private ArrayList<JARDesc> _jarsNotInURLClassLoader = new ArrayList();
    private List<URL> addedURLs = new ArrayList<URL>();
    private JNLPClassLoader _jclParent;

    private JNLPClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkCreateClassLoader();
        }
        if (parent instanceof JNLPClassLoader) {
            this._jclParent = (JNLPClassLoader)((Object)parent);
        }
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        this.checkPackageAccess(name);
        return super.loadClass(name, resolve);
    }

    private void initialize(LaunchDesc launchDesc, AppPolicy appPolicy) {
        this._launchDesc = launchDesc;
        this._acc = AccessController.getContext();
        this._appPolicy = appPolicy;
        this._initialized = true;
        if (this._jclParent != null) {
            this._jclParent.initialize(launchDesc, appPolicy);
            this.drainPendingURLs();
            return;
        }
        if (launchDesc.needFX()) {
            try {
                FXLoader.loadFX();
            }
            catch (Throwable t) {
                Trace.ignored((Throwable)t);
            }
        }
        ResourcesDesc rd = launchDesc.getResources();
        ArrayList<JARDesc> jarsInClassLoader = new ArrayList<JARDesc>();
        if (rd != null) {
            JNLPUtils.sortResourcesForClasspath(rd, jarsInClassLoader, this._jarsNotInURLClassLoader);
            for (JARDesc jd : jarsInClassLoader) {
                this._jarsInURLClassLoader.put(URLUtil.toNormalizedString((URL)jd.getLocation()), jd);
                this.addURL2(jd.getLocation());
            }
        }
    }

    @Override
    public Preloader getPreloader() {
        return Progress.get(null);
    }

    public static JNLPClassLoader createClassLoader() {
        if (_instance == null) {
            JNLPClassLoader child;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            JNLPClassLoader parent = new JNLPClassLoader(cl);
            _instance = !JNLPClassLoader.setDeployURLClassPathCallbacks(parent, child = new JNLPClassLoader((ClassLoader)((Object)parent))) ? parent : child;
        }
        return _instance;
    }

    public static JNLPClassLoader createClassLoader(LaunchDesc ld, AppPolicy appPolicy) {
        JNLPClassLoader jnlpClassLoader = JNLPClassLoader.createClassLoader();
        if (!jnlpClassLoader._initialized) {
            jnlpClassLoader.initialize(ld, appPolicy);
        }
        return jnlpClassLoader;
    }

    public static JNLPClassLoaderIf getInstance() {
        return _instance;
    }

    @Override
    public LaunchDesc getLaunchDesc() {
        return this._launchDesc;
    }

    @Override
    public JARDesc getJarDescFromURL(URL url) {
        if (this._jclParent != null) {
            return this._jclParent.getJarDescFromURL(url);
        }
        String queryURL = URLUtil.toNormalizedString((URL)url);
        JARDesc jd = this._jarsInURLClassLoader.get(queryURL);
        if (jd != null) {
            return jd;
        }
        HashMap<String, JARDesc> newURLs = new HashMap<String, JARDesc>();
        for (String u : this._jarsInURLClassLoader.keySet()) {
            jd = this._jarsInURLClassLoader.get(u);
            String redirectFinal = URLUtil.toNormalizedString((URL)DownloadEngine.getKnownRedirectFinalURL((URL)jd.getLocation()));
            if (this._jarsInURLClassLoader.containsKey(redirectFinal)) continue;
            newURLs.put(redirectFinal, jd);
            if (!queryURL.equals(redirectFinal)) continue;
            this._jarsInURLClassLoader.putAll(newURLs);
            return jd;
        }
        this._jarsInURLClassLoader.putAll(newURLs);
        return null;
    }

    @Override
    public int getDefaultSecurityModel() {
        return this._launchDesc.getSecurityModel();
    }

    public AppInfo getAppInfo(URL u) {
        LaunchDesc ld;
        JARDesc jd = this.getJarDescFromURL(u);
        if (jd != null && jd.getParent() != null && (ld = jd.getParent().getParent()) != null) {
            return ld.getAppInfo();
        }
        return new AppInfo();
    }

    @Override
    public URL getResource(String name) {
        URL resource = null;
        for (int i = 0; resource == null && i < 3; ++i) {
            resource = super.getResource(name);
        }
        return resource;
    }

    private String findLibrary0(String name) {
        JARDesc[] jars;
        ResourcesDesc rd = this._launchDesc.getResources();
        for (JARDesc jar : jars = rd.getEagerOrAllJarDescs(true)) {
            if (!jar.isNativeLib()) continue;
            try {
                String r = ResourceProvider.get().getLibraryDirForJar(name, jar.getLocation(), jar.getVersion());
                if (r == null) continue;
                return new File(r, name).getAbsolutePath();
            }
            catch (IOException ioe) {
                Trace.ignoredException((Exception)ioe);
            }
        }
        return null;
    }

    protected String findLibrary(String name) {
        if (this._jclParent != null) {
            return this._jclParent.findLibrary(name);
        }
        if (!this._initialized) {
            return super.findLibrary(name);
        }
        Object libName = System.mapLibraryName(name);
        Trace.println((String)("JNLPClassLoader: Finding library " + (String)libName));
        String path = this.findLibrary0((String)libName);
        if (path != null) {
            return path;
        }
        if (OSType.isMac() && (path = this.findLibrary0((String)(libName = "lib" + name + ".jnilib"))) != null) {
            return path;
        }
        Trace.println((String)("JNLPClassLoader: Native library " + name + " not found"), (TraceLevel)TraceLevel.NETWORK);
        return super.findLibrary(name);
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (!this._initialized) {
            return super.findClass(name);
        }
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            if (!(cnfe.getCause() instanceof JARSigningException) && this.checkPackageParts(name)) {
                return super.findClass(name);
            }
            throw cnfe;
        }
    }

    public Resource getResourceAsResource(String name) throws MalformedURLException, FileNotFoundException {
        DeployURLClassPath ucp1;
        Resource res1;
        if (this._jclParent != null) {
            try {
                return this._jclParent.getResourceAsResource(name);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if ((res1 = (ucp1 = this.getDeployURLClassPath()).getResource(name, false)) != null) {
            return res1;
        }
        throw new FileNotFoundException("Resource " + name + " not found");
    }

    @Override
    public URL findResource(String name) {
        URL url = super.findResource(name);
        if (!this._initialized) {
            return url;
        }
        if (url == null && this.checkPackageParts(name)) {
            url = super.findResource(name);
        }
        return url;
    }

    private boolean checkPackageParts(String name) {
        if (this._jclParent != null) {
            return this.drainPendingURLs();
        }
        boolean ret = false;
        ResourcesDesc.PackageInformation pi = this._launchDesc.getResources().getPackageInformation(name);
        if (pi != null) {
            JARDesc[] jds;
            for (JARDesc jd : jds = pi.getLaunchDesc().getResources().getPart(pi.getPart())) {
                if (!this._jarsNotInURLClassLoader.contains(jd)) continue;
                this._jarsNotInURLClassLoader.remove(jd);
                this.addLoadedJarsEntry(jd);
                this.addURL2(jd.getLocation());
                ret = true;
            }
        }
        return ret;
    }

    protected PermissionCollection getPermissions(CodeSource codesource) {
        com.sun.deploy.model.Resource r;
        Permissions csPerms = null;
        String host = this.getLaunchDesc().getDownloadHost();
        if (host != null && host.length() > 0) {
            if (!URLUtil.sameBase((URL)this.getLaunchDesc().getCodebase(), (URL)codesource.getLocation())) {
                if (DownloadEngine.isKnownRedirectedHost((String)host, (String)codesource.getLocation().getHost())) {
                    csPerms = new Permissions();
                    SandboxSecurity.addConnectPermission((PermissionCollection)csPerms, (URL)codesource.getLocation());
                    Trace.println((String)("Grant connect perm for " + codesource.getLocation() + " : " + csPerms), (TraceLevel)TraceLevel.SECURITY);
                } else {
                    Trace.println((String)("Connect perm was not granted " + codesource.getLocation() + " : " + csPerms), (TraceLevel)TraceLevel.SECURITY);
                }
            } else {
                csPerms = new Permissions();
                SandboxSecurity.addConnectPermission((PermissionCollection)csPerms, (URL)codesource.getLocation());
                Trace.println((String)("Grant connect perm for " + codesource.getLocation() + " : " + csPerms), (TraceLevel)TraceLevel.SECURITY);
            }
        }
        Permissions perms = csPerms == null ? new Permissions() : csPerms;
        URL url = codesource.getLocation();
        JARDesc jd = this.getJarDescFromURL(url);
        SecureStaticVersioning.checkVersionAllowed((DeploymentRuleSet)this.getDeploymentRuleSet(url));
        if (url != null && jd != null) {
            ToolkitStore.get().getAppContext().put((Object)("deploy-" + url), (Object)jd.getVersion());
            URL finalURL = DownloadEngine.getKnownRedirectFinalURL((URL)url);
            if (!URLUtil.sameURLs((URL)finalURL, (URL)url)) {
                ToolkitStore.get().getAppContext().put((Object)("deploy-" + finalURL), (Object)jd.getVersion());
            }
        }
        try {
            this._appPolicy.addPermissions(JNLPClassLoader.getInstance(), perms, codesource, true);
        }
        catch (ExitException ee) {
            throw new RuntimeException(ee);
        }
        if (jd != null && (r = ResourceProvider.get().getCachedResource(jd.getLocation(), jd.getVersion())) != null && r.getDataFile() != null) {
            String jarPath = r.getDataFile().getPath();
            ((PermissionCollection)perms).add(new FilePermission(jarPath, "read"));
        }
        if (!((PermissionCollection)perms).implies(new AWTPermission("accessClipboard"))) {
            ToolkitStore.get().getAppContext().put((Object)"UNTRUSTED_URLClassLoader", (Object)Boolean.TRUE);
        }
        ((PermissionCollection)perms).add((Permission)new SecureCookiePermission(SecureCookiePermission.getURLOriginString((URL)codesource.getLocation())));
        return perms;
    }

    @Override
    public JarFile getJarFile(URL url) throws IOException {
        final JARDesc jd = this.getJarDescFromURL(url);
        if (jd == null) {
            return null;
        }
        final int contentType = LaunchDownload.getDownloadType(jd);
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<JarFile>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public JarFile run() throws IOException {
                    int level = ResourceProvider.get().incrementInternalUse();
                    try {
                        JarFile jf = ResourceProvider.get().getCachedJarFile(jd.getLocation(), jd.getVersion());
                        if (jf != null) {
                            JarFile jarFile = jf;
                            return jarFile;
                        }
                        JarFile jarFile = ResourceProvider.get().getJarFile(jd.getLocation(), jd.getVersion(), contentType);
                        return jarFile;
                    }
                    finally {
                        ResourceProvider.get().decrementInternalUse(level);
                    }
                }
            });
        }
        catch (PrivilegedActionException wrapper) {
            throw (IOException)wrapper.getException();
        }
    }

    private void addLoadedJarsEntry(JARDesc jd) {
        String u = jd.getLocationString();
        if (!this._jarsInURLClassLoader.containsKey(u)) {
            this._jarsInURLClassLoader.put(u, jd);
        }
    }

    @Override
    public void addResource(URL resource, String version, String id) {
        if (this._jclParent != null) {
            this._jclParent.addResource(resource, version, id);
            this.drainPendingURLs();
            return;
        }
        JARDesc jd = new JARDesc(resource, version, true, false, false, null, 0, null);
        String u = jd.getLocationString();
        if (!this._jarsInURLClassLoader.containsKey(u)) {
            this._launchDesc.getResources().addResource(jd);
            this.addLoadedJarsEntry(jd);
            this.addURL2(resource);
        }
    }

    static boolean setDeployURLClassPathCallbacks(JNLPClassLoader parent, JNLPClassLoader child) {
        try {
            if (!ResourceProvider.get().hasEnhancedJarAccess()) {
                Trace.println((String)"setDeployURLClassPathCallbacks: no enhanced access", (TraceLevel)TraceLevel.BASIC);
                return false;
            }
            CPCallbackHandler handler = new CPCallbackHandler((DeployURLClassLoader)parent, (DeployURLClassLoader)child);
            parent.getDeployURLClassPath().setDeployURLClassPathCallback(handler.getParentCallback());
            child.getDeployURLClassPath().setDeployURLClassPathCallback(handler.getChildCallback());
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Exception e) {
            Trace.ignored((Throwable)e, (boolean)true);
            return false;
        }
        catch (Error err) {
            Trace.ignored((Throwable)err, (boolean)true);
            return false;
        }
        return true;
    }

    public void addURL(URL url) {
        if (this._jclParent != null) {
            this._jclParent.addURL(url);
        }
        super.addURL(url);
    }

    void addURL2(URL url) {
        if (this._jclParent != null) {
            this.drainPendingURLs();
        } else {
            this.putAddedURL(url);
        }
        super.addURL(url);
    }

    boolean drainPendingURLs() {
        int i;
        List<URL> addURLs = this._jclParent.grabAddedURLs();
        for (i = 0; i < addURLs.size(); ++i) {
            super.addURL(addURLs.get(i));
        }
        return i != 0;
    }

    synchronized List<URL> grabAddedURLs() {
        List<URL> urls = this.addedURLs;
        this.addedURLs = new ArrayList<URL>();
        return urls;
    }

    synchronized void putAddedURL(URL url) {
        this.addedURLs.add(url);
    }

    @Override
    public DeploymentRuleSet getDeploymentRuleSet(URL location) {
        LaunchDesc ld;
        JARDesc jd = this.getJarDescFromURL(location);
        if (jd != null && jd.getParent() != null && (ld = jd.getParent().getParent()) != null) {
            CodeRef codeRef = jd.getCodeRef();
            AppRef appRef = LaunchDesc.getJNLPAppRef(ld);
            return DeploymentRuleSet.findDRS((CodeInstance)new CodeInstance(appRef, codeRef));
        }
        URL anchor = this.getLaunchDesc() == null ? null : this.getLaunchDesc().getAnchorURL();
        boolean pack200Enabled = jd != null ? jd.isPack200Enabled() : false;
        CodeRef codeRef = new CodeRef(location, null, false, pack200Enabled);
        AppRef appRef = new AppRef(AppRef.Type.JNLP, null, null, null, anchor);
        return DeploymentRuleSet.findDRS((CodeInstance)new CodeInstance(appRef, codeRef));
    }

    public boolean wantsAllPerms(CodeSource cs) {
        LaunchDesc ld;
        JARDesc jd;
        return cs != null && ((jd = this.getJarDescFromURL(cs.getLocation())) != null && jd.getParent() != null ? (ld = jd.getParent().getParent()) != null && ld.getSecurityModel() != 0 : cs.getCertificates() != null && this._launchDesc != null && this._launchDesc.getSecurityModel() != 0);
    }

    @Override
    public BasicService getBasicService() {
        return BasicServiceImpl.getInstance();
    }

    @Override
    public FileOpenService getFileOpenService() {
        return FileOpenServiceImpl.getInstance();
    }

    @Override
    public FileSaveService getFileSaveService() {
        return FileSaveServiceImpl.getInstance();
    }

    @Override
    public ExtensionInstallerService getExtensionInstallerService() {
        return ExtensionInstallerServiceImpl.getInstance();
    }

    @Override
    public DownloadService getDownloadService() {
        return DownloadServiceImpl.getInstance();
    }

    @Override
    public ClipboardService getClipboardService() {
        return ClipboardServiceImpl.getInstance();
    }

    @Override
    public PrintService getPrintService() {
        return PrintServiceImpl.getInstance();
    }

    @Override
    public PersistenceService getPersistenceService() {
        return PersistenceServiceImpl.getInstance();
    }

    @Override
    public ExtendedService getExtendedService() {
        return ExtendedServiceImpl.getInstance();
    }

    @Override
    public SingleInstanceService getSingleInstanceService() {
        return SingleInstanceServiceImpl.getInstance();
    }

    @Override
    public IntegrationService getIntegrationService() {
        if (Platform.get().isNativeSandbox()) {
            return new IntegrationServiceNSBImpl(new IntegrationServiceImpl(this));
        }
        return new IntegrationServiceImpl(this);
    }

    @Override
    public DownloadService2 getDownloadService2() {
        return DownloadService2Impl.getInstance();
    }
}

