/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.si.DeploySIListener;
import com.sun.deploy.si.SingleInstanceImpl;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.javaws.Globals;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.Main;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.jnl.ApplicationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.XMLFormat;
import com.sun.jnlp.JNLPClassLoader;
import com.sun.jnlp.JNLPClassLoaderIf;
import com.sun.jnlp.JNLPClassLoaderUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jnlp.SingleInstanceListener;
import javax.jnlp.SingleInstanceService;

public final class SingleInstanceServiceImpl
extends SingleInstanceImpl
implements SingleInstanceService {
    private static SingleInstanceServiceImpl _sharedInstance = null;
    private static boolean listenerExists = false;

    public static synchronized SingleInstanceServiceImpl getInstance() {
        if (_sharedInstance == null) {
            _sharedInstance = new SingleInstanceServiceImpl();
        }
        return _sharedInstance;
    }

    public synchronized void addSingleInstanceListener(SingleInstanceListener sil) {
        if (sil == null) {
            return;
        }
        final LaunchDesc ld = JNLPClassLoaderUtil.getInstance().getLaunchDesc();
        URL urlNoQuery = ld.getCanonicalHome();
        int index = urlNoQuery.toString().lastIndexOf(63);
        if (index != -1) {
            try {
                urlNoQuery = new URL(urlNoQuery.toString().substring(0, index));
            }
            catch (MalformedURLException mue) {
                Trace.ignoredException((Exception)mue);
            }
        }
        final String jnlpUrlString = urlNoQuery.toString();
        if (!listenerExists) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    if (SingleInstanceManager.isServerRunning((String)jnlpUrlString)) {
                        ApplicationDesc appDesc;
                        String[] appArgs = Globals.getApplicationArgs();
                        if (appArgs != null && (appDesc = ld.getApplicationDescriptor()) != null) {
                            appDesc.setArguments(appArgs);
                        }
                        if (SingleInstanceManager.connectToServer((String)ld.toString())) {
                            try {
                                Main.systemExit(0);
                            }
                            catch (ExitException ee) {
                                Trace.println((String)("systemExit: " + ee), (TraceLevel)TraceLevel.BASIC);
                                Trace.ignoredException((Exception)ee);
                            }
                        }
                    }
                    return null;
                }
            });
        }
        super.addSingleInstanceListener((DeploySIListener)new TransferListener(sil), jnlpUrlString);
        listenerExists = true;
    }

    public void removeSingleInstanceListener(SingleInstanceListener sil) {
        super.removeSingleInstanceListener((DeploySIListener)new TransferListener(sil));
    }

    public boolean isSame(String inputString, String idString) {
        LaunchDesc ld = null;
        try {
            ld = XMLFormat.parse(inputString.getBytes(), null, null, null);
        }
        catch (Exception e) {
            Trace.ignoredException((Exception)e);
        }
        if (ld != null) {
            URL urlNoQuery = ld.getCanonicalHome();
            int index = urlNoQuery.toString().lastIndexOf(63);
            if (index != -1) {
                try {
                    urlNoQuery = new URL(urlNoQuery.toString().substring(0, index));
                }
                catch (MalformedURLException mue) {
                    Trace.ignoredException((Exception)mue);
                }
            }
            String sessionID = urlNoQuery.toString() + Platform.get().getSessionSpecificString();
            Trace.println((String)("GOT: " + sessionID), (TraceLevel)TraceLevel.BASIC);
            if (idString.equals(sessionID)) {
                return true;
            }
        }
        return false;
    }

    public String[] getArguments(String inputString, String idString) {
        LaunchDesc ld = null;
        try {
            URL lapCodebase = this.getCodebaseFromLap();
            ld = XMLFormat.parse(inputString.getBytes(), lapCodebase, null, null);
        }
        catch (Exception e) {
            Trace.ignoredException((Exception)e);
        }
        if (ld != null) {
            if (ld.getLocation() != null) {
                ld = LaunchDownload.updateLaunchDescInCache(ld);
            }
            if (ld.isApplication()) {
                return ld.getApplicationDescriptor().getArguments();
            }
            return super.getArguments(inputString, idString);
        }
        return new String[0];
    }

    private URL getCodebaseFromLap() {
        String codebase;
        LaunchDesc ld;
        LocalApplicationProperties lap;
        JNLPClassLoaderIf cl = JNLPClassLoader.getInstance();
        if (cl != null && (lap = Cache.getLocalApplicationProperties((URL)(ld = cl.getLaunchDesc()).getCanonicalHome())) != null && (codebase = lap.getCodebase()) != null) {
            try {
                return new URL(codebase);
            }
            catch (Exception e) {
                Trace.ignored((Throwable)e);
            }
        }
        return null;
    }

    private class TransferListener
    implements DeploySIListener {
        SingleInstanceListener _sil;

        public TransferListener(SingleInstanceListener sil) {
            this._sil = sil;
        }

        public void newActivation(String[] params) {
            if (params.length == 2) {
                String filePath = SingleInstanceManager.getOpenPrintFilePath();
                String actionName = SingleInstanceManager.getActionName();
                if (filePath != null && actionName != null && (actionName.equals("-open") || actionName.equals("-print")) && filePath.equals(params[1]) && actionName.equals(params[0])) {
                    JnlpxArgs.getFileReadWriteList().add(params[1]);
                    SingleInstanceManager.setOpenPrintFilePath(null);
                    SingleInstanceManager.setActionName(null);
                }
            }
            this._sil.newActivation(params);
        }

        public Object getSingleInstanceListener() {
            return this._sil;
        }
    }
}

