/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.dom.core;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import sun.plugin.dom.DOMObject;
import sun.plugin.dom.DOMObjectHelper;
import sun.plugin.dom.core.Node;

class CharacterData
extends Node
implements org.w3c.dom.CharacterData {
    private static final String ATTR_DATA = "data";
    private static final String ATTR_LENGTH = "length";
    private static final String FUNC_SUBSTRING_DATA = "substringData";
    private static final String FUNC_APPEND_DATA = "appendData";
    private static final String FUNC_INSERT_DATA = "insertData";
    private static final String FUNC_DELETE_DATA = "deleteData";
    private static final String FUNC_REPLACE_DATA = "replaceData";

    protected CharacterData(DOMObject dOMObject, Document document) {
        super(dOMObject, document);
    }

    @Override
    public String getData() throws DOMException {
        return DOMObjectHelper.getStringMemberNoEx(this.obj, ATTR_DATA);
    }

    @Override
    public void setData(String string) throws DOMException {
        DOMObjectHelper.setStringMember(this.obj, ATTR_DATA, string);
    }

    @Override
    public int getLength() {
        return DOMObjectHelper.getIntMemberNoEx(this.obj, ATTR_LENGTH);
    }

    @Override
    public String substringData(int n, int n2) throws DOMException {
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
        return DOMObjectHelper.callStringMethod(this.obj, FUNC_SUBSTRING_DATA, objectArray);
    }

    @Override
    public void appendData(String string) throws DOMException {
        Object[] objectArray = new Object[]{string};
        this.obj.call(FUNC_APPEND_DATA, objectArray);
    }

    @Override
    public void insertData(int n, String string) throws DOMException {
        Object[] objectArray = new Object[]{new Integer(n), string};
        this.obj.call(FUNC_INSERT_DATA, objectArray);
    }

    @Override
    public void deleteData(int n, int n2) throws DOMException {
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
        this.obj.call(FUNC_DELETE_DATA, objectArray);
    }

    @Override
    public void replaceData(int n, int n2, String string) throws DOMException {
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2), string};
        this.obj.call(FUNC_REPLACE_DATA, objectArray);
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.getData();
    }

    @Override
    public void setNodeValue(String string) throws DOMException {
        this.setData(string);
    }
}

