/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.javascript;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;

public final class JSClassLoader
extends SecureClassLoader {
    private static final String JS_PROXY_PKG = "sun.plugin.javascript.";
    private static final String TRAMPOLINE = "sun.plugin.javascript.Trampoline";
    private static Method bounce = JSClassLoader.bounce();
    private static Method bounceForNewInstance = JSClassLoader.bounceForNewInstance();

    private JSClassLoader() {
    }

    public static Object invoke(Method method, Object object, Object[] objectArray) throws InvocationTargetException, IllegalAccessException {
        try {
            return bounce.invoke(null, method, object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof InvocationTargetException) {
                throw (InvocationTargetException)throwable;
            }
            if (throwable instanceof IllegalAccessException) {
                throw (IllegalAccessException)throwable;
            }
            throw new Error("Unexpected invocation error", throwable);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error("Unexpected invocation error", illegalAccessException);
        }
    }

    public static Object newInstance(Constructor<?> constructor, Object[] objectArray) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        try {
            return bounceForNewInstance.invoke(null, constructor, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof InvocationTargetException) {
                throw (InvocationTargetException)throwable;
            }
            if (throwable instanceof IllegalAccessException) {
                throw (IllegalAccessException)throwable;
            }
            if (throwable instanceof InstantiationException) {
                throw (InstantiationException)throwable;
            }
            throw new Error("Unexpected invocation error", throwable);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error("Unexpected invocation error", illegalAccessException);
        }
    }

    public static void checkPackageAccess(Class<?> clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(".");
        if (n != -1) {
            String string2 = string.substring(0, n);
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPackageAccess(string2);
            }
        }
    }

    public static boolean isPackageAccessible(Class<?> clazz) {
        try {
            JSClassLoader.checkPackageAccess(clazz);
        }
        catch (SecurityException securityException) {
            return false;
        }
        return true;
    }

    private static Method bounce() {
        if (bounce == null) {
            try {
                bounce = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                    @Override
                    public Method run() throws Exception {
                        Class clazz = JSClassLoader.getTrampolineClass();
                        Class[] classArray = new Class[]{Method.class, Object.class, Object[].class};
                        Method method = clazz.getDeclaredMethod("invoke", classArray);
                        method.setAccessible(true);
                        return method;
                    }
                });
            }
            catch (Exception exception) {
                throw new InternalError("No trampoline to bounce on");
            }
        }
        return bounce;
    }

    private static Method bounceForNewInstance() {
        if (bounceForNewInstance == null) {
            try {
                bounceForNewInstance = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                    @Override
                    public Method run() throws Exception {
                        Class clazz = JSClassLoader.getTrampolineClass();
                        Class[] classArray = new Class[]{Constructor.class, Object[].class};
                        Method method = clazz.getDeclaredMethod("newInstance", classArray);
                        method.setAccessible(true);
                        return method;
                    }
                });
            }
            catch (Exception exception) {
                throw new InternalError("No trampoline to bounce on");
            }
        }
        return bounceForNewInstance;
    }

    private static Class<?> getTrampolineClass() {
        try {
            return Class.forName(TRAMPOLINE, true, new JSClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        Object object;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            int n;
            object = string.replace('/', '.');
            if (((String)object).startsWith("[") && (n = ((String)object).lastIndexOf(91) + 2) > 1 && n < ((String)object).length()) {
                object = ((String)object).substring(n);
            }
            if ((n = ((String)object).lastIndexOf(46)) != -1) {
                securityManager.checkPackageAccess(((String)object).substring(0, n));
            }
        }
        if ((object = this.findLoadedClass(string)) == null) {
            try {
                object = this.findClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (object == null) {
                object = this.getParent().loadClass(string);
            }
        }
        if (bl) {
            this.resolveClass((Class<?>)object);
        }
        return object;
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        if (!string.startsWith(JS_PROXY_PKG)) {
            throw new ClassNotFoundException(string);
        }
        String string2 = "/" + string.replace('.', '/').concat(".class");
        try {
            byte[] byArray = JSClassLoader.getBytes(this.getClass().getResource(string2));
            if (byArray != null) {
                return this.defineClass(string, byArray);
            }
        }
        catch (Exception exception) {
            throw new ClassNotFoundException(string, exception);
        }
        throw new ClassNotFoundException(string);
    }

    private Class<?> defineClass(String string, byte[] byArray) throws IOException {
        CodeSource codeSource = new CodeSource(null, (Certificate[])null);
        if (!string.equals(TRAMPOLINE)) {
            throw new IOException("JSClassLoader: bad name " + string);
        }
        return this.defineClass(string, byArray, 0, byArray.length, codeSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBytes(URL uRL) throws IOException {
        HttpURLConnection httpURLConnection;
        int n;
        if (uRL == null) {
            return null;
        }
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof HttpURLConnection && (n = (httpURLConnection = (HttpURLConnection)uRLConnection).getResponseCode()) >= 400) {
            throw new IOException("open HTTP connection failed.");
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        try {
            int n2;
            if (n2 != -1) {
                int n3;
                byte[] byArray = new byte[n2];
                for (n2 = uRLConnection.getContentLength(); n2 > 0; n2 -= n3) {
                    n3 = ((InputStream)bufferedInputStream).read(byArray, byArray.length - n2, n2);
                    if (n3 != -1) continue;
                    throw new IOException("unexpected EOF");
                }
                byte[] byArray2 = byArray;
                return byArray2;
            }
            byte[] byArray = new byte[8192];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            do {
                if ((n2 = ((InputStream)bufferedInputStream).read(byArray)) <= 0) continue;
                byteArrayOutputStream.write(byArray, 0, n2);
            } while (n2 > -1);
            byte[] byArray3 = byteArrayOutputStream.toByteArray();
            return byArray3;
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        permissionCollection.add(new AllPermission());
        return permissionCollection;
    }
}

