/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.javascript;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.plugin.javascript.JSClassLoader;

public class ReflectUtil {
    public static Method[] getJScriptMethods(Class<?> clazz) {
        boolean bl;
        ArrayList<Method> arrayList = new ArrayList<Method>();
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        while (clazz != null && !(bl = ReflectUtil.getPublicMethods(clazz, arrayList, hashMap))) {
            ReflectUtil.getJScriptInterfaceMethods(clazz, arrayList, hashMap);
            clazz = clazz.getSuperclass();
        }
        return arrayList.toArray(new Method[arrayList.size()]);
    }

    private static void getJScriptInterfaceMethods(Class<?> clazz, List<Method> list, Map<String, Method> map) {
        Class<?>[] classArray;
        for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
            Class<?> clazz3 = clazz2;
            boolean bl = ReflectUtil.getPublicMethods(clazz3, list, map);
            if (bl) continue;
            ReflectUtil.getJScriptInterfaceMethods(clazz3, list, map);
        }
    }

    private static boolean getPublicMethods(Class<?> clazz, List<Method> list, Map<String, Method> map) {
        Class<?> clazz2;
        Method[] methodArray = null;
        try {
            if (!Modifier.isPublic(clazz.getModifiers())) {
                return false;
            }
            if (!JSClassLoader.isPackageAccessible(clazz)) {
                return false;
            }
            methodArray = clazz.getMethods();
        }
        catch (SecurityException securityException) {
            return false;
        }
        boolean bl = true;
        for (Method method : methodArray) {
            clazz2 = method.getDeclaringClass();
            if (Modifier.isPublic(clazz2.getModifiers())) continue;
            bl = false;
            break;
        }
        if (map.isEmpty() && !list.isEmpty()) {
            ReflectUtil.initSignatureMap(list, map);
        }
        if (bl) {
            for (Method method : methodArray) {
                ReflectUtil.addMethod(list, map, method);
            }
        } else {
            for (Method method : methodArray) {
                clazz2 = method.getDeclaringClass();
                if (!clazz.equals(clazz2)) continue;
                ReflectUtil.addMethod(list, map, method);
            }
        }
        return bl;
    }

    private static void initSignatureMap(List<Method> list, Map<String, Method> map) {
        for (Method method : list) {
            map.put(ReflectUtil.getSignature(method), method);
        }
    }

    private static void addMethod(List<Method> list, Map<String, Method> map, Method method) {
        if (map.isEmpty()) {
            list.add(method);
            return;
        }
        String string = ReflectUtil.getSignature(method);
        if (!map.containsKey(string)) {
            list.add(method);
            map.put(string, method);
        }
    }

    private static String getSignature(Method method) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(method.getName());
        Class<?>[] classArray = method.getParameterTypes();
        stringBuilder.append('(');
        if (classArray.length > 0) {
            stringBuilder.append(classArray[0].getName());
        }
        for (int i = 1; i < classArray.length; ++i) {
            stringBuilder.append(',');
            stringBuilder.append(classArray[i].getName());
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public static Field[] getJScriptFields(Class<?> clazz) {
        boolean bl;
        ArrayList<Field> arrayList = new ArrayList<Field>();
        HashMap<String, Field> hashMap = new HashMap<String, Field>();
        while (clazz != null && !(bl = ReflectUtil.getPublicFields(clazz, arrayList, hashMap))) {
            ReflectUtil.getJScriptInterfaceFields(clazz, arrayList, hashMap);
            clazz = clazz.getSuperclass();
        }
        return arrayList.toArray(new Field[arrayList.size()]);
    }

    private static void getJScriptInterfaceFields(Class<?> clazz, List<Field> list, Map<String, Field> map) {
        Class<?>[] classArray;
        for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
            Class<?> clazz3 = clazz2;
            boolean bl = ReflectUtil.getPublicFields(clazz3, list, map);
            if (bl) continue;
            ReflectUtil.getJScriptInterfaceFields(clazz3, list, map);
        }
    }

    private static boolean getPublicFields(Class<?> clazz, List<Field> list, Map<String, Field> map) {
        Class<?> clazz2;
        Field[] fieldArray = null;
        try {
            if (!Modifier.isPublic(clazz.getModifiers())) {
                return false;
            }
            if (!JSClassLoader.isPackageAccessible(clazz)) {
                return false;
            }
            fieldArray = clazz.getFields();
        }
        catch (SecurityException securityException) {
            return false;
        }
        boolean bl = true;
        for (Field field : fieldArray) {
            clazz2 = field.getDeclaringClass();
            if (Modifier.isPublic(clazz2.getModifiers())) continue;
            bl = false;
            break;
        }
        if (bl) {
            for (Field field : fieldArray) {
                ReflectUtil.addField(list, map, field);
            }
        } else {
            for (Field field : fieldArray) {
                clazz2 = field.getDeclaringClass();
                if (!clazz.equals(clazz2)) continue;
                ReflectUtil.addField(list, map, field);
            }
        }
        return bl;
    }

    private static void addField(List<Field> list, Map<String, Field> map, Field field) {
        String string = field.getName();
        if (!map.containsKey(string)) {
            list.add(field);
            map.put(string, field);
        }
    }
}

