/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.util;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import com.sun.deploy.util.DeployUIManager;
import com.sun.deploy.util.SystemPropertyUtil;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JDialog;
import sun.plugin2.applet.Plugin2Manager;

public final class PluginSysUtil
extends DeploySysRun {
    private static ThreadGroup pluginThreadGroup = null;
    private static ClassLoader pluginSysClassLoader = null;
    private static final SysExecutionThreadCreator sysExecutionThreadCreator = new SysExecutionThreadCreator();

    public static synchronized ThreadGroup getPluginThreadGroup() {
        if (pluginThreadGroup == null) {
            pluginSysClassLoader = Thread.currentThread().getContextClassLoader();
            pluginThreadGroup = new ThreadGroup(Thread.currentThread().getThreadGroup(), "Plugin Thread Group");
            PluginSysUtil.createAppContext(pluginThreadGroup);
            try {
                Thread thread = new Thread(pluginThreadGroup, new Runnable(){

                    @Override
                    public void run() {
                        DeployUIManager.setLookAndFeel();
                    }
                });
                thread.start();
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return pluginThreadGroup;
    }

    public static Thread createPluginSysThread(Runnable runnable) {
        Thread thread = new Thread(pluginThreadGroup, runnable);
        thread.setContextClassLoader(pluginSysClassLoader);
        return thread;
    }

    public static Thread createPluginSysThread(Runnable runnable, String string) {
        Thread thread = new Thread(pluginThreadGroup, runnable, string);
        thread.setContextClassLoader(pluginSysClassLoader);
        return thread;
    }

    protected Object delegate(DeploySysAction deploySysAction) throws Exception {
        return PluginSysUtil.execute(deploySysAction);
    }

    public static Object execute(DeploySysAction deploySysAction) throws Exception {
        return PluginSysUtil.execute(deploySysAction, PluginSysUtil.getDefaultSetup(), PluginSysUtil.getDefaultCleanup());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object execute(DeploySysAction deploySysAction, Runnable runnable, Runnable runnable2) throws Exception {
        boolean bl;
        if (pluginThreadGroup == null) {
            Trace.println((String)"ERROR:  pluginThreadGroup should not be null!");
            return null;
        }
        if (pluginThreadGroup.equals(Thread.currentThread().getThreadGroup())) {
            return deploySysAction.execute();
        }
        final SysExecutionThread sysExecutionThread = PluginSysUtil.sysExecutionThreadCreator.createThread(deploySysAction, runnable, runnable2);
        sysExecutionThread.setContextClassLoader(pluginSysClassLoader);
        boolean bl2 = bl = ToolkitStore.isAWTToolkitRunning() && EventQueue.isDispatchThread();
        if (bl) {
            Object object = sysExecutionThread.syncObject;
            synchronized (object) {
                DummyDialog dummyDialog;
                sysExecutionThread.theDummy = dummyDialog = new DummyDialog(null, true);
                dummyDialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowOpened(WindowEvent windowEvent) {
                        sysExecutionThread.start();
                    }

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        dummyDialog.setVisible(false);
                    }
                });
                Rectangle rectangle = new Rectangle(new Point(0, 0), Toolkit.getDefaultToolkit().getScreenSize());
                if (!PluginSysUtil.isOnWindows()) {
                    dummyDialog.setLocation(rectangle.x + rectangle.width / 2 - 50, rectangle.y + rectangle.height / 2);
                } else {
                    dummyDialog.setLocation(-100, -100);
                }
                dummyDialog.setResizable(false);
                dummyDialog.toBack();
                dummyDialog.setVisible(true);
                while (!sysExecutionThread.done) {
                    try {
                        sysExecutionThread.syncObject.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                dummyDialog.setVisible(false);
            }
        }
        sysExecutionThread.start();
        try {
            sysExecutionThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (sysExecutionThread.exception != null) {
            throw sysExecutionThread.exception;
        }
        return sysExecutionThread.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createAppContext(ThreadGroup threadGroup) {
        AppContextCreatorThread appContextCreatorThread = new AppContextCreatorThread(threadGroup);
        Object object = appContextCreatorThread.synObject;
        synchronized (object) {
            appContextCreatorThread.start();
            while (!appContextCreatorThread.done) {
                try {
                    appContextCreatorThread.synObject.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static boolean isOnWindows() {
        String string = SystemPropertyUtil.getProperty((String)"os.name");
        return string.indexOf("Windows") != -1;
    }

    private static Runnable getDefaultSetup() {
        final Plugin2Manager plugin2Manager = Plugin2Manager.getCurrentManager();
        return new Runnable(){

            @Override
            public void run() {
                Plugin2Manager.setCurrentManagerThreadLocal(plugin2Manager);
            }
        };
    }

    private static Runnable getDefaultCleanup() {
        return new Runnable(){

            @Override
            public void run() {
                Plugin2Manager.setCurrentManagerThreadLocal(null);
            }
        };
    }

    static {
        sysExecutionThreadCreator.start();
    }

    private static class AppContextCreatorThread
    extends Thread {
        final Object synObject = new Object();
        volatile boolean done = false;

        public AppContextCreatorThread(ThreadGroup threadGroup) {
            super(threadGroup, "AppContext Creator Thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ToolkitStore.get().createAppContext();
            }
            finally {
                this.done = true;
                Object object = this.synObject;
                synchronized (object) {
                    this.synObject.notifyAll();
                }
            }
        }
    }

    private static class DummyDialog
    extends JDialog {
        private static final long serialVersionUID = 2496751495115985790L;
        private ThreadGroup _unsecureGroup = Thread.currentThread().getThreadGroup();

        DummyDialog(Frame frame, boolean bl) {
            super(frame, bl);
        }

        public void secureHide() {
            new Thread(this._unsecureGroup, new Runnable(){

                @Override
                public void run() {
                    DummyDialog.this.setVisible(false);
                }
            }).start();
        }
    }

    private static class Request {
        private DeploySysAction deploySysAction = null;
        private SysExecutionThread sysExecutionThread = null;
        private Runnable setup;
        private Runnable cleanup;

        Request(DeploySysAction deploySysAction, Runnable runnable, Runnable runnable2) {
            this.deploySysAction = deploySysAction;
            this.setup = runnable;
            this.cleanup = runnable2;
        }

        void setResult(SysExecutionThread sysExecutionThread) {
            this.sysExecutionThread = sysExecutionThread;
        }

        SysExecutionThread getResult() {
            return this.sysExecutionThread;
        }
    }

    private static class SysExecutionThread
    extends Thread {
        Exception exception = null;
        Object result = null;
        final DeploySysAction action;
        final Runnable setup;
        final Runnable cleanup;
        final Object syncObject = new Object();
        volatile boolean done = false;
        DummyDialog theDummy = null;

        public SysExecutionThread(DeploySysAction deploySysAction, Runnable runnable, Runnable runnable2) {
            super(pluginThreadGroup, "SysExecutionThead");
            this.setDaemon(true);
            this.action = deploySysAction;
            this.setup = runnable;
            this.cleanup = runnable2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.setup != null) {
                    this.setup.run();
                }
                this.result = this.action.execute();
            }
            catch (Exception exception) {
                this.exception = exception;
            }
            finally {
                this.done = true;
                if (this.theDummy != null) {
                    this.theDummy.secureHide();
                }
                Object object = this.syncObject;
                synchronized (object) {
                    this.syncObject.notifyAll();
                }
                if (this.cleanup != null) {
                    this.cleanup.run();
                }
            }
        }
    }

    private static class SysExecutionThreadCreator
    extends Thread {
        final List<Request> requestQueue = new LinkedList<Request>();

        private SysExecutionThreadCreator() {
            super("SysExecutionTheadCreator");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SysExecutionThread createThread(DeploySysAction deploySysAction, Runnable runnable, Runnable runnable2) {
            Request request = new Request(deploySysAction, runnable, runnable2);
            SysExecutionThreadCreator sysExecutionThreadCreator = this;
            synchronized (sysExecutionThreadCreator) {
                this.requestQueue.add(request);
                this.notifyAll();
                while (request.getResult() == null) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Trace.ignoredException((Exception)interruptedException);
                    }
                }
                return request.getResult();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                SysExecutionThreadCreator sysExecutionThreadCreator = this;
                synchronized (sysExecutionThreadCreator) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Trace.ignoredException((Exception)interruptedException);
                    }
                    while (!this.requestQueue.isEmpty()) {
                        Request request = this.requestQueue.remove(0);
                        request.setResult(new SysExecutionThread(request.deploySysAction, request.setup, request.cleanup));
                    }
                    this.notifyAll();
                }
            }
        }
    }
}

