/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.deploy.config.OSType;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.ref.AppRef;
import com.sun.deploy.ref.CodeInstance;
import com.sun.deploy.ref.CodeRef;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.SecureStaticVersioning;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.util.FXLoader;
import com.sun.deploy.util.NativeLibraryBundle;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ResourceType;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.security.AppPolicy;
import com.sun.javaws.util.JNLPUtils;
import com.sun.jnlp.ClipboardServiceImpl;
import com.sun.jnlp.DownloadService2Impl;
import com.sun.jnlp.DownloadServiceImpl;
import com.sun.jnlp.ExtendedServiceImpl;
import com.sun.jnlp.ExtensionInstallerServiceImpl;
import com.sun.jnlp.FileOpenServiceImpl;
import com.sun.jnlp.FileSaveServiceImpl;
import com.sun.jnlp.IntegrationServiceImpl;
import com.sun.jnlp.IntegrationServiceNSBImpl;
import com.sun.jnlp.JNLPClassLoaderIf;
import com.sun.jnlp.PersistenceServiceImpl;
import com.sun.jnlp.PrintServiceImpl;
import com.sun.jnlp.SingleInstanceServiceImpl;
import java.io.FilePermission;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import javax.jnlp.BasicService;
import javax.jnlp.ClipboardService;
import javax.jnlp.DownloadService;
import javax.jnlp.DownloadService2;
import javax.jnlp.ExtendedService;
import javax.jnlp.ExtensionInstallerService;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.IntegrationService;
import javax.jnlp.PersistenceService;
import javax.jnlp.PrintService;
import javax.jnlp.SingleInstanceService;
import sun.plugin2.applet.Plugin2BasicService;
import sun.plugin2.applet.Plugin2ClassLoader;

public final class JNLP2ClassLoader
extends Plugin2ClassLoader
implements JNLPClassLoaderIf {
    private LaunchDesc _launchDesc = null;
    private AppPolicy _appPolicy;
    private boolean _initialized = false;
    private Map<String, JARDesc> _jarsInURLClassLoader = new HashMap<String, JARDesc>();
    private ArrayList<JARDesc> _jarsNotInURLClassLoader = new ArrayList();
    private NativeLibraryBundle nativeLibraries = null;
    private JNLP2ClassLoader _jclParent;
    private boolean processingException = false;
    BasicService _basicService = null;

    protected JNLP2ClassLoader(URL uRL, ClassLoader classLoader) {
        super(new URL[0], uRL, classLoader);
        if (classLoader instanceof JNLP2ClassLoader) {
            this._jclParent = (JNLP2ClassLoader)((Object)classLoader);
        }
        if (DEBUG) {
            Trace.println((String)"JNLP2ClassLoader: cstr ...", (TraceLevel)TraceLevel.BASIC);
        }
    }

    @Override
    boolean isClassLoadedByPluginClassLoader(Class<?> clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (this.isShadowClassLoader() && this._jclParent != null) {
            return classLoader == this || classLoader == this._jclParent;
        }
        return classLoader == this;
    }

    @Override
    public boolean wantsAllPerms(CodeSource codeSource) {
        LaunchDesc launchDesc;
        JARDesc jARDesc;
        return codeSource != null && ((jARDesc = this.getJarDescFromURL(codeSource.getLocation())) != null && jARDesc.getParent() != null ? (launchDesc = jARDesc.getParent().getParent()) != null && launchDesc.getSecurityModel() != 0 : codeSource.getCertificates() != null && this._launchDesc != null && this._launchDesc.getSecurityModel() != 0);
    }

    protected void initialize(LaunchDesc launchDesc, AppPolicy appPolicy) {
        if (DEBUG) {
            Trace.println((String)"JNLP2ClassLoader: initialize ...", (TraceLevel)TraceLevel.BASIC);
        }
        this._launchDesc = launchDesc;
        this._appPolicy = appPolicy;
        this._initialized = true;
        if (this._launchDesc.getCodebase() != null) {
            this.base = this._launchDesc.getCodebase();
        }
        if (this._jclParent != null) {
            this._jclParent.initialize(launchDesc, appPolicy);
            this.drainPendingURLs();
            return;
        }
        if (launchDesc.needFX()) {
            try {
                FXLoader.loadFX();
            }
            catch (Throwable throwable) {
                Trace.ignored((Throwable)throwable);
            }
        }
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        ArrayList arrayList = new ArrayList();
        if (resourcesDesc != null) {
            JNLPUtils.sortResourcesForClasspath((ResourcesDesc)resourcesDesc, arrayList, this._jarsNotInURLClassLoader);
            for (JARDesc jARDesc : arrayList) {
                if (DEBUG) {
                    Trace.println((String)("\t addURL: " + jARDesc.getLocationString()), (TraceLevel)TraceLevel.BASIC);
                }
                this._jarsInURLClassLoader.put(URLUtil.toNormalizedString((URL)jARDesc.getLocation()), jARDesc);
                this.addURL2(jARDesc.getLocation());
            }
        }
        if (DEBUG) {
            Trace.println((String)"JNLP2ClassLoader: initialize done", (TraceLevel)TraceLevel.BASIC);
        }
    }

    public URL getResource(String string) {
        URL uRL = null;
        for (int i = 0; uRL == null && i < 3; ++i) {
            uRL = super.getResource(string);
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findLibrary0(String string) {
        JARDesc[] jARDescArray;
        Trace.println((String)("JNLP2ClassLoader.findLibrary: Looking up native library: " + string), (TraceLevel)TraceLevel.BASIC);
        JNLP2ClassLoader jNLP2ClassLoader = this;
        synchronized (jNLP2ClassLoader) {
            if (this.nativeLibraries != null) {
                jARDescArray = this.nativeLibraries.get(string);
                if (jARDescArray != null) {
                    Trace.println((String)("JNLP2ClassLoader.findLibrary: native library found: " + (String)jARDescArray), (TraceLevel)TraceLevel.BASIC);
                    return jARDescArray;
                }
            } else {
                this.nativeLibraries = new NativeLibraryBundle();
            }
        }
        jNLP2ClassLoader = this._launchDesc.getResources();
        for (JARDesc jARDesc : jARDescArray = jNLP2ClassLoader.getEagerOrAllJarDescs(true)) {
            if (!jARDesc.isNativeLib()) continue;
            try {
                String string2 = ResourceProvider.get().getLibraryDirForJar(string, jARDesc.getLocation(), jARDesc.getVersion());
                if (string2 == null) continue;
                JarFile jarFile = ResourceProvider.get().getCachedJarFile(jARDesc.getLocation(), jARDesc.getVersion());
                this.nativeLibraries.prepareLibrary(string, jarFile, string2);
                String string3 = this.nativeLibraries.get(string);
                Trace.println((String)("JNLP2ClassLoader.findLibrary: native library found: " + string3), (TraceLevel)TraceLevel.BASIC);
                return string3;
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
        return null;
    }

    protected String findLibrary(String string) {
        if (this._jclParent != null) {
            return this._jclParent.findLibrary(string);
        }
        if (!this._initialized) {
            Trace.println((String)("JNLP2ClassLoader.findLibrary: " + string + ": not initialized -> super()"), (TraceLevel)TraceLevel.BASIC);
            return super.findLibrary(string);
        }
        String string2 = System.mapLibraryName(string);
        String string3 = this.findLibrary0(string2);
        if (string3 != null) {
            return string3;
        }
        if (OSType.isMac() && (string3 = this.findLibrary0(string2 = "lib" + string + ".jnilib")) != null) {
            return string3;
        }
        Trace.println((String)("JNLP2ClassLoader: Native library " + string + " not found"), (TraceLevel)TraceLevel.BASIC);
        return super.findLibrary(string);
    }

    protected Class<?> findClass(String string) throws ClassNotFoundException {
        throw new ClassNotFoundException("can't happen");
    }

    @Override
    protected Class<?> findClass(String string, boolean bl) throws ClassNotFoundException {
        if (!this._initialized) {
            Trace.println((String)("JNLP2ClassLoader.findClass: " + string + ": not initialized -> super()"), (TraceLevel)TraceLevel.BASIC);
            return super.findClass(string);
        }
        try {
            return this.findClassHelper(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.checkPackageParts(string)) {
                return this.findClassHelper(string);
            }
            throw classNotFoundException;
        }
    }

    public URL findResource(String string) {
        URL uRL = super.findResource(string);
        if (!this._initialized) {
            Trace.println((String)("JNLP2ClassLoader.findResource: " + string + ": not initialized -> super()"), (TraceLevel)TraceLevel.BASIC);
            return uRL;
        }
        if (uRL == null && this.checkPackageParts(string)) {
            uRL = super.findResource(string);
        }
        return uRL;
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        JarFile jarFile;
        Trace.println((String)"JNLP2ClassLoader.getPermissions()", (TraceLevel)TraceLevel.BASIC);
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        boolean bl = !permissionCollection.implies(new AllPermission());
        try {
            this._appPolicy.addPermissions((JNLPClassLoaderIf)this, permissionCollection, codeSource, bl);
        }
        catch (ExitException exitException) {
            Trace.println((String)("_appPolicy.addPermissions: " + (Object)((Object)exitException)), (TraceLevel)TraceLevel.BASIC);
            throw new BlockedException(null, (Throwable)exitException);
        }
        URL uRL = codeSource.getLocation();
        SecureStaticVersioning.checkVersionAllowed((DeploymentRuleSet)this.getDeploymentRuleSet(uRL));
        JARDesc jARDesc = this.getJarDescFromURL(uRL);
        if (jARDesc != null && (jarFile = ResourceProvider.get().getCachedJarFile(jARDesc.getLocation(), jARDesc.getVersion())) != null) {
            String string = jarFile.getName();
            permissionCollection.add(new FilePermission(string, "read"));
        }
        Trace.println((String)"JNLP2ClassLoader.getPermissions() X", (TraceLevel)TraceLevel.BASIC);
        return permissionCollection;
    }

    public LaunchDesc getLaunchDesc() {
        return this._launchDesc;
    }

    public JARDesc getJarDescFromURL(URL uRL) {
        if (this._jclParent != null) {
            return this._jclParent.getJarDescFromURL(uRL);
        }
        String string = URLUtil.toNormalizedString((URL)uRL);
        JARDesc jARDesc = this._jarsInURLClassLoader.get(string);
        if (jARDesc != null) {
            return jARDesc;
        }
        HashMap<String, JARDesc> hashMap = new HashMap<String, JARDesc>();
        for (String string2 : this._jarsInURLClassLoader.keySet()) {
            jARDesc = this._jarsInURLClassLoader.get(string2);
            String string3 = URLUtil.toNormalizedString((URL)DownloadEngine.getKnownRedirectFinalURL((URL)jARDesc.getLocation()));
            if (this._jarsInURLClassLoader.containsKey(string3)) continue;
            hashMap.put(string3, jARDesc);
            if (!string.equals(string3)) continue;
            this._jarsInURLClassLoader.putAll(hashMap);
            return jARDesc;
        }
        this._jarsInURLClassLoader.putAll(hashMap);
        return null;
    }

    public JarFile getJarFile(URL uRL) throws IOException {
        final JARDesc jARDesc = this.getJarDescFromURL(uRL);
        JarFile jarFile = null;
        if (jARDesc != null) {
            final int n = LaunchDownload.getDownloadType((JARDesc)jARDesc);
            jarFile = AccessController.doPrivileged(new PrivilegedAction<JarFile>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public JarFile run() throws SecurityException {
                    int n2 = ResourceProvider.get().incrementInternalUse();
                    try {
                        JarFile jarFile;
                        Resource resource = ResourceProvider.get().getResource(jARDesc.getLocation(), jARDesc.getVersion(), true, n, null);
                        JarFile jarFile2 = jarFile = resource != null ? resource.getJarFile() : null;
                        if (jarFile != null) {
                            JarFile jarFile3 = jarFile;
                            return jarFile3;
                        }
                    }
                    catch (IOException iOException) {
                        Trace.ignoredException((Exception)iOException);
                    }
                    finally {
                        ResourceProvider.get().decrementInternalUse(n2);
                    }
                    return null;
                }
            });
            if (jarFile == null) {
                throw new IOException("Resource not found: " + jARDesc.getLocation() + ":" + jARDesc.getVersion());
            }
            return jarFile;
        }
        return null;
    }

    public int getDefaultSecurityModel() {
        return this._launchDesc.getSecurityModel();
    }

    private boolean checkPackageParts(String string) {
        boolean bl = false;
        if (this._jclParent != null) {
            return this.drainPendingURLs();
        }
        try {
            JARDesc[] jARDescArray = null;
            ResourcesDesc resourcesDesc = this._launchDesc.getResources();
            ResourcesDesc.PackageInformation packageInformation = resourcesDesc.getPackageInformation(string);
            if (packageInformation != null) {
                jARDescArray = packageInformation.getLaunchDesc().getResources().getPart(packageInformation.getPart());
            }
            if (jARDescArray != null) {
                for (JARDesc jARDesc : jARDescArray) {
                    String string2 = jARDesc.getLocationString();
                    if (!this._jarsNotInURLClassLoader.contains(jARDesc)) continue;
                    this._jarsNotInURLClassLoader.remove(jARDesc);
                    if (this._jarsInURLClassLoader.containsKey(string2)) continue;
                    this._jarsInURLClassLoader.put(string2, jARDesc);
                    this.addURL2(jARDesc.getLocation());
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            Trace.ignoredException((Exception)exception);
        }
        return bl;
    }

    protected void updateJarDescriptors(ResourcesDesc resourcesDesc) {
        if (this._jclParent != null) {
            this._jclParent.updateJarDescriptors(resourcesDesc);
            this.drainPendingURLs();
            return;
        }
        JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true);
        if (jARDescArray != null) {
            for (JARDesc jARDesc : jARDescArray) {
                this.updateJarDescriptor(resourcesDesc, jARDesc);
            }
        }
    }

    protected void updateJarDescriptor(ResourcesDesc resourcesDesc, JARDesc jARDesc) {
        String string;
        if (jARDesc != null && !this._jarsInURLClassLoader.containsKey(string = jARDesc.getLocationString()) && !this._jarsNotInURLClassLoader.contains(jARDesc)) {
            if (!jARDesc.isLazyDownload() || !resourcesDesc.isPackagePart(jARDesc.getPartName())) {
                this._jarsInURLClassLoader.put(string, jARDesc);
                this.addURL2(jARDesc.getLocation());
            } else {
                this._jarsNotInURLClassLoader.add(jARDesc);
            }
        }
    }

    public void addResource(URL uRL, String string, String string2) {
        if (this._jclParent != null) {
            this._jclParent.addResource(uRL, string, string2);
            this.drainPendingURLs();
            return;
        }
        JARDesc jARDesc = new JARDesc(uRL, string, true, false, false, null, 0, null);
        String string3 = jARDesc.getLocationString();
        if (!this._jarsInURLClassLoader.containsKey(string3)) {
            this._launchDesc.getResources().addResource((ResourceType)jARDesc);
            this._jarsInURLClassLoader.put(string3, jARDesc);
            this.addURL2(uRL);
        }
    }

    public BasicService getBasicService() {
        if (this._basicService == null) {
            URL uRL = this._launchDesc.getCodebase();
            if (uRL == null) {
                uRL = this.base;
            }
            this._basicService = new Plugin2BasicService(uRL);
        }
        return this._basicService;
    }

    public FileOpenService getFileOpenService() {
        return FileOpenServiceImpl.getInstance();
    }

    public FileSaveService getFileSaveService() {
        return FileSaveServiceImpl.getInstance();
    }

    public ExtensionInstallerService getExtensionInstallerService() {
        return ExtensionInstallerServiceImpl.getInstance();
    }

    public DownloadService getDownloadService() {
        return DownloadServiceImpl.getInstance();
    }

    public ClipboardService getClipboardService() {
        return ClipboardServiceImpl.getInstance();
    }

    public PrintService getPrintService() {
        return PrintServiceImpl.getInstance();
    }

    public PersistenceService getPersistenceService() {
        return PersistenceServiceImpl.getInstance();
    }

    public ExtendedService getExtendedService() {
        return ExtendedServiceImpl.getInstance();
    }

    public SingleInstanceService getSingleInstanceService() {
        return SingleInstanceServiceImpl.getInstance();
    }

    public IntegrationService getIntegrationService() {
        if (Platform.get().isNativeSandbox()) {
            return new IntegrationServiceNSBImpl(new IntegrationServiceImpl((JNLPClassLoaderIf)this));
        }
        return new IntegrationServiceImpl((JNLPClassLoaderIf)this);
    }

    public DownloadService2 getDownloadService2() {
        return DownloadService2Impl.getInstance();
    }

    @Override
    public AppInfo getAppInfo(URL uRL) {
        AppInfo appInfo = null;
        JARDesc jARDesc = this.getJarDescFromURL(uRL);
        if (jARDesc != null) {
            ResourcesDesc resourcesDesc = jARDesc.getParent();
            if (resourcesDesc != null && resourcesDesc.getParent() != null) {
                appInfo = resourcesDesc.getParent().getAppInfo();
            }
        } else {
            appInfo = this._launchDesc != null ? this._launchDesc.getAppInfo() : new AppInfo();
        }
        return appInfo;
    }

    public DeploymentRuleSet getDeploymentRuleSet(URL uRL) {
        URL uRL2;
        JARDesc jARDesc = this.getJarDescFromURL(uRL);
        if (jARDesc != null && jARDesc.getParent() != null && (uRL2 = jARDesc.getParent().getParent()) != null) {
            CodeRef codeRef = new CodeRef(uRL, null, false, jARDesc.isPack200Enabled());
            AppRef appRef = LaunchDesc.getJNLPAppRef((LaunchDesc)uRL2);
            return DeploymentRuleSet.findDRS((CodeInstance)new CodeInstance(appRef, codeRef));
        }
        uRL2 = this.getLaunchDesc() == null ? null : this.getLaunchDesc().getAnchorURL();
        boolean bl = jARDesc != null ? jARDesc.isPack200Enabled() : false;
        CodeRef codeRef = new CodeRef(uRL, null, false, bl);
        AppRef appRef = new AppRef(AppRef.Type.JNLP, null, null, null, uRL2);
        return DeploymentRuleSet.findDRS((CodeInstance)new CodeInstance(appRef, codeRef));
    }
}

