/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.applet2.preloader.Preloader;
import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.config.Config;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BadCertificateDialog;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.CPCallbackHandler;
import com.sun.deploy.security.CeilingPolicy;
import com.sun.deploy.security.DeployURLClassLoader;
import com.sun.deploy.security.DeployURLClassPath;
import com.sun.deploy.security.DeployURLClassPathCallback;
import com.sun.deploy.security.Resource;
import com.sun.deploy.security.SandboxSecurity;
import com.sun.deploy.security.SecureCookiePermission;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.security.ValidationState;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.StringUtils;
import com.sun.deploy.util.URLUtil;
import java.awt.AWTPermission;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.ArrayList;
import java.util.List;
import java.util.PropertyPermission;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public abstract class Plugin2ClassLoader
extends DeployURLClassLoader {
    protected static final boolean DEBUG = Config.getDebug();
    protected static final String APPLET_CODE_REWRITE_KEY = "applet-code-rewrite-";
    protected URL base;
    protected CodeSource codesource;
    protected AccessControlContext _acc;
    private AppContext appContext;
    private ThreadGroup threadGroup;
    private boolean codebaseLookup = true;
    private boolean codebaseLookupInitialized = false;
    private boolean securityCheck = false;
    private Plugin2ClassLoader pclParent;
    private List<URL> addedURLs = new ArrayList<URL>();
    private CPCallbackHandler cpHandler;
    private DeployURLClassPathCallback.Element codebaseElement;
    protected ClassLoader parent;
    private static final String UNSIGNED_MESSAGE = " because the class is not signed.";
    private boolean shadowClassLoader = false;
    private Preloader preloader = null;
    private static CodeSource lastBadCertCodeSource = null;
    private TrustedResult sandboxResult = new TrustedResult(false);
    private TrustedResult allPermResult = new TrustedResult(true);
    protected static final ThreadLocal<ClassNotFoundException> cnfeThreadLocal = new ThreadLocal();
    private boolean ssvDialogShown;

    protected Plugin2ClassLoader(URL[] uRLArray, URL uRL) {
        super(uRLArray);
        this.base = uRL;
        this.codesource = new CodeSource(uRL, (Certificate[])null);
        this._acc = AccessController.getContext();
        this.parent = this.getParent();
    }

    protected Plugin2ClassLoader(URL[] uRLArray, URL uRL, ClassLoader classLoader) {
        super(uRLArray, classLoader);
        if (classLoader instanceof Plugin2ClassLoader) {
            this.pclParent = (Plugin2ClassLoader)((Object)classLoader);
            this.shadowClassLoader = true;
        }
        this.setDeployURLClassPath(new DeployURLClassPath(uRLArray, this.shadowClassLoader));
        this.parent = classLoader;
        this.base = uRL;
        this.codesource = new CodeSource(uRL, (Certificate[])null);
        this._acc = AccessController.getContext();
    }

    boolean isShadowClassLoader() {
        return this.shadowClassLoader;
    }

    public void close() throws IOException {
        if (Config.isJavaVersionAtLeast17()) {
            super.close();
        }
        this.setDeployURLClassPath(null);
        if (this.pclParent != null) {
            this.pclParent.close();
        }
    }

    public void setPreloader(Preloader preloader) {
        this.preloader = preloader;
    }

    public Preloader getPreloader() {
        return this.preloader;
    }

    public abstract boolean wantsAllPerms(CodeSource var1);

    protected abstract Class<?> findClass(String var1, boolean var2) throws ClassNotFoundException;

    protected synchronized Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        return this.loadClass(string, bl, false);
    }

    protected synchronized Class<?> loadClass(String string, boolean bl, boolean bl2) throws ClassNotFoundException {
        if (string.contains("\u0000")) {
            return null;
        }
        this.checkPackageAccess(string);
        return this.loadClass0(string, bl, bl2);
    }

    private Class<?> loadClass0(String string, boolean bl, boolean bl2) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz == null) {
            try {
                clazz = this.pclParent != null ? this.pclParent.loadClass(string, false, true) : this.parent.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = this.findClass(string, bl2);
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        Permissions permissions = null;
        String string = this.getBaseURL().getHost();
        if (string != null && string.length() > 0) {
            if (!URLUtil.sameBase((URL)this.getBaseURL(), (URL)codeSource.getLocation())) {
                if (DownloadEngine.isKnownRedirectedHost((String)string, (String)codeSource.getLocation().getHost())) {
                    permissions = new Permissions();
                    SandboxSecurity.addConnectPermission((PermissionCollection)permissions, (URL)codeSource.getLocation());
                    Trace.println((String)("Grant connect perm for " + codeSource.getLocation() + " : " + permissions), (TraceLevel)TraceLevel.SECURITY);
                } else {
                    Trace.println((String)("Connect perm was not granted " + codeSource.getLocation()), (TraceLevel)TraceLevel.SECURITY);
                }
            } else {
                permissions = new Permissions();
                SandboxSecurity.addConnectPermission((PermissionCollection)permissions, (URL)codeSource.getLocation());
                Trace.println((String)("Grant connect perm for " + codeSource.getLocation() + " : " + permissions), (TraceLevel)TraceLevel.SECURITY);
            }
        }
        Permissions permissions2 = permissions == null ? new Permissions() : permissions;
        URL uRL = codeSource.getLocation();
        Plugin2ClassLoader.addDefaultPermissions(permissions2);
        TrustedResult trustedResult = this.isTrustedByTrustDecider(codeSource);
        if (trustedResult.allPerms) {
            CeilingPolicy.addTrustedPermissions((PermissionCollection)permissions2);
            Trace.println((String)"Plugin2ClassLoader.getPermissions CeilingPolicy allPerms", (TraceLevel)TraceLevel.BASIC);
        } else if (this.wantsAllPerms(codeSource)) {
            if (trustedResult.cause instanceof BlockedException) {
                throw (BlockedException)trustedResult.cause;
            }
            throw new BlockedException(ResourceManager.getString((String)"trustdecider.user.deny"), trustedResult.cause, codeSource, this.getAppInfo(codeSource.getLocation()));
        }
        Policy policy = AccessController.doPrivileged(new PrivilegedAction<Policy>(){

            @Override
            public Policy run() {
                return Policy.getPolicy();
            }
        });
        PermissionCollection permissionCollection = policy.getPermissions(codeSource);
        if (!((PermissionCollection)permissions2).implies(new AWTPermission("accessClipboard")) && !permissionCollection.implies(new AWTPermission("accessClipboard"))) {
            ToolkitStore.get().getAppContext().put((Object)"UNTRUSTED_CLIPBOARD_ACCESS_KEY", (Object)Boolean.TRUE);
        }
        ((PermissionCollection)permissions2).add((Permission)new SecureCookiePermission(SecureCookiePermission.getURLOriginString((URL)codeSource.getLocation())));
        if (Plugin2ClassLoader.isUnsigned(codeSource)) {
            Object object = this.getCallbackHandler();
            if (object instanceof CPCallbackHandler) {
                CPCallbackHandler cPCallbackHandler = (CPCallbackHandler)object;
                cPCallbackHandler.addJS2JavaAllowedCodebase(codeSource.getLocation());
            }
        } else if (this.isSignedByTrustedCA(codeSource, this.wantsAllPerms(codeSource), this.getAppInfo(uRL))) {
            String string2 = (String)ToolkitStore.get().getAppContext().get((Object)("deploy-" + codeSource.getLocation().toString()));
            JarFile jarFile = ResourceProvider.get().getCachedJarFile(codeSource.getLocation(), string2);
            this.loadAllowedCodebases(jarFile);
        }
        return permissions2;
    }

    private void loadAllowedCodebases(JarFile jarFile) {
        try {
            String string;
            Attributes attributes;
            Manifest manifest = jarFile.getManifest();
            if (manifest != null && (attributes = manifest.getMainAttributes()) != null && (string = attributes.getValue(new Attributes.Name("Caller-Allowable-Codebase"))) != null && string.trim().length() > 0) {
                ClassLoader classLoader;
                Object object = null;
                if (this.pclParent == null) {
                    classLoader = Thread.currentThread().getContextClassLoader();
                    if (classLoader instanceof Plugin2ClassLoader) {
                        object = ((Plugin2ClassLoader)((Object)classLoader)).getCallbackHandler();
                    }
                } else {
                    object = this.getCallbackHandler();
                }
                if (object instanceof CPCallbackHandler) {
                    classLoader = (CPCallbackHandler)object;
                    classLoader.addJS2JavaAllowedCodebasePattern(string);
                    classLoader.setCallerAllowableCodebaseAttributeExists();
                }
            }
        }
        catch (IOException iOException) {
            Trace.ignored((Throwable)iOException);
        }
    }

    private boolean isSignedByTrustedCA(CodeSource codeSource, boolean bl, AppInfo appInfo) {
        ValidationState.TYPE tYPE = bl ? ValidationState.TYPE.ALL_PERMISSIONS : ValidationState.TYPE.SANDBOX_PERMISSIONS;
        ValidationState validationState = TrustDecider.getJarValidationState((CodeSource)codeSource, (AppInfo)appInfo, (ValidationState.TYPE)tYPE, (DeploymentRuleSet)this.getDeploymentRuleSet(codeSource.getLocation()));
        return validationState.rootCAValid;
    }

    private static boolean isUnsigned(CodeSource codeSource) {
        Certificate[] certificateArray = codeSource.getCertificates();
        return certificateArray == null || certificateArray.length == 0;
    }

    private TrustedResult isTrustedByTrustDecider(CodeSource codeSource) {
        if (!this.wantsAllPerms(codeSource)) {
            SandboxSecurity.isPermissionGranted((CodeSource)codeSource, (AppInfo)this.getAppInfo(codeSource.getLocation()), (DeploymentRuleSet)this.getDeploymentRuleSet(codeSource.getLocation()), (Preloader)this.getPreloader());
            return this.sandboxResult;
        }
        TrustedResult trustedResult = this.sandboxResult;
        try {
            long l = TrustDecider.isAllPermissionGranted((CodeSource)codeSource, (AppInfo)this.getAppInfo(codeSource.getLocation()), (DeploymentRuleSet)this.getDeploymentRuleSet(codeSource.getLocation()), null);
            trustedResult = l != 0L ? this.allPermResult : this.sandboxResult;
        }
        catch (CertificateExpiredException certificateExpiredException) {
            this.securityPrintException(certificateExpiredException, ResourceManager.getString((String)"rsa.cert_expired"), ResourceManager.getString((String)"security.dialog.caption"));
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            this.securityPrintException(certificateNotYetValidException, ResourceManager.getString((String)"rsa.cert_notyieldvalid"), ResourceManager.getString((String)"security.dialog.caption"));
        }
        catch (BlockedException blockedException) {
            throw blockedException;
        }
        catch (Exception exception) {
            if (!codeSource.equals(lastBadCertCodeSource)) {
                lastBadCertCodeSource = codeSource;
                BadCertificateDialog.showDialog((CodeSource)codeSource, (AppInfo)this.getAppInfo(codeSource.getLocation()), (Exception)exception);
            }
            trustedResult = new TrustedResult(trustedResult.allPerms, exception);
        }
        return trustedResult;
    }

    private void securityPrintException(Exception exception, String string, String string2) {
        if (this.shadowClassLoader) {
            Trace.ignored((Throwable)exception);
        } else {
            Trace.securityPrintException((Throwable)exception, (String)string, (String)string2);
        }
    }

    public static void addDefaultPermissions(PermissionCollection permissionCollection) {
        permissionCollection.add(new PropertyPermission("browser", "read"));
        permissionCollection.add(new PropertyPermission("browser.version", "read"));
        permissionCollection.add(new PropertyPermission("browser.vendor", "read"));
        permissionCollection.add(new PropertyPermission("http.agent", "read"));
        permissionCollection.add(new PropertyPermission("javapi.*", "read,write"));
        permissionCollection.add(new PropertyPermission("javaws.*", "read,write"));
        permissionCollection.add(new PropertyPermission("jnlp.*", "read,write"));
        permissionCollection.add(new PropertyPermission("javaplugin.version", "read"));
        permissionCollection.add(new PropertyPermission("javaplugin.vm.options", "read"));
        permissionCollection.add(new PropertyPermission("mrj.version", "read"));
    }

    public AppContext getAppContext() {
        return this.appContext;
    }

    public void setAppContext(AppContext appContext) {
        if (appContext != null && this.appContext != null) {
            throw new IllegalStateException("May not set the AppContext twice");
        }
        if (this.pclParent != null) {
            this.pclParent.setAppContext(appContext);
        }
        this.appContext = appContext;
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public void setThreadGroup(ThreadGroup threadGroup) {
        if (threadGroup != null && this.threadGroup != null) {
            throw new IllegalStateException("May not set the ThreadGroup twice");
        }
        if (this.pclParent != null) {
            this.pclParent.setThreadGroup(threadGroup);
        }
        this.threadGroup = threadGroup;
    }

    public synchronized boolean getCodebaseLookup() {
        if (this.codebaseLookup && !this.codebaseLookupInitialized) {
            Object object = this.getCallbackHandler();
            if (object != null) {
                CPCallbackHandler cPCallbackHandler = (CPCallbackHandler)object;
                DeployURLClassPathCallback deployURLClassPathCallback = cPCallbackHandler.getChildCallback();
                DeployURLClassPathCallback deployURLClassPathCallback2 = cPCallbackHandler.getParentCallback();
                try {
                    this.codebaseLookup = false;
                    deployURLClassPathCallback2.openClassPathElement(this.getBaseURL());
                    DeployURLClassPathCallback.Element element = deployURLClassPathCallback.openClassPathElement(this.getBaseURL());
                    this.setCodebaseElement(element);
                    this.codebaseLookup = !element.skip();
                }
                catch (SecurityException securityException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.codebaseLookupInitialized = true;
        }
        return this.codebaseLookup;
    }

    public void setCodebaseLookup(boolean bl) {
        if (this.pclParent != null) {
            this.pclParent.setCodebaseLookup(false);
        }
        this.codebaseLookup = bl;
    }

    void setSecurityCheck(boolean bl) {
        if (this.pclParent != null) {
            this.pclParent.setSecurityCheck(bl);
        }
        this.securityCheck = bl;
    }

    boolean getSecurityCheck() {
        return this.securityCheck;
    }

    public Class loadCode(String string) throws ClassNotFoundException {
        Object object;
        if (string.contains("\u0000")) {
            return null;
        }
        string = StringUtils.replaceSeparators((String)string);
        String string2 = null;
        int n = string.indexOf(";");
        if (n != -1) {
            string2 = string.substring(n, string.length());
            string = string.substring(0, n);
        }
        String string3 = string;
        if (string.endsWith(".class") || string.endsWith(".java")) {
            string = string.substring(0, string.lastIndexOf(46));
        }
        if (string2 != null && (object = this.getAppContext()) != null) {
            object.put((Object)(APPLET_CODE_REWRITE_KEY + string), (Object)string2);
        }
        object = null;
        try {
            return this.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (classNotFoundException.getMessage().contains(UNSIGNED_MESSAGE)) {
                object = classNotFoundException;
            }
            try {
                return this.loadClass(string3);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                if (object != null) {
                    throw object;
                }
                throw classNotFoundException2;
            }
        }
    }

    boolean isClassLoadedByPluginClassLoader(Class<?> clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (this.isShadowClassLoader()) {
            return classLoader == this || classLoader == this.pclParent;
        }
        return classLoader == this;
    }

    public void checkUntrustedAccess(URL uRL, DeploymentRuleSet deploymentRuleSet) throws SecurityException {
        if (this.cpHandler != null) {
            this.cpHandler.checkUntrustedAccess(uRL, deploymentRuleSet);
        }
    }

    private void setCallbackHandler(CPCallbackHandler cPCallbackHandler) {
        this.cpHandler = cPCallbackHandler;
    }

    Object getCallbackHandler() {
        return this.cpHandler;
    }

    private void setCodebaseElement(DeployURLClassPathCallback.Element element) {
        this.codebaseElement = element;
    }

    private Object getCodebaseElement() {
        return this.codebaseElement;
    }

    static boolean setDeployURLClassPathCallbacks(Plugin2ClassLoader plugin2ClassLoader, Plugin2ClassLoader plugin2ClassLoader2) {
        try {
            if (!ResourceProvider.get().hasEnhancedJarAccess()) {
                Trace.println((String)"setDeployURLClassPathCallbacks: no enhanced access", (TraceLevel)TraceLevel.BASIC);
                return false;
            }
            CPCallbackHandler cPCallbackHandler = new CPCallbackHandler((DeployURLClassLoader)plugin2ClassLoader, (DeployURLClassLoader)plugin2ClassLoader2);
            plugin2ClassLoader.getDeployURLClassPath().setDeployURLClassPathCallback(cPCallbackHandler.getParentCallback());
            plugin2ClassLoader2.getDeployURLClassPath().setDeployURLClassPathCallback(cPCallbackHandler.getChildCallback());
            plugin2ClassLoader2.setCallbackHandler(cPCallbackHandler);
            plugin2ClassLoader.setCodebaseLookup(false);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Exception exception) {
            return false;
        }
        catch (Error error) {
            return false;
        }
        return true;
    }

    void setDeployURLClassPathCallback(DeployURLClassPath deployURLClassPath) {
        Object object = this.getCallbackHandler();
        if (object != null) {
            CPCallbackHandler cPCallbackHandler = (CPCallbackHandler)object;
            deployURLClassPath.setDeployURLClassPathCallback(cPCallbackHandler.getChildCallback());
        }
    }

    void checkResource(String string) throws SecurityException {
        Object object = this.getCodebaseElement();
        if (object != null) {
            DeployURLClassPathCallback.Element element = (DeployURLClassPathCallback.Element)object;
            try {
                element.checkResource(string);
            }
            catch (SecurityException securityException) {
                Trace.println((String)("resource name \"" + string + "\" in " + this.base + " : " + securityException), (TraceLevel)TraceLevel.SECURITY);
                throw securityException;
            }
        }
    }

    public void addURL(URL uRL) {
        this.addURL(uRL, false);
    }

    protected void addURL(URL uRL, boolean bl) {
        if (!bl && !URLUtil.checkTargetURL((URL)URLUtil.getBase((URL)this.base), (URL)uRL)) {
            throw new SecurityException("Permission denied: " + uRL);
        }
        if (this.pclParent != null) {
            Trace.println((String)("Plugin2ClassLoader.addURL parent called for " + uRL), (TraceLevel)TraceLevel.BASIC);
            this.pclParent.addURL(uRL, bl);
        }
        super.addURL(uRL);
    }

    void addURL2(URL uRL) {
        if (!URLUtil.checkTargetURL((URL)URLUtil.getBase((URL)this.base), (URL)uRL)) {
            throw new SecurityException("Permission denied: " + uRL);
        }
        if (this.pclParent != null) {
            this.drainPendingURLs();
        } else {
            this.putAddedURL(uRL);
        }
        Trace.println((String)("Plugin2ClassLoader.addURL2 called for " + uRL), (TraceLevel)TraceLevel.BASIC);
        super.addURL(uRL);
    }

    boolean drainPendingURLs() {
        int n;
        List<URL> list = this.pclParent.grabAddedURLs();
        for (n = 0; n < list.size(); ++n) {
            Trace.println((String)("Plugin2ClassLoader.drainPendingURLs addURL called for " + list.get(n)), (TraceLevel)TraceLevel.BASIC);
            super.addURL(list.get(n));
        }
        return n != 0;
    }

    synchronized List<URL> grabAddedURLs() {
        List<URL> list = this.addedURLs;
        this.addedURLs = new ArrayList<URL>();
        return list;
    }

    synchronized void putAddedURL(URL uRL) {
        this.addedURLs.add(uRL);
    }

    protected Class<?> findClassHelper(String string) throws ClassNotFoundException {
        final String string2 = string;
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws ClassNotFoundException {
                    String string = string2.replace('.', '/').concat(".class");
                    DeployURLClassPath deployURLClassPath = Plugin2ClassLoader.this.getDeployURLClassPath();
                    Resource resource = deployURLClassPath.getResource(string, false);
                    if (resource == null) {
                        throw new ClassNotFoundException(string2);
                    }
                    WrapResource wrapResource = new WrapResource(resource);
                    if (Plugin2ClassLoader.this.getSecurityCheck()) {
                        try {
                            wrapResource.getBytes();
                        }
                        catch (IOException iOException) {
                            throw new ClassNotFoundException(string2, iOException);
                        }
                    }
                    if (Plugin2ClassLoader.this.getSecurityCheck() && !Plugin2ClassLoader.this.isAllPermissionGranted(wrapResource, Plugin2ClassLoader.this.getPreloader())) {
                        cnfeThreadLocal.set(Plugin2ClassLoader.newClassNotFoundException(string2));
                        throw cnfeThreadLocal.get();
                    }
                    try {
                        return Plugin2ClassLoader.this.defineClass(string2, wrapResource);
                    }
                    catch (IOException iOException) {
                        throw new ClassNotFoundException(string2, iOException);
                    }
                }
            }, this._acc);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (ClassNotFoundException)privilegedActionException.getException();
        }
    }

    protected static ClassNotFoundException newClassNotFoundException(String string) {
        return new ClassNotFoundException(string + UNSIGNED_MESSAGE);
    }

    protected boolean isAllPermissionGranted(Resource resource, Preloader preloader) {
        URL uRL = resource.getCodeSourceURL();
        CodeSigner[] codeSignerArray = resource.getCodeSigners();
        CodeSource codeSource = codeSignerArray != null ? new CodeSource(uRL, codeSignerArray) : new CodeSource(uRL, resource.getCertificates());
        try {
            return TrustDecider.isAllPermissionGranted((CodeSource)codeSource, (AppInfo)this.getAppInfo(codeSource.getLocation()), (DeploymentRuleSet)this.getDeploymentRuleSet(codeSource.getLocation()), (Preloader)preloader) != 0L;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean getSSVDialogShown() {
        return this.ssvDialogShown;
    }

    public void setSSVDialogShown(boolean bl) {
        this.ssvDialogShown = bl;
    }

    public abstract AppInfo getAppInfo(URL var1);

    public AccessControlContext getACC() {
        return this._acc;
    }

    public URL getBaseURL() {
        return this.base;
    }

    public Resource getResourceAsResource(String string) throws MalformedURLException, FileNotFoundException {
        DeployURLClassPath deployURLClassPath;
        Resource resource;
        if (string.contains("\u0000")) {
            return null;
        }
        if (this.pclParent != null) {
            try {
                return this.pclParent.getResourceAsResource(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if ((resource = (deployURLClassPath = this.getDeployURLClassPath()).getResource(string, false)) != null) {
            return resource;
        }
        if (this.getCodebaseLookup()) {
            DeployURLClassPath deployURLClassPath2 = new DeployURLClassPath(new URL[]{this.getBaseURL()});
            this.setDeployURLClassPathCallback(deployURLClassPath2);
            Resource resource2 = deployURLClassPath2.getResource(string, false);
            if (resource2 != null) {
                return resource2;
            }
        }
        throw new FileNotFoundException("Resource " + string + " not found");
    }

    public AccessControlContext getACC(Resource resource) {
        CodeSource codeSource = new CodeSource(resource.getCodeSourceURL(), resource.getCodeSigners());
        ProtectionDomain protectionDomain = new ProtectionDomain(codeSource, this.getPermissions(codeSource), (ClassLoader)((Object)this), null);
        return new AccessControlContext(new ProtectionDomain[]{protectionDomain});
    }

    private static class TrustedResult {
        final boolean allPerms;
        final Throwable cause;

        TrustedResult(boolean bl) {
            this(bl, null);
        }

        TrustedResult(boolean bl, Throwable throwable) {
            this.allPerms = bl;
            this.cause = throwable;
        }
    }

    private class WrapResource
    extends Resource {
        private Resource res = null;
        private byte[] cbytes;

        public WrapResource(Resource resource) {
            this.res = resource;
        }

        public String getName() {
            return this.res.getName();
        }

        public URL getURL() {
            return this.res.getURL();
        }

        public URL getCodeSourceURL() {
            return this.res.getCodeSourceURL();
        }

        public InputStream getInputStream() throws IOException {
            return this.res.getInputStream();
        }

        public int getContentLength() throws IOException {
            return this.res.getContentLength();
        }

        public byte[] getBytes() throws IOException {
            if (this.cbytes == null) {
                this.cbytes = super.getBytes();
            }
            return (byte[])this.cbytes.clone();
        }

        public ByteBuffer getByteBuffer() throws IOException {
            return this.res.getByteBuffer();
        }

        public Manifest getManifest() throws IOException {
            return this.res.getManifest();
        }

        public Certificate[] getCertificates() {
            try {
                this.getBytes();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.res.getCertificates();
        }

        public CodeSigner[] getCodeSigners() {
            try {
                this.getBytes();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.res.getCodeSigners();
        }
    }
}

