/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.jvm;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.JVMParameters;
import java.io.InputStream;
import sun.plugin2.applet.Plugin2Manager;
import sun.plugin2.jvm.CircularByteBuffer;
import sun.plugin2.jvm.JVMLauncher;
import sun.plugin2.message.Conversation;
import sun.plugin2.message.LaunchJVMAppletMessage;
import sun.plugin2.message.Pipe;

public class RemoteJVMLauncher
extends JVMLauncher
implements Runnable {
    static final boolean DEBUG = false;
    private static final long INTERVAL = 1000L;
    private final Pipe pipe;
    private final Conversation conversation;
    private LaunchJVMAppletMessage message;
    private boolean done;
    private CircularByteBuffer.Streamer inStreamer;
    private CircularByteBuffer.Streamer errStreamer;
    private CallBack callBack;

    public RemoteJVMLauncher(Pipe pipe, LaunchJVMAppletMessage launchJVMAppletMessage, JVMParameters jVMParameters, Plugin2Manager plugin2Manager) {
        super(launchJVMAppletMessage.getLaunchTime(), launchJVMAppletMessage.getJavaHome(), jVMParameters, true);
        this.pipe = pipe;
        this.conversation = launchJVMAppletMessage.getConversation();
        this.message = launchJVMAppletMessage;
    }

    @Override
    public void start() {
        Trace.println((String)("RemoteJVMLauncher.start(), pipe=" + this.pipe.toString() + " message: " + this.message), (TraceLevel)TraceLevel.BASIC);
        this.runThread();
        String[] stringArray = this.message.getAdditionalArgs();
        for (int i = 0; i < stringArray.length; ++i) {
            this.addParameter(stringArray[i]);
        }
        super.start();
    }

    public void setCallBack(CallBack callBack) {
        this.callBack = callBack;
    }

    protected void runThread() {
        Thread thread = new Thread((Runnable)this, this.toString());
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void afterStart() {
        this.initInErrStreamers();
    }

    private synchronized void initInErrStreamers() {
        if (this.inStreamer != null) {
            return;
        }
        if (this.getInputStream() != null) {
            Trace.println((String)"RemoteJVMLauncher.afterStart(): initializing streamers", (TraceLevel)TraceLevel.BASIC);
            this.inStreamer = RemoteJVMLauncher.startStreamToBuffer(this.getInputStream(), "RemoteJVMLauncher-inputStream");
            this.errStreamer = RemoteJVMLauncher.startStreamToBuffer(this.getErrorStream(), "RemoteJVMLauncher-errorStream");
        }
    }

    @Override
    public void run() {
        Trace.println((String)(Thread.currentThread() + " running..."), (TraceLevel)TraceLevel.BASIC);
        if (!this.pipe.joinConversation(this.conversation)) {
            throw new RuntimeException("Failed to join LaunchJVM conversation on " + this.pipe);
        }
        try {
            this.message.setProcessStarted(true);
            boolean bl = false;
            while (!this.done && !this.exited()) {
                Object object;
                this.initInErrStreamers();
                if (this.inStreamer != null && this.errStreamer != null) {
                    this.message.setProcessInputBytes(this.inStreamer.readAvailable());
                    this.message.setProcessErrorBytes(this.errStreamer.readAvailable());
                    if (this.callBack != null && !bl) {
                        bl = true;
                        this.callBack.jvmStarted();
                    }
                } else {
                    object = "Waiting for process spawning...";
                    this.message.setProcessInputBytes(((String)object).getBytes());
                    this.message.setProcessErrorBytes(null);
                }
                this.pipe.send(this.message);
                object = (LaunchJVMAppletMessage)this.pipe.receive(1000L, this.conversation);
                if (object == null) continue;
                this.message = object;
                if (this.message == null || !this.message.isDoKill()) continue;
                this.destroy();
                this.done = true;
            }
            this.message.setProcessExitCode(0);
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
            this.message.setProcessInputBytes(exception.getMessage().getBytes());
            this.message.setProcessErrorBytes(exception.getMessage().getBytes());
            this.message.setProcessExitCode(-1);
        }
        finally {
            this.message.setProcessExited(true);
            Trace.println((String)(Thread.currentThread() + " completing: done=" + this.done + " exited=" + this.exited()), (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)("Sending final message " + this.message.toClientString()), (TraceLevel)TraceLevel.BASIC);
            try {
                this.pipe.send(this.message);
            }
            catch (Exception exception) {
                Trace.println((String)"Exception sending final message", (TraceLevel)TraceLevel.BASIC);
                Trace.ignored((Throwable)exception);
            }
        }
    }

    static CircularByteBuffer.Streamer startStreamToBuffer(InputStream inputStream, String string) {
        CircularByteBuffer.Streamer streamer = new CircularByteBuffer.Streamer(inputStream);
        Thread thread = new Thread((Runnable)streamer, string);
        thread.setDaemon(true);
        thread.start();
        return streamer;
    }

    public String toString() {
        String string = "";
        if (this.message != null) {
            string = string + this.message.getAppletID();
        }
        return "RemoteJVMLauncher-" + string;
    }

    public static interface CallBack {
        public void jvmStarted();
    }
}

