/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.message.transport;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import sun.plugin2.message.Conversation;
import sun.plugin2.message.Message;
import sun.plugin2.message.Serializer;
import sun.plugin2.message.transport.Transport;

public abstract class SerializingTransport
implements Transport {
    private Map<Integer, Constructor<?>> messageIDMap = new HashMap();
    private final Object writeLock = new Object();

    protected SerializingTransport() {
    }

    public void registerMessageID(int n, Class<?> clazz) throws IllegalArgumentException {
        Integer n2 = n;
        if (this.messageIDMap.get(n2) != null) {
            throw new IllegalArgumentException("Message ID " + n + " already registered");
        }
        try {
            Constructor<?> constructor = clazz.getConstructor(Conversation.class);
            this.messageIDMap.put(n2, constructor);
        }
        catch (Exception exception) {
            throw (IllegalArgumentException)new IllegalArgumentException().initCause(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Message message) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            Serializer serializer = this.getSerializer();
            serializer.writeInt(message.getID());
            serializer.writeConversation(message.getConversation());
            message.writeFields(serializer);
            this.signalDataWritten();
        }
    }

    @Override
    public Message read() throws IOException {
        if (!this.isDataAvailable()) {
            return null;
        }
        Serializer serializer = this.getSerializer();
        int n = serializer.readInt();
        Constructor<?> constructor = this.messageIDMap.get(n);
        if (constructor == null) {
            throw new IOException("Unregistered message ID " + n);
        }
        Conversation conversation = serializer.readConversation();
        Message message = null;
        try {
            message = (Message)constructor.newInstance(conversation);
        }
        catch (Exception exception) {
            throw (IOException)new IOException().initCause(exception);
        }
        message.readFields(serializer);
        this.signalDataRead();
        return message;
    }

    @Override
    public abstract void waitForData(long var1) throws IOException;

    protected abstract void signalDataWritten() throws IOException;

    protected abstract void signalDataRead();

    protected abstract boolean isDataAvailable() throws IOException;

    protected abstract Serializer getSerializer();
}

