/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.server.jvm;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.List;
import sun.plugin2.jvm.JVMEventListener;
import sun.plugin2.jvm.ProcessLauncher;
import sun.plugin2.message.Conversation;
import sun.plugin2.message.LaunchJVMAppletMessage;
import sun.plugin2.message.Pipe;
import sun.plugin2.server.main.AppletID;

public class ProxyJVMLauncher
implements ProcessLauncher,
Runnable {
    private static final boolean DEBUG = false;
    private static final long TIMEOUT = 60000L;
    private static final long INTERVAL = 200L;
    private final int appletID;
    private final Pipe pipe;
    private Conversation conversation;
    private LaunchJVMAppletMessage message;
    private long launchTime;
    private String javaHome;
    private List additionalArguments = new ArrayList();
    private boolean done = false;
    private int exitCode = 0;
    private PipedInputStream in;
    private PipedInputStream err;
    private Exception launchException;
    private Thread thread;
    private boolean sendKill;
    private final ArrayList listeners = new ArrayList();

    public ProxyJVMLauncher(AppletID appletID, Pipe pipe, long l, String string) {
        this.appletID = appletID.getID();
        this.pipe = pipe;
        this.launchTime = l;
        this.javaHome = string;
        this.in = new PipedInputStream();
        this.err = new PipedInputStream();
    }

    @Override
    public void start() {
        this.runThread();
        this.waitForRemoteProcessStarted(60000L);
    }

    protected void runThread() {
        Thread thread = new Thread((Runnable)this, this.toString());
        thread.setDaemon(true);
        thread.start();
        this.thread = thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void waitForRemoteProcessStarted(long l) {
        try {
            long l2 = 0L;
            while (true) {
                if (this.message != null) {
                    if (this.message.isProcessStarted()) return;
                }
                ProxyJVMLauncher proxyJVMLauncher = this;
                synchronized (proxyJVMLauncher) {
                    this.wait(200L);
                    if ((l2 += 200L) > l) {
                        throw new RuntimeException(this + ": exceeds wait time for remote process");
                    }
                }
            }
        }
        catch (Exception exception) {
            this.launchException = exception;
            return;
        }
    }

    private String[] getAdditionalArgs() {
        String[] stringArray = new String[this.additionalArguments.size()];
        return this.additionalArguments.toArray(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.conversation = this.pipe.beginConversation();
            this.message = new LaunchJVMAppletMessage(this.conversation, this.appletID, this.javaHome, this.launchTime, this.getAdditionalArgs());
            this.pipe.send(this.message);
            PipedOutputStream pipedOutputStream = new PipedOutputStream(this.in);
            PipedOutputStream pipedOutputStream2 = new PipedOutputStream(this.err);
            while (!this.done) {
                LaunchJVMAppletMessage launchJVMAppletMessage = (LaunchJVMAppletMessage)this.pipe.receive(60000L, this.conversation);
                if (launchJVMAppletMessage == null) {
                    ProxyJVMLauncher proxyJVMLauncher = this;
                    synchronized (proxyJVMLauncher) {
                        this.wait(200L);
                        continue;
                    }
                }
                this.message = launchJVMAppletMessage;
                if (this.message.getProcessInputBytes() != null) {
                    pipedOutputStream.write(this.message.getProcessInputBytes());
                    ((OutputStream)pipedOutputStream).flush();
                }
                if (this.message.getProcessErrorBytes() != null) {
                    pipedOutputStream2.write(this.message.getProcessErrorBytes());
                    ((OutputStream)pipedOutputStream2).flush();
                }
                this.done = this.message.isProcessExited();
                if (this.done) {
                    System.out.println("ProxyJVMLauncher: remote process exited.");
                    this.fireJVMExited();
                    this.exitCode = this.message.getProcessExitCode();
                    break;
                }
                if (!this.sendKill) continue;
                System.out.println("ProxyJVMLauncher: sending kill " + this.message);
                this.message.setDoKill(true);
                this.sendKill = false;
                this.pipe.send(this.message);
            }
        }
        catch (Exception exception) {
            this.launchException = exception;
            System.out.println("ProxyJVMLauncher.run() got error ");
            exception.printStackTrace();
        }
    }

    public void launchCompleted() {
        this.done = true;
    }

    @Override
    public void addParameter(String string) {
        this.additionalArguments.add(string);
    }

    @Override
    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public InputStream getErrorStream() {
        return this.err;
    }

    public boolean processStarted() {
        return this.message.isProcessStarted();
    }

    @Override
    public boolean exited() {
        return this.done;
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    @Override
    public long getJVMLaunchTime() {
        return this.launchTime;
    }

    @Override
    public Exception getErrorDuringStartup() {
        return this.launchException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addJVMEventListener(JVMEventListener jVMEventListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(jVMEventListener);
        }
    }

    @Override
    public void clearUserArguments() {
    }

    @Override
    public void destroy() {
        if (this.thread.isAlive()) {
            this.sendKill = true;
        } else {
            this.done = true;
        }
    }

    private synchronized List copyListeners() {
        return (List)this.listeners.clone();
    }

    private void fireJVMExited() {
        for (JVMEventListener jVMEventListener : this.copyListeners()) {
            jVMEventListener.jvmExited(this);
        }
    }

    public String toString() {
        return "ProxyJVMLauncher(appletID=" + this.appletID + ")";
    }
}

