/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import com.sun.javaws.IconUtil;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.ui.LaunchErrorDialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class ApplicationIconGenerator
extends Thread {
    private File _index;
    private File _dir;
    private final String _key;
    private final LaunchDesc _ld;
    private Properties _props = new Properties();

    public static void generate(LaunchDesc launchDesc, boolean bl) {
        if (!Cache.isCacheEnabled()) {
            return;
        }
        if (launchDesc.isApplicationDescriptor()) {
            ApplicationIconGenerator applicationIconGenerator = new ApplicationIconGenerator(launchDesc);
            if (bl || applicationIconGenerator.needsCustomIcon()) {
                applicationIconGenerator.start();
            }
        }
    }

    public static void removeCustomIcon(LaunchDesc launchDesc) {
        if (launchDesc.isApplicationDescriptor()) {
            ApplicationIconGenerator applicationIconGenerator = new ApplicationIconGenerator(launchDesc);
            applicationIconGenerator.remove();
        }
    }

    public ApplicationIconGenerator(LaunchDesc launchDesc) {
        this._ld = launchDesc;
        this._dir = new File(Config.getAppIconDir());
        this._key = this._ld.getSplashCanonicalHome();
        String string = Config.getAppIconIndex();
        this._index = new File(string);
        Config.setAppIconCache();
        Config.get().storeIfNeeded();
        if (this._index.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(this._index);
                if (fileInputStream != null) {
                    this._props.load(fileInputStream);
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
    }

    public boolean needsCustomIcon() {
        return this._key != null ? !this._props.containsKey(this._key) : false;
    }

    public void remove() {
        this.addAppIconToCacheIndex(this._key, null);
    }

    @Override
    public void run() {
        if (!this._dir.getParentFile().canWrite() || this._dir.exists() && !this._dir.canWrite() || this._index.exists() && !this._index.canWrite()) {
            return;
        }
        try {
            this._dir.mkdirs();
        }
        catch (Throwable throwable) {
            this.appIconError(throwable);
        }
        try {
            this._index.createNewFile();
        }
        catch (Throwable throwable) {
            this.appIconError(throwable);
        }
        String string = IconUtil.getIconPath(this._ld);
        if (string == null) {
            return;
        }
        try {
            this.addAppIconToCacheIndex(this._key, string);
        }
        catch (Throwable throwable) {
            Trace.ignored((Throwable)throwable);
        }
    }

    private void addAppIconToCacheIndex(String string, String string2) {
        if (string == null) {
            return;
        }
        if (string2 != null) {
            this._props.setProperty(string, string2);
        } else if (this._props.containsKey(string)) {
            this._props.remove(string);
        }
        File[] fileArray = this._dir.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].equals(this._index)) continue;
            try {
                String string3 = fileArray[i].getCanonicalPath();
                if (this._props.containsValue(string3)) continue;
                fileArray[i].delete();
                continue;
            }
            catch (IOException iOException) {
                this.appIconError(iOException);
            }
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this._index);
            this._props.store(fileOutputStream, "");
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            this.appIconError(iOException);
        }
    }

    private void appIconError(Throwable throwable) {
        LaunchErrorDialog.show(null, throwable, false);
        throw new Error(throwable.toString());
    }
}

