/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.config.Platform;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import com.sun.deploy.util.Waiter;
import com.sun.javaws.util.JNLPUtils;
import com.sun.jnlp.ApiDialog;
import com.sun.jnlp.CheckServicePermission;
import com.sun.jnlp.FileContentsImpl;
import com.sun.jnlp.FileOpenServiceNSBImpl;
import com.sun.jnlp.FileSaveServiceImpl;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;

public final class FileOpenServiceImpl
implements FileOpenService {
    static FileOpenService _sharedInstance = null;
    static FileSaveServiceImpl _fileSaveServiceImpl;
    private final ApiDialog _apiDialog;
    private static final AccessControlContext ACC_FILE_INSTANCE;
    private static final AccessControlContext ACC_DIALOG_INSTANCE;

    private FileOpenServiceImpl(FileSaveServiceImpl fileSaveServiceImpl) {
        _fileSaveServiceImpl = fileSaveServiceImpl;
        this._apiDialog = new ApiDialog();
    }

    public static synchronized FileOpenService getInstance() {
        if (_sharedInstance == null) {
            _sharedInstance = Platform.get().isNativeSandbox() ? new FileOpenServiceNSBImpl(new FileOpenServiceImpl(new FileSaveServiceImpl())) : new FileOpenServiceImpl((FileSaveServiceImpl)FileSaveServiceImpl.getInstance());
        }
        return _sharedInstance;
    }

    @Override
    public FileContents openFileDialog(final String string, final String[] stringArray) throws IOException {
        if (!this.askUser()) {
            return null;
        }
        Waiter.WaiterTask waiterTask = new Waiter.WaiterTask(){

            public Object run() throws Exception {
                return (FileContents)DeploySysRun.executePrivileged((DeploySysAction)new DeploySysAction(){

                    public Object execute() {
                        File[] fileArray;
                        String string = string;
                        if (string == null) {
                            string = _fileSaveServiceImpl.getLastPath();
                        }
                        if ((fileArray = ToolkitStore.getUI().showFileChooser(string, stringArray, 8, false, null))[0] != null) {
                            try {
                                _fileSaveServiceImpl.setLastPath(fileArray[0].getPath());
                                return new FileContentsImpl(fileArray[0], FileSaveServiceImpl.computeMaxLength(fileArray[0].length()));
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        return null;
                    }
                }, null, (AccessControlContext)ACC_DIALOG_INSTANCE);
            }
        };
        try {
            return (FileContents)Waiter.runAndWait((Waiter.WaiterTask)waiterTask);
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
            return null;
        }
    }

    String openFileDialogNSB(final String string, final String[] stringArray) throws IOException {
        Waiter.WaiterTask waiterTask = new Waiter.WaiterTask(){

            public Object run() throws Exception {
                return (String)DeploySysRun.executePrivileged((DeploySysAction)new DeploySysAction(){

                    public Object execute() {
                        File[] fileArray;
                        String string = string;
                        if (string == null) {
                            string = _fileSaveServiceImpl.getLastPath();
                        }
                        if ((fileArray = ToolkitStore.getUI().showFileChooser(string, stringArray, 8, false, null))[0] != null) {
                            _fileSaveServiceImpl.setLastPath(fileArray[0].getPath());
                            return fileArray[0].getAbsolutePath();
                        }
                        return null;
                    }
                }, null, (AccessControlContext)ACC_DIALOG_INSTANCE);
            }
        };
        try {
            return (String)Waiter.runAndWait((Waiter.WaiterTask)waiterTask);
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
            return null;
        }
    }

    @Override
    public FileContents[] openMultiFileDialog(final String string, final String[] stringArray) throws IOException {
        if (!this.askUser()) {
            return null;
        }
        Waiter.WaiterTask waiterTask = new Waiter.WaiterTask(){

            public Object run() throws Exception {
                return (FileContents[])DeploySysRun.executePrivileged((DeploySysAction)new DeploySysAction(){

                    public Object execute() {
                        File[] fileArray;
                        String string = string;
                        if (string == null) {
                            string = _fileSaveServiceImpl.getLastPath();
                        }
                        if ((fileArray = ToolkitStore.getUI().showFileChooser(string, stringArray, 8, true, null)) != null && fileArray.length > 0) {
                            FileContents[] fileContentsArray = new FileContents[fileArray.length];
                            for (int i = 0; i < fileArray.length; ++i) {
                                try {
                                    fileContentsArray[i] = new FileContentsImpl(fileArray[i], FileSaveServiceImpl.computeMaxLength(fileArray[i].length()));
                                    _fileSaveServiceImpl.setLastPath(fileArray[i].getPath());
                                    continue;
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            return fileContentsArray;
                        }
                        return null;
                    }
                }, null, (AccessControlContext)ACC_DIALOG_INSTANCE);
            }
        };
        try {
            return (FileContents[])Waiter.runAndWait((Waiter.WaiterTask)waiterTask);
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
            return null;
        }
    }

    String[] openMultiFileDialogNSB(final String string, final String[] stringArray) throws IOException {
        Waiter.WaiterTask waiterTask = new Waiter.WaiterTask(){

            public Object run() throws Exception {
                return (String[])DeploySysRun.executePrivileged((DeploySysAction)new DeploySysAction(){

                    public Object execute() {
                        File[] fileArray;
                        String string = string;
                        if (string == null) {
                            string = _fileSaveServiceImpl.getLastPath();
                        }
                        if ((fileArray = ToolkitStore.getUI().showFileChooser(string, stringArray, 8, true, null)) != null && fileArray.length > 0) {
                            String[] stringArray = new String[fileArray.length];
                            for (int i = 0; i < fileArray.length; ++i) {
                                stringArray[i] = fileArray[i].getAbsolutePath();
                                _fileSaveServiceImpl.setLastPath(fileArray[i].getPath());
                            }
                            return stringArray;
                        }
                        return null;
                    }
                }, null, (AccessControlContext)ACC_DIALOG_INSTANCE);
            }
        };
        try {
            return (String[])Waiter.runAndWait((Waiter.WaiterTask)waiterTask);
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
            return null;
        }
    }

    synchronized boolean askUser() {
        Object object;
        if (CheckServicePermission.hasFileAccessPermissions()) {
            return true;
        }
        final LocalApplicationProperties localApplicationProperties = JNLPUtils.getLocalApplicationProperties();
        if (localApplicationProperties != null && (object = localApplicationProperties.get("jnlp.api.always.FileOpenService.open")) != null) {
            return true;
        }
        object = this._apiDialog.askUser(ResourceManager.getString((String)"api.file.open.title"), ResourceManager.getString((String)"api.file.open.message"), ResourceManager.getString((String)"api.file.open.always"));
        if (object == ApiDialog.DialogResult.ALWAYS) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    localApplicationProperties.put("jnlp.api.always.FileOpenService.open", "skip");
                    try {
                        localApplicationProperties.store();
                    }
                    catch (Throwable throwable) {
                        Trace.ignored((Throwable)throwable);
                    }
                    return null;
                }
            }, ACC_FILE_INSTANCE);
        }
        return object == ApiDialog.DialogResult.OK || object == ApiDialog.DialogResult.ALWAYS;
    }

    static {
        ACC_FILE_INSTANCE = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

            @Override
            public AccessControlContext run() {
                Permissions permissions = new Permissions();
                FilePermission filePermission = new FilePermission("<<ALL FILES>>", "read,write");
                ((PermissionCollection)permissions).add(filePermission);
                return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
            }
        });
        ACC_DIALOG_INSTANCE = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

            @Override
            public AccessControlContext run() {
                Permissions permissions = new Permissions();
                FilePermission filePermission = new FilePermission("<<ALL FILES>>", "read,write");
                ((PermissionCollection)permissions).add(filePermission);
                RuntimePermission runtimePermission = new RuntimePermission("setContextClassLoader");
                ((PermissionCollection)permissions).add(runtimePermission);
                return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
            }
        });
    }
}

