/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.association.Association;
import com.sun.deploy.association.AssociationDesc;
import com.sun.deploy.association.AssociationNotRegisteredException;
import com.sun.deploy.association.RegisterFailedException;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.ResourceProvider;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ShortcutDesc;
import com.sun.jnlp.JNLPClassLoaderIf;
import java.io.FilePermission;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLPermission;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.PropertyPermission;
import javax.jnlp.IntegrationService;

public final class IntegrationServiceImpl
implements IntegrationService {
    private JNLPClassLoaderIf jnlpClassLoader;
    private static final AccessControlContext ACC_INT_INSTANCE = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

        @Override
        public AccessControlContext run() {
            Permissions permissions = new Permissions();
            ((PermissionCollection)permissions).add(new FilePermission("<<ALL FILES>>", "read,write,delete,execute"));
            ((PermissionCollection)permissions).add(new PropertyPermission("os.name", "read"));
            ((PermissionCollection)permissions).add(new PropertyPermission("user.home", "read"));
            ((PermissionCollection)permissions).add(new SocketPermission("*", "connect,resolve"));
            ((PermissionCollection)permissions).add(new URLPermission("http:*", "*:*"));
            ((PermissionCollection)permissions).add(new URLPermission("https:*", "*:*"));
            return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
        }
    });
    private static final String TSPECIALS = "()<>@,;:\\\"/[]?=";

    public IntegrationServiceImpl(JNLPClassLoaderIf jNLPClassLoaderIf) {
        this.jnlpClassLoader = jNLPClassLoaderIf;
    }

    @Override
    public boolean requestShortcut(boolean bl, boolean bl2, String string) {
        final boolean bl3 = bl || bl2;
        final LaunchDesc launchDesc = this.jnlpClassLoader.getLaunchDesc();
        InformationDesc informationDesc = launchDesc.getInformation();
        informationDesc.setShortcut(new ShortcutDesc(true, false, bl, bl2, string));
        final LocalInstallHandler localInstallHandler = LocalInstallHandler.getInstance();
        final LocalApplicationProperties localApplicationProperties = this.getLocalApplicationProperties(launchDesc);
        Boolean bl4 = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                boolean bl = false;
                if (localInstallHandler.isLocalInstallSupported()) {
                    bl = localInstallHandler.performIntegration(null, launchDesc, localApplicationProperties, false, true, false);
                    try {
                        localApplicationProperties.store();
                    }
                    catch (Exception exception) {}
                } else {
                    bl = !bl3;
                }
                return bl;
            }
        }, ACC_INT_INSTANCE);
        return bl4;
    }

    @Override
    public boolean hasDesktopShortcut() {
        return this.hasShortcut(0);
    }

    @Override
    public boolean hasMenuShortcut() {
        return this.hasShortcut(1);
    }

    private boolean hasShortcut(int n) {
        LaunchDesc launchDesc = this.jnlpClassLoader.getLaunchDesc();
        final LocalInstallHandler localInstallHandler = LocalInstallHandler.getInstance();
        final LocalApplicationProperties localApplicationProperties = this.getLocalApplicationProperties(launchDesc);
        boolean[] blArray = AccessController.doPrivileged(new PrivilegedAction<boolean[]>(){

            @Override
            public boolean[] run() {
                return localInstallHandler.whichShortcutsExist(localApplicationProperties);
            }
        }, ACC_INT_INSTANCE);
        return blArray[n];
    }

    private LocalApplicationProperties getLocalApplicationProperties(final LaunchDesc launchDesc) {
        LocalApplicationProperties localApplicationProperties = AccessController.doPrivileged(new PrivilegedAction<LocalApplicationProperties>(){

            @Override
            public LocalApplicationProperties run() {
                URL uRL = launchDesc.getCanonicalHome();
                return ResourceProvider.get().getLocalApplicationProperties(uRL, null, true);
            }
        }, ACC_INT_INSTANCE);
        return localApplicationProperties;
    }

    @Override
    public boolean removeShortcuts() {
        final LaunchDesc launchDesc = this.jnlpClassLoader.getLaunchDesc();
        final LocalInstallHandler localInstallHandler = LocalInstallHandler.getInstance();
        final LocalApplicationProperties localApplicationProperties = this.getLocalApplicationProperties(launchDesc);
        Boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                boolean bl = localInstallHandler.uninstallShortcuts(launchDesc, localApplicationProperties);
                try {
                    localApplicationProperties.store();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return bl;
            }
        }, ACC_INT_INSTANCE);
        return bl;
    }

    @Override
    public boolean requestAssociation(String string, String[] stringArray) {
        this.validateAssociationArguments(string, stringArray);
        final LaunchDesc launchDesc = this.jnlpClassLoader.getLaunchDesc();
        InformationDesc informationDesc = launchDesc.getInformation();
        AssociationDesc associationDesc = this.createAssociationDesc(string, stringArray);
        informationDesc.setAssociation(associationDesc);
        final LocalApplicationProperties localApplicationProperties = this.getLocalApplicationProperties(launchDesc);
        final LocalInstallHandler localInstallHandler = LocalInstallHandler.getInstance();
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                boolean bl = false;
                if (localInstallHandler.isAssociationSupported()) {
                    bl = localInstallHandler.performIntegration(null, launchDesc, localApplicationProperties, false, false, true);
                }
                return bl;
            }
        }, ACC_INT_INSTANCE);
    }

    @Override
    public boolean hasAssociation(String string, String[] stringArray) {
        this.validateAssociationArguments(string, stringArray);
        final LaunchDesc launchDesc = this.jnlpClassLoader.getLaunchDesc();
        final LocalApplicationProperties localApplicationProperties = this.getLocalApplicationProperties(launchDesc);
        final Association association = this.createAssociation(string, stringArray);
        final LocalInstallHandler localInstallHandler = LocalInstallHandler.getInstance();
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return localInstallHandler.hasAssociation(launchDesc, localApplicationProperties, association);
            }
        }, ACC_INT_INSTANCE);
    }

    @Override
    public boolean removeAssociation(String string, String[] stringArray) {
        this.validateAssociationArguments(string, stringArray);
        final LaunchDesc launchDesc = this.jnlpClassLoader.getLaunchDesc();
        final LocalApplicationProperties localApplicationProperties = this.getLocalApplicationProperties(launchDesc);
        final Association association = this.createAssociation(string, stringArray);
        final LocalInstallHandler localInstallHandler = LocalInstallHandler.getInstance();
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                Boolean bl = Boolean.TRUE;
                if (localInstallHandler.isAssociationSupported()) {
                    try {
                        localInstallHandler.unregisterAssociationInternal(launchDesc, localApplicationProperties, association);
                    }
                    catch (AssociationNotRegisteredException associationNotRegisteredException) {
                        bl = Boolean.FALSE;
                    }
                    catch (RegisterFailedException registerFailedException) {
                        bl = Boolean.FALSE;
                    }
                }
                return bl;
            }
        }, ACC_INT_INSTANCE);
    }

    private void validateAssociationArguments(String string, String[] stringArray) {
        this.validateMimeType(string);
        this.validateExtensions(stringArray);
    }

    private void validateExtensions(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Null or empty extensions array not allowed");
        }
        for (String string : stringArray) {
            if (string == null) {
                throw new IllegalArgumentException("Null extension not allowed");
            }
            if (!string.equals("")) continue;
            throw new IllegalArgumentException("Empty extension not allowed");
        }
    }

    private void validateMimeType(String string) {
        String string2;
        String string3;
        if (string == null) {
            throw new IllegalArgumentException("Null mimetype not allowed");
        }
        int n = string.indexOf(47);
        int n2 = string.indexOf(59);
        if (n < 0 && n2 < 0) {
            throw new IllegalArgumentException("Unable to find a sub type.");
        }
        if (n < 0 && n2 >= 0) {
            throw new IllegalArgumentException("Unable to find a sub type.");
        }
        if (n >= 0 && n2 < 0) {
            string3 = string.substring(0, n).trim().toLowerCase();
            string2 = string.substring(n + 1).trim().toLowerCase();
        } else if (n < n2) {
            string3 = string.substring(0, n).trim().toLowerCase();
            string2 = string.substring(n + 1, n2).trim().toLowerCase();
        } else {
            throw new IllegalArgumentException("Unable to find a sub type.");
        }
        if (!this.isValidToken(string3)) {
            throw new IllegalArgumentException("Primary type is invalid.");
        }
        if (!this.isValidToken(string2)) {
            throw new IllegalArgumentException("Sub type is invalid.");
        }
    }

    private boolean isValidToken(String string) {
        int n = string.length();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (IntegrationServiceImpl.isTokenChar(c)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isTokenChar(char c) {
        return c > ' ' && c < '\u007f' && TSPECIALS.indexOf(c) < 0;
    }

    private Association createAssociation(String string, String[] stringArray) {
        Association association = new Association();
        association.setMimeType(string);
        for (String string2 : stringArray) {
            association.addFileExtension(string2);
        }
        LaunchDesc launchDesc = this.jnlpClassLoader.getLaunchDesc();
        association.setName(this.getAssociationDescription(launchDesc));
        return association;
    }

    private AssociationDesc createAssociationDesc(String string, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append(' ');
        }
        LaunchDesc launchDesc = this.jnlpClassLoader.getLaunchDesc();
        AssociationDesc associationDesc = new AssociationDesc(stringBuilder.toString(), string, this.getAssociationDescription(launchDesc), null);
        return associationDesc;
    }

    private String getAssociationDescription(LaunchDesc launchDesc) {
        return launchDesc.getInformation().getTitle();
    }
}

