/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.applet2.preloader.Preloader;
import com.sun.deploy.config.OSType;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.ref.AppRef;
import com.sun.deploy.ref.CodeInstance;
import com.sun.deploy.ref.CodeRef;
import com.sun.deploy.security.CPCallbackHandler;
import com.sun.deploy.security.DeployURLClassLoader;
import com.sun.deploy.security.DeployURLClassPath;
import com.sun.deploy.security.Resource;
import com.sun.deploy.security.SandboxSecurity;
import com.sun.deploy.security.SecureCookiePermission;
import com.sun.deploy.security.SecureStaticVersioning;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.FXLoader;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.progress.Progress;
import com.sun.javaws.security.AppPolicy;
import com.sun.javaws.util.JNLPUtils;
import com.sun.jnlp.BasicServiceImpl;
import com.sun.jnlp.ClipboardServiceImpl;
import com.sun.jnlp.DownloadService2Impl;
import com.sun.jnlp.DownloadServiceImpl;
import com.sun.jnlp.ExtendedServiceImpl;
import com.sun.jnlp.ExtensionInstallerServiceImpl;
import com.sun.jnlp.FileOpenServiceImpl;
import com.sun.jnlp.FileSaveServiceImpl;
import com.sun.jnlp.IntegrationServiceImpl;
import com.sun.jnlp.IntegrationServiceNSBImpl;
import com.sun.jnlp.JNLPClassLoaderIf;
import com.sun.jnlp.PersistenceServiceImpl;
import com.sun.jnlp.PrintServiceImpl;
import com.sun.jnlp.SingleInstanceServiceImpl;
import java.awt.AWTPermission;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import javax.jnlp.BasicService;
import javax.jnlp.ClipboardService;
import javax.jnlp.DownloadService;
import javax.jnlp.DownloadService2;
import javax.jnlp.ExtendedService;
import javax.jnlp.ExtensionInstallerService;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.IntegrationService;
import javax.jnlp.PersistenceService;
import javax.jnlp.PrintService;
import javax.jnlp.SingleInstanceService;

public final class JNLPClassLoader
extends DeployURLClassLoader
implements JNLPClassLoaderIf {
    private static JNLPClassLoader _instance = null;
    private LaunchDesc _launchDesc = null;
    private AppPolicy _appPolicy;
    private AccessControlContext _acc = null;
    private boolean _initialized = false;
    private Map<String, JARDesc> _jarsInURLClassLoader = new HashMap<String, JARDesc>();
    private ArrayList<JARDesc> _jarsNotInURLClassLoader = new ArrayList();
    private List<URL> addedURLs = new ArrayList<URL>();
    private JNLPClassLoader _jclParent;

    private JNLPClassLoader(ClassLoader classLoader) {
        super(new URL[0], classLoader);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        if (classLoader instanceof JNLPClassLoader) {
            this._jclParent = (JNLPClassLoader)((Object)classLoader);
        }
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        this.checkPackageAccess(string);
        return super.loadClass(string, bl);
    }

    private void initialize(LaunchDesc launchDesc, AppPolicy appPolicy) {
        this._launchDesc = launchDesc;
        this._acc = AccessController.getContext();
        this._appPolicy = appPolicy;
        this._initialized = true;
        if (this._jclParent != null) {
            this._jclParent.initialize(launchDesc, appPolicy);
            this.drainPendingURLs();
            return;
        }
        if (launchDesc.needFX()) {
            try {
                FXLoader.loadFX();
            }
            catch (Throwable throwable) {
                Trace.ignored((Throwable)throwable);
            }
        }
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        ArrayList<JARDesc> arrayList = new ArrayList<JARDesc>();
        if (resourcesDesc != null) {
            JNLPUtils.sortResourcesForClasspath(resourcesDesc, arrayList, this._jarsNotInURLClassLoader);
            for (JARDesc jARDesc : arrayList) {
                this._jarsInURLClassLoader.put(URLUtil.toNormalizedString((URL)jARDesc.getLocation()), jARDesc);
                this.addURL2(jARDesc.getLocation());
            }
        }
    }

    @Override
    public Preloader getPreloader() {
        return Progress.get(null);
    }

    public static JNLPClassLoader createClassLoader() {
        if (_instance == null) {
            JNLPClassLoader jNLPClassLoader;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            JNLPClassLoader jNLPClassLoader2 = new JNLPClassLoader(classLoader);
            _instance = !JNLPClassLoader.setDeployURLClassPathCallbacks(jNLPClassLoader2, jNLPClassLoader = new JNLPClassLoader((ClassLoader)((Object)jNLPClassLoader2))) ? jNLPClassLoader2 : jNLPClassLoader;
        }
        return _instance;
    }

    public static JNLPClassLoader createClassLoader(LaunchDesc launchDesc, AppPolicy appPolicy) {
        JNLPClassLoader jNLPClassLoader = JNLPClassLoader.createClassLoader();
        if (!jNLPClassLoader._initialized) {
            jNLPClassLoader.initialize(launchDesc, appPolicy);
        }
        return jNLPClassLoader;
    }

    public static JNLPClassLoaderIf getInstance() {
        return _instance;
    }

    @Override
    public LaunchDesc getLaunchDesc() {
        return this._launchDesc;
    }

    @Override
    public JARDesc getJarDescFromURL(URL uRL) {
        if (this._jclParent != null) {
            return this._jclParent.getJarDescFromURL(uRL);
        }
        String string = URLUtil.toNormalizedString((URL)uRL);
        JARDesc jARDesc = this._jarsInURLClassLoader.get(string);
        if (jARDesc != null) {
            return jARDesc;
        }
        HashMap<String, JARDesc> hashMap = new HashMap<String, JARDesc>();
        for (String string2 : this._jarsInURLClassLoader.keySet()) {
            jARDesc = this._jarsInURLClassLoader.get(string2);
            String string3 = URLUtil.toNormalizedString((URL)DownloadEngine.getKnownRedirectFinalURL((URL)jARDesc.getLocation()));
            if (this._jarsInURLClassLoader.containsKey(string3)) continue;
            hashMap.put(string3, jARDesc);
            if (!string.equals(string3)) continue;
            this._jarsInURLClassLoader.putAll(hashMap);
            return jARDesc;
        }
        this._jarsInURLClassLoader.putAll(hashMap);
        return null;
    }

    @Override
    public int getDefaultSecurityModel() {
        return this._launchDesc.getSecurityModel();
    }

    public AppInfo getAppInfo(URL uRL) {
        LaunchDesc launchDesc;
        JARDesc jARDesc = this.getJarDescFromURL(uRL);
        if (jARDesc != null && jARDesc.getParent() != null && (launchDesc = jARDesc.getParent().getParent()) != null) {
            return launchDesc.getAppInfo();
        }
        return new AppInfo();
    }

    @Override
    public URL getResource(String string) {
        URL uRL = null;
        for (int i = 0; uRL == null && i < 3; ++i) {
            uRL = super.getResource(string);
        }
        return uRL;
    }

    private String findLibrary0(String string) {
        JARDesc[] jARDescArray;
        ResourcesDesc resourcesDesc = this._launchDesc.getResources();
        for (JARDesc jARDesc : jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true)) {
            if (!jARDesc.isNativeLib()) continue;
            try {
                String string2 = ResourceProvider.get().getLibraryDirForJar(string, jARDesc.getLocation(), jARDesc.getVersion());
                if (string2 == null) continue;
                return new File(string2, string).getAbsolutePath();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
        return null;
    }

    protected String findLibrary(String string) {
        if (this._jclParent != null) {
            return this._jclParent.findLibrary(string);
        }
        if (!this._initialized) {
            return super.findLibrary(string);
        }
        String string2 = System.mapLibraryName(string);
        Trace.println((String)("JNLPClassLoader: Finding library " + string2));
        String string3 = this.findLibrary0(string2);
        if (string3 != null) {
            return string3;
        }
        if (OSType.isMac() && (string3 = this.findLibrary0(string2 = "lib" + string + ".jnilib")) != null) {
            return string3;
        }
        Trace.println((String)("JNLPClassLoader: Native library " + string + " not found"), (TraceLevel)TraceLevel.NETWORK);
        return super.findLibrary(string);
    }

    protected Class<?> findClass(String string) throws ClassNotFoundException {
        if (!this._initialized) {
            return super.findClass(string);
        }
        try {
            return super.findClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (!(classNotFoundException.getCause() instanceof JARSigningException) && this.checkPackageParts(string)) {
                return super.findClass(string);
            }
            throw classNotFoundException;
        }
    }

    public Resource getResourceAsResource(String string) throws MalformedURLException, FileNotFoundException {
        DeployURLClassPath deployURLClassPath;
        Resource resource;
        if (this._jclParent != null) {
            try {
                return this._jclParent.getResourceAsResource(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if ((resource = (deployURLClassPath = this.getDeployURLClassPath()).getResource(string, false)) != null) {
            return resource;
        }
        throw new FileNotFoundException("Resource " + string + " not found");
    }

    @Override
    public URL findResource(String string) {
        URL uRL = super.findResource(string);
        if (!this._initialized) {
            return uRL;
        }
        if (uRL == null && this.checkPackageParts(string)) {
            uRL = super.findResource(string);
        }
        return uRL;
    }

    private boolean checkPackageParts(String string) {
        if (this._jclParent != null) {
            return this.drainPendingURLs();
        }
        boolean bl = false;
        ResourcesDesc.PackageInformation packageInformation = this._launchDesc.getResources().getPackageInformation(string);
        if (packageInformation != null) {
            JARDesc[] jARDescArray;
            for (JARDesc jARDesc : jARDescArray = packageInformation.getLaunchDesc().getResources().getPart(packageInformation.getPart())) {
                if (!this._jarsNotInURLClassLoader.contains(jARDesc)) continue;
                this._jarsNotInURLClassLoader.remove(jARDesc);
                this.addLoadedJarsEntry(jARDesc);
                this.addURL2(jARDesc.getLocation());
                bl = true;
            }
        }
        return bl;
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        URL uRL;
        Permissions permissions = null;
        String string = this.getLaunchDesc().getDownloadHost();
        if (string != null && string.length() > 0) {
            if (!URLUtil.sameBase((URL)this.getLaunchDesc().getCodebase(), (URL)codeSource.getLocation())) {
                if (DownloadEngine.isKnownRedirectedHost((String)string, (String)codeSource.getLocation().getHost())) {
                    permissions = new Permissions();
                    SandboxSecurity.addConnectPermission((PermissionCollection)permissions, (URL)codeSource.getLocation());
                    Trace.println((String)("Grant connect perm for " + codeSource.getLocation() + " : " + permissions), (TraceLevel)TraceLevel.SECURITY);
                } else {
                    Trace.println((String)("Connect perm was not granted " + codeSource.getLocation() + " : " + permissions), (TraceLevel)TraceLevel.SECURITY);
                }
            } else {
                permissions = new Permissions();
                SandboxSecurity.addConnectPermission((PermissionCollection)permissions, (URL)codeSource.getLocation());
                Trace.println((String)("Grant connect perm for " + codeSource.getLocation() + " : " + permissions), (TraceLevel)TraceLevel.SECURITY);
            }
        }
        Permissions permissions2 = permissions == null ? new Permissions() : permissions;
        URL uRL2 = codeSource.getLocation();
        JARDesc jARDesc = this.getJarDescFromURL(uRL2);
        SecureStaticVersioning.checkVersionAllowed((DeploymentRuleSet)this.getDeploymentRuleSet(uRL2));
        if (uRL2 != null && jARDesc != null) {
            ToolkitStore.get().getAppContext().put((Object)("deploy-" + uRL2), (Object)jARDesc.getVersion());
            uRL = DownloadEngine.getKnownRedirectFinalURL((URL)uRL2);
            if (!URLUtil.sameURLs((URL)uRL, (URL)uRL2)) {
                ToolkitStore.get().getAppContext().put((Object)("deploy-" + uRL), (Object)jARDesc.getVersion());
            }
        }
        try {
            this._appPolicy.addPermissions(JNLPClassLoader.getInstance(), permissions2, codeSource, true);
        }
        catch (ExitException exitException) {
            throw new RuntimeException(exitException);
        }
        if (jARDesc != null && (uRL = ResourceProvider.get().getCachedResource(jARDesc.getLocation(), jARDesc.getVersion())) != null && uRL.getDataFile() != null) {
            String string2 = uRL.getDataFile().getPath();
            ((PermissionCollection)permissions2).add(new FilePermission(string2, "read"));
        }
        if (!((PermissionCollection)permissions2).implies(new AWTPermission("accessClipboard"))) {
            ToolkitStore.get().getAppContext().put((Object)"UNTRUSTED_URLClassLoader", (Object)Boolean.TRUE);
        }
        ((PermissionCollection)permissions2).add((Permission)new SecureCookiePermission(SecureCookiePermission.getURLOriginString((URL)codeSource.getLocation())));
        return permissions2;
    }

    @Override
    public JarFile getJarFile(URL uRL) throws IOException {
        final JARDesc jARDesc = this.getJarDescFromURL(uRL);
        if (jARDesc == null) {
            return null;
        }
        final int n = LaunchDownload.getDownloadType(jARDesc);
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<JarFile>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public JarFile run() throws IOException {
                    int n2 = ResourceProvider.get().incrementInternalUse();
                    try {
                        JarFile jarFile = ResourceProvider.get().getCachedJarFile(jARDesc.getLocation(), jARDesc.getVersion());
                        if (jarFile != null) {
                            JarFile jarFile2 = jarFile;
                            return jarFile2;
                        }
                        JarFile jarFile3 = ResourceProvider.get().getJarFile(jARDesc.getLocation(), jARDesc.getVersion(), n);
                        return jarFile3;
                    }
                    finally {
                        ResourceProvider.get().decrementInternalUse(n2);
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private void addLoadedJarsEntry(JARDesc jARDesc) {
        String string = jARDesc.getLocationString();
        if (!this._jarsInURLClassLoader.containsKey(string)) {
            this._jarsInURLClassLoader.put(string, jARDesc);
        }
    }

    @Override
    public void addResource(URL uRL, String string, String string2) {
        if (this._jclParent != null) {
            this._jclParent.addResource(uRL, string, string2);
            this.drainPendingURLs();
            return;
        }
        JARDesc jARDesc = new JARDesc(uRL, string, true, false, false, null, 0, null);
        String string3 = jARDesc.getLocationString();
        if (!this._jarsInURLClassLoader.containsKey(string3)) {
            this._launchDesc.getResources().addResource(jARDesc);
            this.addLoadedJarsEntry(jARDesc);
            this.addURL2(uRL);
        }
    }

    static boolean setDeployURLClassPathCallbacks(JNLPClassLoader jNLPClassLoader, JNLPClassLoader jNLPClassLoader2) {
        try {
            if (!ResourceProvider.get().hasEnhancedJarAccess()) {
                Trace.println((String)"setDeployURLClassPathCallbacks: no enhanced access", (TraceLevel)TraceLevel.BASIC);
                return false;
            }
            CPCallbackHandler cPCallbackHandler = new CPCallbackHandler((DeployURLClassLoader)jNLPClassLoader, (DeployURLClassLoader)jNLPClassLoader2);
            jNLPClassLoader.getDeployURLClassPath().setDeployURLClassPathCallback(cPCallbackHandler.getParentCallback());
            jNLPClassLoader2.getDeployURLClassPath().setDeployURLClassPathCallback(cPCallbackHandler.getChildCallback());
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception, (boolean)true);
            return false;
        }
        catch (Error error) {
            Trace.ignored((Throwable)error, (boolean)true);
            return false;
        }
        return true;
    }

    public void addURL(URL uRL) {
        if (this._jclParent != null) {
            this._jclParent.addURL(uRL);
        }
        super.addURL(uRL);
    }

    void addURL2(URL uRL) {
        if (this._jclParent != null) {
            this.drainPendingURLs();
        } else {
            this.putAddedURL(uRL);
        }
        super.addURL(uRL);
    }

    boolean drainPendingURLs() {
        int n;
        List<URL> list = this._jclParent.grabAddedURLs();
        for (n = 0; n < list.size(); ++n) {
            super.addURL(list.get(n));
        }
        return n != 0;
    }

    synchronized List<URL> grabAddedURLs() {
        List<URL> list = this.addedURLs;
        this.addedURLs = new ArrayList<URL>();
        return list;
    }

    synchronized void putAddedURL(URL uRL) {
        this.addedURLs.add(uRL);
    }

    @Override
    public DeploymentRuleSet getDeploymentRuleSet(URL uRL) {
        Object object;
        JARDesc jARDesc = this.getJarDescFromURL(uRL);
        if (jARDesc != null && jARDesc.getParent() != null && (object = jARDesc.getParent().getParent()) != null) {
            CodeRef codeRef = jARDesc.getCodeRef();
            AppRef appRef = LaunchDesc.getJNLPAppRef((LaunchDesc)object);
            return DeploymentRuleSet.findDRS((CodeInstance)new CodeInstance(appRef, codeRef));
        }
        object = this.getLaunchDesc() == null ? null : this.getLaunchDesc().getAnchorURL();
        boolean bl = jARDesc != null ? jARDesc.isPack200Enabled() : false;
        CodeRef codeRef = new CodeRef(uRL, null, false, bl);
        AppRef appRef = new AppRef(AppRef.Type.JNLP, null, null, null, (URL)object);
        return DeploymentRuleSet.findDRS((CodeInstance)new CodeInstance(appRef, codeRef));
    }

    public boolean wantsAllPerms(CodeSource codeSource) {
        LaunchDesc launchDesc;
        JARDesc jARDesc;
        return codeSource != null && ((jARDesc = this.getJarDescFromURL(codeSource.getLocation())) != null && jARDesc.getParent() != null ? (launchDesc = jARDesc.getParent().getParent()) != null && launchDesc.getSecurityModel() != 0 : codeSource.getCertificates() != null && this._launchDesc != null && this._launchDesc.getSecurityModel() != 0);
    }

    @Override
    public BasicService getBasicService() {
        return BasicServiceImpl.getInstance();
    }

    @Override
    public FileOpenService getFileOpenService() {
        return FileOpenServiceImpl.getInstance();
    }

    @Override
    public FileSaveService getFileSaveService() {
        return FileSaveServiceImpl.getInstance();
    }

    @Override
    public ExtensionInstallerService getExtensionInstallerService() {
        return ExtensionInstallerServiceImpl.getInstance();
    }

    @Override
    public DownloadService getDownloadService() {
        return DownloadServiceImpl.getInstance();
    }

    @Override
    public ClipboardService getClipboardService() {
        return ClipboardServiceImpl.getInstance();
    }

    @Override
    public PrintService getPrintService() {
        return PrintServiceImpl.getInstance();
    }

    @Override
    public PersistenceService getPersistenceService() {
        return PersistenceServiceImpl.getInstance();
    }

    @Override
    public ExtendedService getExtendedService() {
        return ExtendedServiceImpl.getInstance();
    }

    @Override
    public SingleInstanceService getSingleInstanceService() {
        return SingleInstanceServiceImpl.getInstance();
    }

    @Override
    public IntegrationService getIntegrationService() {
        if (Platform.get().isNativeSandbox()) {
            return new IntegrationServiceNSBImpl(new IntegrationServiceImpl(this));
        }
        return new IntegrationServiceImpl(this);
    }

    @Override
    public DownloadService2 getDownloadService2() {
        return DownloadService2Impl.getInstance();
    }
}

