/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public abstract class AbstractLocalApplicationProperties
implements LocalApplicationProperties {
    protected static final DateFormat _df = new SimpleDateFormat("MMM dd, yyyy, HH:mm:ss a", Locale.getDefault());

    @Override
    public int getInteger(String key) {
        String value = this.get(key);
        if (value == null) {
            return 0;
        }
        int count = 0;
        try {
            count = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            count = 0;
        }
        return count;
    }

    @Override
    public boolean getBoolean(String key) {
        String value = this.get(key);
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    @Override
    public Date getDate(String key) {
        String value = this.get(key);
        if (value == null) {
            return null;
        }
        try {
            return _df.parse(value);
        }
        catch (ParseException pe) {
            Trace.println("ParseException parsing date: " + value, TraceLevel.BASIC);
            return null;
        }
    }
}

