/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CachedJarFile;
import com.sun.deploy.cache.JarSigningData;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.DownloadDelegate;
import com.sun.deploy.model.Resource;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.net.MessageHeader;
import com.sun.deploy.net.UpdateTracker;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.JarVerifier;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.DeployJavaUtilJarAccess;
import com.sun.deploy.util.SessionState;
import com.sun.deploy.util.SyncFileAccess;
import com.sun.deploy.util.URLUtil;
import com.sun.deploy.util.VersionString;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipException;

public class CacheEntry
implements Resource {
    public static final int INCOMPLETE_FALSE = 0;
    public static final int INCOMPLETE_TRUE = 1;
    public static final int INCOMPLETE_ONHOLD = 2;
    public static final int BUSY_FALSE = 0;
    public static final int BUSY_TRUE = 1;
    private static final String ABSOLUTE_PATH_ESCAPE_CHAR = "\t";
    private File indexFile = null;
    private SyncFileAccess indexFileSyncAccess = null;
    private File tempDataFile = null;
    private int busy = 1;
    private int incomplete = 0;
    private int cacheVersion = Cache.getCacheVersion();
    private int contentLength = 0;
    private int isShortcutImage = 0;
    private int isProxiedHost = 0;
    private long lastModified = 0L;
    private long expirationDate = 0L;
    private String version = null;
    private String url = "";
    private String namespaceID = "";
    private MessageHeader headerFields = new MessageHeader();
    private String filename = null;
    private String codebaseIP = null;
    private boolean hasOnlySignedEntries = false;
    private boolean hasSingleCodeSource = false;
    private boolean hasMissingSignedEntries = false;
    private static final int section1Length = 128;
    private int section2Length = 0;
    private int section3Length = 0;
    private int section4Length = 0;
    private int section4CertsLength = 0;
    private int section4SignersLength = 0;
    private int section4Pre15Length = 0;
    private int section5Length = 0;
    private int reducedManifestLength = 0;
    private int reducedManifest2Length = 0;
    private SoftReference<JarSigningData> signingDataRef = new SoftReference<Object>(null);
    private WeakReference<JarFile> jarRef = new WeakReference<Object>(null);
    private static boolean enhancedJarAccess = false;
    private static final AccessControlContext ACC_FILE_INSTANCE;
    private static final AccessControlContext ACC_FILE_NET_INSTANCE;
    private volatile AtomicReference<URL> _url = new AtomicReference<Object>(null);
    private static SessionSigningDataStorage sessionSigningDataStorage;

    static boolean hasEnhancedJarAccess() {
        return enhancedJarAccess;
    }

    boolean hasSigningInfo() {
        return this.section4Length > 15;
    }

    private void invalidateEntryDueToException(Throwable e) {
        Trace.println("Invalidating entry url=" + this.url + " file=" + this.indexFile.getAbsolutePath());
        Trace.ignored(e);
        this.invalidateEntry();
    }

    private void invalidateEntry() {
        this.setIncomplete(1);
        try {
            this.updateIndexHeaderOnDisk();
        }
        catch (IOException ioe) {
            Trace.ignoredException(ioe);
        }
    }

    void markIncompleteOnHold() {
        this.setBusy(1);
        this.invalidateEntry();
        this.setIncomplete(2);
    }

    public CacheEntry(File idxFile) {
        this(idxFile, false);
    }

    CacheEntry(File idxFile, final boolean incompleteOK) {
        String path = idxFile.getPath();
        this.filename = path.substring(0, path.length() - 4);
        this.indexFile = idxFile;
        this.indexFileSyncAccess = new SyncFileAccess(this.indexFile);
        this.tempDataFile = new File(this.filename + "-temp");
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    CacheEntry.this.readIndexFile(incompleteOK);
                }
                catch (Throwable e) {
                    CacheEntry.this.invalidateEntryDueToException(e);
                }
                return null;
            }
        }, ACC_FILE_INSTANCE);
    }

    synchronized void generateShortcutImage() throws IOException {
        if (this.getIsShortcutImage() == 0) {
            this.setIsShortcutImage(1);
            this.updateIndexHeaderOnDisk();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomAccessFile openLockIndexFile(String mode, boolean privileged) throws IOException {
        SyncFileAccess.RandomAccessFileLock rafL = null;
        RandomAccessFile raf = null;
        try {
            rafL = this.indexFileSyncAccess.openLockRandomAccessFile(mode, 10000, privileged);
            raf = rafL != null ? rafL.getRandomAccessFile() : new RandomAccessFile(this.indexFile, mode);
            RandomAccessFile randomAccessFile = raf;
            return randomAccessFile;
        }
        finally {
            if (rafL != null) {
                rafL.release();
            }
        }
    }

    private void readIndexFileOld(DataInputStream in, RandomAccessFile raf) throws IOException {
        if (!this.indexFile.exists()) {
            return;
        }
        switch (this.getCacheVersion()) {
            case 605: {
                break;
            }
            case 603: 
            case 604: {
                this.readSection1Remaining604(in);
                this.readSection2(raf);
                break;
            }
            case 606: {
                raf.close();
                raf = null;
                this.readIndexFile();
                break;
            }
            case 602: {
                this.readIndexFile602(raf);
            }
        }
    }

    private void readIndexFile() {
        this.readIndexFile(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readIndexFile(boolean incompleteOK) {
        RandomAccessFile raf = null;
        IOException error = null;
        try {
            if (this.indexFile.exists()) {
                raf = this.openLockIndexFile("r", false);
                byte[] header = new byte[128];
                int n = raf.read(header);
                DataInputStream in = new DataInputStream(new ByteArrayInputStream(header, 0, n));
                this.setBusy(in.readByte());
                int v = in.readByte();
                if (incompleteOK && v == 1) {
                    v = 2;
                }
                this.setIncomplete(v);
                if (this.isIncomplete()) {
                    return;
                }
                this.setCacheVersion(in.readInt());
                if (this.getCacheVersion() != Cache.getCacheVersion()) {
                    Trace.println("In-place upgrading old version " + this.getCacheVersion() + " file: " + this.indexFile.getAbsolutePath(), TraceLevel.CACHE);
                    this.readIndexFileOld(in, raf);
                    raf.close();
                    raf = null;
                    this.saveUpgrade();
                    return;
                }
                this.readSection1Remaining(in);
                this.readSection2(raf);
                File resource = new File(this.getResourceFilename());
                if (!this.isRedirectEntry() && !resource.exists()) {
                    this.setIncomplete(1);
                    return;
                }
                if (this.hasSigningInfo() && this.section4Pre15Length == 0 && enhancedJarAccess && (!Cache.isSystemCacheEntry(this) || Environment.isSystemCacheMode())) {
                    raf.close();
                    raf = null;
                    this.saveUpgrade();
                    Trace.println("readIndexFile returning success", TraceLevel.CACHE);
                }
            }
        }
        catch (IOException ioe) {
            error = ioe;
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (IOException ioe) {
                Trace.ignoredException(ioe);
            }
        }
        if (error != null) {
            this.invalidateEntryDueToException(error);
        }
    }

    void processRedirectData(URL sourceURL, CacheEntry target) throws IOException {
        this.setBusy(0);
        this.setIncomplete(0);
        this.setURL(sourceURL.toString());
        this.setLastModified(target.getLastModified());
        this.setExpirationDate(target.getExpirationDate());
        this.setVersion(target.getVersion());
        this.headerFields = new MessageHeader();
        this.headerFields.add(null, String.valueOf(302));
        this.headerFields.add("Location", target.getURL());
        this.setHeaders(this.headerFields);
        this.writeFileToDisk();
    }

    public synchronized void setBusy(int busyFlag) {
        this.busy = busyFlag;
    }

    synchronized int getBusy() {
        return this.busy;
    }

    private void setCacheVersion(int version) {
        this.cacheVersion = version;
    }

    int getCacheVersion() {
        return this.cacheVersion;
    }

    public synchronized void setIncomplete(int incompleteFlag) {
        this.incomplete = incompleteFlag;
    }

    public synchronized int getIncomplete() {
        return this.incomplete;
    }

    boolean isIncomplete() {
        return this.getIncomplete() == 1;
    }

    public synchronized boolean isValidEntry() {
        return this.busy == 0 && this.incomplete == 0;
    }

    synchronized boolean storageFilesExist() {
        Boolean exists = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                if (CacheEntry.this.filename != null && new File(CacheEntry.this.filename).exists() && CacheEntry.this.indexFile != null && CacheEntry.this.indexFile.exists()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        }, ACC_FILE_INSTANCE);
        return exists;
    }

    public synchronized void setIsShortcutImage(int shortcutImageFlag) {
        this.isShortcutImage = shortcutImageFlag;
    }

    public synchronized int getIsShortcutImage() {
        return this.isShortcutImage;
    }

    public synchronized void setIsProxied(int isProxied) {
        this.isProxiedHost = isProxied;
    }

    public synchronized int getIsProxied() {
        return this.isProxiedHost;
    }

    synchronized boolean removeBefore(CacheEntry ce) {
        long ce2Expired;
        long ceLastModified;
        if (this.isIncomplete()) {
            return true;
        }
        if (ce.isIncomplete()) {
            return false;
        }
        long thisLastModified = this.getIndexFile().lastModified();
        if (thisLastModified < (ceLastModified = ce.getIndexFile().lastModified())) {
            return true;
        }
        if (thisLastModified > ceLastModified) {
            return false;
        }
        long currentDate = System.currentTimeMillis();
        long ce1Expired = this.getExpirationDate();
        if (ce1Expired != (ce2Expired = ce.getExpirationDate())) {
            if (ce1Expired < currentDate) {
                return true;
            }
            if (ce2Expired < currentDate) {
                return false;
            }
        }
        return this.getContentLength() >= ce.getContentLength();
    }

    synchronized void setContentLength(int length) {
        this.contentLength = length;
    }

    @Override
    public synchronized int getContentLength() {
        return this.contentLength;
    }

    private CodeSource createCodeSource(Certificate[] certs) {
        if (this._url.get() == null) {
            try {
                this._url.compareAndSet(null, new URL(this.url));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return new CodeSource(this._url.get(), certs);
    }

    private CodeSource createCodeSource(CodeSigner[] signers) {
        if (this._url.get() == null) {
            try {
                this._url.compareAndSet(null, new URL(this.url));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return new CodeSource(this._url.get(), signers);
    }

    synchronized JarSigningData getJarSigningData() {
        if (this.signingDataRef == null) {
            return null;
        }
        JarSigningData jsd = this.signingDataRef.get();
        if (jsd == null) {
            try {
                jsd = sessionSigningDataStorage.get(new URL(this.url), this.version, this);
                if (jsd != null) {
                    return jsd;
                }
            }
            catch (MalformedURLException e) {
                Trace.ignored(e);
            }
            try {
                jsd = AccessController.doPrivileged(new PrivilegedExceptionAction<JarSigningData>(){

                    @Override
                    public JarSigningData run() throws IOException, JARSigningException {
                        List<CodeSigner> signersCS;
                        URL jarLocation = new URL(CacheEntry.this.url);
                        File jarFile = new File(CacheEntry.this.filename);
                        JarVerifier jv = JarVerifier.create(jarLocation, CacheEntry.this.version, jarFile, null);
                        jv.validate(null);
                        CacheEntry.this.hasOnlySignedEntries = jv.hasOnlySignedEntries();
                        CacheEntry.this.hasSingleCodeSource = jv.hasSingleCodeSource();
                        CacheEntry.this.hasMissingSignedEntries = jv.hasMissingSignedEntries();
                        if (!jv.getSignerCerts().isEmpty() && CacheEntry.this.hasStrictSingleSigning()) {
                            Map<String, int[]> signerMapCert = jv.getSignerMapCert();
                            signerMapCert.clear();
                            signerMapCert.put(null, jv.getSingleSignerIndicesCert());
                        }
                        if (!(signersCS = jv.getSignersCS()).isEmpty() && CacheEntry.this.hasStrictSingleSigning()) {
                            Map<String, int[]> signerMap = jv.getSignerMap();
                            signerMap.clear();
                            signerMap.put(null, jv.getSingleSignerIndicesCS());
                        }
                        JarSigningData newJSD = JarSigningData.create(jv);
                        CacheEntry.this.signingDataRef = new SoftReference<JarSigningData>(newJSD);
                        sessionSigningDataStorage.put(CacheEntry.this);
                        return newJSD;
                    }
                }, ACC_FILE_NET_INSTANCE);
            }
            catch (PrivilegedActionException e) {
                Trace.ignoredException(e.getException());
                this.invalidateEntryDueToException(e.getException());
                this.signingDataRef = null;
            }
            catch (Throwable t) {
                Trace.ignored(t);
                this.invalidateEntryDueToException(t);
                this.signingDataRef = null;
            }
        }
        return jsd;
    }

    synchronized boolean hasStrictSingleSigning() {
        return this.hasOnlySignedEntries && this.hasSingleCodeSource && !this.hasMissingSignedEntries;
    }

    @Override
    public synchronized Certificate[] getCertificates() {
        JarSigningData jsd = this.getJarSigningData();
        return jsd != null ? jsd.getCertificates() : null;
    }

    @Override
    public synchronized CodeSigner[] getCodeSigners() {
        JarSigningData jsd = this.getJarSigningData();
        return jsd != null ? jsd.getCodeSigners() : null;
    }

    synchronized void setLastModified(long time) {
        this.lastModified = time;
    }

    @Override
    public synchronized long getLastModified() {
        return this.lastModified;
    }

    synchronized void setExpirationDate(long time) {
        this.expirationDate = time;
    }

    synchronized void updateExpirationInIndexFile(long time) {
        if (this.getExpirationDate() == time) {
            return;
        }
        this.setExpirationDate(time);
        try {
            this.updateIndexHeaderOnDisk();
        }
        catch (IOException ioe) {
            Trace.ignoredException(ioe);
        }
    }

    @Override
    public synchronized long getExpirationDate() {
        return this.expirationDate;
    }

    synchronized boolean isExpired() {
        return this.expirationDate == 0L || System.currentTimeMillis() >= this.expirationDate;
    }

    synchronized void setURL(String u) {
        this.url = u;
    }

    @Override
    public synchronized String getURL() {
        return this.url;
    }

    synchronized void setVersion(String ver) {
        this.version = ver == null || ver.equals("") ? null : ver;
    }

    @Override
    public synchronized String getVersion() {
        return this.version;
    }

    private void setNamespaceID(String id) {
        this.namespaceID = id;
    }

    private String getNamespaceID() {
        return this.namespaceID;
    }

    synchronized JarFile getRefJar() {
        Object o;
        if (this.jarRef != null && (o = this.jarRef.get()) instanceof JarFile) {
            return (JarFile)o;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JarFile getJarFile() {
        if (this.isRedirectEntry()) {
            return null;
        }
        JarFile newJarFile = null;
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            Object o;
            if (this.jarRef != null && (o = this.jarRef.get()) instanceof JarFile) {
                return (JarFile)o;
            }
            newJarFile = AccessController.doPrivileged(new PrivilegedAction<JarFile>(){

                @Override
                public JarFile run() {
                    try {
                        return CachedJarFile.create(CacheEntry.this);
                    }
                    catch (Exception e) {
                        Trace.ignored(e);
                        return null;
                    }
                }
            }, ACC_FILE_INSTANCE);
            this.jarRef = new WeakReference<JarFile>(newJarFile);
        }
        MemoryCache.addResourceReference(newJarFile, this.url);
        return newJarFile;
    }

    @Override
    public synchronized String getResourceFilename() {
        return this.filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getDataFile() {
        File f = null;
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            if (!this.isRedirectEntry() && this.filename != null && !this.url.equals("")) {
                f = new File(this.filename);
            }
        }
        if (f != null) {
            MemoryCache.addResourceReference(f, this.url);
        }
        return f;
    }

    synchronized File getTempDataFile() {
        return this.tempDataFile;
    }

    public synchronized File getIndexFile() {
        return this.indexFile;
    }

    @Override
    public synchronized long getSize() {
        long ret = 0L;
        if (this.getDataFile() != null) {
            ret += this.getDataFile().length();
        }
        if (this.getIndexFile() != null) {
            ret += this.getIndexFile().length();
        }
        return ret;
    }

    synchronized void setHeaders(MessageHeader headers) {
        this.headerFields = headers;
    }

    MessageHeader cloneHeaders() {
        return new MessageHeader(this.headerFields);
    }

    @Override
    public synchronized Map<String, List<String>> getHeaders() {
        return this.headerFields.getHeaders();
    }

    public synchronized boolean isHttpNoCacheEnabled() {
        String cacheControlValue = this.headerFields.getValue(this.headerFields.getKey("cache-control"));
        if (cacheControlValue != null && cacheControlValue.equals("no-cache")) {
            return true;
        }
        String pragmaValue = this.headerFields.getValue(this.headerFields.getKey("pragma"));
        return pragmaValue != null && pragmaValue.equals("no-cache");
    }

    synchronized boolean processTempDataFile(boolean applyJarDiff, DownloadDelegate dd, URL href, URL requestURL, String newVersion) {
        boolean ret = false;
        if (applyJarDiff) {
            String currentVersion = null;
            String query = requestURL.getQuery();
            StringTokenizer st = new StringTokenizer(query, "&");
            String tokens = null;
            while (st.hasMoreTokens()) {
                tokens = st.nextToken();
                if (!tokens.startsWith("current-version-id")) continue;
                currentVersion = tokens.substring("current-version-id".length() + 1);
                break;
            }
            CacheEntry currentCE = null;
            currentCE = Cache.getCacheEntry(href, currentVersion);
            File currentFile = null;
            if (currentCE != null) {
                currentFile = new File(currentCE.getResourceFilename());
            }
            File newFile = null;
            try {
                if (Trace.isEnabled(TraceLevel.NETWORK)) {
                    Trace.println(ResourceManager.getString("cacheEntry.applyJarDiff", href == null ? "" : href.toString(), currentVersion, newVersion), TraceLevel.NETWORK);
                }
                newFile = DownloadEngine.applyPatch(currentFile, this.tempDataFile, href, newVersion, dd, this.filename);
            }
            catch (IOException ioe) {
                Trace.ignoredException(ioe);
            }
            if (Platform.get().isNativeSandbox()) {
                Platform.get().getNativeSandboxBroker().deleteFile(this.tempDataFile);
            } else {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        CacheEntry.this.tempDataFile.delete();
                        return null;
                    }
                }, ACC_FILE_INSTANCE);
            }
            if (newFile != null) {
                ret = true;
            }
        }
        if (Platform.get().getNativeSandboxBroker().renameFile(this.tempDataFile, this.filename)) {
            ret = true;
        }
        return ret;
    }

    public synchronized Manifest getManifest() {
        try {
            JarFile jarFile = this.getJarFile();
            return jarFile != null ? jarFile.getManifest() : null;
        }
        catch (IOException ioe) {
            Trace.ignoredException(ioe);
            this.invalidateEntryDueToException(ioe);
            return null;
        }
    }

    private synchronized void setCodebaseIP(String ipaddr) {
        this.codebaseIP = ipaddr;
    }

    public synchronized String getCodebaseIP() {
        return this.codebaseIP;
    }

    void writeFileToDisk() throws IOException {
        this.writeFileToDisk(1, null);
    }

    @Override
    public synchronized boolean isJarFile() {
        Map<String, List<String>> headers = this.headerFields != null ? this.headerFields.getHeaders() : Collections.emptyMap();
        return HttpUtils.isJarFile(this.url, headers);
    }

    @Override
    public synchronized boolean isJNLPFile() {
        Map<String, List<String>> headers = this.headerFields != null ? this.headerFields.getHeaders() : Collections.emptyMap();
        return HttpUtils.isJNLPFile(this.url, headers);
    }

    public synchronized void updateIndexHeaderOnDisk() throws IOException {
        block4: {
            if (Platform.get().isNativeSandbox()) {
                this.doUpdateHeader(null);
            } else {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws IOException {
                            if (CacheEntry.this.indexFile != null && CacheEntry.this.indexFile.exists()) {
                                try (RandomAccessFile raf = null;){
                                    raf = CacheEntry.this.openLockIndexFile("rw", false);
                                    CacheEntry.this.doUpdateHeader(raf);
                                }
                            }
                            return null;
                        }
                    }, ACC_FILE_INSTANCE);
                }
                catch (PrivilegedActionException pae) {
                    if (!(pae.getException() instanceof IOException)) break block4;
                    throw (IOException)pae.getException();
                }
            }
        }
    }

    private int doUpdateHeader(RandomAccessFile raf) throws IOException {
        byte[] header = this.prepareHeader();
        Platform.get().getNativeSandboxBroker().writeFile(raf, this.indexFile, 0L, header);
        return header.length;
    }

    private byte[] prepareHeader() throws IOException {
        ByteArrayOutputStream headerdata = new ByteArrayOutputStream(128);
        DataOutputStream s = new DataOutputStream(headerdata);
        s.writeByte(this.busy);
        s.writeByte(this.incomplete);
        s.writeInt(this.cacheVersion);
        s.writeByte(this.isShortcutImage);
        s.writeInt(this.contentLength);
        s.writeLong(this.lastModified);
        s.writeLong(this.expirationDate);
        s.writeLong(0L);
        s.writeByte(0);
        s.writeInt(this.section2Length);
        s.writeInt(this.section3Length);
        s.writeInt(this.section4Length);
        s.writeInt(this.section5Length);
        s.writeLong(0L);
        s.writeLong(0L);
        s.writeByte(0);
        s.writeInt(this.reducedManifestLength);
        s.writeInt(this.section4Pre15Length);
        s.writeByte(this.hasOnlySignedEntries ? 1 : 0);
        s.writeByte(this.hasSingleCodeSource ? 1 : 0);
        s.writeInt(this.section4CertsLength);
        s.writeInt(this.section4SignersLength);
        s.writeByte(0);
        s.writeLong(0L);
        s.writeInt(this.reducedManifest2Length);
        s.writeByte(this.isProxiedHost);
        s.flush();
        if (headerdata.size() < 128) {
            byte[] junk = new byte[128 - headerdata.size()];
            s.write(junk);
        } else {
            Trace.println("Incorrect header size: " + headerdata.size(), TraceLevel.CACHE);
        }
        s.close();
        return headerdata.toByteArray();
    }

    synchronized void writeFileToDisk(int contentType, DownloadDelegate dd) throws IOException {
        this.writeFileToDisk(contentType, dd, true);
    }

    synchronized void writeFileToDisk(final int contentType, final DownloadDelegate dd, final boolean newEntry) throws IOException {
        block2: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException {
                        RandomAccessFile raf = null;
                        CacheEntry.this.section2Length = 0;
                        CacheEntry.this.section3Length = 0;
                        CacheEntry.this.section4Length = 0;
                        CacheEntry.this.section4Pre15Length = 0;
                        CacheEntry.this.section4CertsLength = 0;
                        CacheEntry.this.section4SignersLength = 0;
                        CacheEntry.this.section5Length = 0;
                        CacheEntry.this.reducedManifestLength = 0;
                        CacheEntry.this.reducedManifest2Length = 0;
                        try {
                            URL u;
                            String host;
                            if (!Platform.get().isNativeSandbox()) {
                                raf = CacheEntry.this.openLockIndexFile("rw", false);
                            }
                            int headerLength = CacheEntry.this.doUpdateHeader(raf);
                            ByteArrayOutputStream bout = new ByteArrayOutputStream(1000);
                            DataOutputStream out = new DataOutputStream(bout);
                            out.writeUTF(CacheEntry.this.getVersion() != null ? CacheEntry.this.getVersion() : "");
                            out.writeUTF(CacheEntry.this.getURL());
                            out.writeUTF(CacheEntry.this.getNamespaceID());
                            InetAddress ina = null;
                            String codebase = "";
                            if (CacheEntry.this.url != null && !CacheEntry.this.url.equals("") && (ina = Cache.getHostIP(host = (u = new URL(CacheEntry.this.url)).getHost())) != null) {
                                codebase = ina.getHostAddress();
                            }
                            out.writeUTF(codebase);
                            CacheEntry.this.writeHeaders(out);
                            out.close();
                            bout.close();
                            CacheEntry.this.section2Length = bout.size();
                            Platform.get().getNativeSandboxBroker().writeFile(raf, CacheEntry.this.indexFile, (long)headerLength, bout.toByteArray());
                            if (CacheEntry.this.incomplete == 0) {
                                if (CacheEntry.this.isJarFile() && !CacheEntry.this.hasCompressEncoding() && !CacheEntry.this.isRedirectEntry()) {
                                    CacheEntry.this.processJar(contentType, dd);
                                }
                                if (newEntry) {
                                    UpdateTracker.checkDone(CacheEntry.this.url);
                                }
                                Cache.addToCleanupThreadLoadedResourceList(CacheEntry.this.url);
                                CacheEntry.this.setBusy(0);
                                CacheEntry.this.setIncomplete(0);
                                CacheEntry.this.doUpdateHeader(raf);
                            }
                        }
                        catch (Exception e) {
                            Trace.ignoredException(e);
                            if (raf != null) {
                                raf.close();
                                raf = null;
                            }
                            Cache.removeCacheEntry(CacheEntry.this);
                            if (e instanceof JARSigningException) {
                                throw (JARSigningException)e;
                            }
                            if (e instanceof ZipException) {
                                throw new JARSigningException(new URL(CacheEntry.this.url), CacheEntry.this.version, 2, e);
                            }
                            throw new IOException(e.getMessage());
                        }
                        finally {
                            if (raf != null) {
                                raf.close();
                            }
                            Cache.cleanup();
                        }
                        return null;
                    }
                }, ACC_FILE_NET_INSTANCE);
            }
            catch (PrivilegedActionException pae) {
                if (!(pae.getException() instanceof IOException)) break block2;
                throw (IOException)pae.getException();
            }
        }
    }

    boolean isRedirectEntry() {
        return this.getRedirectFinalURL() != null;
    }

    public URL getRedirectFinalURL() {
        String redirectFinalRequest;
        Map<String, List<String>> headers = this.getHeaders();
        List<String> values = headers == null ? null : headers.get("Location");
        String string = redirectFinalRequest = values == null || values.size() < 1 ? null : values.get(0);
        if (redirectFinalRequest != null) {
            try {
                return new URL(redirectFinalRequest);
            }
            catch (MalformedURLException e) {
                Trace.ignored(e);
            }
        }
        return null;
    }

    private byte[] readBlock(final int offset, final int length) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<byte[]>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public byte[] run() throws IOException {
                    try (RandomAccessFile raf = CacheEntry.this.openLockIndexFile("r", false);){
                        raf.seek(offset);
                        byte[] data = new byte[length];
                        raf.readFully(data);
                        byte[] byArray = data;
                        return byArray;
                    }
                }
            }, ACC_FILE_INSTANCE);
        }
        catch (PrivilegedActionException pae) {
            if (pae.getException() instanceof IOException) {
                throw (IOException)pae.getException();
            }
            return null;
        }
    }

    synchronized byte[] getFullManifestBytes() throws IOException {
        if (this.reducedManifest2Length > 0) {
            int offset = 128 + this.section2Length;
            int length = this.section3Length - this.reducedManifest2Length;
            return this.readBlock(offset, length);
        }
        if (this.reducedManifestLength > 0) {
            int offset = 128 + this.section2Length + this.reducedManifestLength;
            int length = this.section3Length - this.reducedManifestLength;
            return this.readBlock(offset, length);
        }
        return null;
    }

    public String getNativeLibPath() {
        return this.getResourceFilename() + "-n";
    }

    private void processJar(int contentType, DownloadDelegate dd) throws IOException {
        List<CodeSigner> signersCS;
        URL jarLocation = new URL(this.url);
        File jarFile = new File(this.filename);
        File nativePath = null;
        if (DownloadEngine.isNativeContentType(contentType)) {
            nativePath = new File(this.getNativeLibPath()).getCanonicalFile();
        }
        JarVerifier jv = JarVerifier.create(jarLocation, this.version, jarFile, nativePath);
        jv.validate(dd);
        this.hasOnlySignedEntries = jv.hasOnlySignedEntries();
        this.hasSingleCodeSource = jv.hasSingleCodeSource();
        this.hasMissingSignedEntries = jv.hasMissingSignedEntries();
        if (!jv.getSignerCerts().isEmpty() && this.hasStrictSingleSigning()) {
            Map<String, int[]> signerMapCert = jv.getSignerMapCert();
            signerMapCert.clear();
            signerMapCert.put(null, jv.getSingleSignerIndicesCert());
        }
        if (!(signersCS = jv.getSignersCS()).isEmpty() && this.hasStrictSingleSigning()) {
            Map<String, int[]> signerMap = jv.getSignerMap();
            signerMap.clear();
            signerMap.put(null, jv.getSingleSignerIndicesCS());
        }
        JarSigningData jsd = JarSigningData.create(jv);
        this.signingDataRef = new SoftReference<JarSigningData>(jsd);
        sessionSigningDataStorage.put(this);
    }

    private void readIndexFile602(RandomAccessFile raf) throws IOException {
        raf.seek(0L);
        raf.readByte();
        raf.readByte();
        raf.readInt();
        raf.read();
        raf.read();
        this.setIsShortcutImage(raf.read());
        this.setContentLength(raf.readInt());
        this.setLastModified(raf.readLong());
        this.setExpirationDate(raf.readLong());
        this.setVersion(raf.readUTF());
        this.setURL(raf.readUTF());
        this.setNamespaceID(raf.readUTF());
        File resource = new File(this.getResourceFilename());
        if (!this.isRedirectEntry() && !resource.exists()) {
            this.invalidateEntry();
        }
        if (!this.isIncomplete()) {
            this.readHeaders602(raf);
        }
    }

    private void readHeaders602(RandomAccessFile raf) throws IOException {
        String CODEBASEIP_HEADER_KEY = "deploy_resource_codebase_ip";
        for (int count = raf.readInt(); count > 0; --count) {
            String name = raf.readUTF();
            if (name.equals("deploy_resource_codebase_ip")) {
                this.setCodebaseIP(raf.readUTF());
                continue;
            }
            if (name.equals("<null>")) {
                name = null;
            }
            this.headerFields.add(name, raf.readUTF());
        }
    }

    private void readHeaders(DataInputStream is) throws IOException {
        for (int count = is.readInt(); count > 0; --count) {
            String name = is.readUTF();
            if (name.equals("<null>")) {
                name = null;
            }
            this.headerFields.add(name, is.readUTF());
        }
    }

    private void writeHeaders(DataOutputStream out) throws IOException {
        if (this.headerFields == null) {
            out.writeInt(0);
            return;
        }
        Map<String, List<String>> headers = this.headerFields.getHeaders();
        if (!headers.isEmpty()) {
            out.writeInt(headers.size());
            for (int index = 0; index < headers.size(); ++index) {
                String value;
                String name = this.headerFields.getKey(index);
                if (null == name) {
                    name = "<null>";
                }
                if ((value = this.headerFields.getValue(index)) == null) {
                    if (!Cache.DEBUG) continue;
                    Trace.print("Header field '" + name + "' null, skip.");
                    continue;
                }
                out.writeUTF(name);
                out.writeUTF(value);
            }
        } else {
            out.writeInt(0);
        }
    }

    private String printManifest() {
        Manifest manifest = this.getManifest();
        if (manifest != null) {
            StringBuffer sb = new StringBuffer();
            Attributes a = manifest.getMainAttributes();
            for (Object key : a.keySet()) {
                sb.append("key: " + key);
                sb.append(" value: " + a.get(key) + "\n");
            }
            return sb.toString();
        }
        return null;
    }

    public String toString() {
        return "URL: " + this.url + " | " + this.indexFile;
    }

    public String dumpToString() {
        StringBuffer sb = new StringBuffer();
        sb.append("-----Cache Entry------\n");
        sb.append("busy: " + this.getBusy() + "\n");
        sb.append("incomplete: " + this.getIncomplete() + "\n");
        sb.append("cacheVersion: " + this.getCacheVersion() + "\n");
        sb.append("contentLength: " + this.getContentLength() + "\n");
        long lastModified = this.getLastModified();
        sb.append("lastModified: " + lastModified + " [" + new Date(lastModified).toString() + "]\n");
        sb.append("expirationDate: " + this.getExpirationDate() + "\n");
        sb.append("version: " + this.getVersion() + "\n");
        sb.append("URL: " + this.url + "\n");
        sb.append("NamespaceID: " + this.getNamespaceID() + "\n");
        sb.append("HTTP/HTTPS Header: " + this.getHeaders() + "\n");
        if (this.getManifest() != null) {
            sb.append("Jar-Manifest Main Attributes:\n");
            sb.append(this.printManifest());
            sb.append("----------------------\n");
        }
        return sb.toString();
    }

    public boolean hasCompressEncoding() {
        return HttpUtils.hasGzipOrPack200Encoding(this.getHeaders());
    }

    boolean matchesVersionString(String versionString, boolean exactOnly) {
        return CacheEntry.matchesVersionString(this, versionString, exactOnly);
    }

    static boolean matchesVersionString(Resource r, String versionString, boolean exactOnly) {
        if (r.getVersion() == null && versionString == null) {
            return true;
        }
        VersionString query = new VersionString(versionString);
        if (exactOnly && !query.isSimpleVersion()) {
            return false;
        }
        return query.contains(r.getVersion());
    }

    public boolean isSameEntry(CacheEntry other) {
        return other != null && this.getIndexFile().equals(other.getIndexFile());
    }

    private void readSection2(RandomAccessFile raf) throws IOException {
        if (this.section2Length > 0) {
            byte[] header = new byte[this.section2Length];
            raf.read(header);
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(header));
            this.setVersion(in.readUTF());
            this.setURL(in.readUTF());
            this.setNamespaceID(in.readUTF());
            this.setCodebaseIP(in.readUTF());
            this.readHeaders(in);
        }
    }

    private void readSection1Remaining(DataInputStream in) throws IOException {
        this.setIsShortcutImage(in.readByte());
        this.setContentLength(in.readInt());
        this.setLastModified(in.readLong());
        this.setExpirationDate(in.readLong());
        in.readLong();
        in.readByte();
        this.section2Length = in.readInt();
        this.section3Length = in.readInt();
        this.section4Length = in.readInt();
        this.section5Length = in.readInt();
        in.readLong();
        in.readLong();
        in.readByte();
        this.reducedManifestLength = in.readInt();
        this.section4Pre15Length = in.readInt();
        in.readByte();
        in.readByte();
        this.section4CertsLength = in.readInt();
        this.section4SignersLength = in.readInt();
        in.readByte();
        in.readLong();
        this.reducedManifest2Length = in.readInt();
        this.setIsProxied(in.readByte());
        in.close();
    }

    private void readSection1Remaining604(DataInputStream in) throws IOException {
        in.readByte();
        in.readByte();
        this.setIsShortcutImage(in.readByte());
        this.setContentLength(in.readInt());
        this.setLastModified(in.readLong());
        this.setExpirationDate(in.readLong());
        in.readLong();
        in.readByte();
        this.section2Length = in.readInt();
        this.section3Length = in.readInt();
        this.section4Length = in.readInt();
        this.section5Length = in.readInt();
        in.readLong();
        in.readLong();
        in.readByte();
        this.reducedManifestLength = in.readInt();
        this.section4Pre15Length = in.readInt();
        in.readByte();
        in.readByte();
        this.section4CertsLength = in.readInt();
        this.section4SignersLength = in.readInt();
        in.readByte();
        in.readLong();
        this.reducedManifest2Length = in.readInt();
    }

    private void saveUpgrade() throws IOException {
        Trace.println("Trying to update in place " + this.indexFile.getAbsolutePath(), TraceLevel.CACHE);
        this.cacheVersion = Cache.getCacheVersion();
        boolean isOK = this.isValidEntry();
        try {
            this.setBusy(1);
            this.updateIndexHeaderOnDisk();
            if (isOK) {
                Trace.println("Upgrade writing to disk for " + this.getResourceFilename(), TraceLevel.CACHE);
                this.writeFileToDisk(1, null, false);
                Trace.println("Upgrade of entry done", TraceLevel.CACHE);
            } else {
                Trace.println("Upgrade of incomplete entry done", TraceLevel.CACHE);
            }
        }
        finally {
            this.setBusy(0);
        }
    }

    @Override
    public int getState() {
        if (this.incomplete == 1 && this.busy == 0) {
            return 2;
        }
        if (this.incomplete == 0 && this.busy == 0) {
            return 1;
        }
        return 0;
    }

    static {
        try {
            DeployJavaUtilJarAccess access = DeployJavaUtilJarAccess.instance();
            access.setEagerValidation(null, false);
            enhancedJarAccess = true;
        }
        catch (NoClassDefFoundError access) {
        }
        catch (NoSuchMethodError access) {
        }
        catch (NullPointerException npe) {
            enhancedJarAccess = true;
        }
        catch (Exception npe) {
        }
        catch (Error npe) {
            // empty catch block
        }
        Permissions perms = new Permissions();
        ((PermissionCollection)perms).add(new FilePermission("<<ALL FILES>>", "read,write,delete"));
        ((PermissionCollection)perms).add(new PropertyPermission("*", "read,write"));
        ACC_FILE_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        perms = new Permissions();
        ((PermissionCollection)perms).add(new FilePermission("<<ALL FILES>>", "read,write,delete"));
        ((PermissionCollection)perms).add(new PropertyPermission("*", "read,write"));
        ((PermissionCollection)perms).add(new SocketPermission("*", "connect,resolve"));
        ACC_FILE_NET_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        sessionSigningDataStorage = new SessionSigningDataStorage();
    }

    private static class SessionSigningDataStorage
    implements SessionState.Client {
        private Map<Pair, String> ceToFile = new ConcurrentHashMap<Pair, String>();
        private File sessionFolder;
        private List<CacheEntry> cacheEntries = new ArrayList<CacheEntry>();
        private final String STORAGE_FILE_NAME = "SessionSigningDataStorage";

        public SessionSigningDataStorage() {
            SessionState.register(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void importState(File folder) {
            ObjectInputStream ois = null;
            this.sessionFolder = folder;
            try {
                BufferedInputStream fis = new BufferedInputStream(new FileInputStream(new File(this.sessionFolder, "SessionSigningDataStorage")));
                ois = new ObjectInputStream(fis);
                this.ceToFile = (Map)ois.readObject();
            }
            catch (Exception e) {
                Trace.ignored(e);
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException e) {
                        Trace.ignored(e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void exportState(File folder) {
            ObjectOutputStream oos = null;
            try {
                BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(new File(folder, "SessionSigningDataStorage")));
                oos = new ObjectOutputStream(fos);
                for (CacheEntry o : this.cacheEntries) {
                    try {
                        CacheEntry ce = o;
                        JarSigningData jarSigningData = ce.getJarSigningData();
                        if (jarSigningData == null) continue;
                        String name = UUID.randomUUID().toString();
                        File file = new File(folder, name);
                        this.saveSigningData(ce, jarSigningData, new BufferedOutputStream(new FileOutputStream(file)));
                        this.ceToFile.put(new Pair(new URL(ce.url), ce.version), name);
                    }
                    catch (IOException e) {
                        Trace.ignored(e);
                    }
                }
                oos.writeObject(this.ceToFile);
            }
            catch (Exception e) {
                Trace.ignored(e);
            }
            finally {
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException e) {
                        Trace.ignored(e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveSigningData(CacheEntry ce, JarSigningData jsd, OutputStream outputStream) throws IOException {
            try (ObjectOutputStream out = null;){
                out = new ObjectOutputStream(outputStream);
                out.writeBoolean(ce.hasOnlySignedEntries);
                out.writeBoolean(ce.hasSingleCodeSource);
                out.writeBoolean(ce.hasMissingSignedEntries);
                CodeSigner[] signersCS = jsd.getCodeSigners();
                if (signersCS != null && signersCS.length != 0) {
                    out.writeInt(signersCS.length);
                    for (CodeSigner codeSigner : signersCS) {
                        out.writeObject(codeSigner);
                    }
                    out.flush();
                    Map<String, int[]> signerMap = jsd.getSignerMap();
                    Iterator<String> keysCS = signerMap.keySet().iterator();
                    String lastPathCS = null;
                    while (keysCS.hasNext()) {
                        Object nameCS = keysCS.next();
                        if (nameCS == null || ((String)nameCS).length() == 0) continue;
                        int[] signerIndicesCS = signerMap.get(nameCS);
                        if (((String)nameCS).startsWith("/")) {
                            nameCS = CacheEntry.ABSOLUTE_PATH_ESCAPE_CHAR + (String)nameCS;
                            lastPathCS = null;
                        } else {
                            int lastSlash = ((String)nameCS).lastIndexOf("/");
                            if (lastSlash > 0) {
                                String path = ((String)nameCS).substring(0, lastSlash);
                                if (path.equals(lastPathCS)) {
                                    nameCS = ((String)nameCS).substring(lastSlash);
                                } else {
                                    lastPathCS = path;
                                }
                            } else {
                                lastPathCS = null;
                            }
                        }
                        out.writeUTF((String)nameCS);
                        Object lineCS = String.valueOf(signerIndicesCS.length);
                        for (int i = 0; i < signerIndicesCS.length; ++i) {
                            lineCS = (String)lineCS + " " + signerIndicesCS[i];
                        }
                        out.writeUTF((String)lineCS);
                    }
                    out.flush();
                } else {
                    out.writeInt(0);
                    out.flush();
                }
            }
        }

        public void put(CacheEntry ce) {
            this.cacheEntries.add(ce);
        }

        private String readLine(ObjectInputStream in) throws IOException {
            try {
                return in.readUTF();
            }
            catch (EOFException ex) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private JarSigningData readSigningData(InputStream in, CacheEntry ce) throws IOException, ClassNotFoundException {
            JarSigningData jsd;
            block18: {
                jsd = null;
                try (ObjectInputStream ois = null;){
                    ois = new ObjectInputStream(in);
                    boolean hasOnlySignedEntries = ois.readBoolean();
                    boolean hasSingleCodeSource = ois.readBoolean();
                    boolean hasMissingSignedEntries = ois.readBoolean();
                    int numCS = ois.readInt();
                    if (numCS <= 0) break block18;
                    jsd = new JarSigningData(hasOnlySignedEntries, hasSingleCodeSource, hasMissingSignedEntries);
                    HashMap<String, int[]> signerMap = new HashMap<String, int[]>();
                    JarVerifier.CodeSourceCache codeSourceCache = new JarVerifier.CodeSourceCache();
                    CodeSigner[] signers = new CodeSigner[numCS];
                    try {
                        for (int i = 0; i < numCS; ++i) {
                            signers[i] = (CodeSigner)ois.readObject();
                        }
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException("Error reading signer certificates: " + e);
                    }
                    if (jsd.hasStrictSingleSigning()) {
                        int[] signerIndices = new int[signers.length];
                        for (int i = 0; i < signers.length; ++i) {
                            signerIndices[i] = i;
                        }
                        CodeSource codeSource = ce.createCodeSource(signers);
                        signerMap.put(null, signerIndices);
                        codeSourceCache.put(signerIndices, codeSource);
                    } else {
                        String line = this.readLine(ois);
                        String lastPackage = null;
                        HashMap<String, int[]> signerIndicesCache = new HashMap<String, int[]>();
                        while (line != null && !line.equals("")) {
                            Object name = line;
                            if (lastPackage != null && ((String)name).startsWith("/")) {
                                name = lastPackage + (String)name;
                            } else if (((String)name).startsWith(CacheEntry.ABSOLUTE_PATH_ESCAPE_CHAR)) {
                                name = ((String)name).substring(1);
                                lastPackage = null;
                            } else {
                                int lastSlash = ((String)name).lastIndexOf("/");
                                lastPackage = lastSlash > 0 ? ((String)name).substring(0, lastSlash) : null;
                            }
                            line = this.readLine(ois);
                            int[] signerIndices = (int[])signerIndicesCache.get(line);
                            if (signerIndices == null) {
                                StringTokenizer tokenizer = new StringTokenizer(line, " ", false);
                                int numEntrySigners = Integer.parseInt(tokenizer.nextToken());
                                signerIndices = new int[numEntrySigners];
                                for (int i = 0; i < numEntrySigners; ++i) {
                                    signerIndices[i] = Integer.parseInt(tokenizer.nextToken());
                                }
                                signerIndicesCache.put(line, signerIndices);
                                CodeSigner[] codeSigners = new CodeSigner[signerIndices.length];
                                for (int i = 0; i < signerIndices.length; ++i) {
                                    codeSigners[i] = signers[signerIndices[i]];
                                }
                                CodeSource codeSource = ce.createCodeSource(codeSigners);
                                codeSourceCache.put(signerIndices, codeSource);
                            }
                            signerMap.put((String)name, signerIndices);
                            line = this.readLine(ois);
                        }
                    }
                    jsd.updateSignerInfo(signers, signerMap, codeSourceCache);
                }
            }
            return jsd;
        }

        public JarSigningData get(URL jarLocation, String jarVersion, CacheEntry ce) {
            JarSigningData jsd = null;
            try {
                Pair key = new Pair(jarLocation, jarVersion);
                if (this.ceToFile.containsKey(key)) {
                    File f = new File(this.sessionFolder, this.ceToFile.get(key));
                    jsd = this.readSigningData(new BufferedInputStream(new FileInputStream(f)), ce);
                }
            }
            catch (Exception e) {
                Trace.ignored(e);
            }
            return jsd;
        }

        private static class Pair
        implements Serializable {
            private static final long serialVersionUID = 2765726970695729305L;
            private URL jarLocation;
            private String jarVersion;

            public Pair(URL jarLocation, String jarVersion) {
                this.jarLocation = jarLocation;
                this.jarVersion = jarVersion;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Pair pair = (Pair)o;
                if (this.jarLocation != null ? !URLUtil.sameURLs(this.jarLocation, pair.jarLocation) : pair.jarLocation != null) {
                    return false;
                }
                return !(this.jarVersion != null ? !this.jarVersion.equals(pair.jarVersion) : pair.jarVersion != null);
            }

            public int hashCode() {
                int result = 0;
                if (this.jarLocation != null) {
                    String location = this.jarLocation.toString();
                    result = location.hashCode();
                }
                result = 31 * result + (this.jarVersion != null ? this.jarVersion.hashCode() : 0);
                return result;
            }

            public String toString() {
                return "Pair{jarLocation=" + this.jarLocation + ", jarVersion='" + this.jarVersion + "'}";
            }
        }
    }
}

