/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.ImmutableManifest;
import com.sun.deploy.cache.JarSigningData;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.config.Config;
import com.sun.deploy.model.ResourceObject;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.JarUtil;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class CachedJarFile
extends JarFile
implements ResourceObject {
    private Reference<JarSigningData> signingDataRef;
    private final URL resourceURL;
    private final String resourceVersion;
    private final File indexFile;
    private SoftReference<ImmutableManifest> manifestRef = new SoftReference<Object>(null);
    private static Enumeration<String> emptyEnumeration = new Enumeration<String>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public String nextElement() {
            throw new NoSuchElementException();
        }
    };

    @Override
    public String getName() {
        String name = super.getName();
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return name;
        }
        try {
            sm.checkPermission(new RuntimePermission("accessDeploymentCache"));
            return name;
        }
        catch (SecurityException securityException) {
            return "";
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        try {
            CachedJarFile cloned = Config.isJavaVersionAtLeast9() ? new CachedJarFile(new File(super.getName()), this.signingDataRef, this.resourceURL, this.resourceVersion, this.indexFile, Runtime.version()) : new CachedJarFile(new File(super.getName()), this.signingDataRef, this.resourceURL, this.resourceVersion, this.indexFile);
            MemoryCache.addResourceReference(cloned, this.resourceURL.toString());
            return cloned;
        }
        catch (IOException ioe) {
            Trace.ignoredException(ioe);
            throw new CloneNotSupportedException();
        }
    }

    protected static CachedJarFile create(CacheEntry ce) throws IOException {
        if (Config.isJavaVersionAtLeast9()) {
            return new CachedJarFile(new File(ce.getResourceFilename()), new SoftReference<Object>(null), new URL(ce.getURL()), ce.getVersion(), ce.getIndexFile(), Runtime.version());
        }
        return new CachedJarFile(new File(ce.getResourceFilename()), new SoftReference<Object>(null), new URL(ce.getURL()), ce.getVersion(), ce.getIndexFile());
    }

    private CachedJarFile(File file, Reference<JarSigningData> signingDataRef, URL resourceURL, String resourceVersion, File indexFile) throws IOException {
        super(file, false);
        this.signingDataRef = signingDataRef;
        this.resourceURL = resourceURL;
        this.resourceVersion = resourceVersion;
        this.indexFile = indexFile;
        CachedJarFile.ensureAncestorKnowsAboutManifest(this);
    }

    private CachedJarFile(File file, Reference<JarSigningData> signingDataRef, URL resourceURL, String resourceVersion, File indexFile, Runtime.Version version) throws IOException {
        super(file, false, 1, version);
        this.signingDataRef = signingDataRef;
        this.resourceURL = resourceURL;
        this.resourceVersion = resourceVersion;
        this.indexFile = indexFile;
        CachedJarFile.ensureAncestorKnowsAboutManifest(this);
    }

    private static void ensureAncestorKnowsAboutManifest(JarFile jar) throws IOException {
    }

    @Override
    public ZipEntry getEntry(String name) {
        ZipEntry ze = super.getEntry(name);
        if (ze != null) {
            return new JarFileEntry(ze);
        }
        return null;
    }

    public ZipEntry getRealEntry(String name) {
        if (Config.isJavaVersionAtLeast9() && this.isMultiRelease()) {
            return super.getEntry(name);
        }
        return this.getEntry(name);
    }

    @Override
    public void close() throws IOException {
        if (!this.isReferencedTo()) {
            Trace.println("Closing CachedJarFile " + this.getName(), TraceLevel.CACHE);
            super.close();
        }
    }

    @Override
    public void doClose() throws IOException {
        super.close();
    }

    private boolean isReferencedTo() {
        CacheEntry ce = (CacheEntry)MemoryCache.getLoadedResource(this.resourceURL.toString(), false);
        return ce != null && this.indexFile != null && this.indexFile.equals(ce.getIndexFile());
    }

    @Override
    public Enumeration<JarEntry> entries() {
        final Enumeration<JarEntry> entryList = super.entries();
        return new Enumeration<JarEntry>(){

            @Override
            public boolean hasMoreElements() {
                return entryList.hasMoreElements();
            }

            @Override
            public JarEntry nextElement() {
                try {
                    ZipEntry ze = (ZipEntry)entryList.nextElement();
                    return new JarFileEntry(ze);
                }
                catch (InternalError ie) {
                    throw new InternalError("Error in CachedJarFile entries");
                }
            }
        };
    }

    @Override
    public synchronized Manifest getManifest() throws IOException {
        Manifest m;
        ImmutableManifest manifest = this.manifestRef.get();
        if (manifest == null && (m = super.getManifest()) != null) {
            if (Environment.isJavaWebStart() && m.getMainAttributes().containsKey(Attributes.Name.CLASS_PATH)) {
                m.getMainAttributes().remove(Attributes.Name.CLASS_PATH);
            }
            manifest = new ImmutableManifest(m);
            this.manifestRef = new SoftReference<ImmutableManifest>(manifest);
        }
        return manifest;
    }

    @Override
    public URL getResourceURL() {
        return this.resourceURL;
    }

    @Override
    public String getResourceVersion() {
        return this.resourceVersion;
    }

    private synchronized CacheEntry getCacheEntry() {
        if (this.resourceURL == null) {
            return null;
        }
        CacheEntry ce = (CacheEntry)MemoryCache.getLoadedResource(this.resourceURL.toString());
        if (ce == null || !this.indexFile.equals(ce.getIndexFile())) {
            String msg = ce == null ? "No memory CacheEntry: " + this.resourceURL : "CachedJarFile.getCacheEntry: " + this.indexFile + " != " + ce.getIndexFile() + " for " + this.resourceURL;
            Trace.println(msg, TraceLevel.CACHE);
            ce = CachedJarFile.recoverCacheEntry(this.indexFile, this.resourceURL, this.resourceVersion);
            if (ce != null) {
                this.clearReferences();
            }
        }
        return ce;
    }

    static CacheEntry recoverCacheEntry(File idxFile, URL url, String version) {
        CacheEntry recovered = CachedJarFile.recoverOldCacheEntry(idxFile, url);
        if (recovered != null) {
            MemoryCache.addLoadedResource(url.toString(), recovered);
            return recovered;
        }
        return CachedJarFile.recoverCacheEntry(url, version);
    }

    private static CacheEntry recoverOldCacheEntry(File idxFile, URL url) {
        CacheEntry ce = null;
        if (idxFile != null && idxFile.isFile()) {
            try {
                ce = Cache.getCacheEntryFromFile(idxFile, true);
            }
            catch (Exception ex) {
                Trace.ignored(ex);
            }
        }
        if (ce == null) {
            Trace.println("Failed to recover old CacheEntry for " + url + "from " + idxFile, TraceLevel.CACHE);
        } else {
            Trace.println("Recovered memory CacheEntry from: " + url, TraceLevel.CACHE);
        }
        return ce;
    }

    static CacheEntry recoverCacheEntry(URL url, String version) {
        CacheEntry ce = Cache.getCacheEntry(url, version);
        if (ce != null) {
            Trace.println("Recovered CacheEntry: " + ce, TraceLevel.CACHE);
        } else {
            Trace.println("Failed to recover with latest CacheEntry", TraceLevel.CACHE);
        }
        return ce;
    }

    synchronized JarSigningData getSigningData() {
        if (this.signingDataRef == null) {
            return null;
        }
        JarSigningData jsd = this.signingDataRef.get();
        if (jsd == null) {
            CacheEntry ce = this.getCacheEntry();
            if (ce != null) {
                jsd = ce.getJarSigningData();
                this.signingDataRef = jsd != null ? new SoftReference<JarSigningData>(jsd) : null;
            } else {
                Trace.println("getSignerMap failed to get CacheEntry for " + this.resourceURL, TraceLevel.CACHE);
            }
        }
        return jsd;
    }

    private synchronized void clearReferences() {
        CachedJarFile.clear(new Reference[]{this.signingDataRef});
    }

    static void clear(Reference<?>[] refs) {
        if (refs == null) {
            return;
        }
        for (int i = 0; i < refs.length; ++i) {
            if (refs[i] == null) continue;
            refs[i].clear();
        }
    }

    Enumeration<String> entryNames(CodeSource[] cs) {
        JarSigningData jsd = this.getSigningData();
        if (jsd != null && jsd.matchStrictSingleSigning(cs)) {
            return this.unsignedEntryNames(null);
        }
        boolean matchUnsigned = false;
        ArrayList<String> names = new ArrayList<String>();
        if (jsd != null) {
            matchUnsigned = jsd.collectEntryNamesBySigners(cs, names);
        }
        Map<String, int[]> signerMap = jsd != null ? jsd.getSignerMap() : null;
        final Iterator signerKeys = names.iterator();
        final Enumeration<String> enum2 = matchUnsigned ? this.unsignedEntryNames(signerMap) : emptyEnumeration;
        return new Enumeration<String>(){
            String name;

            @Override
            public boolean hasMoreElements() {
                if (this.name != null) {
                    return true;
                }
                if (signerKeys.hasNext()) {
                    this.name = (String)signerKeys.next();
                    return true;
                }
                if (enum2.hasMoreElements()) {
                    this.name = (String)enum2.nextElement();
                    return true;
                }
                return false;
            }

            @Override
            public String nextElement() {
                if (this.hasMoreElements()) {
                    String value = this.name;
                    this.name = null;
                    return value;
                }
                throw new NoSuchElementException();
            }
        };
    }

    private Enumeration<String> unsignedEntryNames(final Map<String, int[]> signerMap) {
        final Enumeration<JarEntry> entries = this.entries();
        return new Enumeration<String>(){
            String name;

            @Override
            public boolean hasMoreElements() {
                if (this.name != null) {
                    return true;
                }
                while (entries.hasMoreElements()) {
                    ZipEntry e = (ZipEntry)entries.nextElement();
                    String value = e.getName();
                    if (JarUtil.canSkipEntry(e) || signerMap != null && signerMap.get(value) != null) continue;
                    this.name = value;
                    return true;
                }
                return false;
            }

            @Override
            public String nextElement() {
                if (this.hasMoreElements()) {
                    String value = this.name;
                    this.name = null;
                    return value;
                }
                throw new NoSuchElementException();
            }
        };
    }

    synchronized CodeSource[] getCodeSources(URL url) {
        JarSigningData jsd = this.getSigningData();
        return jsd != null ? jsd.getCodeSources(url) : new CodeSource[]{};
    }

    synchronized CodeSource getCodeSource(URL url, String name) {
        JarSigningData jsd = this.getSigningData();
        return jsd != null ? jsd.getCodeSource(url, name) : null;
    }

    private class JarFileEntry
    extends JarEntry {
        ZipEntry ze;

        JarFileEntry(ZipEntry ze) {
            super(ze);
            this.ze = ze;
        }

        public JarEntry getRealEntry() {
            if (this.ze instanceof JarEntry) {
                return (JarEntry)this.ze;
            }
            return this;
        }

        @Override
        public Attributes getAttributes() throws IOException {
            Manifest manifest = CachedJarFile.this.getManifest();
            if (manifest != null) {
                Attributes attr = manifest.getAttributes(this.getName());
                return attr;
            }
            return null;
        }

        @Override
        public Certificate[] getCertificates() {
            JarSigningData jsd = CachedJarFile.this.getSigningData();
            if (jsd != null) {
                return jsd.getCertificates(this.getName());
            }
            return null;
        }

        @Override
        public CodeSigner[] getCodeSigners() {
            JarSigningData jsd = CachedJarFile.this.getSigningData();
            if (jsd != null) {
                return jsd.getCodeSigners(this.getName());
            }
            return null;
        }
    }
}

