/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.BuiltInProperties;
import com.sun.deploy.config.DefaultConfig;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.NativePlatform;
import com.sun.deploy.config.OSType;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.DeploymentHooks;
import com.sun.deploy.util.SecurityBaseline;
import com.sun.deploy.util.StringUtils;
import com.sun.deploy.util.VersionID;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.security.SecurityPermission;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import sun.reflect.misc.ReflectUtil;

public abstract class Config
extends Properties {
    private static final long serialVersionUID = -9046288262792011014L;
    private static final String SYSPROP_OS_NAME = "os.name";
    protected static final String PROPERTIES_FILE = "deployment.properties";
    protected static final String CONFIG_FILE = "deployment.config";
    protected static final String BASE = "deployment.";
    protected static final String USER = "deployment.user.";
    protected static final String SYSTEM = "deployment.system.";
    protected static final String SEC = "deployment.security.";
    protected static final String USEC = "deployment.user.security.";
    protected static final String SSEC = "deployment.system.security.";
    protected static final String PROX = "deployment.proxy.";
    protected static final String JAVAPI = "deployment.javapi.";
    protected static final String JAVAWS = "deployment.javaws.";
    public static final String VERSION_UPDATED_KEY = "deployment.version";
    public static final String VERSION_UPDATE_THIS = "7.21";
    public static final String VERSION_UPDATE_THIS_JDK8 = "8";
    public static final String VERSION_UPDATE_DEF = "0";
    public static final String SYSTEM_CACHEDIR_NAME = "SystemCache";
    public static final String CACHEDIR_NAME = "cache";
    public static final String CACHEDIR_KEY = "deployment.user.cachedir";
    public static final String SYSCACHE_KEY = "deployment.system.cachedir";
    public static final String SEC_TLSv1_KEY = "deployment.security.TLSv1";
    public static final boolean SEC_TLSv1_DEF = true;
    public static final String SEC_TLSv11_KEY = "deployment.security.TLSv1.1";
    public static final boolean SEC_TLSv11_DEF = true;
    public static final String SEC_TLSv12_KEY = "deployment.security.TLSv1.2";
    public static final boolean SEC_TLSv12_DEF = true;
    public static final String SEC_SSLv2_KEY = "deployment.security.SSLv2Hello";
    public static final boolean SEC_SSLv2_DEF = false;
    public static final String SEC_SSLv3_KEY = "deployment.security.SSLv3";
    public static final boolean SEC_SSLv3_DEF = false;
    public static final String BASELINE_DEBUG_KEY = "deployment.baseline.debug";
    public static final String BASELINE_URL_KEY = "deployment.baseline.url";
    public static final String BASELINE_URL_DEF = "https://javadl-esd-secure.oracle.com/update/securitypack.jar";
    public static final String JAVAWS_CACHE_KEY = "deployment.javaws.cachedir";
    public static final String JAVAPI_CACHE_KEY = "deployment.javapi.cachedir";
    public static final String JAVAWS_UPDATE_KEY = "deployment.javaws.cache.update";
    public static final boolean JAVAWS_UPDATE_DEF = false;
    public static final String JAVAPI_UPDATE_KEY = "deployment.javapi.cache.update";
    public static final boolean JAVAPI_UPDATE_DEF = false;
    public static final String LOGDIR_KEY = "deployment.user.logdir";
    public static final String LOGDIR_NAME = "log";
    public static final String LOGDIR_DEF = "$USER_HOME" + File.separator + "log";
    public static final String JCP_TRACEFILE_KEY = "deployment.user.logfile";
    public static final String JCP_TRACEFILE_DEF = "jcp.trace";
    public static final String JCP_TRACEFILE_APPEND_KEY = "deployment.user.logfile.append";
    public static final boolean JCP_TRACEFILE_APPEND_DEF = false;
    public static final String PLUGIN_OUTPUTFILE_PREFIX = "plugin";
    public static final String JAVAWS_OUTPUTFILE_PREFIX = "javaws";
    public static final String OUTPUTFILE_LOG_SUFFIX = ".log";
    public static final String OUTPUTFILE_TRACE_SUFFIX = ".trace";
    public static final String JAVAWS_TRACEFILE_KEY = "deployment.javaws.traceFileName";
    public static final String JAVAWS_TRACEFILE_DEF = "";
    public static final String JAVAWS_LOGFILE_KEY = "deployment.javaws.logFileName";
    public static final String JAVAWS_LOGFILE_DEF = "";
    public static final String TMPDIR_KEY = "deployment.user.tmp";
    public static final String TMPDIR_DEF = "$USER_HOME" + File.separator + "tmp";
    public static final String USR_EXTDIR_KEY = "deployment.user.extdir";
    public static final String USR_EXTDIR_DEF = "$USER_HOME" + File.separator + "ext";
    public static final String SYS_EXTDIR_KEY = "deployment.system.extdir";
    public static final String WEBJAVA_ENABLED_KEY = "deployment.webjava.enabled";
    public static final boolean WEBJAVA_ENABLED_DEF = true;
    public static final String MODIFIED_KEY = "deployment.modified.timestamp";
    public static final String SYS_MAX_APPLET_THREAD_COUNT_KEY = "deployment.system.maxAppletThreadCount";
    public static final String USEC_POLICY_KEY = "deployment.user.security.policy";
    public static final String SEC_USE_HOME_JAVA_POLICY_KEY = "deployment.security.use.user.home.java.policy";
    public static final boolean SEC_USE_HOME_JAVA_POLICY_DEF = false;
    public static final String USEC_CACERTS_KEY = "deployment.user.security.trusted.cacerts";
    public static final String USEC_CACERTS_DEF = "$LOCAL_OR_ROAMING_USER_HOME" + File.separator + "security" + File.separator + "trusted.cacerts";
    public static final String USEC_JSSECERTS_KEY = "deployment.user.security.trusted.jssecacerts";
    public static final String USEC_JSSECERTS_DEF = "$LOCAL_OR_ROAMING_USER_HOME" + File.separator + "security" + File.separator + "trusted.jssecacerts";
    public static final String USEC_SANDBOX_CERTS_KEY = "deployment.user.security.sandbox.certs";
    public static final String USEC_SANDBOX_CERTS_DEF = "$LOCAL_OR_ROAMING_USER_HOME" + File.separator + "security" + File.separator + "sandbox.certs";
    public static final String USEC_TRUSTED_CERTS_KEY = "deployment.user.security.trusted.certs";
    public static final String USEC_TRUSTED_CERTS_DEF = "$LOCAL_OR_ROAMING_USER_HOME" + File.separator + "security" + File.separator + "trusted.certs";
    public static final String USEC_TRUSTED_JSSE_CERTS_KEY = "deployment.user.security.trusted.jssecerts";
    public static final String USEC_TRUSTED_JSSE_CERTS_DEF = "$LOCAL_OR_ROAMING_USER_HOME" + File.separator + "security" + File.separator + "trusted.jssecerts";
    public static final String USEC_TRUSTED_CLIENT_CERTS_KEY = "deployment.user.security.trusted.clientauthcerts";
    public static final String USEC_TRUSTED_CLIENT_CERTS_DEF = "$LOCAL_OR_ROAMING_USER_HOME" + File.separator + "security" + File.separator + "trusted.clientcerts";
    public static final String USEC_BLACKLIST_KEY = "deployment.user.security.blacklist";
    public static final String USEC_BLACKLIST_DEF = "$LOCAL_OR_ROAMING_USER_HOME" + File.separator + "security" + File.separator + "blacklist";
    public static final String USEC_BLACKLIST_CERTS_KEY = "deployment.user.security.blacklisted.certs";
    public static final String USEC_BLACKLIST_CERTS_DEF = "$LOCAL_OR_ROAMING_USER_HOME" + File.separator + "security" + File.separator + "blacklisted.certs";
    public static final String USEC_DYNAMIC_BLACKLIST_KEY = "deployment.user.security.blacklist.dynamic";
    public static final String USEC_DYNAMIC_BLACKLIST_DEF = "$LOCAL_OR_ROAMING_USER_HOME" + File.separator + "security" + File.separator + "blacklist.dynamic";
    public static final String USEC_TRUSTED_LIBRARIES_KEY = "deployment.user.security.trusted.libraries";
    public static final String USEC_TRUSTED_LIBRARIES_DEF = "$LOCAL_OR_ROAMING_USER_HOME" + File.separator + "security" + File.separator + "trusted.libraries";
    public static final String USEC_CREDENTIAL_KEY = "deployment.user.security.saved.credentials";
    public static final String USEC_CREDENTIAL_DEF = "$LOCAL_OR_ROAMING_USER_HOME" + File.separator + "security" + File.separator + "auth.dat";
    public static final String USEC_EXCEPTION_SITES_KEY = "deployment.user.security.exception.sites";
    public static final String USEC_EXCEPTION_SITES_DEF = "$LOCAL_OR_ROAMING_USER_HOME" + File.separator + "security" + File.separator + "exception.sites";
    public static final String SSEC_POLICY_KEY = "deployment.system.security.policy";
    public static final String SSEC_CACERTS_KEY = "deployment.system.security.cacerts";
    public static final String SSEC_CACERTS_DEF = "$LATEST_JRE_HOME" + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
    public static final String SSEC_JSSECERTS_KEY = "deployment.system.security.jssecacerts";
    public static final String SSEC_JSSECERTS_DEF = "$LATEST_JRE_HOME" + File.separator + "lib" + File.separator + "security" + File.separator + "jssecacerts";
    public static final String SSEC_TRUSTED_CERTS_KEY = "deployment.system.security.trusted.certs";
    public static final String SSEC_TRUSTED_CERTS_DEF = "$JAVA_HOME" + File.separator + "lib" + File.separator + "security" + File.separator + "trusted.certs";
    public static final String SSEC_TRUSTED_JSSE_CERTS_KEY = "deployment.system.security.trusted.jssecerts";
    public static final String SSEC_TRUSTED_JSSE_CERTS_DEF = "$JAVA_HOME" + File.separator + "lib" + File.separator + "security" + File.separator + "trusted.jssecerts";
    public static final String SSEC_TRUSTED_CLIENT_CERTS_KEY = "deployment.system.security.trusted.clientauthcerts";
    public static final String SSEC_TRUSTED_CLIENT_CERTS_DEF = "$JAVA_HOME" + File.separator + "lib" + File.separator + "security" + File.separator + "trusted.clientcerts";
    public static final String SSEC_BLACKLIST_KEY = "deployment.system.security.blacklist";
    public static final String SSEC_BLACKLIST_DEF = "$LATEST_JRE_HOME" + File.separator + "lib" + File.separator + "security" + File.separator + "blacklist";
    public static final String SSEC_TRUSTED_LIBRARIES_KEY = "deployment.system.security.trusted.libraries";
    public static final String SSEC_TRUSTED_LIBRARIES_DEF = "$LATEST_JRE_HOME" + File.separator + "lib" + File.separator + "security" + File.separator + "trusted.libraries";
    public static final String APPCONTEXT_APP_NAME_KEY = "deploy.trust.decider.app.name";
    public static final String SEC_ASKGRANT_SHOW_KEY = "deployment.security.askgrantdialog.show";
    public static final boolean SEC_ASKGRANT_SHOW_DEF = true;
    public static final String SEC_ASKGRANT_NOTCA_KEY = "deployment.security.askgrantdialog.notinca";
    public static final boolean SEC_ASKGRANT_NOTCA_DEF = true;
    public static final String SEC_USE_BROWSER_KEYSTORE_KEY = "deployment.security.browser.keystore.use";
    public static final boolean SEC_USE_BROWSER_KEYSTORE_DEF = true;
    public static final String SEC_USE_CLIENTAUTH_AUTO_KEY = "deployment.security.clientauth.keystore.auto";
    public static final boolean SEC_USE_CLIENTAUTH_AUTO_DEF = true;
    public static final String SEC_NOTINCA_WARN_KEY = "deployment.security.notinca.warning";
    public static final boolean SEC_NOTINCA_WARN_DEF = true;
    public static final String SEC_JSSE_HOST_WARN_KEY = "deployment.security.jsse.hostmismatch.warning";
    public static final boolean SEC_JSSE_HOST_WARN_DEF = true;
    public static final String SEC_HTTPS_DIALOG_WARN_KEY = "deployment.security.https.warning.show";
    public static final boolean SEC_HTTPS_DIALOG_WARN_DEF = false;
    public static final String SEC_TRUSTED_POLICY_KEY = "deployment.security.trusted.policy";
    public static final String SEC_TRUSTED_POLICY_DEF = "";
    public static final String SEC_AWT_WARN_WINDOW_KEY = "deployment.security.sandbox.awtwarningwindow";
    public static final boolean SEC_AWT_WARN_WINDOW_DEF = true;
    public static final String SEC_SANDBOX_JNLP_ENHANCED_KEY = "deployment.security.sandbox.jnlp.enhanced";
    public static final boolean SEC_SANDBOX_JNLP_ENHANCED_DEF = true;
    public static final String SEC_USE_VALIDATION_CRL_KEY = "deployment.security.validation.crl";
    public static final boolean SEC_USE_VALIDATION_CRL_DEF = true;
    public static final String SEC_USE_VALIDATION_CRL_URL_KEY = "deployment.security.validation.crl.url";
    public static final String SEC_TLS_USE_VALIDATION_CRL_KEY = "deployment.security.tls.validation.crl";
    public static final boolean SEC_TLS_USE_VALIDATION_CRL_DEF = true;
    public static final String SEC_TLS_USE_VALIDATION_CRL_URL_KEY = "deployment.security.tls.validation.crl.url";
    public static final String SEC_USE_VALIDATION_OCSP_KEY = "deployment.security.validation.ocsp";
    public static final boolean SEC_USE_VALIDATION_OCSP_DEF = true;
    public static final String SEC_TLS_USE_VALIDATION_OCSP_KEY = "deployment.security.tls.validation.ocsp";
    public static final boolean SEC_TLS_USE_VALIDATION_OCSP_DEF = true;
    public static final String SEC_REVOCATION_CHECK_TYPE_KEY = "deployment.security.revocation.check";
    public static final String SEC_TLS_REVOCATION_CHECK_TYPE_KEY = "deployment.security.tls.revocation.check";
    public static final String SERVER_CERTIFICATE_ONLY = "SERVER_CERTIFICATE_ONLY";
    public static final String PUBLISHER_ONLY = "PUBLISHER_ONLY";
    public static final String ALL_CERTIFICATES = "ALL_CERTIFICATES";
    public static final String NO_CERTIFICATES_CHECK = "NO_CHECK";
    public static final String SEC_REVOCATION_CHECK_TYPE_DEF = "ALL_CERTIFICATES";
    public static final String SEC_TLS_REVOCATION_CHECK_TYPE_DEF = "ALL_CERTIFICATES";
    public static final String SEC_REVOCATION_BEST_EFFORT_KEY = "deployment.security.revocation.check.best.effort";
    public static final boolean SEC_REVOCATION_CHECK_BEST_EFFORT_DEF = true;
    public static final String SEC_TLS_REVOCATION_BEST_EFFORT_KEY = "deployment.security.tls.revocation.check.best.effort";
    public static final boolean SEC_TLS_REVOCATION_CHECK_BEST_EFFORT_DEF = true;
    public static final String SEC_PERMISSIONS_MANIFEST_REQUIRED_KEY = "deployment.security.permissions.manifest.required";
    public static final boolean SEC_PERMISSIONS_MANIFEST_REQUIRED_KEY_DEF = true;
    public static final String SEC_USE_VALIDATION_OCSP_EE_KEY = "deployment.security.validation.ocsp.publisher";
    public static final boolean SEC_USE_VALIDATION_OCSP_EE_DEF = false;
    public static final String SEC_USE_VALIDATION_OCSP_SIGNER_KEY = "deployment.security.validation.ocsp.signer";
    public static final String SEC_TLS_USE_VALIDATION_OCSP_SIGNER_KEY = "deployment.security.tls.validation.ocsp.signer";
    public static final String SEC_USE_VALIDATION_OCSP_URL_KEY = "deployment.security.validation.ocsp.url";
    public static final String SEC_TLS_USE_VALIDATION_OCSP_URL_KEY = "deployment.security.tls.validation.ocsp.url";
    public static final String SEC_USE_VALIDATION_CLOCK_SKEW_KEY = "deployment.security.validation.clockskew";
    public static final String SEC_TLS_USE_VALIDATION_CLOCK_SKEW_KEY = "deployment.security.tls.validation.clockskew";
    public static final String SEC_USE_VALIDATION_TIMEOUT_KEY = "deployment.security.validation.timeout";
    public static final String SEC_TLS_USE_VALIDATION_TIMEOUT_KEY = "deployment.security.tls.validation.timeout";
    public static final String SEC_AUTHENTICATOR_KEY = "deployment.security.authenticator";
    public static final boolean SEC_AUTHENTICATOR_DEF = true;
    public static final String SEC_USE_BLACKLIST_CHECK_KEY = "deployment.security.blacklist.check";
    public static final boolean SEC_USE_BLACKLIST_CHECK_DEF = true;
    public static final String SEC_USE_PASSWORD_CACHE_KEY = "deployment.security.password.cache";
    public static final boolean SEC_USE_PASSWORD_CACHE_DEF = true;
    public static final String MODE_PROMPT = "PROMPT";
    public static final String MODE_PROMPT_MULTI = "PROMPT_MULTI";
    public static final String MODE_NEVER = "NEVER";
    public static final String SSV_MODE_KEY = "deployment.insecure.jres";
    public static final String SSV_MODE_DEF = "PROMPT";
    public static final String SEC_DISABLE_KEY = "deployment.security.disable";
    public static final boolean SEC_DISABLE_DEF = false;
    public static final String SEC_RUN_UNTRUSTED_KEY = "deployment.security.run.untrusted";
    public static final String SEC_RUN_UNTRUSTED_DEF = "PROMPT";
    public static final String SEC_SANDBOX_CASIGNED_KEY = "deployment.security.sandbox.casigned";
    public static final String SEC_SANDBOX_CASIGNED_DEF = "PROMPT";
    public static final String SEC_SANDBOX_SELFSIGNED_KEY = "deployment.security.sandbox.selfsigned";
    public static final String SEC_SANDBOX_SELFSIGNED_DEF = "PROMPT";
    public static final String SEC_LOCAL_APPLETS_KEY = "deployment.security.local.applets";
    public static final String SEC_LOCAL_APPLETS_DEF = "PROMPT";
    public static final String SEC_ALLOW_VM_SHARING_KEY = "deployment.security.allow.vm.sharing";
    public static final String SEC_ALLOW_EXPIRED_CERT_KEY = "deployment.security.allow.expired.certs";
    public static final String SEC_LEVEL_CUSTOM = "CUSTOM";
    public static final String SEC_LEVEL_HIGH = "HIGH";
    public static final String SEC_LEVEL_VERY_HIGH = "VERY_HIGH";
    public static final String SEC_LEVEL_KEY = "deployment.security.level";
    public static final String SEC_LEVEL_DEF = "HIGH";
    public static final String SECURE_LAUNCH_KILL_KEY = "deployment.security.use.insecure.launcher";
    public static final boolean SECURE_LAUNCH_KILL_DEF = false;
    public static final String NATIVE_SANDBOX_KILL_KEY = "deployment.security.use.native.sandbox";
    public static final boolean NATIVE_SANDBOX_KILL_DEF = false;
    public static final String NATIVE_SANDBOX_ESL_OVERRIDE = "deployment.security.esl.override.native.sandbox";
    public static final boolean NATIVE_SANDBOX_ESL_OVERRIDE_DEF = false;
    public static final String EXPIRATION_CHECK_ENABLED_KEY = "deployment.expiration.check.enabled";
    public static final boolean EXPIRATION_CHECK_ENABLED_DEF;
    public static final String DEBUG_PORT_INCREMENT_ON_RELAUNCH_KEY = "deployment.relaunch.increment.debug.port";
    public static final boolean DEBUG_PORT_INCREMENT_ON_RELAUNCH_DEF = true;
    public static final String SHOW_PLUGIN_DEPRECATION_DIALOG_KEY = "deployment.deprecation.plugin.dialog.show";
    public static final boolean SHOW_PLUGIN_DEPRECATION_DIALOG_DEF = true;
    private static boolean expirationCheckEnabled;
    public static final String EXPIRED_VERSION_KEY = "deployment.expired.version";
    protected static final String EXPIRATION_DECISION_KEY_PREFIX = "deployment.expiration.decision.";
    protected static final String EXPIRATION_DECISION_TIMESTAMP_KEY_PREFIX = "deployment.expiration.decision.timestamp.";
    protected static final String EXPIRATION_DECISION_SUPPRESSION_KEY_PREFIX = "deployment.expiration.decision.suppression.";
    protected static final String EXPIRATION_DECISION_TTL_KEY_PREFIX = "deployment.expiration.decision.ttl.";
    public static final int PROX_TYPE_UNKNOWN = -1;
    public static final int PROX_TYPE_NONE = 0;
    public static final int PROX_TYPE_MANUAL = 1;
    public static final int PROX_TYPE_AUTO = 2;
    public static final int PROX_TYPE_BROWSER = 3;
    public static final int PROX_TYPE_SYSTEM = 4;
    public static final String PROX_TYPE_KEY = "deployment.proxy.type";
    public static final int PROX_TYPE_DEF = 3;
    public static final String PROX_SAME_KEY = "deployment.proxy.same";
    public static final boolean PROX_SAME_DEF = false;
    public static final String PROX_LOCAL_KEY = "deployment.proxy.bypass.local";
    public static final boolean PROX_LOCAL_DEF = false;
    public static final String PROX_AUTOCFG_KEY = "deployment.proxy.auto.config.url";
    public static final String PROX_BYPASS_KEY = "deployment.proxy.bypass.list";
    public static final String PROX_HTTP_HOST_KEY = "deployment.proxy.http.host";
    public static final String PROX_HTTP_PORT_KEY = "deployment.proxy.http.port";
    public static final String PROX_HTTPS_HOST_KEY = "deployment.proxy.https.host";
    public static final String PROX_HTTPS_PORT_KEY = "deployment.proxy.https.port";
    public static final String PROX_FTP_HOST_KEY = "deployment.proxy.ftp.host";
    public static final String PROX_FTP_PORT_KEY = "deployment.proxy.ftp.port";
    public static final String PROX_SOX_HOST_KEY = "deployment.proxy.socks.host";
    public static final String PROX_SOX_PORT_KEY = "deployment.proxy.socks.port";
    public static final String PROX_OVERRIDE_KEY = "deployment.proxy.override.hosts";
    public static final String PROX_OVERRIDE_DEF = "";
    protected static final String ACTIVE_PREFIX = "active.";
    static final String[] PROXY_KEYS;
    private static final String[] ALL_TLS_PROTOCOLS;
    public static final String CACHE_MAX_KEY = "deployment.cache.max.size";
    public static final String CACHE_MAX_DEF = "-1";
    public static final String CACHE_COMPRESSION_KEY = "deployment.cache.jarcompression";
    public static final int CACHE_COMPRESSION_DEF = 0;
    public static final String CACHE_ENABLED_KEY = "deployment.cache.enabled";
    public static final boolean CACHE_ENABLED_DEF = true;
    public static final String SPLASH_CACHE_INDEX_KEY = "deployment.javaws.splash.index";
    public static final String APP_ICON_CACHE_INDEX_KEY = "deployment.javaws.appicon.index";
    public static final String CONSOLE_MODE_HIDE = "HIDE";
    public static final String CONSOLE_MODE_SHOW = "SHOW";
    public static final String CONSOLE_MODE_DISABLED = "DISABLE";
    public static final String CONSOLE_MODE_KEY = "deployment.console.startup.mode";
    public static final String CONSOLE_MODE_DEF = "HIDE";
    public static final String TRACE_MODE_KEY = "deployment.trace";
    public static final boolean TRACE_MODE_DEF = false;
    public static final String TRACE_LEVEL_KEY = "deployment.trace.level";
    public static final String TRACE_REDIRECT_STDIO_KEY = "deployment.trace.redirect.stdio";
    public static final boolean TRACE_REDIRECT_STDIO_DEF = true;
    public static final String MAX_NUM_FILES_KEY = "deployment.max.output.files";
    public static final int MAX_NUM_FILES_DEF = 5;
    public static final String MAX_SIZE_FILE_KEY = "deployment.max.output.file.size";
    public static final int MAX_SIZE_FILE_DEF = 10;
    public static final String LOG_MODE_KEY = "deployment.log";
    public static final boolean LOG_MODE_DEF = false;
    public static final String LOG_CP_KEY = "deployment.control.panel.log";
    public static final boolean LOG_CP_DEF = false;
    public static final String USE_SYSTEM_LF_KEY = "deployment.system.lookandfeel";
    public static final String JPI_TRACE_FILE_KEY = "deployment.javapi.trace.filename";
    public static final String JPI_TRACE_FILE_DEF = "";
    public static final String JPI_LOG_FILE_KEY = "deployment.javapi.log.filename";
    public static final String JPI_LOG_FILE_DEF = "";
    public static final String SHOW_EXCEPTIONS_KEY = "deployment.javapi.lifecycle.exception";
    public static final boolean SHOW_EXCEPTIONS_DEF = false;
    public static final int JPI_RUNTIME_TYPE_JRE = 0;
    public static final int JPI_RUNTIME_TYPE_JDK = 1;
    public static final String SYSTEM_TRAY_ICON_KEY = "deployment.system.tray.icon";
    public static final boolean SYSTEM_TRAY_ICON_DEF = false;
    public static final String JPI_RUNTIME_VER_KEY = "deployment.javapi.runtime.version";
    public static final String JPI_RUNTIME_VER_DEF = "";
    public static final String JPI_RUNTIME_TYPE_KEY = "deployment.javapi.runtime.type";
    public static final int JPI_RUNTIME_TYPE_DEF = 0;
    public static final String JAVAPI_STOP_TIMEOUT_KEY = "deployment.javapi.stop.timeout";
    public static final int JAVAPI_STOP_TIMEOUT_DEF = 200;
    public static final int JAVAPI_STOP_TIMEOUT_MAX = 3000;
    public static final String JAVAWS_CONCURRENT_DOWNLOADS_KEY = "deployment.javaws.concurrentDownloads";
    public static final int JAVAWS_CONCURRENT_DOWNLOADS_DEF = 4;
    public static final int JAVAWS_CONCURRENT_DOWNLOADS_MAX = 10;
    public static final String JPI_UPDATE_CHECK_ENABLED = "deployment.macosx.check.update";
    public static final boolean JPI_UPDATE_CHECK_ENABLED_DEF = true;
    public static final String JPI_JAVA_PATH = ".path";
    public static final String JPI_JAVA_ARGS = ".args";
    public static final String JPI_JAVA_OSNAME = ".osname";
    public static final String JPI_JAVA_OSARCH = ".osarch";
    public static final String JPI_JAVA_ENABLED = ".enabled";
    public static final String JPI_JRE_KEY = "deployment.javapi.jre.";
    public static final String JPI_JDK_KEY = "deployment.javapi.jdk.";
    public static final String SYS_JRE_KEY = "deployment.system.jre.";
    public static final String SYS_JRE_APPLIED_KEY = "deployment.system.jre.applied";
    public static final String ASSOCIATION_MODE_KEY = "deployment.javaws.associations";
    public static final String ASSOCIATION_MODE_ALWAYS = "ALWAYS";
    public static final String ASSOCIATION_MODE_NEVER = "NEVER";
    public static final String ASSOCIATION_MODE_NEW_ONLY = "NEW_ONLY";
    public static final String ASSOCIATION_MODE_ASK_USER = "ASK_USER";
    public static final String ASSOCIATION_MODE_REPLACE_ASK = "REPLACE_ASK";
    public static final String ASSOCIATION_MODE_DEF = "ASK_USER";
    public static final int ASSOCIATION_NEVER = 0;
    public static final int ASSOCIATION_NEW_ONLY = 1;
    public static final int ASSOCIATION_ASK_USER = 2;
    public static final int ASSOCIATION_REPLACE_ASK = 3;
    public static final int ASSOCIATION_ALWAYS = 4;
    public static final int SHORTCUT_NEVER = 0;
    public static final int SHORTCUT_ALWAYS = 1;
    public static final int SHORTCUT_ASK_TRUSTED = 2;
    public static final int SHORTCUT_ASK_UNTRUSTED = 3;
    public static final String SHORTCUT_MODE_NEVER = "NEVER";
    public static final String SHORTCUT_MODE_ALWAYS = "ALWAYS";
    public static final String SHORTCUT_MODE_ASK_TRUSTED = "ASK_TRUSTED";
    public static final String SHORTCUT_MODE_ASK_UNTRUSTED = "ASK_UNTRUSTED";
    public static final String SHORTCUT_MODE_KEY = "deployment.javaws.shortcut";
    public static final String SHORTCUT_MODE_DEF = "ASK_UNTRUSTED";
    public static final int INSTALL_NEVER = 0;
    public static final int INSTALL_IF_SHORTCUT = 1;
    public static final int INSTALL_IF_HINT_AND_SHORTCUT = 2;
    public static final int INSTALL_IF_HINT = 3;
    public static final String INSTALL_MODE_NEVER = "NEVER";
    public static final String INSTALL_MODE_IF_SHORTCUT = "IF_SHORTCUT";
    public static final String INSTALL_MODE_IF_HINT_AND_SHORTCUT = "IF_HINT_AND_SHORTCUT";
    public static final String INSTALL_MODE_IF_HINT = "IF_HINT";
    public static final String INSTALL_MODE_KEY = "deployment.javaws.install";
    public static final String INSTALL_MODE_DEF = "IF_HINT";
    public static final String SHORTCUT_UNINSTALL_KEY = "deployment.javaws.uninstall.shortcut";
    public static final boolean SHORTCUT_UNINSTALL_DEF = false;
    public static final String JAVAWS_JRE_PLATFORM_ID = ".platform";
    public static final String JAVAWS_JRE_PRODUCT_ID = ".product";
    public static final String JAVAWS_JRE_LOCATION = ".location";
    public static final String JAVAWS_JRE_PATH = ".path";
    public static final String JAVAWS_JRE_ARGS = ".args";
    public static final String JAVAWS_JRE_OS_ARCH = ".osarch";
    public static final String JAVAWS_JRE_OS_NAME = ".osname";
    public static final String JAVAWS_JRE_ISENABLED = ".enabled";
    public static final String JAVAWS_JRE_ISREGISTERED = ".registered";
    public static final String JAVAWS_JRE_KEY = "deployment.javaws.jre.";
    public static final String JAVAWS_JRE_INSTALL_KEY = "deployment.javaws.installURL";
    public static final String JAVAWS_JRE_INSTALL_DEF = "http://java.sun.com/products/autodl/j2se";
    public static final String JAVAFX_INSTALLER_URL = "http://javaweb.sfbay.sun.com/~hj156752/awtless/fx/installer/fxinstaller.jnlp";
    public static final int MIXCODE_ENABLE = 0;
    public static final int MIXCODE_HIDE_RUN = 1;
    public static final int MIXCODE_HIDE_CANCEL = 2;
    public static final int MIXCODE_DISABLE = 3;
    public static final String MIXCODE_MODE_ENABLE = "ENABLE";
    public static final String MIXCODE_MODE_HIDE_RUN = "HIDE_RUN";
    public static final String MIXCODE_MODE_HIDE_CANCEL = "HIDE_CANCEL";
    public static final String MIXCODE_MODE_DISABLE = "DISABLE";
    public static final String MIXCODE_MODE_KEY = "deployment.security.mixcode";
    public static final String MIXCODE_MODE_DEF = "ENABLE";
    public static final String LSP_FILENAME = "DeploymentRuleSet.jar";
    public static final String JAUTHENTICATOR_SYSTEM_PROP = "javaws.cfg.jauthenticator";
    public static final String BROWSER_PATH_KEY = "deployment.browser.path";
    public static final String BROWSER_PATH_DEF = "";
    public static final String EXTENDED_BROWSER_ARGS_KEY = "deployment.browser.args";
    public static final String EXTENDED_BROWSER_ARGS_DEF = "-remote openURL(%u,new-window)";
    public static final String CAPTURE_MIME_KEY = "deployment.capture.mime.types";
    public static final boolean CAPTURE_MIME_DEF = false;
    public static final String UPDATE_MIME_KEY = "deployment.update.mime.types";
    public static final boolean UPDATE_MIME_DEF = true;
    public static final String MIME_DEFAULTS_KEY = "deployment.mime.types.use.default";
    public static final boolean MIME_DEFAULTS_MIME_DEF = true;
    public static final String JAVAWS_MUFFIN_LIMIT_KEY = "deployment.javaws.muffin.max";
    public static final int JAVAWS_MUFFIN_LIMIT_DEF = 256;
    public static final String JAVAWS_UPDATE_TIMEOUT_KEY = "deployment.javaws.update.timeout";
    public static final int JAVAWS_UPDATE_TIMEOUT_DEF = 1500;
    public static final String SECURE_PROPS_KEY = "deployment.javaws.secure.properties";
    public static final String ENABLE_JAVAFX_KEY = "deployment.javafx.mode.enabled";
    public static final boolean ENABLE_JAVAFX_DEF = true;
    public static final String APPCONTEXT_KEY_PREFIX = "deploy-";
    public static final String APPCONTEXT_MAIN_CLASS_KEY = "deploy-main-class";
    public static final String APPCONTEXT_DOWNLOAD_TYPE_KEY = "deploy-download-type-";
    public static final String SPONSOR_OFFER_DISABLED_KEY = "install.disable.sponsor.offers";
    public static final String USE_ROAMING_PROFILE_KEY = "deployment.roaming.profile";
    private static final Set<String> defaultSecureProperties;
    private static final String[] secureVmArgs;
    private static final String[] secureVmPrefixes;
    private static final String[] secureSignedVmPrefixes;
    private static final DeploymentHooks deploymentHooks;
    private static final AccessControlContext ACC_INSTANCE;
    private static final String PROP_PACKAGE_ACCESS = "package.access";
    private static final String PROP_PACKAGE_DEFINITION = "package.definition";
    private static final String _javaVersionProperty;
    private static final String _javaRuntimeNameProperty;
    private static final boolean _atLeast13;
    private static final boolean _atLeast14;
    private static final boolean _atLeast15;
    private static final boolean _atLeast16;
    private static final boolean _atLeast17;
    private static final boolean _atLeast18;
    private static final boolean _atLeast9;
    private static Config _config;
    private static final String _jreHome;
    private static String _latestJREHome;
    public static final String SKIP_CACHE_UPGRADE = "deployment.cache.upgrade.skip";
    private static int javaTestVersion;
    private static final AccessControlContext noPermissionACC;
    private String _osFullName;
    private static final String _os;
    private static final String _arch;
    private static final String _platform;
    private static boolean _debugSet;
    private static boolean _debug;
    private static boolean _verbose;

    public static String[] getAllTlsProtocols() {
        return (String[])ALL_TLS_PROTOCOLS.clone();
    }

    public static boolean useSecureLaunch(JREInfo jreInfo) {
        if (Config.getBooleanProperty(SECURE_LAUNCH_KILL_KEY)) {
            return false;
        }
        return jreInfo == null || jreInfo.getPlatformVersion().isGreaterThanOrEqual(new VersionID("1.7"));
    }

    public static boolean useNativeSandbox(JREInfo jreInfo) {
        if (!OSType.isWin()) {
            return false;
        }
        if (!Config.useSecureLaunch(jreInfo)) {
            return false;
        }
        return Config.getBooleanProperty(NATIVE_SANDBOX_KILL_KEY);
    }

    public static boolean getNativeSandboxESLOverride() {
        if (!OSType.isWin()) {
            return false;
        }
        return Config.getBooleanProperty(NATIVE_SANDBOX_ESL_OVERRIDE);
    }

    public static DeploymentHooks getHooks() {
        return deploymentHooks;
    }

    public static void setupPackageAccessRestriction() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Config.addToPackageProtection(new String[]{"com.sun.javaws", "com.sun.deploy", "com.oracle.deploy", "com.sun.jnlp"});
                Config.addToPackageProtection(new String[]{"org.mozilla.jss"});
                Config.addToPackageProtection(new String[]{"com.sun.browser", "com.sun.glass", "com.sun.javafx", "com.sun.media.jfxmedia", "com.sun.media.jfxmediaimpl", "com.sun.openpisces", "com.sun.prism", "com.sun.scenario", "com.sun.t2k", "com.sun.webpane", "com.sun.pisces", "com.sun.webkit"});
                return null;
            }
        }, ACC_INSTANCE);
    }

    private static void addToPackageProtection(String[] packageNames) {
        if (packageNames == null || packageNames.length == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(packageNames[0]);
        for (int i = 1; i < packageNames.length; ++i) {
            sb.append(",");
            sb.append(packageNames[i]);
        }
        Config.addToSecurityProperty(PROP_PACKAGE_ACCESS, sb.toString());
        Config.addToSecurityProperty(PROP_PACKAGE_DEFINITION, sb.toString());
    }

    private static void addToSecurityProperty(String propertyName, String newValue) {
        Object value = Security.getProperty(propertyName);
        value = value != null ? (String)value + "," + newValue : newValue;
        Security.setProperty(propertyName, (String)value);
    }

    public static boolean isDeployVersionAtLeast11() {
        String deploy_ver = BuiltInProperties.getProperty("DEPLOY_VERSION");
        return !deploy_ver.startsWith("10");
    }

    public static String getJavaVersion() {
        return _javaVersionProperty;
    }

    public static String getJavaRuntimeNameProperty() {
        return _javaRuntimeNameProperty;
    }

    public static boolean isJavaVersionAtLeast9() {
        return _atLeast9 && Config.isJavaTestVersionAtLeast(19);
    }

    public static boolean isJavaVersionAtLeast18() {
        return _atLeast18 && Config.isJavaTestVersionAtLeast(18);
    }

    public static boolean isJavaVersionAtLeast17() {
        return _atLeast17 && Config.isJavaTestVersionAtLeast(17);
    }

    public static boolean isJFB() {
        return _javaRuntimeNameProperty.endsWith("Business");
    }

    static void setExpirationCheckEnabled(boolean state) {
        expirationCheckEnabled = state;
    }

    public static boolean isExpirationCheckEnabled() {
        return expirationCheckEnabled;
    }

    public static boolean installDeployRMIClassLoaderSpi() {
        return !Boolean.getBoolean("jnlp.noDeployRMIClassLoaderSpi");
    }

    public static synchronized Config get() {
        if (_config != null) {
            return _config;
        }
        return DefaultConfig.getDefaultConfig();
    }

    public static Config getInstance() {
        return _config;
    }

    public static void setInstance(Config config) {
        if (_config != null && config != null) {
            Trace.println("Unexpected second call to Config.setInstance() !", TraceLevel.BASIC);
        }
        _config = config;
        if (Config.getDebug()) {
            Trace.println("Config.setInstance called from:");
            Thread.dumpStack();
        }
        if (_config != null) {
            Config.initSecurityBaselineAndStoreIfNeeded(_config);
        }
    }

    private static void initSecurityBaselineAndStoreIfNeeded(Config conf) {
        if (SecurityBaseline.isExpired()) {
            conf.markAsDirty();
        }
        conf.storeIfNeeded();
    }

    public abstract void markAsDirty();

    protected static synchronized DefaultConfig getDefaults() {
        return DefaultConfig.getDefaultConfig();
    }

    public static Properties getDefaultProperties() {
        return Config.getDefaults();
    }

    public abstract boolean init(String var1, String var2);

    public abstract boolean isPropertyLocked(String var1);

    public abstract void storeIfNeeded();

    public abstract void refreshIfNeeded();

    public abstract boolean updateJREs();

    public abstract String getEnterpriseString();

    public abstract boolean isValid();

    public abstract boolean isConfigDirty();

    public abstract Properties getSystemProps();

    public abstract boolean getSponsorOffersDisabledSettings();

    public abstract boolean useRoamingProfile();

    public static String getPropertiesFilename() {
        return PROPERTIES_FILE;
    }

    public static int getMaxCommandLineLength() {
        return Platform.get().getPlatformMaxCommandLineLength();
    }

    public static String booleanToString(boolean bool) {
        if (bool) {
            return "true";
        }
        return "false";
    }

    public static String getJREHome() {
        return _jreHome;
    }

    public static String getLatestJREHome() {
        if (_latestJREHome == null) {
            List<JREInfo> all = Platform.get().getInstalledJREList();
            ArrayList<JREInfo> list = new ArrayList<JREInfo>();
            NativePlatform np = NativePlatform.getCurrentNativePlatform();
            for (JREInfo jre : all) {
                if (!jre.getNativePlatform().match(np)) continue;
                list.add(jre);
            }
            _latestJREHome = Config.findLatestJREPath(list);
            if (_latestJREHome == null) {
                _latestJREHome = Config.getJREHome();
            }
        }
        return _latestJREHome;
    }

    private static String findLatestJREPath(List<JREInfo> list) {
        JREInfo latest = null;
        for (JREInfo jre : list) {
            if (latest != null && !jre.getProductVersion().isGreaterThan(latest.getProductVersion())) continue;
            latest = jre;
        }
        return latest != null ? latest.getJavaHomePath() : null;
    }

    public static String getOSHome() {
        return Platform.get().getOSHome();
    }

    public static String getSystemHome() {
        return Platform.get().getSystemHome();
    }

    public static String getUserHome() {
        return Platform.get().getUserHome();
    }

    public static String getLocalOrRoamingUserHome() {
        return Config.get().useRoamingProfile() ? Config.getRoamingUserHome() : Config.getUserHome();
    }

    public static String getLocalStorageDir() {
        return Platform.get().getLocalStorageDir();
    }

    public static String getRoamingUserHome() {
        return Platform.get().getRoamingUserHome();
    }

    public static File getDRSFile() {
        return new File(Config.getSystemHome() + File.separator + LSP_FILENAME);
    }

    public static String getStringProperty(String key) {
        String value = Config.get().getProperty(key);
        if (value != null) {
            return Config.replaceVariables(value).trim();
        }
        return null;
    }

    public static void setStringProperty(String key, String value) {
        if (value == null || value.length() == 0) {
            Config.get().setProperty(key, null);
        } else {
            Config.get().setProperty(key, Config.restoreVariables(value));
        }
    }

    public static int getIntProperty(String key) {
        String value = Config.getStringProperty(key);
        if (value == null) {
            return -1;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public static void setIntProperty(String key, int value) {
        Config.setStringProperty(key, Integer.toString(value));
    }

    public static boolean getBooleanProperty(String key) {
        String value = Config.getStringProperty(key);
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    public static void setBooleanProperty(String key, boolean value) {
        Config.setStringProperty(key, Config.booleanToString(value));
    }

    private static void setProperties(Properties p) {
        Enumeration<Object> en = p.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            Config.setStringProperty(key, p.getProperty(key));
        }
    }

    protected static String restoreVariables(String value) {
        if (value.indexOf(Environment.getJavaHome()) >= 0) {
            value = Config.substitute(value, "$JAVA_HOME", Environment.getJavaHome());
        }
        if (value.indexOf(Config.getJREHome()) >= 0) {
            value = Config.substitute(value, "$JRE_HOME", Config.getJREHome());
        }
        if (value.indexOf(Config.getLatestJREHome()) >= 0) {
            value = Config.substitute(value, "$LATEST_JRE_HOME", Config.getLatestJREHome());
        }
        if (value.indexOf(Config.getUserHome()) >= 0) {
            value = Config.substitute(value, "$USER_HOME", Config.getUserHome());
        }
        if (value.indexOf(Config.getSystemHome()) >= 0) {
            value = Config.substitute(value, "$SYSTEM_HOME", Config.getSystemHome());
        }
        return value;
    }

    protected static String replaceVariables(String value) {
        if (value.indexOf("$JAVA_HOME") >= 0) {
            value = Config.substitute(value, Environment.getJavaHome(), "$JAVA_HOME");
        }
        if (value.indexOf("$JRE_HOME") >= 0) {
            value = Config.substitute(value, Config.getJREHome(), "$JRE_HOME");
        }
        if (value.indexOf("$LATEST_JRE_HOME") >= 0) {
            value = Config.substitute(value, Config.getLatestJREHome(), "$LATEST_JRE_HOME");
        }
        if (value.indexOf("$USER_HOME") >= 0) {
            value = Config.substitute(value, Config.getUserHome(), "$USER_HOME");
        }
        if (value.indexOf("$SYSTEM_HOME") >= 0) {
            value = Config.substitute(value, Config.getSystemHome(), "$SYSTEM_HOME");
        }
        if (value.indexOf("$LOCAL_OR_ROAMING_USER_HOME") >= 0) {
            value = Config.substitute(value, Config.getLocalOrRoamingUserHome(), "$LOCAL_OR_ROAMING_USER_HOME");
        }
        return value;
    }

    private static String substitute(String val, String s1, String s2) {
        int i = val.indexOf(s2);
        return i < 0 ? val : val.substring(0, i) + s1 + val.substring(i + s2.length());
    }

    public static void printProps() {
        Trace.println("\n_defaultProps:");
        Config.printP(Config.getDefaults());
        Trace.println("\n_props:");
        Config.printP(Config.get());
    }

    public static void printP(Properties p) {
        Enumeration<Object> en = p.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = p.getProperty(key);
            Trace.println("  " + key + " : " + value);
        }
        Trace.println("");
    }

    public static String getSandboxTrustedCertificateFile() {
        return Config.getStringProperty(USEC_SANDBOX_CERTS_KEY);
    }

    public static String getUserTrustedCertificateFile() {
        return Config.getStringProperty(USEC_TRUSTED_CERTS_KEY);
    }

    public static String getSystemTrustedCertificateFile() {
        return Config.getStringProperty(SSEC_TRUSTED_CERTS_KEY);
    }

    public static String getUserTrustedHttpsCertificateFile() {
        return Config.getStringProperty(USEC_TRUSTED_JSSE_CERTS_KEY);
    }

    public static String getSystemTrustedHttpsCertificateFile() {
        return Config.getStringProperty(SSEC_TRUSTED_JSSE_CERTS_KEY);
    }

    public static String getUserRootCertificateFile() {
        return Config.getStringProperty(USEC_CACERTS_KEY);
    }

    public static String getSystemRootCertificateFile() {
        return Config.getStringProperty(SSEC_CACERTS_KEY);
    }

    public static String getUserSSLRootCertificateFile() {
        return Config.getStringProperty(USEC_JSSECERTS_KEY);
    }

    public static String getSystemSSLRootCertificateFile() {
        return Config.getStringProperty(SSEC_JSSECERTS_KEY);
    }

    public static String getUserClientAuthCertFile() {
        return Config.getStringProperty(USEC_TRUSTED_CLIENT_CERTS_KEY);
    }

    public static String getSystemClientAuthCertFile() {
        return Config.getStringProperty(SSEC_TRUSTED_CLIENT_CERTS_KEY);
    }

    public static String getUserBlacklistFile() {
        return Config.getStringProperty(USEC_BLACKLIST_KEY);
    }

    public static String getSystemBlacklistFile() {
        return Config.getStringProperty(SSEC_BLACKLIST_KEY);
    }

    public static String getDynamicBlacklistFile() {
        return Config.getStringProperty(USEC_DYNAMIC_BLACKLIST_KEY);
    }

    public static String getDynamicBlacklistCertsFile() {
        return Config.getStringProperty(USEC_BLACKLIST_CERTS_KEY);
    }

    public static String getUserTrustedLibrariesFile() {
        return Config.getStringProperty(USEC_TRUSTED_LIBRARIES_KEY);
    }

    public static String getSystemTrustedLibrariesFile() {
        return Config.getStringProperty(SSEC_TRUSTED_LIBRARIES_KEY);
    }

    public static String getUserAuthFile() {
        return Config.getStringProperty(USEC_CREDENTIAL_KEY);
    }

    public static String getUserCookieFile() {
        return Config.getLocalOrRoamingUserHome() + File.separator + "security" + File.separator + "cookie.txt";
    }

    protected static String getUserPropertiesFile() {
        return Config.getUserHome() + File.separator + PROPERTIES_FILE;
    }

    protected static String getRoamingUserPropertiesFile() {
        String roamingUserHome = Config.getRoamingUserHome();
        if (roamingUserHome == null) {
            return null;
        }
        return roamingUserHome + File.separator + PROPERTIES_FILE;
    }

    protected static String getSystemHomePropertiesFile() {
        return Config.getSystemHome() + File.separator + PROPERTIES_FILE;
    }

    public static String getCacheDirectory() {
        String dir = Config.getStringProperty(CACHEDIR_KEY);
        if (dir == null) {
            dir = Config.getDefaultCacheDirectory();
        }
        return dir;
    }

    public static String getDefaultCacheDirectory() {
        return Config.getLocalStorageDir() + File.separator + CACHEDIR_NAME;
    }

    public static String getDefaultRoamingCacheDirectory() {
        return Config.getRoamingUserHome() + File.separator + CACHEDIR_NAME;
    }

    public String getDefaultCacheVersionDirectory() {
        return Config.getDefaultCacheDirectory() + File.separator + "6.0";
    }

    public boolean isCacheUpgradeSkipped() {
        return Config.getBooleanProperty(SKIP_CACHE_UPGRADE);
    }

    public static String getPluginCacheDir() {
        String overrideLocation = Config.getStringProperty(JAVAPI_CACHE_KEY);
        if (overrideLocation != null) {
            return overrideLocation;
        }
        return Config.getCacheDirectory() + File.separator + "javapi";
    }

    public static String getTempCacheDir() {
        return Config.getCacheDirectory() + File.separator + "tmp";
    }

    public static String getSecurityCacheDir() {
        return Config.getCacheDirectory() + File.separator + "security";
    }

    public static String getSystemCacheDirectory() {
        return Config.getStringProperty(SYSCACHE_KEY);
    }

    public String getDefaultSystemCacheVersionDirectory() {
        String defCache = Platform.get().getDefaultSystemCache();
        if (defCache != null) {
            return defCache + File.separator + "6.0";
        }
        return null;
    }

    public static void setCacheDirectory(String dir) {
        Config.get().setProperty(CACHEDIR_KEY, dir);
    }

    public static String getLogDirectory() {
        return Config.getStringProperty(LOGDIR_KEY);
    }

    public static String getTempDirectory() {
        return Config.getStringProperty(TMPDIR_KEY);
    }

    public static String getUserExtensionDirectory() {
        return Config.getStringProperty(USR_EXTDIR_KEY);
    }

    public static String getSystemExtensionDirectory() {
        return Config.getStringProperty(SYS_EXTDIR_KEY);
    }

    public static int getMaxAppletThreadCount() {
        int v = Config.getIntProperty(SYS_MAX_APPLET_THREAD_COUNT_KEY);
        if (v == -1) {
            v = 50;
        }
        return v;
    }

    public static String getUserSecurityPolicyURL() {
        return Config.getStringProperty(USEC_POLICY_KEY);
    }

    public static String getSystemSecurityPolicyURL() {
        return Config.getStringProperty(SSEC_POLICY_KEY);
    }

    public static int getProxyType() {
        return Config.getIntProperty("active.deployment.proxy.type");
    }

    public static boolean isProxySame() {
        return Config.getBooleanProperty("active.deployment.proxy.same");
    }

    public static boolean isProxyBypassLocal() {
        return Config.getBooleanProperty("active.deployment.proxy.bypass.local");
    }

    public static String getProxyAutoConfig() {
        return Config.getStringProperty("active.deployment.proxy.auto.config.url");
    }

    public static String getProxyBypass() {
        return Config.getStringProperty("active.deployment.proxy.bypass.list");
    }

    public static String getProxyOverride() {
        return Config.getStringProperty("active.deployment.proxy.override.hosts");
    }

    public static String getProxyHttpHost() {
        return Config.getStringProperty("active.deployment.proxy.http.host");
    }

    public static String getProxyHttpsHost() {
        return Config.getStringProperty("active.deployment.proxy.https.host");
    }

    public static String getProxyFtpHost() {
        return Config.getStringProperty("active.deployment.proxy.ftp.host");
    }

    public static String getProxySocksHost() {
        return Config.getStringProperty("active.deployment.proxy.socks.host");
    }

    public static int getProxyHttpPort() {
        return Config.getIntProperty("active.deployment.proxy.http.port");
    }

    public static int getProxyHttpsPort() {
        return Config.getIntProperty("active.deployment.proxy.https.port");
    }

    public static int getProxyFtpPort() {
        return Config.getIntProperty("active.deployment.proxy.ftp.port");
    }

    public static int getProxySocksPort() {
        return Config.getIntProperty("active.deployment.proxy.socks.port");
    }

    public static void validateSystemCacheDirectory() {
        if (Config.getSystemCacheDirectory() != null && Config.getSystemCacheDirectory().equalsIgnoreCase(Config.getCacheDirectory())) {
            Trace.println(ResourceManager.getString("launch.warning.cachedir"), TraceLevel.BASIC);
            Environment.setSystemCacheMode(false);
            Cache.setSystemCacheDir(null);
        }
    }

    public static boolean useSystemLookAndFeel() {
        String value = Config.getStringProperty(USE_SYSTEM_LF_KEY);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return Platform.get().systemLookAndFeelDefault();
    }

    public static String getJavaCommand() {
        String command = System.getProperty("java.home");
        return Config.getJavaCommand(command);
    }

    public static String getJavaCommand(String path) {
        if (null == path) {
            return null;
        }
        if (((String)path).endsWith(Platform.get().getPlatformSpecificJavaName())) {
            return path;
        }
        if (!((String)path).endsWith(File.separator)) {
            path = (String)path + File.separator;
        }
        return (String)path + "bin" + File.separator + Platform.get().getPlatformSpecificJavaName();
    }

    public static String getJavaHome(String command) {
        if (null == command) {
            return null;
        }
        String java = "bin" + File.separator + Platform.get().getPlatformSpecificJavaName();
        if (command.endsWith(java)) {
            command = command.substring(0, command.length() - java.length());
        }
        while (command.endsWith(File.separator)) {
            command = command.substring(0, command.length() - 1);
        }
        return command;
    }

    public static String getOldJavawsCacheDir() {
        String overrideLocation = Config.getStringProperty(JAVAWS_CACHE_KEY);
        if (overrideLocation != null) {
            return overrideLocation;
        }
        return Config.getCacheDirectory() + File.separator + JAVAWS_OUTPUTFILE_PREFIX;
    }

    public static String getSplashDir() {
        return ResourceProvider.get().getCacheDir().getPath() + File.separator + "splash";
    }

    public static String getSplashIndex() {
        return Config.getSplashDir() + File.separator + "splash.xml";
    }

    public static void setSplashCache() {
        Config.get().setProperty(SPLASH_CACHE_INDEX_KEY, Config.getSplashIndex());
    }

    public static String getAppIconDir() {
        return ResourceProvider.get().getCacheDir().getPath() + File.separator + "appIcon";
    }

    public static String getAppIconIndex() {
        return Config.getAppIconDir() + File.separator + "appIcon.xml";
    }

    public static void setAppIconCache() {
        Config.get().setProperty(APP_ICON_CACHE_INDEX_KEY, Config.getAppIconIndex());
    }

    public static String[] getSecureProperties() {
        ArrayList<String> list = new ArrayList<String>(4);
        list.addAll(defaultSecureProperties);
        String ConfigKeys = Config.getStringProperty(SECURE_PROPS_KEY);
        if (ConfigKeys != null) {
            StringTokenizer st = new StringTokenizer(ConfigKeys, ",");
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
        }
        return list.toArray(new String[0]);
    }

    public static boolean isLegalArgument(String arg) {
        return !Config.containsUnsupportedCharacters(arg);
    }

    public static boolean isLegalProperty(String key, String value) {
        if (!Config.containsUnsupportedCharacters(key)) {
            return !Config.containsUnsupportedCharacters(value);
        }
        return true;
    }

    public static boolean isLegalExtendedASCIIProperty(String key, String value) {
        if (!Config.containsUnsupportedCharacters(key)) {
            return !Config.containsUnsupportedCharactersExtASCII(value);
        }
        return true;
    }

    private static boolean isSecureSignedVmArg(String arg) {
        for (String tmp : secureSignedVmPrefixes) {
            if (!arg.startsWith(tmp)) continue;
            return !Config.containsUnsupportedCharacters(arg);
        }
        return false;
    }

    public static String findSecureSignedVmArg(String args) {
        if (args != null) {
            for (String secureSignedArg : secureSignedVmPrefixes) {
                int invalidStart = args.indexOf(secureSignedArg);
                if (invalidStart < 0) continue;
                int invalidEnd = args.indexOf(" ", invalidStart);
                if (invalidEnd > invalidStart) {
                    return args.substring(invalidStart, invalidEnd);
                }
                return args.substring(invalidStart);
            }
        }
        return null;
    }

    public static boolean isSecureVmArg(String arg) {
        for (String tmp : secureVmArgs) {
            if (!arg.equals(tmp)) continue;
            return true;
        }
        for (String tmp : secureVmPrefixes) {
            if (!arg.startsWith(tmp)) continue;
            return !Config.containsUnsupportedCharacters(arg);
        }
        if (arg.startsWith("-D") || arg.startsWith("\"-D")) {
            return Config.isSecureSystemProperty(arg);
        }
        return Config.isSecureSignedVmArg(arg);
    }

    public static boolean isSecureSystemProperty(String arg) {
        String value = "";
        if (arg.startsWith("-D")) {
            arg = arg.substring(2);
        } else if (arg.startsWith("\"-D")) {
            arg = arg.substring(3);
        }
        int equalIndex = arg.indexOf(61);
        if (equalIndex != -1) {
            if (equalIndex + 1 < arg.length()) {
                value = arg.substring(equalIndex + 1);
            }
            arg = arg.substring(0, equalIndex);
        }
        return Config.isSecureProperty(arg, value);
    }

    public static boolean isSecurePropertyKey(String key) {
        if (Config.containsUnsupportedCharacters(key)) {
            return false;
        }
        if (key.startsWith("jnlp.") || key.startsWith("javaws.") || key.startsWith("javapi.")) {
            return true;
        }
        return defaultSecureProperties.contains(key);
    }

    public static boolean isSecureProperty(String key, String value) {
        return Config.isSecurePropertyKey(key) && !Config.containsUnsupportedCharacters(value);
    }

    private static boolean containsUnsupportedCharacters(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        int last = s.length() - 1;
        char fc = s.charAt(0);
        char lc = s.charAt(last);
        if (!(fc != '\"' && lc != '\"' || lc == fc && last != 0)) {
            return true;
        }
        if (lc == '\\' || last > 0 && lc == '\"' && s.charAt(last - 1) == '\\') {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            char a = s.charAt(i);
            if (a < ' ' || a > '~' || a == '%') {
                return true;
            }
            if (a != '\"' || i == 0 || i == last) continue;
            return true;
        }
        return false;
    }

    private static boolean containsUnsupportedCharactersExtASCII(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        int last = s.length() - 1;
        char fc = s.charAt(0);
        char lc = s.charAt(last);
        if (!(fc != '\"' && lc != '\"' || lc == fc && last != 0)) {
            return true;
        }
        if (lc == '\\' || last > 0 && lc == '\"' && s.charAt(last - 1) == '\\') {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            char a = s.charAt(i);
            if ((a < ' ' || a > '~' || a == '%') && (Character.isISOControl(a) || Character.isWhitespace(a) || a == '%')) {
                return true;
            }
            if (a != '\"' || i == 0 || i == last) continue;
            return true;
        }
        return false;
    }

    public static void addSecureSystemPropertiesTo(Properties props) {
        String[] secureProps;
        for (String key : secureProps = Config.getSecureProperties()) {
            String value = System.getProperty(key);
            if (value == null) continue;
            props.setProperty(key, value);
        }
    }

    public static void addAllSystemPropertiesTo(Properties props) {
        Properties sprops = System.getProperties();
        Enumeration<?> ep = sprops.propertyNames();
        while (ep.hasMoreElements()) {
            String key = (String)ep.nextElement();
            String val = sprops.getProperty(key);
            props.setProperty(key, val);
        }
    }

    public static List<String> getProxyOverrideList() {
        return null;
    }

    public static void setMixcodeValue(int value) {
        String str;
        switch (value) {
            case 0: {
                str = "ENABLE";
                break;
            }
            default: {
                str = MIXCODE_MODE_HIDE_RUN;
                break;
            }
            case 2: {
                str = MIXCODE_MODE_HIDE_CANCEL;
                break;
            }
            case 3: {
                str = "DISABLE";
            }
        }
        Config.setStringProperty(MIXCODE_MODE_KEY, str);
    }

    public static int getMixcodeValue() {
        String str = Config.getStringProperty(MIXCODE_MODE_KEY);
        if (str.equals("ENABLE")) {
            return 0;
        }
        if (str.equals(MIXCODE_MODE_HIDE_RUN)) {
            return 1;
        }
        if (str.equals(MIXCODE_MODE_HIDE_CANCEL)) {
            return 2;
        }
        if (str.equals("DISABLE")) {
            return 3;
        }
        return 0;
    }

    public static int getShortcutValue() {
        String str = Config.getStringProperty(SHORTCUT_MODE_KEY);
        if (str.equals("NEVER")) {
            return 0;
        }
        if (str.equals("ALWAYS")) {
            return 1;
        }
        if (str.equals(SHORTCUT_MODE_ASK_TRUSTED)) {
            return 2;
        }
        return 3;
    }

    public static int getInstallMode() {
        String s = Config.getStringProperty(INSTALL_MODE_KEY);
        if (s.equals("IF_HINT")) {
            return 3;
        }
        if (s.equals(INSTALL_MODE_IF_SHORTCUT)) {
            return 1;
        }
        if (s.equals(INSTALL_MODE_IF_HINT_AND_SHORTCUT)) {
            return 2;
        }
        return 0;
    }

    public static int getAssociationValue() {
        String str = Config.getStringProperty(ASSOCIATION_MODE_KEY);
        if (str.equals("ALWAYS")) {
            return 4;
        }
        if (str.equals("NEVER")) {
            return 0;
        }
        if (str.equals(ASSOCIATION_MODE_NEW_ONLY)) {
            return 1;
        }
        if (str.equals("ASK_USER")) {
            return 2;
        }
        if (str.equals(ASSOCIATION_MODE_REPLACE_ASK)) {
            return 3;
        }
        return 0;
    }

    public static long getCacheSizeMax() {
        long size = -1L;
        String str = Config.getStringProperty(CACHE_MAX_KEY);
        if (str != null && str.length() > 0) {
            long factor;
            if (str.endsWith("M") || str.endsWith("m")) {
                factor = 0x100000L;
                str = str.substring(0, str.length() - 1);
            } else if (str.endsWith("K") || str.endsWith("k")) {
                factor = 1024L;
                str = str.substring(0, str.length() - 1);
            } else {
                factor = 0x100000L;
            }
            try {
                long sizeFromProp = Long.valueOf(str);
                if (sizeFromProp > 0L) {
                    size = factor * sizeFromProp;
                }
            }
            catch (NumberFormatException e) {
                size = -1L;
            }
        }
        return size;
    }

    public static void setJavaVersionForTest(int version) {
        javaTestVersion = version;
    }

    private static boolean isJavaTestVersionAtLeast(int version) {
        if (javaTestVersion == 0) {
            return true;
        }
        return javaTestVersion >= version;
    }

    public static boolean isDebugMode() {
        String debugMode = System.getProperty("deploy.debugMode");
        return debugMode != null && debugMode.equalsIgnoreCase("true");
    }

    public static boolean isDebugVMMode() {
        String debugVMMode = System.getProperty("deploy.useDebugJavaVM");
        return debugVMMode != null && debugVMMode.equalsIgnoreCase("true");
    }

    public static boolean checkClassName(String className) {
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        return true;
    }

    public static AccessControlContext getNoPermissionACC() {
        return noPermissionACC;
    }

    public static boolean checkPackageAccess(final String name, AccessControlContext acc) {
        Boolean allowed = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    ReflectUtil.checkPackageAccess(StringUtils.replaceSeparators(name));
                    return Boolean.TRUE;
                }
                catch (Exception e) {
                    return Boolean.FALSE;
                }
            }
        }, acc);
        return allowed;
    }

    public static String getOSName() {
        return _os;
    }

    public static String getOSFullName() {
        return Config.get()._getOSFullName();
    }

    protected String _getOSFullName() {
        if (this._osFullName == null) {
            this._osFullName = System.getProperty(SYSPROP_OS_NAME);
        }
        return this._osFullName;
    }

    public static String getOSArch() {
        return _arch;
    }

    public static String getOSPlatform() {
        return _platform;
    }

    public static void setDebug() {
        if (Environment.getenv("JPI_PLUGIN2_DEBUG") != null || Environment.getenv("DEPLOY_DEBUG") != null) {
            _debug = true;
        }
        if (Environment.getenv("JPI_PLUGIN2_VERBOSE") != null || Environment.getenv("DEPLOY_VERBOSE") != null) {
            // empty if block
        }
        _debugSet = true;
    }

    public static boolean getDebug() {
        if (!_debugSet) {
            Config.setDebug();
        }
        return _debug;
    }

    public static boolean getVerbose() {
        if (!_debugSet) {
            Config.setDebug();
        }
        return _verbose;
    }

    public static File getExceptionSitesFile() {
        return new File(Config.getStringProperty(USEC_EXCEPTION_SITES_KEY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getExceptionSites() {
        ArrayList<String> sites;
        block19: {
            sites = new ArrayList<String>();
            File file = Config.getExceptionSitesFile();
            BufferedReader br = null;
            int badLines = 0;
            try {
                String line;
                if (!file.exists()) break block19;
                FileInputStream is = new FileInputStream(file);
                br = new BufferedReader(new InputStreamReader(is));
                while ((line = br.readLine()) != null) {
                    line = line.trim();
                    try {
                        URL u = new URL(line);
                        if (sites.contains(line)) continue;
                        sites.add(line);
                    }
                    catch (Exception mue) {
                        Trace.println("invalid exception list entry: " + line, TraceLevel.BASIC);
                        Trace.ignored(mue);
                        if (++badLines <= 8) continue;
                        break;
                    }
                }
            }
            catch (FileNotFoundException ex) {
                Trace.ignored(ex);
            }
            catch (IOException ex) {
                Trace.ignored(ex);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception e) {
                        Trace.ignored(e);
                    }
                }
            }
        }
        return sites.toArray(new String[0]);
    }

    public void installSecurityManager() {
    }

    static {
        expirationCheckEnabled = EXPIRATION_CHECK_ENABLED_DEF = BuiltInProperties.isJreBaselineCheckEnabled();
        PROXY_KEYS = new String[]{PROX_TYPE_KEY, PROX_SAME_KEY, PROX_LOCAL_KEY, PROX_AUTOCFG_KEY, PROX_BYPASS_KEY, PROX_HTTP_HOST_KEY, PROX_HTTP_PORT_KEY, PROX_HTTPS_HOST_KEY, PROX_HTTPS_PORT_KEY, PROX_FTP_HOST_KEY, PROX_FTP_PORT_KEY, PROX_SOX_HOST_KEY, PROX_SOX_PORT_KEY, PROX_OVERRIDE_KEY};
        ALL_TLS_PROTOCOLS = new String[]{SEC_TLSv12_KEY, SEC_TLSv11_KEY, SEC_TLSv1_KEY, SEC_SSLv3_KEY};
        defaultSecureProperties = new HashSet<String>();
        defaultSecureProperties.add("sun.java2d.noddraw");
        defaultSecureProperties.add(JAUTHENTICATOR_SYSTEM_PROP);
        defaultSecureProperties.add("swing.useSystemFontSettings");
        defaultSecureProperties.add("swing.metalTheme");
        defaultSecureProperties.add("http.agent");
        defaultSecureProperties.add("http.keepAlive");
        defaultSecureProperties.add("sun.awt.noerasebackground");
        defaultSecureProperties.add("sun.java2d.opengl");
        defaultSecureProperties.add("sun.java2d.d3d");
        defaultSecureProperties.add("java.awt.syncLWRequests");
        defaultSecureProperties.add("java.awt.Window.locationByPlatform");
        defaultSecureProperties.add("sun.awt.erasebackgroundonresize");
        defaultSecureProperties.add("sun.awt.keepWorkingSetOnMinimize");
        defaultSecureProperties.add("swing.noxp");
        defaultSecureProperties.add("swing.boldMetal");
        defaultSecureProperties.add("awt.useSystemAAFontSettings");
        defaultSecureProperties.add("sun.java2d.dpiaware");
        defaultSecureProperties.add("sun.awt.disableMixing");
        defaultSecureProperties.add("sun.lang.ClassLoader.allowArraySyntax");
        defaultSecureProperties.add("java.awt.smartInvalidate");
        defaultSecureProperties.add("apple.laf.useScreenMenuBar");
        defaultSecureProperties.add("java.net.preferIPv4Stack");
        defaultSecureProperties.add("java.util.Arrays.useLegacyMergeSort");
        defaultSecureProperties.add("sun.locale.formatasdefault");
        defaultSecureProperties.add("sun.awt.enableExtraMouseButtons");
        defaultSecureProperties.add("com.sun.management.jmxremote.local.only");
        defaultSecureProperties.add("sun.nio.ch.bugLevel");
        defaultSecureProperties.add("sun.nio.ch.disableSystemWideOverlappingFileLockCheck");
        defaultSecureProperties.add("jdk.map.althashing.threshold");
        secureVmArgs = new String[]{"-d32", "-client", "-server", "-verbose", "-version", "-showversion", "-help", "-X", "-ea", "-enableassertions", "-da", "-disableassertions", "-esa", "-enablesystemassertions", "-dsa", "-disablesystemassertions", "-Xmixed", "-Xint", "-Xnoclassgc", "-Xincgc", "-Xbatch", "-Xprof", "-Xdebug", "-Xfuture", "-Xrs", "-XX:+ForceTimeHighResolution", "-XX:-ForceTimeHighResolution", "-XX:+PrintGCDetails", "-XX:+PrintGCTimeStamps", "-XX:+PrintHeapAtGC", "-XX:+PrintTenuringDistribution", "-XX:+TraceClassUnloading", "-XX:+CMSClassUnloadingEnabled", "-XX:+CMSIncrementalPacing", "-XX:+UseConcMarkSweepGC", "-XX:-ParallelRefProcEnabled", "-XX:+DisableExplicitGC", "-XX:+UseG1GC", "-XX:+HeapDumpOnOutOfMemoryError", "-XstartOnFirstThread", "-XX:+UseG1GC", "-XX:+UseStringDeduplication", "-XX:+PrintStringDeduplicationStatistics", "-XX:+UseParallelOldGC", "-XX:-UseParallelOldGC", "-XX:+UseParallelOldGCCompacting", "-XX:-UseParallelOldGCCompacting", "-XX:+UseParallelGC", "-XX:-UseParallelGC", "-XX:+UseGCTimeLimit", "-XX:-UseGCTimeLimit", "-XX:+UseGCOverheadLimit", "-XX:-UseGCOverheadLimit", "-XX:+ScavengeBeforeFullGC", "-XX:-ScavengeBeforeFullGC", "-XX:+UseParallelScavenge", "-XX:-UseParallelScavenge", "-XX:-TransmitErrorReport"};
        secureVmPrefixes = new String[]{"-ea:", "-enableassertions:", "-da:", "-disableassertions:", "-verbose:", "-Xmn", "-Xms", "-Xmx", "-Xss", "-XX:NewRatio", "-XX:NewSize", "-XX:MaxNewSize", "-XX:PermSize", "-XX:MaxPermSize", "-XX:MaxHeapFreeRatio", "-XX:MinHeapFreeRatio", "-XX:-UseSerialGC", "-XX:ThreadStackSize", "-XX:MaxInlineSize", "-XX:ReservedCodeCacheSize", "-XX:MaxDirectMemorySize", "-XX:PrintCMSStatistics", "-XX:SurvivorRatio", "-XX:MaxTenuringThreshold", "-XX:CMSMarkStackSize", "-XX:CMSMarkStackSizeMax", "-XX:CMSIncrementalDutyCycleMin", "-XX:ParallelCMSThreads", "-XX:ParallelGCThreads", "-XX:CMSInitiatingOccupancyFraction", "-XX:+UseCompressedOops", "-XX:GCPauseIntervalMillis", "-XX:MaxGCPauseMillis", "-XX:+CMSIncrementalMode", "-XX:StringDeduplicationAgeThreshold", "-XX:GCTimeLimit", "-XX:GCHeapFreeLimit", "-XX:MarkStackSize", "-XX:MarkStackSizeMax", "-XX:ConcGCThreads", "--add-modules="};
        secureSignedVmPrefixes = new String[]{"--add-exports=", "--add-opens="};
        deploymentHooks = new DeploymentHooks();
        Permissions perms = new Permissions();
        SecurityPermission perm = new SecurityPermission("getProperty.package.access");
        ((PermissionCollection)perms).add(perm);
        perm = new SecurityPermission("setProperty.package.access");
        ((PermissionCollection)perms).add(perm);
        perm = new SecurityPermission("getProperty.package.definition");
        ((PermissionCollection)perms).add(perm);
        perm = new SecurityPermission("setProperty.package.definition");
        ((PermissionCollection)perms).add(perm);
        ACC_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        _javaVersionProperty = System.getProperty("java.version");
        _javaRuntimeNameProperty = System.getProperty("java.runtime.name");
        _atLeast13 = !_javaVersionProperty.startsWith("1.2");
        _atLeast14 = _atLeast13 && !_javaVersionProperty.startsWith("1.3");
        _atLeast15 = _atLeast14 && !_javaVersionProperty.startsWith("1.4");
        _atLeast16 = _atLeast15 && !_javaVersionProperty.startsWith("1.5");
        _atLeast17 = _atLeast16 && !_javaVersionProperty.startsWith("1.6");
        _atLeast18 = _atLeast17 && !_javaVersionProperty.startsWith("1.7");
        _atLeast9 = _atLeast18 && !_javaVersionProperty.startsWith("1.8");
        _config = null;
        _jreHome = System.getProperty("java.home");
        _latestJREHome = null;
        javaTestVersion = 0;
        noPermissionACC = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, null)});
        String stmp = System.getProperty(SYSPROP_OS_NAME);
        _os = stmp.startsWith("Win") ? "Windows" : stmp;
        _arch = System.getProperty("os.arch");
        _platform = System.getProperty("os.platform");
        _debugSet = false;
        _debug = false;
        _verbose = false;
    }
}

