/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class SecuritySettings {
    private static final String[] SEC_LEVEL_MANAGED_PROPERTIES = new String[]{"deployment.insecure.jres", "deployment.security.run.untrusted", "deployment.security.local.applets", "deployment.security.sandbox.selfsigned", "deployment.security.sandbox.casigned", "deployment.security.askgrantdialog.notinca", "deployment.security.revocation.check.best.effort", "deployment.security.permissions.manifest.required", "deployment.security.allow.expired.certs", "deployment.security.tls.revocation.check.best.effort", "deployment.security.allow.vm.sharing"};
    private static final String[][] SEC_LEVEL_MAP = new String[][]{{"NEVER", "NEVER"}, {"NEVER", "NEVER"}, {"NEVER", "NEVER"}, {"NEVER", "NEVER"}, {"PROMPT", "PROMPT"}, {"false", "false"}, {"true", "false"}, {"true", "true"}, {"false", "false"}, {"true", "false"}, {"false", "false"}};
    public static final String[] SECURITY_LEVELS = new String[]{"HIGH", "VERY_HIGH"};
    public static final int LEVEL_HIGH_INDEX = 0;
    public static final int LEVEL_VERY_HIGH_INDEX = 1;
    public static final int LEVEL_DEFAULT_INDEX = 0;

    public static boolean isUnrelatedVmSharingAllowed() {
        return SecuritySettings.getManagedBooleanValue("deployment.security.allow.vm.sharing");
    }

    public static boolean isExpiredAllowed() {
        return SecuritySettings.getManagedBooleanValue("deployment.security.allow.expired.certs");
    }

    public static boolean isSelfSignedNever() {
        return "NEVER".equals(SecuritySettings.getManagedPropertyValue("deployment.security.sandbox.selfsigned"));
    }

    public static boolean isCaSignedNever() {
        return "NEVER".equals(SecuritySettings.getManagedPropertyValue("deployment.security.sandbox.casigned"));
    }

    public static boolean isSSVModeNever() {
        return "NEVER".equals(SecuritySettings.getManagedPropertyValue("deployment.insecure.jres"));
    }

    public static boolean isSSVModePrompt() {
        return "PROMPT".equals(SecuritySettings.getManagedPropertyValue("deployment.insecure.jres"));
    }

    public static boolean isSSVModeMultiClick() {
        return "PROMPT_MULTI".equals(SecuritySettings.getManagedPropertyValue("deployment.insecure.jres"));
    }

    public static boolean isAskGrantShowSet() {
        return Config.getBooleanProperty("deployment.security.askgrantdialog.show");
    }

    public static boolean isAskGrantSelfSignedSet() {
        return SecuritySettings.getManagedBooleanValue("deployment.security.askgrantdialog.notinca");
    }

    public static boolean isRunUntrustedNever() {
        return "NEVER".equals(SecuritySettings.getManagedPropertyValue("deployment.security.run.untrusted"));
    }

    public static boolean isRunUntrustedMultiClick() {
        return "PROMPT_MULTI".equals(SecuritySettings.getManagedPropertyValue("deployment.security.run.untrusted"));
    }

    public static boolean isPermissionsManifestRequired() {
        return SecuritySettings.getManagedBooleanValue("deployment.security.permissions.manifest.required");
    }

    public static boolean isRunLocalAppletsNever() {
        return "NEVER".equals(SecuritySettings.getManagedPropertyValue("deployment.security.local.applets"));
    }

    public static boolean isRevocationCheckBestEffort() {
        return SecuritySettings.getManagedBooleanValue("deployment.security.revocation.check.best.effort");
    }

    public static boolean isTLSRevocationCheckBestEffort() {
        return SecuritySettings.getManagedBooleanValue("deployment.security.tls.revocation.check.best.effort");
    }

    public static String getManagedPropertyValue(String key) {
        int level = SecuritySettings.getSecurityLevelInt();
        int property_index = SecuritySettings.getPropertyIndex(key);
        if (property_index < 0) {
            Trace.println("Trying to call getManagedProperty(" + key + ");", TraceLevel.BASIC);
            return Config.getStringProperty(key);
        }
        return SEC_LEVEL_MAP[property_index][level];
    }

    public static boolean getManagedBooleanValue(String key) {
        return "true".equalsIgnoreCase(SecuritySettings.getManagedPropertyValue(key));
    }

    private static int getPropertyIndex(String key) {
        for (int i = 0; i < SEC_LEVEL_MANAGED_PROPERTIES.length; ++i) {
            if (!SEC_LEVEL_MANAGED_PROPERTIES[i].equals(key)) continue;
            return i;
        }
        return -1;
    }

    public static void setSecurityLevel(String level) {
        Config.setStringProperty("deployment.security.level", level);
        for (int i = 0; i < SEC_LEVEL_MANAGED_PROPERTIES.length; ++i) {
            Config.setStringProperty(SEC_LEVEL_MANAGED_PROPERTIES[i], null);
        }
    }

    public static String getSecurityLevel() {
        return Config.getStringProperty("deployment.security.level");
    }

    public static int getSecurityLevelInt() {
        return SecuritySettings.getLevelInt(SecuritySettings.getSecurityLevel());
    }

    private static int getLevelInt(String level) {
        for (int i = 0; i < SECURITY_LEVELS.length; ++i) {
            if (!SECURITY_LEVELS[i].equals(level)) continue;
            return i;
        }
        return 0;
    }

    public static void setInstallerRecommendedSecurityLevel(int level) {
        if (level >= 0 && level < SECURITY_LEVELS.length) {
            SecuritySettings.setSystemDeploymentProperty("deployment.security.level", SECURITY_LEVELS[level]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean setSystemDeploymentProperty(String name, String value) {
        try {
            File f = new File(Config.getSystemHomePropertiesFile());
            Properties instProps = new Properties();
            if (f.exists()) {
                instProps.load(new FileInputStream(f));
            }
            instProps.setProperty(name, value);
            new FileOutputStream(f);
            FileOutputStream fos = new FileOutputStream(f);
            if (fos == null) return false;
            try {
                instProps.store(fos, "System Deployment Properties");
                boolean bl = true;
                return bl;
            }
            finally {
                fos.flush();
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
        return false;
    }
}

