/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.nativesandbox;

import com.sun.deploy.config.Platform;
import com.sun.deploy.nativesandbox.NativeSandboxBrokerImpl;
import com.sun.deploy.util.ArgumentParsingUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public final class IntegrityProcess
extends Process {
    public static final int INTEGRITY_LEVEL_UNKNOWN = 0;
    public static final int INTEGRITY_LEVEL_LOW = 1;
    public static final int INTEGRITY_LEVEL_MEDIUM = 2;
    public static final int INTEGRITY_LEVEL_APP_CONTAINER = 3;
    private static int integrityLevel = 0;
    private long processHandle = 0L;
    private Thread brokerThread = null;
    private static ClassLoader loader = null;

    public static void setClassLoader(ClassLoader cl) {
        loader = cl;
    }

    public static Process getIntegrityProcess(List<String> command) throws IOException {
        if (command.isEmpty()) {
            return null;
        }
        IntegrityProcess process = new IntegrityProcess();
        process.start(command);
        return process;
    }

    public static int getIntegrityLevel() {
        if (integrityLevel == 0) {
            integrityLevel = IntegrityProcess.getCurrentIntegrityLevel();
        }
        return integrityLevel;
    }

    private static native int getCurrentIntegrityLevel();

    private static native long launchProcess(String var0, String var1);

    private static native void waitForProcess(long var0);

    private static native void destroyProcess(long var0);

    private IntegrityProcess() {
    }

    @Override
    public OutputStream getOutputStream() {
        return null;
    }

    @Override
    public InputStream getInputStream() {
        return null;
    }

    @Override
    public InputStream getErrorStream() {
        return null;
    }

    @Override
    public int waitFor() throws InterruptedException {
        if (this.processHandle != 0L) {
            IntegrityProcess.waitForProcess(this.processHandle);
        }
        return 0;
    }

    @Override
    public int exitValue() {
        return 0;
    }

    @Override
    public synchronized void destroy() {
        if (this.processHandle != 0L) {
            IntegrityProcess.destroyProcess(this.processHandle);
            this.processHandle = 0L;
        }
    }

    private void initializeNativeSandboxBroker(List<String> command) throws IOException {
        final long[] handlesBrokerRead = NativeSandboxBrokerImpl.getNativeSandboxPipeHandles();
        if (handlesBrokerRead == null) {
            throw new IOException("Cannot create native pipes.");
        }
        final long[] handlesBrokerWrite = NativeSandboxBrokerImpl.getNativeSandboxPipeHandles();
        if (handlesBrokerWrite == null) {
            throw new IOException("Cannot create native pipes.");
        }
        String taArg = null;
        int index = -1;
        for (int i = 1; i < command.size(); ++i) {
            String arg = command.get(i);
            if (!arg.equals("-ta")) continue;
            if (i + 1 >= command.size()) break;
            index = i + 1;
            taArg = command.get(index);
            break;
        }
        if (taArg == null && index == -1) {
            ArrayList<String> args = new ArrayList<String>();
            args.add("-DNSBWP=" + handlesBrokerRead[1]);
            args.add("-DNSBRP=" + handlesBrokerWrite[0]);
            taArg = ArgumentParsingUtil.encodeArgumentList(args);
            command.add("-ta");
            command.add(taArg);
        } else {
            List<String> args = ArgumentParsingUtil.decodeArgumentList(taArg);
            args.add("-DNSBWP=" + handlesBrokerRead[1]);
            args.add("-DNSBRP=" + handlesBrokerWrite[0]);
            taArg = ArgumentParsingUtil.encodeArgumentList(args);
            command.remove(index);
            command.add(index, taArg);
        }
        this.brokerThread = new Thread(){

            @Override
            public void run() {
                if (loader != null) {
                    Thread.currentThread().setContextClassLoader(loader);
                }
                NativeSandboxBrokerImpl broker = new NativeSandboxBrokerImpl(handlesBrokerRead[0], handlesBrokerWrite[1]);
                broker.runNativeSandboxBroker();
            }
        };
        this.brokerThread.setDaemon(false);
        this.brokerThread.start();
    }

    private void start(List<String> command) throws IOException {
        String app = "";
        Object args = "";
        this.initializeNativeSandboxBroker(command);
        Platform.validateProcessBuilder(command);
        app = command.get(0);
        for (int i = 0; i < command.size(); ++i) {
            String arg = command.get(i);
            if (arg.contains(" ")) {
                args = (String)args + "\"";
                args = (String)args + arg;
                args = (String)args + "\"";
            } else {
                args = (String)args + arg;
            }
            if (i >= command.size() - 1) continue;
            args = (String)args + " ";
        }
        this.processHandle = IntegrityProcess.launchProcess(app, (String)args);
    }
}

