/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.cookie;

import com.sun.deploy.net.cookie.CookieHandler;
import com.sun.deploy.net.cookie.CookieUnavailableException;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.SecureCookiePermission;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeployCookieSelector
extends java.net.CookieHandler {
    private HashMap<String, String> cookieTable = new HashMap();
    private CookieHandler cookieHandler = null;

    public static synchronized void reset() {
        java.net.CookieHandler.setDefault(new DeployCookieSelector());
    }

    private boolean canServeCookies(URI uri) {
        SecurityManager se = System.getSecurityManager();
        if (se != null) {
            try {
                se.checkPermission(new SecureCookiePermission(uri));
            }
            catch (SecurityException se2) {
                if (uri != null && !uri.getScheme().toLowerCase().equals("http")) {
                    Trace.msgSecurityPrintln("Possible use of 'Secure' cookies blocked for " + uri);
                    Trace.msgSecurityPrintln("To use secure cookie (HTTPS), consider signing the application or host application with HTTPS");
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized Map<String, List<String>> get(URI uri, Map<String, List<String>> requestHeaders) throws IOException {
        String cookieInfo;
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        URI uriForCookie = uri;
        if (!this.canServeCookies(uriForCookie)) {
            try {
                uriForCookie = new URI("http", uri.getSchemeSpecificPart(), uri.getFragment());
            }
            catch (Exception e) {
                Trace.ignoredException(e);
            }
            if (!this.canServeCookies(uriForCookie)) {
                return map;
            }
        }
        if ((cookieInfo = this.getCookieInfo(uriForCookie.toURL())) != null) {
            ArrayList<String> valueList = new ArrayList<String>();
            valueList.add(cookieInfo);
            map.put("Cookie", valueList);
        }
        return map;
    }

    @Override
    public synchronized void put(URI uri, Map<String, List<String>> responseHeaders) throws IOException {
        for (String key : responseHeaders.keySet()) {
            List<String> header;
            if (key == null || !key.equalsIgnoreCase("Set-Cookie") && !key.equalsIgnoreCase("Set-Cookie2") || (header = responseHeaders.get(key)) == null) continue;
            for (String cookieInfo : header) {
                if (cookieInfo == null) continue;
                this.setCookieInfo(uri.toURL(), cookieInfo);
            }
        }
    }

    protected void setCookieInfo(URL u, String value) {
        this.initializeImpl();
        if (Trace.isEnabled(TraceLevel.NETWORK)) {
            Trace.msgNetPrintln("net.cookie.server", new Object[]{u, value});
        }
        try {
            this.setCookieInBrowser(u, value);
        }
        catch (CookieUnavailableException e) {
            System.out.println(ResourceManager.getString("net.cookie.ignore.setcookie"));
        }
    }

    protected String getCookieInfo(URL u) {
        this.initializeImpl();
        String cookie = null;
        try {
            String file = u.getFile();
            int index = file.lastIndexOf(47);
            if (index != -1) {
                file = file.substring(0, index);
            }
            String key = u.getProtocol() + "://" + u.getHost() + file;
            try {
                cookie = this.getCookieFromBrowser(u);
                if (!(cookie == null || cookie.equals("") || cookie.equals("\n") || cookie.equals("\r\n"))) {
                    this.cookieTable.put(key, cookie);
                } else {
                    this.cookieTable.put(key, "");
                    cookie = null;
                }
            }
            catch (CookieUnavailableException se) {
                if (Trace.isEnabled(TraceLevel.NETWORK)) {
                    Trace.msgNetPrintln(ResourceManager.getString("net.cookie.noservice"));
                }
                cookie = this.cookieTable.get(key);
            }
            if (cookie != null && Trace.isEnabled(TraceLevel.NETWORK)) {
                Trace.msgNetPrintln("net.cookie.connect", new Object[]{u, cookie});
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return cookie;
    }

    protected void initializeImpl() {
        if (this.cookieHandler == null) {
            Service service = ServiceManager.getService();
            this.cookieHandler = service.getCookieHandler();
        }
    }

    protected void setCookieInBrowser(URL u, String value) throws CookieUnavailableException {
        if (this.cookieHandler != null) {
            this.cookieHandler.setCookieInfo(u, value);
        }
    }

    protected String getCookieFromBrowser(URL u) throws CookieUnavailableException {
        if (this.cookieHandler != null) {
            return this.cookieHandler.getCookieInfo(u);
        }
        return null;
    }
}

