/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.net.proxy.BrowserProxyConfig;
import com.sun.deploy.net.proxy.BrowserProxyInfo;
import com.sun.deploy.net.proxy.DirectProxyHandler;
import com.sun.deploy.net.proxy.ManualProxyHandler;
import com.sun.deploy.net.proxy.ProxyConfigException;
import com.sun.deploy.net.proxy.ProxyHandler;
import com.sun.deploy.net.proxy.ProxyInfo;
import com.sun.deploy.net.proxy.ProxyUnavailableException;
import com.sun.deploy.net.proxy.UserDefinedProxyConfig;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;

public class DynamicProxyManager {
    private static HashMap<String, List<Proxy>> proxyCache = new HashMap();
    private static ProxyHandler handler = null;
    private static final AccessControlContext ACC_PROXY_INSTANCE;

    public static synchronized List<Proxy> getProxyList(URL url, boolean isSocketURI) {
        String protocol = url.getProtocol();
        String host = url.getHost();
        StringBuffer keyBuffer = new StringBuffer();
        keyBuffer.append(protocol);
        keyBuffer.append(host);
        keyBuffer.append(url.getPort());
        String key = keyBuffer.toString();
        List<Proxy> pInfo = null;
        if (handler.isProxyCacheSupported()) {
            pInfo = proxyCache.get(key);
        }
        if (pInfo == null) {
            try {
                pInfo = new ArrayList<Proxy>();
                if (!host.equals("127.0.0.1") && !host.equals("localhost")) {
                    URL getProxyUrl = new URL(url.getProtocol(), url.getHost(), url.getPort(), "");
                    ProxyInfo[] proxyArray = handler.getProxyInfo(getProxyUrl);
                    for (int i = 0; i < proxyArray.length; ++i) {
                        if (proxyArray[i].isProxyUsed()) {
                            pInfo.add(DynamicProxyManager.getProxy(proxyArray[i], isSocketURI));
                            continue;
                        }
                        pInfo.add(Proxy.NO_PROXY);
                    }
                } else {
                    pInfo.add(Proxy.NO_PROXY);
                }
                if (handler.isProxyCacheSupported()) {
                    proxyCache.put(key.toString(), pInfo);
                }
            }
            catch (ProxyUnavailableException e) {
                Trace.msgNetPrintln("net.proxy.service.not_available", new Object[]{url});
                pInfo.add(Proxy.NO_PROXY);
            }
            catch (MalformedURLException mue) {
                Trace.msgNetPrintln("net.proxy.service.not_available", new Object[]{url});
                Trace.ignored(mue);
                pInfo.add(Proxy.NO_PROXY);
            }
        }
        ArrayList<Proxy> dup = new ArrayList();
        dup = pInfo;
        return dup;
    }

    private static Proxy getProxy(final ProxyInfo pi, final boolean isSocketURL) {
        Proxy proxy = null;
        try {
            proxy = AccessController.doPrivileged(new PrivilegedExceptionAction<Proxy>(){

                @Override
                public Proxy run() throws IOException {
                    if (isSocketURL) {
                        if (pi.isSocksUsed()) {
                            return new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(pi.getSocksProxy(), pi.getSocksPort()));
                        }
                        return Proxy.NO_PROXY;
                    }
                    if (pi.getProxy() == null && pi.isSocksUsed()) {
                        return new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(pi.getSocksProxy(), pi.getSocksPort()));
                    }
                    return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(pi.getProxy(), pi.getPort()));
                }
            }, ACC_PROXY_INSTANCE);
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        return proxy;
    }

    public static synchronized void setNoProxy(URL url) {
        String key = DynamicProxyManager.buildProxyKey(url);
        if (handler.isProxyCacheSupported()) {
            ArrayList<Proxy> list = new ArrayList<Proxy>();
            list.add(Proxy.NO_PROXY);
            proxyCache.put(key, list);
        }
    }

    private static String buildProxyKey(URL url) {
        StringBuffer keyBuffer = new StringBuffer();
        keyBuffer.append(url.getProtocol());
        keyBuffer.append(url.getHost());
        keyBuffer.append(url.getPort());
        return keyBuffer.toString();
    }

    protected static synchronized void removeProxyFromCache(URL url, String connection) {
        String key = DynamicProxyManager.buildProxyKey(url);
        if (proxyCache.containsKey(key)) {
            List<Proxy> pi = proxyCache.get(key);
            ListIterator<Proxy> iter = pi.listIterator();
            ArrayList<Proxy> removedProxy = new ArrayList<Proxy>();
            while (iter.hasNext()) {
                Proxy proxy = iter.next();
                InetSocketAddress proxyAddr = (InetSocketAddress)proxy.address();
                if (proxyAddr == null || !connection.contains(proxyAddr.getHostName())) continue;
                removedProxy.add(proxy);
            }
            iter = removedProxy.listIterator();
            while (iter.hasNext()) {
                pi.remove(iter.next());
            }
            if (pi.size() == 0) {
                proxyCache.remove(key);
            }
        }
    }

    public static synchronized void reset() {
        try {
            proxyCache.clear();
            UserDefinedProxyConfig upc = new UserDefinedProxyConfig();
            BrowserProxyInfo bpi = upc.getBrowserProxyInfo();
            Service service = ServiceManager.getService();
            if (bpi.getType() == 3) {
                BrowserProxyConfig bpc = service.getProxyConfig();
                bpi = bpc.getBrowserProxyInfo();
            }
            switch (bpi.getType()) {
                case 4: {
                    ProxyHandler ph;
                    try {
                        ph = service.getSystemProxyHandler();
                        if (ph == null) {
                            throw new ProxyConfigException("Unable to obtain system proxy handler.");
                        }
                        handler = ph;
                        handler.init(bpi);
                    }
                    catch (ProxyConfigException e) {
                        Trace.ignoredException(e);
                    }
                    break;
                }
                case 3: {
                    ProxyHandler ph;
                    try {
                        ph = service.getBrowserProxyHandler();
                        if (ph == null) {
                            throw new ProxyConfigException("Unable to obtain browser proxy handler.");
                        }
                        handler = ph;
                        handler.init(bpi);
                    }
                    catch (ProxyConfigException e) {
                        Trace.ignoredException(e);
                    }
                    break;
                }
                case 0: {
                    try {
                        handler = new DirectProxyHandler();
                        handler.init(bpi);
                    }
                    catch (ProxyConfigException e0) {
                        Trace.ignoredException(e0);
                    }
                    break;
                }
                case 1: {
                    try {
                        handler = new ManualProxyHandler();
                        handler.init(bpi);
                    }
                    catch (ProxyConfigException e0) {
                        Trace.msgNetPrintln("net.proxy.loading.manual.error");
                        try {
                            bpi.setType(0);
                            handler = new DirectProxyHandler();
                            handler.init(bpi);
                        }
                        catch (ProxyConfigException e1) {
                            Trace.ignoredException(e1);
                        }
                    }
                    break;
                }
                case 2: {
                    ProxyHandler ph;
                    try {
                        ph = service.getAutoProxyHandler();
                        if (ph == null) {
                            throw new ProxyConfigException("Unable to obtain auto proxy handler.");
                        }
                        handler = ph;
                        handler.init(bpi);
                    }
                    catch (ProxyConfigException e0) {
                        Trace.msgNetPrintln("net.proxy.loading.auto.error");
                        try {
                            bpi.setType(1);
                            handler = new ManualProxyHandler();
                            handler.init(bpi);
                        }
                        catch (ProxyConfigException e1) {
                            Trace.msgNetPrintln("net.proxy.loading.manual.error");
                            try {
                                bpi.setType(0);
                                handler = new DirectProxyHandler();
                                handler.init(bpi);
                            }
                            catch (ProxyConfigException e2) {
                                Trace.ignoredException(e2);
                            }
                        }
                    }
                    break;
                }
                default: {
                    Trace.ignored(new IllegalStateException("DynamicProxyManager: Invalid Proxy Type: " + bpi.getType() + " using ProxyType.NONE."));
                    try {
                        bpi.setType(0);
                        handler = new DirectProxyHandler();
                        handler.init(bpi);
                        break;
                    }
                    catch (ProxyConfigException e2) {
                        Trace.ignoredException(e2);
                    }
                }
            }
            final BrowserProxyInfo info = bpi;
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    DynamicProxyManager.setProperties(info);
                    return null;
                }
            });
            if (Trace.isEnabled(TraceLevel.NETWORK)) {
                Trace.msgNetPrintln(bpi.toString());
            }
        }
        catch (Throwable e) {
            Trace.ignored(e);
            ToolkitStore.getUI().showExceptionDialog(null, null, e, null, null, null, null);
        }
    }

    private static void setProperties(BrowserProxyInfo info) {
        Properties props = System.getProperties();
        int proxyType = info.getType();
        StringBuffer sb = new StringBuffer();
        if (info.getHttpHost() != null) {
            sb.append("http=" + info.getHttpHost());
            if (info.getHttpPort() != -1) {
                sb.append(":" + info.getHttpPort());
            }
        }
        if (info.getHttpsHost() != null) {
            sb.append(",https=" + info.getHttpsHost());
            if (info.getHttpsPort() != -1) {
                sb.append(":" + info.getHttpsPort());
            }
        }
        if (info.getFtpHost() != null) {
            sb.append(",ftp=" + info.getFtpHost());
            if (info.getFtpPort() != -1) {
                sb.append(":" + info.getFtpPort());
            }
        }
        if (info.getGopherHost() != null) {
            sb.append(",gopher=" + info.getGopherHost());
            if (info.getGopherPort() != -1) {
                sb.append(":" + info.getGopherPort());
            }
        }
        if (info.getSocksHost() != null) {
            sb.append(",socks=" + info.getSocksHost());
            if (info.getSocksPort() != -1) {
                sb.append(":" + info.getSocksPort());
            }
        }
        String proxyList = sb.toString();
        String[] overrides = info.getOverrides();
        String proxyOverride = null;
        if (overrides != null) {
            sb = new StringBuffer();
            boolean first = true;
            for (int idx = 0; idx < overrides.length; ++idx) {
                if (idx != 0) {
                    sb.append(",");
                }
                sb.append(overrides[idx]);
            }
            proxyOverride = sb.toString();
        }
        props.remove("javaplugin.proxy.config.type");
        props.remove("javaplugin.proxy.config.list");
        props.remove("javaplugin.proxy.config.bypass");
        if (proxyType == 0) {
            props.put("javaplugin.proxy.config.type", "direct");
        } else if (proxyType == 1) {
            props.put("javaplugin.proxy.config.type", "manual");
            if (proxyList != null) {
                props.put("javaplugin.proxy.config.list", proxyList);
            }
            if (proxyOverride != null) {
                props.put("javaplugin.proxy.config.bypass", proxyOverride);
            }
        } else if (proxyType == 2) {
            props.put("javaplugin.proxy.config.type", "auto");
        } else if (proxyType == 3) {
            props.put("javaplugin.proxy.config.type", "browser");
            if (proxyList != null) {
                props.put("javaplugin.proxy.config.list", proxyList);
            }
            if (proxyOverride != null) {
                props.put("javaplugin.proxy.config.bypass", proxyOverride);
            }
        } else {
            props.put("javaplugin.proxy.config.type", "unknown");
        }
        System.setProperties(props);
    }

    static {
        Permissions perms = new Permissions();
        SocketPermission perm = new SocketPermission("*", "connect,resolve");
        ((PermissionCollection)perms).add(perm);
        ACC_PROXY_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
    }
}

