/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.trace.Trace;

public final class ProxyInfo {
    private String proxy = null;
    private int port = -1;
    static final int DEFAULT_PROXY_PORT = 80;
    private String socksProxy = null;
    private int socksPort = -1;
    static final int DEFAULT_SOCKET_PORT = 1080;

    public ProxyInfo(String pinfo) {
        this(pinfo, null);
    }

    public ProxyInfo(String pinfo, String spinfo) {
        Object[] args;
        Object[] args2;
        int ix;
        if (pinfo != null) {
            ix = pinfo.indexOf("//");
            if (ix >= 0) {
                pinfo = pinfo.substring(ix + 2);
            }
            if ((ix = pinfo.lastIndexOf(58)) >= 0) {
                this.proxy = pinfo.substring(0, ix);
                try {
                    pinfo = pinfo.substring(ix + 1);
                    ix = pinfo.indexOf("/");
                    if (ix >= 0) {
                        pinfo = pinfo.substring(0, ix);
                    }
                    this.port = Integer.parseInt(pinfo.trim());
                }
                catch (Exception e) {
                    args2 = new Object[]{this.proxy, Integer.toString(80)};
                    Trace.msgNetPrintln("net.proxy.browser.missingPort", args2);
                    this.port = 80;
                }
            } else if (!pinfo.equals("")) {
                this.proxy = pinfo;
                args = new Object[]{this.proxy, Integer.toString(80)};
                Trace.msgNetPrintln("net.proxy.browser.missingPort", args);
                this.port = 80;
            }
        }
        if (spinfo != null) {
            ix = spinfo.lastIndexOf(58);
            if (ix >= 0) {
                this.socksProxy = spinfo.substring(0, ix);
                try {
                    this.socksPort = Integer.parseInt(spinfo.substring(ix + 1).trim());
                }
                catch (Exception e) {
                    args2 = new Object[]{this.socksProxy, Integer.toString(80)};
                    Trace.msgNetPrintln("net.proxy.browser.missingPort", args2);
                    this.socksPort = 1080;
                }
            } else if (!spinfo.equals("")) {
                this.socksProxy = spinfo;
                args = new Object[]{this.socksProxy, Integer.toString(80)};
                Trace.msgNetPrintln("net.proxy.browser.missingPort", args);
                this.socksPort = 1080;
            }
        }
    }

    public ProxyInfo(String proxy, int port) {
        this(proxy, port, null, -1);
    }

    public ProxyInfo(String proxy, int port, String socksProxy, int socksPort) {
        this.proxy = proxy;
        this.port = port;
        this.socksProxy = socksProxy;
        this.socksPort = socksPort;
    }

    public String getProxy() {
        return this.proxy;
    }

    public int getPort() {
        return this.port;
    }

    public String getSocksProxy() {
        return this.socksProxy;
    }

    public int getSocksPort() {
        return this.socksPort;
    }

    public boolean isProxyUsed() {
        return this.proxy != null || this.socksProxy != null;
    }

    public boolean isSocksUsed() {
        return this.socksProxy != null;
    }

    public String toString() {
        if (this.proxy != null) {
            return this.proxy + ":" + this.port;
        }
        if (this.socksProxy != null) {
            return this.socksProxy + ":" + this.socksPort;
        }
        return "DIRECT";
    }
}

