/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.net.proxy.BrowserProxyInfo;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

public final class ProxyUtils {
    private static void parseProxyAddress(int protocolType, String adString, BrowserProxyInfo info) {
        int DEFAULT_HTTP_PORT = 80;
        int DEFAULT_SOCKS_PORT = 1080;
        String addressString = null;
        try {
            URL u = new URL(adString);
            addressString = new String(u.getHost() + ":" + u.getPort());
        }
        catch (MalformedURLException mue) {
            addressString = new String(adString);
        }
        StringTokenizer st = new StringTokenizer(addressString, ":");
        if (!st.hasMoreTokens()) {
            return;
        }
        String host = st.nextToken();
        int port = -1;
        if (st.hasMoreTokens()) {
            try {
                port = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        switch (protocolType) {
            case 1: {
                info.setHttpHost(host);
                if (port == -1) {
                    port = 80;
                }
                info.setHttpPort(port);
                break;
            }
            case 2: {
                info.setHttpsHost(host);
                if (port == -1) {
                    port = 80;
                }
                info.setHttpsPort(port);
                break;
            }
            case 4: {
                info.setFtpHost(host);
                if (port == -1) {
                    port = 80;
                }
                info.setFtpPort(port);
                break;
            }
            case 8: {
                info.setGopherHost(host);
                if (port == -1) {
                    port = 80;
                }
                info.setGopherPort(port);
                break;
            }
            case 16: {
                info.setSocksHost(host);
                if (port == -1) {
                    port = 1080;
                }
                info.setSocksPort(port);
                break;
            }
            default: {
                throw new IllegalStateException("ProxyUtils: ProtocolType not valid");
            }
        }
    }

    public static void parseProxyServer(String server, BrowserProxyInfo info) {
        if (server.indexOf("=") != -1) {
            StringTokenizer st = new StringTokenizer(server, ";");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (s.startsWith("http=")) {
                    ProxyUtils.parseProxyAddress(1, s.substring(5, s.length()), info);
                    continue;
                }
                if (s.startsWith("https=")) {
                    ProxyUtils.parseProxyAddress(2, s.substring(6, s.length()), info);
                    continue;
                }
                if (s.startsWith("ftp=")) {
                    ProxyUtils.parseProxyAddress(4, s.substring(4, s.length()), info);
                    continue;
                }
                if (s.startsWith("gopher=")) {
                    ProxyUtils.parseProxyAddress(8, s.substring(7, s.length()), info);
                    continue;
                }
                if (!s.startsWith("socks=")) continue;
                ProxyUtils.parseProxyAddress(16, s.substring(6, s.length()), info);
            }
        } else {
            ProxyUtils.parseProxyAddress(1, server, info);
            ProxyUtils.parseProxyAddress(2, server, info);
            ProxyUtils.parseProxyAddress(4, server, info);
            ProxyUtils.parseProxyAddress(8, server, info);
        }
    }
}

