/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.config.Platform;
import com.sun.deploy.net.proxy.BrowserProxyConfig;
import com.sun.deploy.net.proxy.BrowserProxyInfo;
import com.sun.deploy.net.proxy.ProxyUtils;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.WinRegistry;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;

public final class WIExplorerProxyConfig
implements BrowserProxyConfig {
    private static final String REGSTR_PATH_INTERNET_SETTINGS = "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings";
    private static final String REGSTR_PATH_AUTOPROXY_DETECT = "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\Connections";
    private static final String REGSTR_VAL_PROXYENABLE = "ProxyEnable";
    private static final String REGSTR_VAL_PROXYSERVER = "ProxyServer";
    private static final String REGSTR_VAL_PROXYOVERRIDE = "ProxyOverride";
    private static final String REGSTR_VAL_AUTOCONFIGURL = "AutoConfigURL";
    private static final String DEFAULT_CONNECTION_SETTINGS = "DefaultConnectionSettings";

    static native String performAutoDetection();

    @Override
    public BrowserProxyInfo getBrowserProxyInfo() {
        Trace.msgNetPrintln("net.proxy.loading.ie");
        BrowserProxyInfo info = new BrowserProxyInfo();
        info.setType(0);
        ProxyInfo proxyInfo = this.getBrowserProxySettings();
        if (proxyInfo != null) {
            int type = proxyInfo.getProxyType();
            if ((type & 2) != 0) {
                info.setType(1);
                if (proxyInfo.getProxy() != null) {
                    String proxy = proxyInfo.getProxy().replace(' ', ';');
                    ProxyUtils.parseProxyServer(proxy, info);
                }
                if (proxyInfo.getProxyBypass() != null) {
                    StringTokenizer st = new StringTokenizer(proxyInfo.getProxyBypass(), " ;");
                    ArrayList<String> list = new ArrayList<String>();
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken().toLowerCase(Locale.ENGLISH).trim();
                        if (token == null || token.length() <= 0) continue;
                        list.add(token);
                    }
                    info.setOverrides(list);
                }
            } else {
                info.setType(0);
            }
        }
        if (this.isAutoDetectEnabled()) {
            info.setAutoProxyDetectionEnabled(true);
            info.setAutoConfigURL(WIExplorerProxyConfig.performAutoDetection());
        }
        if (info.getAutoConfigURL() == null) {
            info.setAutoConfigURL(this.getAutoConfigURL());
        }
        if (info.getAutoConfigURL() != null) {
            Trace.msgNetPrintln("net.proxy.browser.autoConfigURL", new Object[]{info.getAutoConfigURL()});
            info.setType(2);
        }
        Trace.msgNetPrintln("net.proxy.loading.done");
        return info;
    }

    public String getAutoConfigURL() {
        String scriptLocation = null;
        scriptLocation = WinRegistry.getString(-2147483647, REGSTR_PATH_INTERNET_SETTINGS, REGSTR_VAL_AUTOCONFIGURL);
        return scriptLocation;
    }

    public boolean isAutoDetectEnabled() {
        boolean autoDetection = false;
        byte[] data = (byte[])WinRegistry.get(-2147483647, REGSTR_PATH_AUTOPROXY_DETECT, DEFAULT_CONNECTION_SETTINGS);
        if (data != null && (data[8] & 8) != 0) {
            autoDetection = true;
        }
        return autoDetection;
    }

    @Override
    public void getSystemProxy(BrowserProxyInfo bpi) {
    }

    private native ProxyInfo getBrowserProxySettings();

    static {
        Platform.get().loadDeployNativeLib();
    }

    static class ProxyInfo {
        private int proxyType;
        private String proxy;
        private String proxyBypass;

        public ProxyInfo(int proxyType, String proxy, String proxyBypass) {
            this.proxyType = proxyType;
            this.proxy = proxy;
            this.proxyBypass = proxyBypass;
        }

        public int getProxyType() {
            return this.proxyType;
        }

        public String getProxy() {
            return this.proxy;
        }

        public String getProxyBypass() {
            return this.proxyBypass;
        }
    }
}

