/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.socket;

import com.sun.deploy.config.Platform;
import com.sun.deploy.net.socket.UnixDomainSocketException;
import com.sun.deploy.net.socket.UnixSocketImpl;
import com.sun.deploy.util.ByteBufferWrapper;
import com.sun.deploy.util.SafeThreadFactory;
import java.io.File;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.List;

public class UnixDomainSocket {
    public static final String pipeFileNamePrefix = "jpi-";
    public static final int STATUS_CLOSE = 0;
    public static final int STATUS_OPEN = 1;
    public static final int STATUS_CONNECT = 2;
    public static final int STATUS_BIND = 3;
    public static final int STATUS_LISTEN = 4;
    public static final int STATUS_ACCEPT = 5;
    private volatile int socketStatus;
    private volatile long socketHandle;
    private volatile boolean unlinkFile;
    private String fileName;
    private boolean abstractNamespace;
    private int protocol;
    private int backlog;
    private static ShutdownHookUnlinkFiles shutdownHookUnlinkFiles;

    public static boolean isSupported() {
        return UnixSocketImpl.unStreamSocketSupported();
    }

    public static UnixDomainSocket CreateClientConnect(String fileName, boolean abstractNamespace, int protocol) throws UnixDomainSocketException, UnsupportedOperationException {
        UnixDomainSocket uds = new UnixDomainSocket(fileName, abstractNamespace, protocol);
        uds.connect();
        return uds;
    }

    public static UnixDomainSocket CreateServerBindListen(String fileName, boolean abstractNamespace, int protocol, int backlog) throws UnixDomainSocketException, UnsupportedOperationException {
        UnixDomainSocket uds = new UnixDomainSocket(fileName, abstractNamespace, protocol);
        uds.bind();
        uds.listen(backlog);
        return uds;
    }

    public static UnixDomainSocket CreateServerBindListen(int protocol, int backlog) throws UnixDomainSocketException, UnsupportedOperationException {
        UnixDomainSocket uds = new UnixDomainSocket(protocol);
        uds.bind();
        uds.listen(backlog);
        return uds;
    }

    public UnixDomainSocket(String fileName, boolean abstractNamespace, int protocol) throws UnixDomainSocketException, UnsupportedOperationException {
        this.setup(fileName, false, protocol);
    }

    public UnixDomainSocket(int protocol) throws UnixDomainSocketException, UnsupportedOperationException {
        File pipeFile;
        long threadId = Platform.get().getNativePID();
        String pipeFileName = null;
        try {
            pipeFile = File.createTempFile(pipeFileNamePrefix + String.valueOf(threadId), "");
            pipeFileName = pipeFile.getAbsolutePath();
            if (pipeFile.exists()) {
                pipeFile.delete();
            } else {
                pipeFileName = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            pipeFileName = null;
        }
        if (pipeFileName == null) {
            try {
                pipeFileName = new String("/tmp/jpi-" + String.valueOf(threadId));
                pipeFile = new File(pipeFileName);
                if (pipeFile.exists()) {
                    pipeFile.delete();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                pipeFileName = null;
            }
        }
        if (pipeFileName == null) {
            throw new RuntimeException("could not create a temp pipe filename");
        }
        this.setup(pipeFileName, false, protocol);
    }

    public synchronized void open() throws UnixDomainSocketException, UnsupportedOperationException {
        this.validateSocketStatusTransition(1);
        this.socketHandle = UnixSocketImpl.unStreamSocketCreate(this.fileName, this.abstractNamespace, this.protocol);
        this.socketStatus = 1;
    }

    public void close() {
        this.socketStatus = 0;
        if (0L != this.socketHandle) {
            long _socketHandle = this.socketHandle;
            this.socketHandle = 0L;
            try {
                UnixSocketImpl.unStreamSocketClose(_socketHandle);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.unlinkFile) {
            try {
                File pipeFile = new File(this.fileName);
                if (null != pipeFile) {
                    pipeFile.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.backlog = 0;
    }

    public void deleteFileOnClose() {
        if (!this.unlinkFile && !this.abstractNamespace) {
            this.unlinkFile = true;
            shutdownHookUnlinkFiles.add(this.fileName);
        }
    }

    public synchronized void bind() throws UnixDomainSocketException, UnsupportedOperationException {
        this.validateSocketStatusTransition(3);
        UnixSocketImpl.unStreamSocketBind(this.socketHandle);
        this.socketStatus = 3;
        this.deleteFileOnClose();
    }

    public synchronized void listen(int backlog) throws UnixDomainSocketException, UnsupportedOperationException {
        this.validateSocketStatusTransition(4);
        UnixSocketImpl.unStreamSocketListen(this.socketHandle, backlog);
        this.backlog = backlog;
        this.socketStatus = 4;
    }

    public UnixDomainSocket accept() throws UnixDomainSocketException, UnsupportedOperationException {
        this.validateSocketStatusTransition(5);
        long clientSocketHandle = UnixSocketImpl.unStreamSocketAccept(this.socketHandle);
        this.socketStatus = 5;
        return new UnixDomainSocket(this, clientSocketHandle, 2);
    }

    public void connect() throws UnixDomainSocketException, UnsupportedOperationException {
        this.validateSocketStatusTransition(2);
        UnixSocketImpl.unStreamSocketConnect(this.socketHandle);
        this.socketStatus = 2;
    }

    public int read(ByteBufferWrapper buffer) throws UnixDomainSocketException, BufferOverflowException, UnsupportedOperationException {
        return this.read(buffer, buffer.remaining());
    }

    public int read(ByteBufferWrapper buffer, int count) throws UnixDomainSocketException, BufferOverflowException, UnsupportedOperationException {
        int n;
        this.validateSocketStatusForReadWrite();
        if (null == buffer) {
            throw new IllegalArgumentException("Argument buffer is null");
        }
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("Argument buffer is not direct");
        }
        int limit = buffer.limit();
        int pos = buffer.position();
        if (pos >= limit) {
            throw new BufferOverflowException();
        }
        if (pos + count > limit) {
            count = limit - pos;
        }
        if ((n = UnixSocketImpl.unStreamSocketRead(this.socketHandle, buffer.getBuffer(), pos, count)) > 0) {
            buffer.position(pos + n);
        }
        return n;
    }

    public int write(ByteBufferWrapper buffer) throws UnixDomainSocketException, BufferUnderflowException, UnsupportedOperationException {
        return this.write(buffer, buffer.remaining());
    }

    public int write(ByteBufferWrapper buffer, int count) throws UnixDomainSocketException, BufferUnderflowException, UnsupportedOperationException {
        int n;
        this.validateSocketStatusForReadWrite();
        if (null == buffer) {
            throw new IllegalArgumentException("Argument buffer is null");
        }
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("Argument buffer is not direct");
        }
        int limit = buffer.limit();
        int pos = buffer.position();
        if (pos >= limit) {
            throw new BufferUnderflowException();
        }
        if (pos + count > limit) {
            count = limit - pos;
        }
        if ((n = UnixSocketImpl.unStreamSocketWrite(this.socketHandle, buffer.getBuffer(), pos, count)) > 0) {
            buffer.position(pos + n);
        }
        return n;
    }

    public synchronized boolean isOpenAndValid() throws UnsupportedOperationException {
        boolean res = false;
        if (0L != this.socketHandle && this.socketStatus != 0) {
            try {
                res = UnixSocketImpl.unStreamSocketIsValid(this.socketHandle);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!res) {
            this.socketStatus = 0;
        }
        return res;
    }

    public boolean isOpen() {
        return this.socketStatus != 0;
    }

    public boolean isConnected() {
        return this.socketStatus != 2;
    }

    public String getFilename() {
        return this.fileName;
    }

    public boolean getIsAbstractNamespace() {
        return this.abstractNamespace;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public int getStatus() {
        return this.socketStatus;
    }

    public String getStatusAsString() {
        switch (this.socketStatus) {
            case 0: {
                return "close";
            }
            case 1: {
                return "open";
            }
            case 2: {
                return "connect";
            }
            case 3: {
                return "bind";
            }
            case 4: {
                return "listen";
            }
            case 5: {
                return "accept";
            }
        }
        return "invalid";
    }

    public boolean isServer() {
        switch (this.socketStatus) {
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public String getNativeInfo() {
        String res = "n.a.";
        if (0L != this.socketHandle) {
            try {
                res = UnixSocketImpl.unStreamSocketGetNativeInfo(this.socketHandle);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return res;
    }

    public String toString() {
        return "UnixDomainSocket[" + this.getStatusAsString() + ", pipe: " + this.getFilename() + ", ans: " + this.getIsAbstractNamespace() + ", proto: " + this.getProtocol() + ", backlog: " + this.getBacklog() + ", info: " + this.getNativeInfo() + "]";
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private void setup(String fileName, boolean abstractNamespace, int protocol) throws UnixDomainSocketException, UnsupportedOperationException {
        if (null == fileName) {
            throw new IllegalArgumentException("Argument fileName is null");
        }
        this.socketHandle = 0L;
        this.fileName = fileName;
        this.abstractNamespace = abstractNamespace;
        this.protocol = protocol;
        this.backlog = 0;
        this.socketStatus = 0;
        this.open();
    }

    private UnixDomainSocket(UnixDomainSocket serverSocket, long clientSocketHandle, int status) {
        this.socketHandle = clientSocketHandle;
        this.fileName = serverSocket.fileName;
        this.abstractNamespace = serverSocket.abstractNamespace;
        this.protocol = serverSocket.protocol;
        this.backlog = 0;
        this.socketStatus = status;
    }

    private void validateSocketStatusTransition(int newStatus) throws UnixDomainSocketException {
        if (0L == this.socketHandle && 0 != this.socketStatus) {
            throw new UnixDomainSocketException(this.toString(), 22);
        }
        switch (newStatus) {
            case 1: {
                if (this.socketStatus != 0) break;
                return;
            }
            case 2: 
            case 3: {
                if (this.socketStatus != 1) break;
                return;
            }
            case 4: {
                if (this.socketStatus != 3) break;
                return;
            }
            case 5: {
                if (this.socketStatus != 4 && this.socketStatus != 5) break;
                return;
            }
        }
        throw new UnixDomainSocketException(this.toString(), 22);
    }

    private void validateSocketStatusForReadWrite() throws UnixDomainSocketException {
        if (0L != this.socketHandle && 2 == this.socketStatus) {
            return;
        }
        throw new UnixDomainSocketException(this.toString(), 22);
    }

    static {
        Platform.get();
        shutdownHookUnlinkFiles = new ShutdownHookUnlinkFiles();
        Runtime.getRuntime().addShutdownHook(SafeThreadFactory.createThread(shutdownHookUnlinkFiles));
    }

    private static class ShutdownHookUnlinkFiles
    implements Runnable {
        private List<File> files = new ArrayList<File>();

        public synchronized void add(String filename) {
            try {
                File file = new File(filename);
                this.files.add(file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            for (File file : this.files) {
                try {
                    if (null == file) continue;
                    file.delete();
                }
                catch (Exception exception) {}
            }
        }
    }
}

