/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.Base64Wrapper;
import java.io.ByteArrayInputStream;
import java.security.cert.CertPath;
import java.security.cert.CertificateFactory;
import java.util.Date;

public class CachedCertificatesHelper {
    private static final boolean DEBUG = Config.getDebug();
    private final CertPath path;
    private final Date tm;
    private final boolean signedJNLP;

    public CachedCertificatesHelper(Date tm, CertPath path) {
        this(tm, path, false);
    }

    public CachedCertificatesHelper(Date tm, CertPath path, boolean signedJnlp) {
        this.tm = tm != null ? new Date(tm.getTime()) : null;
        this.path = path;
        this.signedJNLP = signedJnlp;
    }

    public static CachedCertificatesHelper create(Date tm, String base64, boolean signedJNLP) {
        block4: {
            if (base64 == null) {
                return null;
            }
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                byte[] bytes = Base64Wrapper.decodeFromString(base64);
                CertPath path = cf.generateCertPath(new ByteArrayInputStream(bytes));
                if (path != null) {
                    return new CachedCertificatesHelper(tm, path, signedJNLP);
                }
            }
            catch (Exception e) {
                String error = ResourceManager.getString("launch.error.embedded.cert", e.getLocalizedMessage());
                if (!DEBUG) break block4;
                Trace.println(error, TraceLevel.SECURITY);
            }
        }
        return null;
    }

    public boolean isSignedJNLP() {
        return this.signedJNLP;
    }

    public CertPath getCertPath() {
        return this.path;
    }

    public String exportCertificatesToBase64() {
        if (this.path != null) {
            try {
                return Base64Wrapper.encodeToString(this.path.getEncoded());
            }
            catch (Exception e) {
                Trace.println("Failed to export certificats in BASE64 form", TraceLevel.SECURITY);
            }
        }
        return null;
    }

    public Date getTimestamp() {
        if (this.tm != null) {
            return new Date(this.tm.getTime());
        }
        return null;
    }
}

