/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.Enumeration;
import sun.security.provider.PolicyFile;

public final class CeilingPolicy {
    private static PermissionCollection _trustedPerms = null;
    private static boolean _initialized = false;

    public static synchronized void addTrustedPermissions(PermissionCollection perms) {
        if (!_initialized) {
            _initialized = true;
            String url = Config.getStringProperty("deployment.security.trusted.policy");
            if (url != null && url.length() > 0) {
                CodeSource cs = new CodeSource((URL)null, (Certificate[])null);
                int numPolicy = 1;
                while (Security.getProperty("policy.url." + numPolicy) != null) {
                    ++numPolicy;
                }
                String key = "policy.url." + numPolicy;
                Security.setProperty(key, url);
                try {
                    PolicyFile policy = new PolicyFile();
                    _trustedPerms = ((Policy)policy).getPermissions(cs);
                }
                catch (Exception e) {
                    Trace.ignoredException(e);
                }
                Security.setProperty(key, "");
            } else {
                _trustedPerms = new Permissions();
                _trustedPerms.add(new AllPermission());
            }
        }
        if (_trustedPerms != null) {
            Enumeration<Permission> e = _trustedPerms.elements();
            while (e.hasMoreElements()) {
                perms.add(e.nextElement());
            }
        }
    }
}

