/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.X509Util;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.x509.AccessDescription;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.NetscapeCertTypeExtension;
import sun.security.x509.X509CertImpl;

public class CertUtils {
    private static final String OID_BASIC_CONSTRAINTS = "2.5.29.19";
    private static final String OID_KEY_USAGE = "2.5.29.15";
    private static final String OID_EXTENDED_KEY_USAGE = "2.5.29.37";
    private static final String OID_NETSCAPE_CERT_TYPE = "2.16.840.1.113730.1.1";
    private static final String OID_EKU_ANY_USAGE = "2.5.29.37.0";
    private static final String OID_EKU_CODE_SIGNING = "1.3.6.1.5.5.7.3.3";
    private static final String OID_EKU_SERVER_AUTH = "1.3.6.1.5.5.7.3.1";
    private static final String OID_EKU_CLIENT_AUTH = "1.3.6.1.5.5.7.3.2";
    private static final String OID_EKU_TIME_STAMPING = "1.3.6.1.5.5.7.3.8";
    private static final String OID_CRL = "2.5.29.31";
    private static final String OID_AIA = "1.3.6.1.5.5.7.1.1";
    private static final String NSCT_OBJECT_SIGNING_CA = "object_signing_ca";
    private static final String NSCT_OBJECT_SIGNING = "object_signing";
    private static final String NSCT_SSL_CA = "ssl_ca";
    private static final String NSCT_S_MIME_CA = "s_mime_ca";
    private static final String NSCT_S_MIME = "s_mime";
    private static final String NSCT_SSL_CLIENT = "ssl_client";
    private static final String NSCT_SSL_SERVER = "ssl_server";
    private static final int KU_SIGNATURE = 0;
    static final String TSFLAG = "$tsflag";
    static final String LOCFLAG = "$loc=";

    public static KeyStore createEmptyKeyStore() {
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance("JKS");
            ks.load(null, null);
        }
        catch (Exception e) {
            Trace.ignoredException(e);
        }
        return ks;
    }

    public static void checkUsageForCodeSigning(X509Certificate currentCert, int index) throws CertificateException, IOException {
        CertUtils.checkUsageForCodeSigning(currentCert, index, false);
    }

    public static void checkUsageForCodeSigning(X509Certificate currentCert, int index, boolean checkTimeStamping) throws CertificateException, IOException {
        String msg = null;
        Set<String> critSet = currentCert.getCriticalExtensionOIDs();
        if (critSet == null) {
            critSet = Collections.emptySet();
        }
        if (!CertUtils.checkBasicConstraintsForCodeSigning(currentCert, critSet, index)) {
            Trace.msgSecurityPrintln("trustdecider.check.basicconstraints");
            msg = ResourceManager.getString("trustdecider.check.basicconstraints");
            throw new CertificateException(msg);
        }
        if (index == 0) {
            if (!CertUtils.checkLeafKeyUsageForCodeSigning(currentCert, critSet, checkTimeStamping)) {
                Trace.msgSecurityPrintln("trustdecider.check.leafkeyusage");
                msg = ResourceManager.getString("trustdecider.check.leafkeyusage");
                throw new CertificateException(msg);
            }
        } else if (!CertUtils.checkSignerKeyUsage(currentCert, critSet)) {
            Trace.msgSecurityPrintln("trustdecider.check.signerkeyusage");
            msg = ResourceManager.getString("trustdecider.check.signerkeyusage");
            throw new CertificateException(msg);
        }
        if (!critSet.isEmpty()) {
            Trace.msgSecurityPrintln("trustdecider.check.extensions");
            msg = ResourceManager.getString("trustdecider.check.extensions");
            throw new CertificateException(msg);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkBasicConstraintsForCodeSigning(X509Certificate cert, Set<String> critSet, int index) throws CertificateException, IOException {
        critSet.remove(OID_BASIC_CONSTRAINTS);
        critSet.remove(OID_NETSCAPE_CERT_TYPE);
        if (index == 0) {
            return true;
        }
        if (cert.getExtensionValue(OID_BASIC_CONSTRAINTS) == null) {
            if (cert.getExtensionValue(OID_NETSCAPE_CERT_TYPE) != null) {
                if (CertUtils.getNetscapeCertTypeBit(cert, NSCT_OBJECT_SIGNING_CA)) return true;
                Trace.msgSecurityPrintln("trustdecider.check.basicconstraints.certtypebit");
                return false;
            }
            Trace.msgSecurityPrintln("trustdecider.check.basicconstraints.extensionvalue");
            return false;
        }
        if (cert.getExtensionValue(OID_NETSCAPE_CERT_TYPE) != null && (CertUtils.getNetscapeCertTypeBit(cert, NSCT_SSL_CA) || CertUtils.getNetscapeCertTypeBit(cert, NSCT_S_MIME_CA) || CertUtils.getNetscapeCertTypeBit(cert, NSCT_OBJECT_SIGNING_CA)) && !CertUtils.getNetscapeCertTypeBit(cert, NSCT_OBJECT_SIGNING_CA)) {
            Trace.msgSecurityPrintln("trustdecider.check.basicconstraints.bitvalue");
            return false;
        }
        int constraints = cert.getBasicConstraints();
        if (constraints < 0) {
            Trace.msgSecurityPrintln("trustdecider.check.basicconstraints.enduser");
            return false;
        }
        if (index - 1 <= constraints) return true;
        Trace.msgSecurityPrintln("trustdecider.check.basicconstraints.pathlength");
        return false;
    }

    private static boolean checkLeafKeyUsageForCodeSigning(X509Certificate cert, Set<String> critSet, boolean checkTimeStamping) throws CertificateException, IOException {
        critSet.remove(OID_KEY_USAGE);
        boolean[] keyUsageInfo = cert.getKeyUsage();
        if (keyUsageInfo != null) {
            if (keyUsageInfo.length == 0) {
                Trace.msgSecurityPrintln("trustdecider.check.leafkeyusage.length");
                return false;
            }
            boolean digitalSignature = keyUsageInfo[0];
            if (!digitalSignature) {
                Trace.msgSecurityPrintln("trustdecider.check.leafkeyusage.digitalsignature");
                return false;
            }
        }
        List<String> extKeyUsageInfo = X509Util.getExtendedKeyUsage(cert);
        Set<String> nonCritSet = cert.getNonCriticalExtensionOIDs();
        if (extKeyUsageInfo != null && (critSet.contains(OID_EXTENDED_KEY_USAGE) || nonCritSet.contains(OID_EXTENDED_KEY_USAGE))) {
            critSet.remove(OID_EXTENDED_KEY_USAGE);
            if (checkTimeStamping) {
                if (!extKeyUsageInfo.contains(OID_EKU_ANY_USAGE) && !extKeyUsageInfo.contains(OID_EKU_TIME_STAMPING)) {
                    Trace.msgSecurityPrintln("trustdecider.check.leafkeyusage.tsaextkeyusageinfo");
                    return false;
                }
            } else if (!extKeyUsageInfo.contains(OID_EKU_ANY_USAGE) && !extKeyUsageInfo.contains(OID_EKU_CODE_SIGNING)) {
                Trace.msgSecurityPrintln("trustdecider.check.leafkeyusage.extkeyusageinfo");
                return false;
            }
        }
        if (cert.getExtensionValue(OID_NETSCAPE_CERT_TYPE) != null && !CertUtils.getNetscapeCertTypeBit(cert, NSCT_OBJECT_SIGNING)) {
            Trace.msgSecurityPrintln("trustdecider.check.leafkeyusage.certtypebit");
            return false;
        }
        return true;
    }

    private static boolean checkSignerKeyUsage(X509Certificate cert, Set<String> critSet) throws CertificateException, IOException {
        critSet.remove(OID_KEY_USAGE);
        boolean[] keyUsageInfo = cert.getKeyUsage();
        if (!(keyUsageInfo == null || keyUsageInfo.length >= 6 && keyUsageInfo[5])) {
            Trace.msgSecurityPrintln("trustdecider.check.signerkeyusage.lengthandbit");
            return false;
        }
        List<String> extKeyUsageInfo = X509Util.getExtendedKeyUsage(cert);
        Set<String> nonCritSet = cert.getNonCriticalExtensionOIDs();
        if (extKeyUsageInfo != null && (critSet.contains(OID_EXTENDED_KEY_USAGE) || nonCritSet.contains(OID_EXTENDED_KEY_USAGE))) {
            critSet.remove(OID_EXTENDED_KEY_USAGE);
            if (!extKeyUsageInfo.contains(OID_EKU_ANY_USAGE) && !extKeyUsageInfo.contains(OID_EKU_CODE_SIGNING)) {
                Trace.msgSecurityPrintln("trustdecider.check.signerkeyusage.keyusage");
                return false;
            }
        }
        return true;
    }

    static boolean getNetscapeCertTypeBit(X509Certificate cert, String type) throws CertificateException, IOException {
        byte[] extVal = cert.getExtensionValue(OID_NETSCAPE_CERT_TYPE);
        if (extVal == null) {
            return false;
        }
        DerInputStream in = new DerInputStream(extVal);
        byte[] encoded = in.getOctetString();
        encoded = new DerValue(encoded).getUnalignedBitString().toByteArray();
        NetscapeCertTypeExtension extn = new NetscapeCertTypeExtension(encoded);
        Boolean val = Config.isJavaVersionAtLeast18() ? extn.get(type) : CertUtils.callPre18NetscapeCertTypeExtensionGet(extn, type);
        return val;
    }

    private static boolean checkKeyUsage(X509Certificate cert, int bit) {
        boolean[] keyUsage = cert.getKeyUsage();
        if (keyUsage == null) {
            return true;
        }
        return keyUsage.length > bit && keyUsage[bit];
    }

    private static boolean checkEKU(X509Certificate cert, String expectedEKU) throws CertificateException {
        List<String> eku = cert.getExtendedKeyUsage();
        if (eku == null) {
            return true;
        }
        return eku.contains(expectedEKU) || eku.contains(OID_EKU_ANY_USAGE);
    }

    static boolean checkTLSClient(X509Certificate cert) throws CertificateException {
        if (!CertUtils.checkKeyUsage(cert, 0)) {
            Trace.msgSecurityPrintln("clientauth.checkTLSClient.checkKeyUsage");
            return false;
        }
        if (!CertUtils.checkEKU(cert, OID_EKU_CLIENT_AUTH)) {
            Trace.msgSecurityPrintln("clientauth.checkTLSClient.checkEKU");
            return false;
        }
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException e1) {
            return false;
        }
        catch (CertificateNotYetValidException e2) {
            return false;
        }
        return true;
    }

    public static boolean isIssuerOf(X509Certificate cert1, X509Certificate cert2) {
        Principal subject;
        Principal issuer = cert1.getIssuerDN();
        return issuer.equals(subject = cert2.getSubjectDN());
    }

    private static String extractFromQuote(String s, String prefix) {
        if (s == null) {
            return null;
        }
        int x = s.indexOf(prefix);
        int y = 0;
        if (x >= 0) {
            if ((y = s.charAt(x += prefix.length()) == '\"' ? s.indexOf(34, ++x) : s.indexOf(44, x)) < 0) {
                return s.substring(x);
            }
            return s.substring(x, y);
        }
        return null;
    }

    public static String extractSubjectAliasName(X509Certificate cert) {
        String subjectName = ResourceManager.getString("config.unknownSubject");
        try {
            Principal principal = cert.getSubjectDN();
            String subjectDNName = principal.getName();
            subjectName = CertUtils.extractFromQuote(subjectDNName, "CN=");
            if (subjectName == null) {
                String subOName = CertUtils.extractFromQuote(subjectDNName, "O=");
                String subOUName = CertUtils.extractFromQuote(subjectDNName, "OU=");
                if (subOName != null || subOUName != null) {
                    subjectName = ResourceManager.getString("config.certShowOOU", subOName == null ? "" : subOName, subOUName == null ? "" : subOUName);
                }
            }
            if (subjectName == null) {
                subjectName = ResourceManager.getString("config.unknownSubject");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return subjectName;
    }

    public static String extractIssuerAliasName(X509Certificate cert) {
        String issuerName = ResourceManager.getString("config.unknownIssuer");
        try {
            Principal principalIssuer = cert.getIssuerDN();
            String issuerDNName = principalIssuer.getName();
            issuerName = CertUtils.extractFromQuote(issuerDNName, "CN=");
            if (issuerName == null) {
                String issOName = CertUtils.extractFromQuote(issuerDNName, "O=");
                String issOUName = CertUtils.extractFromQuote(issuerDNName, "OU=");
                if (issOName != null || issOUName != null) {
                    issuerName = ResourceManager.getString("config.certShowOOU", issOName == null ? "" : issOName, issOUName == null ? "" : issOUName);
                }
            }
            if (issuerName == null) {
                issuerName = ResourceManager.getString("config.unknownIssuer");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return issuerName;
    }

    static long getFileLastModified(final String filename) {
        long lastModified = 0L;
        try {
            lastModified = AccessController.doPrivileged(new PrivilegedExceptionAction<Long>(){

                @Override
                public Long run() throws SecurityException {
                    return new File(filename).lastModified();
                }
            });
        }
        catch (PrivilegedActionException e) {
            Trace.securityPrintException(e);
        }
        return lastModified;
    }

    static boolean hasAIAExtensionWithOCSPAccessMethod(X509Certificate cert) throws IOException {
        AuthorityInfoAccessExtension aia = null;
        if (cert instanceof X509CertImpl) {
            aia = ((X509CertImpl)cert).getAuthorityInfoAccessExtension();
        } else {
            byte[] aiaValue = cert.getExtensionValue(OID_AIA);
            if (aiaValue == null) {
                Trace.msgSecurityPrintln("trustdecider.check.validation.ocsp.notfound");
                return false;
            }
            if (aiaValue[0] == 4) {
                aiaValue = new DerValue(aiaValue).getOctetString();
            }
            Trace.msgSecurityPrintln(CertUtils.extractSubjectAliasName(cert));
            aia = new AuthorityInfoAccessExtension(false, aiaValue);
        }
        if (aia != null) {
            Trace.msgSecurityPrintln(aia.toString());
            List<AccessDescription> descriptions = aia.getAccessDescriptions();
            for (AccessDescription description : descriptions) {
                if (!description.getAccessMethod().equals(AccessDescription.Ad_OCSP_Id)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean checkWildcardDomainList(String hostname, ArrayList<String> subjectNameList) {
        for (int i = 0; i < subjectNameList.size(); ++i) {
            String subjectName = subjectNameList.get(i);
            if (!CertUtils.checkWildcardDomain(hostname, subjectName)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkWildcardDomain(String hostname, String subjectName) {
        if (hostname == null || hostname.length() == 0 || subjectName == null || subjectName.length() == 0) {
            return false;
        }
        if ((subjectName = subjectName.trim()).equalsIgnoreCase(hostname = hostname.trim())) {
            return true;
        }
        int starIdx = subjectName.indexOf("*.");
        if (starIdx == -1) {
            return false;
        }
        String rightSubjectName = subjectName.substring(starIdx + 1);
        String leftSubjectName = subjectName.substring(0, starIdx);
        String rightHostName = hostname.length() >= rightSubjectName.length() ? hostname.substring(hostname.length() - rightSubjectName.length()) : "";
        String leftHostName = hostname.length() >= leftSubjectName.length() ? hostname.substring(0, leftSubjectName.length()) : "";
        return !leftSubjectName.contains(".") && leftHostName.equalsIgnoreCase(leftSubjectName) && rightHostName.equalsIgnoreCase(rightSubjectName) && hostname.length() >= subjectName.length();
    }

    public static ArrayList<String> getServername(X509Certificate peerCert) {
        ArrayList<String> servernameList = new ArrayList<String>();
        try {
            Collection<List<?>> subjAltNames = peerCert.getSubjectAlternativeNames();
            if (subjAltNames != null) {
                for (List<?> next : subjAltNames) {
                    if ((Integer)next.get(0) != 2) continue;
                    String dnsName = (String)next.get(1);
                    servernameList.add(dnsName);
                }
                if (servernameList.size() > 0) {
                    return servernameList;
                }
            }
        }
        catch (NoSuchMethodError subjAltNames) {
        }
        catch (CertificateException subjAltNames) {
            // empty catch block
        }
        String certHostname = CertUtils.extractSubjectAliasName(peerCert);
        servernameList.add(certHostname);
        return servernameList;
    }

    private static Boolean callPre18NetscapeCertTypeExtensionGet(final NetscapeCertTypeExtension extn, final String type) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    Method m = NetscapeCertTypeExtension.class.getDeclaredMethod("get", String.class);
                    Object o = m.invoke((Object)extn, type);
                    if (o instanceof Boolean) {
                        return (Boolean)o;
                    }
                }
                catch (Exception ex) {
                    Trace.ignored(ex);
                }
                return Boolean.FALSE;
            }
        });
    }

    /*
     * Exception decompiling
     */
    protected static boolean add(KeyStore ks, String key, Certificate cert, String loc, boolean tsFlag) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[DOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static boolean contains(KeyStore ks, Certificate cert, String loc, boolean tsFlag) {
        String[] existing = CertUtils.getExistingAliases(ks, cert);
        if (existing != null) {
            for (int i = 0; i < existing.length; ++i) {
                String alias = existing[i];
                if (!CertUtils.matchingAlias(alias, loc)) continue;
                if (tsFlag) {
                    if (alias.indexOf(TSFLAG) < 0) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    private static String[] getExistingAliases(KeyStore ks, Certificate cert) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Enumeration<String> e = ks.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                if (!cert.equals(ks.getCertificate(alias))) continue;
                list.add(alias);
            }
        }
        catch (KeyStoreException kse) {
            Trace.ignored(kse);
        }
        return list.toArray(new String[0]);
    }

    private static boolean matchingAlias(String alias, String loc) {
        if (alias.indexOf(LOCFLAG) < 0) {
            return true;
        }
        return alias.indexOf(LOCFLAG + loc) >= 0;
    }

    private static void byte2hex(byte b, StringBuffer buf) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        buf.append(hexChars[high]);
        buf.append(hexChars[low]);
    }

    private static String getSecureHash(String algorithm, byte[] input) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            Trace.ignored(e);
            return "";
        }
        byte[] digest = md.digest(input);
        StringBuffer output = new StringBuffer();
        for (int i = 0; i < digest.length; ++i) {
            CertUtils.byte2hex(digest[i], output);
        }
        return output.toString();
    }

    static String getCertificateFingerPrint(String mdAlg, X509Certificate cert) {
        byte[] input = null;
        try {
            input = cert.getEncoded();
        }
        catch (CertificateEncodingException e) {
            Trace.ignored(e);
            return "";
        }
        String fingerPrint = CertUtils.getSecureHash(mdAlg, input);
        Trace.println(mdAlg + "Certificate finger print: " + fingerPrint, TraceLevel.SECURITY);
        return fingerPrint;
    }

    public static String getMainCertHash(Certificate[] certs, String algorithm) {
        if (certs != null && certs.length > 0 && certs[0] instanceof X509Certificate) {
            if (algorithm == null) {
                algorithm = "SHA-256";
            }
            return CertUtils.getCertificateFingerPrint(algorithm, (X509Certificate)certs[0]);
        }
        return "0";
    }

    public static String getSecureHashForString(String input) {
        return CertUtils.getSecureHash("SHA-256", input.getBytes());
    }

    static String hashToAlias(String base64String) {
        StringBuffer sb = new StringBuffer();
        char[] chars = base64String.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = base64String.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append('#');
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

