/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertificateInfo;
import com.sun.deploy.security.HexDumpEncoderWrapper;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.JHighDPITable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;

public class CertificateDialog {
    public static void showCertificates(JDialog parent, Certificate[] certs, int start, int end) {
        final JDialog details = new JDialog(parent, ResourceManager.getString("cert.dialog.caption"), true);
        details.getContentPane().setLayout(new BorderLayout());
        details.getContentPane().add((Component)CertificateDialog.getComponents(parent, certs, start, end), "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(4));
        JButton closeButton = new JButton(CertificateDialog.getMessage("cert.dialog.close"));
        closeButton.setMnemonic(ResourceManager.getMnemonic("cert.dialog.close"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                details.setVisible(false);
            }
        });
        buttonPanel.add(closeButton);
        details.getContentPane().add((Component)buttonPanel, "South");
        details.pack();
        details.setLocationRelativeTo(parent);
        details.setResizable(false);
        if (parent != null && parent.isAlwaysOnTop()) {
            details.setAlwaysOnTop(true);
        }
        if (!Trace.isAutomationEnabled()) {
            details.setVisible(true);
        }
    }

    private static JPanel getComponents(JDialog parent, Certificate[] certs, int start, int end) {
        if (certs.length > start && certs[start] instanceof X509Certificate) {
            final JHighDPITable certInfoTable = new JHighDPITable();
            final JTextArea textArea = new JTextArea();
            Border etchBorder = BorderFactory.createEtchedBorder();
            final JTree certChainTree = CertificateDialog.buildCertChainTree(certs, start, end);
            certChainTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)certChainTree.getLastSelectedPathComponent();
                    if (node != null) {
                        CertificateInfo certInfo = (CertificateInfo)node.getUserObject();
                        CertificateDialog.showCertificateInfo(certInfo.getCertificate(), certInfoTable, textArea);
                    }
                }
            });
            CertificateDialog.showCertificateInfo((X509Certificate)certs[start], certInfoTable, textArea);
            certInfoTable.setSelectionMode(0);
            ListSelectionModel rowSM = certInfoTable.getSelectionModel();
            rowSM.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int row = certInfoTable.getSelectedRow();
                    if (row >= 0) {
                        String value = (String)certInfoTable.getValueAt(row, 1);
                        textArea.setText(value);
                        textArea.repaint();
                    }
                }
            });
            textArea.setLineWrap(false);
            textArea.setEditable(false);
            textArea.setRows(10);
            textArea.setColumns(40);
            Font f = ResourceManager.getUIFont();
            Font fixedWidthFont = new Font("Monospaced", 0, f.getSize());
            textArea.setFont(fixedWidthFont);
            int fontHeight = f.getSize();
            certInfoTable.setRowSelectionInterval(9, 9);
            JPanel panelInfo = new JPanel();
            panelInfo.setLayout(new BorderLayout());
            Dimension dim = certInfoTable.getPreferredScrollableViewportSize();
            dim.setSize(dim.getWidth(), 200.0);
            certInfoTable.setPreferredScrollableViewportSize(dim);
            JScrollPane scrollPane = new JScrollPane(certInfoTable);
            scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0), scrollPane.getBorder()));
            panelInfo.add((Component)scrollPane, "Center");
            panelInfo.add((Component)new JScrollPane(textArea), "South");
            panelInfo.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            dim = certChainTree.getPreferredScrollableViewportSize();
            dim.setSize(200.0, 100.0);
            scrollPane = new JScrollPane(certChainTree);
            scrollPane.setPreferredSize(dim);
            panel.add((Component)scrollPane, "West");
            panel.add((Component)panelInfo, "East");
            return panel;
        }
        return new JPanel();
    }

    private static String formatDNString(String dnString) {
        int len = dnString.length();
        boolean last = false;
        boolean inQuote = false;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            char ch = dnString.charAt(i);
            if (ch == '\"' || ch == '\'') {
                boolean bl = inQuote = !inQuote;
            }
            if (ch == ',' && !inQuote) {
                buffer.append(",\n");
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    private static JTree buildCertChainTree(Certificate[] cert, int start, int end) {
        DefaultMutableTreeNode root = null;
        DefaultMutableTreeNode currentNode = null;
        for (int i = start; i < cert.length && i < end; ++i) {
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(new CertificateInfo((X509Certificate)cert[i]));
            if (root == null) {
                root = childNode;
                currentNode = childNode;
                continue;
            }
            currentNode.add(childNode);
            currentNode = childNode;
        }
        JHighDPITree tree = new JHighDPITree(root);
        DefaultTreeCellRenderer noHTMLRenderer = new DefaultTreeCellRenderer();
        noHTMLRenderer.putClientProperty("html.disable", Boolean.TRUE);
        tree.setCellRenderer(noHTMLRenderer);
        tree.getSelectionModel().setSelectionMode(1);
        tree.putClientProperty("JTree.lineStyle", "Angled");
        return tree;
    }

    private static void byte2hex(byte b, StringBuffer buf) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        buf.append(hexChars[high]);
        buf.append(hexChars[low]);
    }

    private static String toHexString(byte[] block) {
        StringBuffer buf = new StringBuffer();
        int len = block.length;
        for (int i = 0; i < len; ++i) {
            CertificateDialog.byte2hex(block[i], buf);
            if (i >= len - 1) continue;
            buf.append(":");
        }
        return buf.toString();
    }

    private static String getCertFingerPrint(String mdAlg, X509Certificate cert) throws Exception {
        byte[] encCertInfo = cert.getEncoded();
        MessageDigest md = MessageDigest.getInstance(mdAlg);
        byte[] digest = md.digest(encCertInfo);
        return CertificateDialog.toHexString(digest);
    }

    private static void showCertificateInfo(X509Certificate cert, JTable certInfoTable, JTextArea textArea) {
        String certVersion = "V" + cert.getVersion();
        Object certSerialNumber = "[xxxxx-xxxxx]";
        String md5 = null;
        String sha1 = null;
        String sha256 = null;
        try {
            certSerialNumber = "[" + cert.getSerialNumber() + "]";
            md5 = CertificateDialog.getCertFingerPrint("MD5", cert);
            sha1 = CertificateDialog.getCertFingerPrint("SHA1", cert);
            sha256 = CertificateDialog.getCertFingerPrint("SHA-256", cert);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String certSigAlg = "[" + cert.getSigAlgName() + "]";
        String certIssuer = CertificateDialog.formatDNString(cert.getIssuerDN().toString());
        String certValidity = "[From: " + cert.getNotBefore() + ",\n To: " + cert.getNotAfter() + "]";
        String certSubject = CertificateDialog.formatDNString(cert.getSubjectDN().toString());
        String certSig = HexDumpEncoderWrapper.encodeBuffer(cert.getSignature());
        Object[][] data = new Object[][]{{CertificateDialog.getMessage("cert.dialog.field.Version"), certVersion}, {CertificateDialog.getMessage("cert.dialog.field.SerialNumber"), certSerialNumber}, {CertificateDialog.getMessage("cert.dialog.field.SignatureAlg"), certSigAlg}, {CertificateDialog.getMessage("cert.dialog.field.Issuer"), certIssuer}, {CertificateDialog.getMessage("cert.dialog.field.Validity"), certValidity}, {CertificateDialog.getMessage("cert.dialog.field.Subject"), certSubject}, {CertificateDialog.getMessage("cert.dialog.field.Signature"), certSig}, {CertificateDialog.getMessage("cert.dialog.field.md5Fingerprint"), md5}, {CertificateDialog.getMessage("cert.dialog.field.sha1Fingerprint"), sha1}, {CertificateDialog.getMessage("cert.dialog.field.sha256Fingerprint"), sha256}};
        Object[] columnNames = new String[]{CertificateDialog.getMessage("cert.dialog.field"), CertificateDialog.getMessage("cert.dialog.value")};
        certInfoTable.setModel(new DefaultTableModel(data, columnNames){

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        });
        certInfoTable.setRowSelectionInterval(9, 9);
        certInfoTable.repaint();
        textArea.repaint();
    }

    private static String getMessage(String key) {
        return ResourceManager.getString(key);
    }

    private static class JHighDPITree
    extends JTree {
        private static final long serialVersionUID = 4268865244864861155L;

        public JHighDPITree(TreeNode root) {
            super(root);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            Dimension d = new JLabel("0").getPreferredSize();
            this.setRowHeight(d.height);
        }
    }
}

