/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.trace.Trace;
import java.io.IOException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import sun.security.validator.PKIXValidator;

final class DeployCertPathChecker
extends PKIXCertPathChecker {
    private int remainingCerts;
    private PKIXValidator pv;
    private static final String OID_BASIC_CONSTRAINTS = "2.5.29.19";
    private static final String OID_NETSCAPE_CERT_TYPE = "2.16.840.1.113730.1.1";
    private static final Set<String> extSet = Collections.singleton("2.16.840.1.113730.1.1");
    private static final String NSCT_OBJECT_SIGNING_CA = "object_signing_ca";
    private static final String NSCT_SSL_CA = "ssl_ca";
    private static final String NSCT_S_MIME_CA = "s_mime_ca";

    DeployCertPathChecker(PKIXValidator pv) {
        this.pv = pv;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void check(Certificate cert, Collection<String> unresCritExts) throws CertPathValidatorException {
        X509Certificate xcert = (X509Certificate)cert;
        String msg = null;
        if (unresCritExts != null && !unresCritExts.isEmpty()) {
            unresCritExts.remove(OID_NETSCAPE_CERT_TYPE);
        }
        --this.remainingCerts;
        if (this.remainingCerts == 0) {
            return;
        }
        try {
            if (xcert.getExtensionValue(OID_BASIC_CONSTRAINTS) != null) {
                if (xcert.getExtensionValue(OID_NETSCAPE_CERT_TYPE) == null) return;
                if (CertUtils.getNetscapeCertTypeBit(xcert, NSCT_OBJECT_SIGNING_CA)) return;
                Trace.msgSecurityPrintln("trustdecider.check.basicconstraints.bitvalue");
                msg = ResourceManager.getString("trustdecider.check.basicconstraints.bitvalue");
                throw new CertPathValidatorException(msg);
            }
            if (xcert.getExtensionValue(OID_NETSCAPE_CERT_TYPE) != null) {
                if (CertUtils.getNetscapeCertTypeBit(xcert, NSCT_OBJECT_SIGNING_CA)) return;
                Trace.msgSecurityPrintln("trustdecider.check.basicconstraints.certtypebit");
                msg = ResourceManager.getString("trustdecider.check.basicconstraints.certtypebit");
                throw new CertPathValidatorException(msg);
            }
            Trace.msgSecurityPrintln("trustdecider.check.basicconstraints.extensionvalue");
            msg = ResourceManager.getString("trustdecider.check.basicconstraints.extensionvalue");
            throw new CertPathValidatorException(msg);
        }
        catch (IOException ioe) {
            throw new CertPathValidatorException();
        }
        catch (CertificateException ce) {
            throw new CertPathValidatorException();
        }
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return extSet;
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return true;
    }

    @Override
    public void init(boolean forward) throws CertPathValidatorException {
        this.remainingCerts = this.pv.getCertPathLength();
    }
}

