/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.CredentialInfo;
import com.sun.deploy.security.ImmutableCertStore;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.TreeSet;

public final class DeploySigningCertStore
implements CertStore {
    private static String _userFilename = null;
    private static String _systemFilename = null;
    private static String _sandboxFilename = null;
    private long _userLastModified = 0L;
    private long _sysLastModified = 0L;
    private long _sandLastModified = 0L;
    private KeyStore _deploymentUserCerts = CertUtils.createEmptyKeyStore();
    private KeyStore _deploymentSystemCerts = CertUtils.createEmptyKeyStore();
    private KeyStore _deploymentSandboxCerts = CertUtils.createEmptyKeyStore();
    private char[] keyPassphrase = new char[0];
    private boolean cancelFlag = false;
    private int certStoreType = 0;

    private DeploySigningCertStore(int storeType) {
        this.certStoreType = storeType;
    }

    public static CertStore getCertStore() {
        return new ImmutableCertStore(new DeploySigningCertStore(3));
    }

    public static CertStore getUserCertStore() {
        return new DeploySigningCertStore(1);
    }

    public static CertStore getSystemCertStore() {
        return new ImmutableCertStore(new DeploySigningCertStore(2));
    }

    public static CertStore getSandboxCertStore() {
        return new DeploySigningCertStore(4);
    }

    public static boolean checkStoredCertificates(int storeType, int daysOld, boolean delete, boolean reset) {
        DeploySigningCertStore store = new DeploySigningCertStore(storeType);
        try {
            store.load();
            return store.checkCertificateTimestamps(daysOld, delete, reset);
        }
        catch (Exception e) {
            Trace.ignored(e);
            return false;
        }
    }

    @Override
    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        this.load(false);
    }

    @Override
    public void load(boolean integrityCheck) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        long lastModified;
        if ((this.certStoreType & 1) == 1 && _userFilename != null && (lastModified = CertUtils.getFileLastModified(_userFilename)) != this._userLastModified) {
            this._deploymentUserCerts = this.loadCertStore(_userFilename, integrityCheck);
            this._userLastModified = lastModified;
        }
        if ((this.certStoreType & 2) == 2 && _systemFilename != null && (lastModified = CertUtils.getFileLastModified(_systemFilename)) != this._sysLastModified) {
            this._deploymentSystemCerts = this.loadCertStore(_systemFilename, integrityCheck);
            this._sysLastModified = lastModified;
        }
        if ((this.certStoreType & 4) == 4 && _sandboxFilename != null && (lastModified = CertUtils.getFileLastModified(_sandboxFilename)) != this._sandLastModified) {
            this._deploymentSandboxCerts = this.loadCertStore(_sandboxFilename, integrityCheck);
            this._sandLastModified = lastModified;
        }
    }

    private boolean checkCertificateTimestamps(long daysOld, boolean delete, boolean reset) {
        KeyStore loadedKeyStore = null;
        if (this.certStoreType == 1) {
            loadedKeyStore = this._deploymentUserCerts;
        } else if (this.certStoreType == 4) {
            loadedKeyStore = this._deploymentSandboxCerts;
        } else {
            return false;
        }
        if (delete && reset) {
            return false;
        }
        Date currentDate = new Date();
        ArrayList<Object> aliases = new ArrayList();
        try {
            Enumeration<String> e = loadedKeyStore.aliases();
            if (daysOld == 0L && e.hasMoreElements()) {
                if (!delete && !reset) {
                    return true;
                }
                aliases = Collections.list(e);
            } else {
                while (e.hasMoreElements()) {
                    String alias = e.nextElement();
                    long l = loadedKeyStore.getCreationDate(alias).getTime();
                    if (currentDate.getTime() - l <= daysOld * 24L * 60L * 60L * 1000L) continue;
                    if (!delete && !reset) {
                        return true;
                    }
                    aliases.add(alias);
                }
            }
            for (String string : aliases) {
                if (delete) {
                    loadedKeyStore.deleteEntry(string);
                    continue;
                }
                Certificate cert = loadedKeyStore.getCertificate(string);
                loadedKeyStore.setCertificateEntry(string, cert);
            }
            if (!aliases.isEmpty()) {
                this.save();
                return true;
            }
        }
        catch (Exception e) {
            Trace.ignored(e);
        }
        return false;
    }

    private KeyStore loadCertStore(String filename, final boolean integrityCheck) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("deploycertstore.cert.loading", new Object[]{filename});
        final File file = new File(filename);
        final KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    if (file.exists()) {
                        FileInputStream fis = new FileInputStream(file);
                        BufferedInputStream bis = new BufferedInputStream(fis);
                        if (integrityCheck) {
                            DeploySigningCertStore.this.cancelFlag = false;
                            keyStore.load(bis, new char[0]);
                        } else {
                            keyStore.load(bis, null);
                        }
                        bis.close();
                        fis.close();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            if (ex instanceof IOException) {
                if (integrityCheck) {
                    FileInputStream fis = new FileInputStream(file);
                    BufferedInputStream bis = new BufferedInputStream(fis);
                    CredentialInfo passwordInfo = ToolkitStore.getUI().showPasswordDialog(null, ResourceManager.getString("password.dialog.title"), ResourceManager.getString("deploycertstore.password.dialog.text"), false, false, null, false, null);
                    if (passwordInfo != null) {
                        this.cancelFlag = false;
                        this.keyPassphrase = passwordInfo.getPassword();
                        keyStore.load(bis, this.keyPassphrase);
                    } else {
                        this.cancelFlag = true;
                    }
                    bis.close();
                    fis.close();
                }
                throw (IOException)ex;
            }
            if (ex instanceof CertificateException) {
                throw (CertificateException)ex;
            }
            if (ex instanceof KeyStoreException) {
                throw (KeyStoreException)ex;
            }
            if (ex instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)ex;
            }
            Trace.securityPrintException(e);
        }
        Trace.msgSecurityPrintln("deploycertstore.cert.loaded", new Object[]{filename});
        return keyStore;
    }

    @Override
    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        final String filename = this.certStoreType == 4 ? _sandboxFilename : _userFilename;
        final KeyStore ks = this.certStoreType == 4 ? this._deploymentSandboxCerts : this._deploymentUserCerts;
        Trace.msgSecurityPrintln("deploycertstore.cert.saving", new Object[]{filename});
        try {
            if (Platform.get().isNativeSandbox()) {
                File file = new File(filename);
                OutputStream os = Platform.get().getNativeSandboxBroker().getOutputStream(file, false);
                BufferedOutputStream bos = new BufferedOutputStream(os);
                ks.store(bos, this.keyPassphrase);
                bos.close();
                os.close();
            } else {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                        File file = new File(filename);
                        file.getParentFile().mkdirs();
                        FileOutputStream fos = new FileOutputStream(file);
                        BufferedOutputStream bos = new BufferedOutputStream(fos);
                        ks.store(bos, DeploySigningCertStore.this.keyPassphrase);
                        bos.close();
                        fos.close();
                        return null;
                    }
                });
            }
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof CertificateException) {
                throw (CertificateException)ex;
            }
            if (ex instanceof KeyStoreException) {
                throw (KeyStoreException)ex;
            }
            if (ex instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)ex;
            }
            Trace.securityPrintException(e);
        }
        Trace.msgSecurityPrintln("deploycertstore.cert.saved", new Object[]{filename});
    }

    @Override
    public boolean add(Certificate cert) throws KeyStoreException {
        return this.add(cert, null, false);
    }

    @Override
    public boolean add(Certificate cert, String loc, boolean tsFlag) throws KeyStoreException {
        KeyStore ks;
        String key;
        if (this.certStoreType == 4) {
            key = "deploymentsandboxcert";
            ks = this._deploymentSandboxCerts;
        } else {
            key = "deploymentusercert";
            ks = this._deploymentUserCerts;
        }
        return CertUtils.add(ks, key, cert, loc, tsFlag);
    }

    @Override
    public boolean remove(Certificate cert) throws IOException, KeyStoreException {
        if (this.cancelFlag) {
            return false;
        }
        Trace.msgSecurityPrintln("deploycertstore.cert.removing");
        KeyStore ks = this.certStoreType == 4 ? this._deploymentSandboxCerts : this._deploymentUserCerts;
        String alias = ks.getCertificateAlias(cert);
        if (alias != null) {
            ks.deleteEntry(alias);
        }
        Trace.msgSecurityPrintln("deploycertstore.cert.removed", new Object[]{alias});
        return true;
    }

    @Override
    public boolean contains(Certificate cert) throws KeyStoreException {
        return this.contains(cert, null, false);
    }

    @Override
    public boolean contains(Certificate cert, String loc, boolean tsFlag) throws KeyStoreException {
        if (this.certStoreType == 4) {
            return CertUtils.contains(this._deploymentSandboxCerts, cert, loc, tsFlag);
        }
        return CertUtils.contains(this._deploymentUserCerts, cert, loc, tsFlag) || CertUtils.contains(this._deploymentSystemCerts, cert, loc, tsFlag);
    }

    @Override
    public boolean verify(Certificate cert) {
        Trace.msgSecurityPrintln("deploycertstore.cert.canverify");
        return false;
    }

    @Override
    public Collection<X509Certificate> getCertificates() throws KeyStoreException {
        HashSet<X509Certificate> deploySigningCerts = new HashSet<X509Certificate>();
        if ((this.certStoreType & 1) == 1) {
            deploySigningCerts.addAll(this.getCertificates(1));
        }
        if ((this.certStoreType & 2) == 2) {
            deploySigningCerts.addAll(this.getCertificates(2));
        }
        if ((this.certStoreType & 4) == 4) {
            deploySigningCerts.addAll(this.getCertificates(4));
        }
        return deploySigningCerts;
    }

    private Collection<X509Certificate> getCertificates(int myCertStoreType) throws KeyStoreException {
        Trace.msgSecurityPrintln("deploycertstore.cert.getcertificates");
        ArrayList<X509Certificate> certCollection = new ArrayList<X509Certificate>();
        KeyStore ks = null;
        ks = myCertStoreType == 4 ? this._deploymentSandboxCerts : (myCertStoreType == 1 ? this._deploymentUserCerts : this._deploymentSystemCerts);
        Enumeration<String> keyAliases = ks.aliases();
        TreeSet<String> tsCerts = new TreeSet<String>();
        while (keyAliases.hasMoreElements()) {
            String alias = keyAliases.nextElement();
            tsCerts.add(alias);
        }
        for (String sortAlias : tsCerts) {
            X509Certificate cert = (X509Certificate)ks.getCertificate(sortAlias);
            certCollection.add(cert);
        }
        return certCollection;
    }

    static {
        _userFilename = Config.getUserTrustedCertificateFile();
        _systemFilename = Config.getSystemTrustedCertificateFile();
        _sandboxFilename = Config.getSandboxTrustedCertificateFile();
    }
}

