/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CachedJarFile;
import com.sun.deploy.config.Config;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.security.DeployURLClassPathCallback;
import com.sun.deploy.security.InvalidLoader;
import com.sun.deploy.security.JarIndexWrapper;
import com.sun.deploy.security.Resource;
import com.sun.deploy.security.URLClassPathControl;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.DeployJavaUtilJarAccess;
import com.sun.deploy.util.SystemPropertyUtil;
import com.sun.deploy.util.URLUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import sun.net.www.ParseUtil;

public class DeployURLClassPath {
    static final String USER_AGENT_JAVA_VERSION = "UA-Java-Version";
    static final String JAVA_VERSION = SystemPropertyUtil.getProperty("java.version");
    private static final boolean DEBUG;
    private static final boolean DEBUG2;
    private static boolean hasRealMetaIndex;
    private List<URL> path = new ArrayList<URL>();
    private Set<String> knownUrls = new HashSet<String>();
    final Stack<URL> urls = new Stack();
    List<Loader> loaders = new ArrayList<Loader>();
    Map<String, Loader> lmap = new HashMap<String, Loader>();
    private URLStreamHandler jarHandler;
    private DeployURLClassPathCallback cb;
    private boolean isShadowClassPath = false;

    private DeployURLClassPath(URL[] urls, URLStreamHandlerFactory factory) {
        this.path.addAll(Arrays.asList(urls));
        this.push(urls);
        if (factory != null) {
            this.jarHandler = factory.createURLStreamHandler("jar");
        }
    }

    public DeployURLClassPath(URL[] urls) {
        this(urls, null);
    }

    public DeployURLClassPath(DeployURLClassPath ucp) {
        this(ucp.getURLs());
    }

    public DeployURLClassPath(URL[] urls, boolean isShadow) {
        this(urls);
        this.isShadowClassPath = isShadow;
    }

    public String toString() {
        return "DeployURLClassPath{path=" + this.path + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addURL(URL url) {
        Stack<URL> stack = this.urls;
        synchronized (stack) {
            String u = URLUtil.toNormalizedString(url);
            if (this.knownUrls.contains(u)) {
                return;
            }
            this.knownUrls.add(u);
            this.urls.add(0, url);
            this.path.add(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] getURLs() {
        Stack<URL> stack = this.urls;
        synchronized (stack) {
            return this.path.toArray(new URL[this.path.size()]);
        }
    }

    public void setDeployURLClassPathCallback(DeployURLClassPathCallback cb) {
        this.cb = cb;
    }

    public URL findResource(String name, boolean check) {
        Loader loader;
        if (URLClassPathControl.isDisabledInCurrentThread()) {
            return null;
        }
        PathIterator pi = new PathIterator();
        while ((loader = this.getLoader(pi)) != null) {
            URL url = loader.findResource(name, check, pi);
            if (url != null) {
                return url;
            }
            pi.next();
        }
        return null;
    }

    public Resource getResource(String name, boolean check) {
        Loader loader;
        if (URLClassPathControl.isDisabledInCurrentThread()) {
            return null;
        }
        if (DEBUG2) {
            System.err.println("URLClassPath.getResource(\"" + name + "\")");
        }
        PathIterator pi = new PathIterator();
        while ((loader = this.getLoader(pi)) != null) {
            Resource res = loader.getResource(name, check, pi);
            if (res != null) {
                return res;
            }
            pi.next();
        }
        return null;
    }

    public Enumeration<URL> findResources(final String name, final boolean check) {
        if (URLClassPathControl.isDisabledInCurrentThread()) {
            return Collections.enumeration(Collections.emptyList());
        }
        return new Enumeration<URL>(){
            private PathIterator pi = new PathIterator();
            private URL url = null;

            private boolean next() {
                Loader loader;
                if (this.url != null) {
                    return true;
                }
                while ((loader = DeployURLClassPath.this.getLoader(this.pi)) != null) {
                    this.url = loader.findResource(name, check, this.pi);
                    this.pi.nextResource();
                    if (this.url == null) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next();
            }

            @Override
            public URL nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                URL u = this.url;
                this.url = null;
                return u;
            }
        };
    }

    public Resource getResource(String name) {
        return this.getResource(name, true);
    }

    public Enumeration<Resource> getResources(final String name, final boolean check) {
        if (URLClassPathControl.isDisabledInCurrentThread()) {
            return Collections.enumeration(Collections.emptyList());
        }
        return new Enumeration<Resource>(){
            PathIterator pi = new PathIterator();
            private Resource res = null;

            private boolean next() {
                Loader loader;
                if (this.res != null) {
                    return true;
                }
                while ((loader = DeployURLClassPath.this.getLoader(this.pi)) != null) {
                    this.res = loader.getResource(name, check, this.pi);
                    this.pi.nextResource();
                    if (this.res == null) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next();
            }

            @Override
            public Resource nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                Resource r = this.res;
                this.res = null;
                return r;
            }
        };
    }

    public Enumeration<Resource> getResources(String name) {
        return this.getResources(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Loader getLoader(PathIterator pi) {
        if (pi.found()) {
            return null;
        }
        while (this.loaders.size() < pi.index() + 1) {
            Loader loader;
            String urlNoFragString;
            block9: {
                URL url;
                Stack<URL> stack = this.urls;
                synchronized (stack) {
                    if (this.urls.empty()) {
                        return null;
                    }
                    url = this.urls.pop();
                }
                urlNoFragString = URLUtil.urlNoFragString(url);
                if (this.lmap.containsKey(urlNoFragString)) continue;
                try {
                    loader = this.getLoader(url);
                    URL[] nurls = loader.getClassPath();
                    if (nurls == null) break block9;
                    this.push(nurls);
                }
                catch (JARSigningException e) {
                    loader = new InvalidLoader(e, e.getLocation());
                }
                catch (IOException e) {
                    Trace.ignored(e);
                    continue;
                }
            }
            this.loaders.add(loader);
            this.lmap.put(urlNoFragString, loader);
        }
        return this.loaders.get(pi.index());
    }

    private Loader getLoader(final URL url) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Loader>(){

                @Override
                public Loader run() throws IOException {
                    String file = url.getFile();
                    if (file != null && file.endsWith("/")) {
                        if ("file".equals(url.getProtocol())) {
                            return new FileLoader(url);
                        }
                        return new UrlLoader(url);
                    }
                    return new JarLoader(url, DeployURLClassPath.this.jarHandler, DeployURLClassPath.this.lmap);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void push(URL[] us) {
        Stack<URL> stack = this.urls;
        synchronized (stack) {
            for (int i = us.length - 1; i >= 0; --i) {
                this.urls.push(us[i]);
            }
        }
    }

    public URL checkURL(URL url) {
        try {
            DeployURLClassPath.check(url);
        }
        catch (Exception e) {
            return null;
        }
        return url;
    }

    static void check(URL url) throws IOException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            URLConnection urlConnection = url.openConnection();
            Permission perm = URLUtil.getConnectPermission(url);
            if (perm != null) {
                try {
                    security.checkPermission(perm);
                }
                catch (SecurityException se) {
                    if (perm instanceof FilePermission && perm.getActions().indexOf("read") != -1) {
                        security.checkRead(perm.getName());
                    }
                    if (perm instanceof SocketPermission && perm.getActions().indexOf("connect") != -1) {
                        URL locUrl = url;
                        if (urlConnection instanceof JarURLConnection) {
                            locUrl = ((JarURLConnection)urlConnection).getJarFileURL();
                        }
                        security.checkConnect(locUrl.getHost(), locUrl.getPort());
                    }
                    throw se;
                }
            }
        }
    }

    public synchronized List<IOException> closeLoaders() {
        ArrayList<IOException> errors = new ArrayList<IOException>();
        for (Loader loader : this.lmap.values()) {
            try {
                if (loader == null) continue;
                loader.close();
            }
            catch (IOException ex) {
                errors.add(ex);
            }
        }
        this.lmap.clear();
        this.loaders.clear();
        return errors;
    }

    private String parseUtilEncodePath(String name, boolean flag) {
        try {
            return ParseUtil.encodePath(name, flag);
        }
        catch (NoSuchMethodError e) {
            return ParseUtil.encodePath(name);
        }
    }

    private static URL createBaseJarURL(URL jarURL, URLStreamHandler h) throws IOException {
        return new URL("jar", "", -1, jarURL + "!/", h);
    }

    static {
        DEBUG2 = SystemPropertyUtil.getProperty("sun.misc.URLClassPath.debug") != null;
        DEBUG = DEBUG2 || Config.getDebug();
        try {
            if (Class.forName("sun.misc.MetaIndex") != null) {
                hasRealMetaIndex = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private class FileLoader
    extends Loader {
        private File dir;

        FileLoader(URL url) throws IOException {
            super(url);
            if (!"file".equals(url.getProtocol())) {
                throw new IllegalArgumentException("url");
            }
            String path = url.getFile().replace('/', File.separatorChar);
            path = ParseUtil.decode(path);
            this.dir = new File(path).getCanonicalFile();
            if (DeployURLClassPath.this.cb != null) {
                this.cpe = DeployURLClassPath.this.cb.openClassPathElement(url);
                this.skip = this.cpe.skip();
                this.defer = this.cpe.defer();
            }
        }

        @Override
        URL findResource(String name, boolean check, PathIterator pi) {
            try {
                Resource rsc = this.getResource(name, check, pi);
                if (rsc != null) {
                    return rsc.getURL();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        @Override
        Resource getResource(final String name, boolean check, PathIterator pi) {
            File f;
            URL url;
            if (this.skip) {
                return null;
            }
            try {
                URL normalizedBase = new URL(this.getBaseURL(), ".");
                url = new URL(this.getBaseURL(), DeployURLClassPath.this.parseUtilEncodePath(name, false));
                if (!URLUtil.checkTargetURL(this.getBaseURL(), url)) {
                    throw new SecurityException("Permission denied: " + url);
                }
                if (!url.getFile().startsWith(normalizedBase.getFile())) {
                    return null;
                }
                if (check) {
                    DeployURLClassPath.check(url);
                }
                if (name.indexOf("..") != -1) {
                    f = new File(this.dir, name.replace('/', File.separatorChar)).getCanonicalFile();
                    if (!f.getPath().startsWith(this.dir.getPath())) {
                        return null;
                    }
                } else {
                    f = new File(this.dir, name.replace('/', File.separatorChar));
                }
                if (!f.exists()) {
                    return null;
                }
            }
            catch (Exception e) {
                return null;
            }
            if (DeployURLClassPath.this.cb != null) {
                if (this.defer) {
                    pi.found(true);
                    return null;
                }
                try {
                    this.cpe.checkResource(name);
                }
                catch (SecurityException se) {
                    Trace.println("resource name \"" + name + "\" in " + this.dir + " : " + se, TraceLevel.SECURITY);
                    throw se;
                }
            }
            final File file = f;
            return new Resource(){

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public URL getURL() {
                    return url;
                }

                @Override
                public URL getCodeSourceURL() {
                    return FileLoader.this.getBaseURL();
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return new FileInputStream(file);
                }

                @Override
                public int getContentLength() throws IOException {
                    return (int)file.length();
                }
            };
        }

        @Override
        void close() throws IOException {
        }
    }

    class JarLoader
    extends Loader {
        private JarFile jar;
        private URL csu;
        private URL redirectFinalBase;
        private JarIndexWrapper index;
        private URLStreamHandler handler;
        private Map<String, Loader> lmap;
        private Attributes mainAttributes;

        JarLoader(URL url, URLStreamHandler jarHandler, Map<String, Loader> loaderMap) throws IOException {
            super(DeployURLClassPath.createBaseJarURL(url, jarHandler));
            this.mainAttributes = null;
            this.csu = url;
            this.handler = jarHandler;
            this.lmap = loaderMap;
            this.ensureOpen();
        }

        JarFile getJarFile() {
            return this.jar;
        }

        private void ensureOpen() throws IOException {
            if (this.jar == null) {
                int current = ResourceProvider.get().incrementInternalUse();
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws IOException {
                            if (DEBUG) {
                                System.err.println("Opening jar " + JarLoader.this.csu);
                            }
                            JarLoader.this.jar = JarLoader.this.getJarFile(JarLoader.this.csu);
                            JarLoader.this.index = JarIndexWrapper.getJarIndex(JarLoader.this.jar);
                            if (JarLoader.this.index != null) {
                                String[] jarfiles = JarLoader.this.index.getJarFiles();
                                for (int i = 0; i < jarfiles.length; ++i) {
                                    try {
                                        URL jarURL = new URL(JarLoader.this.csu, jarfiles[i]);
                                        if (!URLUtil.checkTargetURL(JarLoader.this.csu, jarURL)) {
                                            throw new SecurityException("Permission denied: " + jarURL);
                                        }
                                        String urlNoFragString = URLUtil.urlNoFragString(jarURL);
                                        if (JarLoader.this.lmap.containsKey(urlNoFragString)) continue;
                                        JarLoader.this.lmap.put(urlNoFragString, null);
                                        continue;
                                    }
                                    catch (MalformedURLException e) {
                                        // empty catch block
                                    }
                                }
                            }
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw (IOException)pae.getException();
                }
                finally {
                    ResourceProvider.get().decrementInternalUse(current);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private JarFile getJarFile(URL url) throws IOException {
            JarFile jf;
            int level = ResourceProvider.get().incrementInternalUse();
            try {
                JarURLConnection uc = (JarURLConnection)this.getBaseURL().openConnection();
                uc.setRequestProperty(DeployURLClassPath.USER_AGENT_JAVA_VERSION, JAVA_VERSION);
                jf = uc.getJarFile();
            }
            finally {
                ResourceProvider.get().decrementInternalUse(level);
            }
            URL target = DownloadEngine.getKnownRedirectFinalURL(this.csu);
            if (!URLUtil.sameURLs(target, this.csu)) {
                this.csu = target;
                this.redirectFinalBase = DeployURLClassPath.createBaseJarURL(this.csu, this.handler);
            }
            if (DeployURLClassPath.this.cb != null) {
                this.cpe = DeployURLClassPath.this.cb.openClassPathElement(jf, this.csu);
                this.skip = this.cpe.skip();
                this.defer = this.cpe.defer();
            }
            return jf;
        }

        @Override
        URL getBaseURL() {
            if (this.redirectFinalBase != null) {
                return this.redirectFinalBase;
            }
            return super.getBaseURL();
        }

        JarIndexWrapper getIndex() {
            try {
                this.ensureOpen();
            }
            catch (IOException e) {
                throw (InternalError)new InternalError().initCause(e);
            }
            return this.index;
        }

        Resource checkResource(final String name, boolean check, final JarEntry entry, final JarFile jar, PathIterator pi) {
            URL url;
            try {
                String nm = name;
                JarEntry realEntry = entry;
                if (Config.isJavaVersionAtLeast9() && jar.isMultiRelease()) {
                    if (jar instanceof CachedJarFile) {
                        realEntry = (JarEntry)((CachedJarFile)jar).getRealEntry(name);
                    }
                    try {
                        nm = DeployJavaUtilJarAccess.instance().getRealName(jar, realEntry);
                    }
                    catch (Exception e) {
                        Trace.ignored(e);
                    }
                }
                url = new URL(this.getBaseURL(), DeployURLClassPath.this.parseUtilEncodePath(nm, false));
                if (!URLUtil.checkTargetURL(this.getBaseURL(), url)) {
                    throw new SecurityException("Permission denied: " + url);
                }
                if (check) {
                    DeployURLClassPath.check(url);
                }
            }
            catch (MalformedURLException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
            catch (AccessControlException e) {
                return null;
            }
            if (DeployURLClassPath.this.cb != null) {
                if (this.defer) {
                    pi.found(true);
                    return null;
                }
                try {
                    this.cpe.checkResource(name);
                }
                catch (SecurityException se) {
                    Trace.println("resource name \"" + name + "\" in " + this.csu + " : " + se, TraceLevel.SECURITY);
                    throw se;
                }
            }
            return new Resource(){

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public URL getURL() {
                    return url;
                }

                @Override
                public URL getCodeSourceURL() {
                    return JarLoader.this.csu;
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return jar.getInputStream(entry);
                }

                @Override
                public int getContentLength() {
                    return (int)entry.getSize();
                }

                @Override
                public Manifest getManifest() throws IOException {
                    return jar.getManifest();
                }

                @Override
                public Certificate[] getCertificates() {
                    return entry.getCertificates();
                }

                @Override
                public CodeSigner[] getCodeSigners() {
                    return entry.getCodeSigners();
                }
            };
        }

        @Override
        URL findResource(String name, boolean check, PathIterator pi) {
            try {
                Resource rsc = this.getResource(name, check, pi);
                if (rsc != null) {
                    return rsc.getURL();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        @Override
        Resource getResource(String name, boolean check, PathIterator pi) {
            if (this.skip) {
                return null;
            }
            try {
                this.ensureOpen();
            }
            catch (IOException e) {
                throw (InternalError)new InternalError().initCause(e);
            }
            JarEntry entry = this.jar.getJarEntry(name);
            if (entry != null) {
                return this.checkResource(name, check, entry, this.jar, pi);
            }
            if (this.index == null) {
                return null;
            }
            HashSet<String> visited = new HashSet<String>();
            return this.getResource(name, check, visited, pi);
        }

        Resource getResource(String name, boolean check, Set<String> visited, PathIterator pi) {
            int count = 0;
            LinkedList<String> jarFilesList = this.index.get(name);
            if (jarFilesList == null) {
                return null;
            }
            do {
                Object[] jarFiles = jarFilesList.toArray();
                int size = jarFilesList.size();
                while (count < size) {
                    Resource res;
                    boolean visitedURL;
                    JarLoader newLoader;
                    URL url;
                    block12: {
                        String jarName = (String)jarFiles[count++];
                        try {
                            url = new URL(this.csu, jarName);
                            if (!URLUtil.checkTargetURL(this.csu, url)) {
                                throw new SecurityException("Permission denied: " + url);
                            }
                            String urlNoFragString = URLUtil.urlNoFragString(url);
                            newLoader = (JarLoader)this.lmap.get(urlNoFragString);
                            if (newLoader != null) break block12;
                            newLoader = (JarLoader)AccessController.doPrivileged(new PrivilegedExceptionAction<Loader>(){

                                @Override
                                public Loader run() throws IOException {
                                    return new JarLoader(url, JarLoader.this.handler, JarLoader.this.lmap);
                                }
                            });
                            JarIndexWrapper newIndex = newLoader.getIndex();
                            if (newIndex != null) {
                                int pos = jarName.lastIndexOf("/");
                                newIndex.merge(this.index, pos == -1 ? null : jarName.substring(0, pos + 1));
                            }
                            this.lmap.put(urlNoFragString, newLoader);
                        }
                        catch (PrivilegedActionException pae) {
                            continue;
                        }
                        catch (MalformedURLException e) {
                            continue;
                        }
                    }
                    boolean bl = visitedURL = !visited.add(URLUtil.urlNoFragString(url));
                    if (!visitedURL) {
                        try {
                            newLoader.ensureOpen();
                        }
                        catch (IOException e) {
                            throw (InternalError)new InternalError().initCause(e);
                        }
                        JarEntry entry = newLoader.jar.getJarEntry(name);
                        if (entry != null) {
                            return newLoader.checkResource(name, check, entry, newLoader.jar, pi);
                        }
                    }
                    if (visitedURL || newLoader == this || newLoader.getIndex() == null || (res = newLoader.getResource(name, check, visited, pi)) == null) continue;
                    return res;
                }
            } while (count < (jarFilesList = this.index.get(name)).size());
            return null;
        }

        private synchronized Attributes getMainAttributes() throws IOException {
            if (this.mainAttributes == null) {
                this.ensureOpen();
                Manifest man = this.jar.getManifest();
                if (man == null) {
                    return null;
                }
                this.mainAttributes = man.getMainAttributes();
            }
            return this.mainAttributes;
        }

        @Override
        URL[] getClassPath() throws IOException {
            String value;
            Attributes attr;
            if (this.index != null) {
                return null;
            }
            this.ensureOpen();
            if (!DeployURLClassPath.this.isShadowClassPath && (attr = this.getMainAttributes()) != null && (value = attr.getValue("Extension-List")) != null && !value.isEmpty()) {
                Trace.msgPrintln("optpkg.unsupported", new Object[]{this.csu}, TraceLevel.BASIC);
            }
            if (DeployJavaUtilJarAccess.instance().jarFileHasClassPathAttribute(this.jar) ? (attr = this.getMainAttributes()) != null && (value = attr.getValue(Attributes.Name.CLASS_PATH)) != null : (attr = this.getMainAttributes()) != null && (value = attr.getValue(Attributes.Name.CLASS_PATH)) != null) {
                return this.parseClassPath(this.csu, value);
            }
            return null;
        }

        private URL[] parseClassPath(URL base, String value) throws MalformedURLException {
            StringTokenizer st = new StringTokenizer(value);
            URL[] urls = new URL[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                String path = st.nextToken();
                urls[i] = new URL(base, path);
                if (!URLUtil.checkTargetURL(base, urls[i])) {
                    throw new SecurityException("Permission denied: " + urls[i]);
                }
                ++i;
            }
            return urls;
        }

        @Override
        void close() throws IOException {
            this.jar = null;
        }
    }

    private class UrlLoader
    extends Loader {
        UrlLoader(URL url) throws IOException {
            super(url);
            if (DeployURLClassPath.this.cb != null) {
                this.cpe = DeployURLClassPath.this.cb.openClassPathElement(url);
                this.skip = this.cpe.skip();
                this.defer = this.cpe.defer();
            }
        }

        @Override
        URL findResource(String name, boolean check, PathIterator pi) {
            URL url;
            if (this.skip) {
                return null;
            }
            try {
                url = new URL(this.getBaseURL(), DeployURLClassPath.this.parseUtilEncodePath(name, false));
                if (!URLUtil.checkTargetURL(this.getBaseURL(), url)) {
                    throw new SecurityException("Permission denied: " + url);
                }
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("name");
            }
            try {
                URLConnection uc;
                if (check) {
                    DeployURLClassPath.check(url);
                }
                if ((uc = url.openConnection()) instanceof HttpURLConnection) {
                    HttpURLConnection hconn = (HttpURLConnection)uc;
                    hconn.setRequestMethod("HEAD");
                    if (hconn.getResponseCode() >= 400) {
                        return null;
                    }
                } else {
                    InputStream is = url.openStream();
                    is.close();
                }
                if (this.cpe != null) {
                    if (this.defer) {
                        pi.found(true);
                        return null;
                    }
                    this.cpe.checkResource(name);
                }
                return DownloadEngine.getKnownRedirectFinalURL(url);
            }
            catch (SecurityException se) {
                Trace.println("resource name \"" + name + "\" in " + url + " : " + se, TraceLevel.SECURITY);
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        Resource getResource(final String name, boolean check, PathIterator pi) {
            URLConnection uc;
            URL url;
            if (this.skip) {
                return null;
            }
            try {
                url = new URL(this.getBaseURL(), DeployURLClassPath.this.parseUtilEncodePath(name, false));
                if (!URLUtil.checkTargetURL(this.getBaseURL(), url)) {
                    throw new SecurityException("Permission denied: " + url);
                }
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("name");
            }
            try {
                if (check) {
                    DeployURLClassPath.check(url);
                }
                uc = url.openConnection();
                InputStream inputStream = uc.getInputStream();
            }
            catch (Exception e) {
                if (DEBUG) {
                    Trace.ignored(e);
                }
                return null;
            }
            if (DeployURLClassPath.this.cb != null) {
                if (this.defer) {
                    pi.found(true);
                    return null;
                }
                try {
                    this.cpe.checkResource(name);
                }
                catch (SecurityException se) {
                    Trace.println("resource name \"" + name + "\" in " + url + " : " + se, TraceLevel.SECURITY);
                    throw se;
                }
            }
            final boolean redirect = !URLUtil.sameURLs(url, uc.getURL());
            final URL targetURL = redirect ? uc.getURL() : DownloadEngine.getKnownRedirectFinalURL(url);
            return new Resource(){
                private InputStream in;

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public URL getURL() {
                    return targetURL;
                }

                @Override
                public URL getCodeSourceURL() {
                    return targetURL;
                }

                @Override
                public synchronized InputStream getInputStream() throws IOException {
                    if (this.in == null) {
                        this.in = redirect ? new BufferedInputStream(uc.getInputStream()){
                            boolean closeCalled;

                            @Override
                            public void close() throws IOException {
                                if (!this.closeCalled) {
                                    this.closeCalled = true;
                                    super.close();
                                    Cache.createRedirectEntry(url, uc.getURL(), null);
                                }
                            }
                        } : uc.getInputStream();
                    }
                    return this.in;
                }

                @Override
                public int getContentLength() throws IOException {
                    return uc.getContentLength();
                }
            };
        }

        @Override
        void close() throws IOException {
        }
    }

    static abstract class Loader {
        private final URL base;
        protected DeployURLClassPathCallback.Element cpe;
        protected boolean skip;
        protected boolean defer;

        Loader(URL url) {
            this.base = url;
        }

        URL getBaseURL() {
            return this.base;
        }

        URL[] getClassPath() throws IOException {
            return null;
        }

        abstract URL findResource(String var1, boolean var2, PathIterator var3);

        abstract Resource getResource(String var1, boolean var2, PathIterator var3);

        abstract void close() throws IOException;
    }

    static class PathIterator {
        int index;
        boolean found;

        PathIterator() {
        }

        int index() {
            return this.index;
        }

        void next() {
            ++this.index;
        }

        void nextResource() {
            ++this.index;
            this.found = false;
        }

        boolean found() {
            return this.found;
        }

        void found(boolean found) {
            this.found = found;
        }
    }
}

