/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.CodeSigner;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.Timestamp;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.pkcs.PKCS9Attributes;
import sun.security.pkcs.ParsingException;
import sun.security.pkcs.SignerInfo;
import sun.security.timestamp.TimestampToken;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;

public class JarSignature {
    public static final String BLOB_SIGNATURE = "META-INF/SIGNATURE.BSF";
    private final Signature sig;
    private final X509Certificate[] certChain;
    private final List<CodeSigner> codeSigners;
    private final SignerInfo[] signerInfos;

    public static JarSignature load(byte[] rawSignature) throws ParsingException, CertificateException, IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        PKCS7 pkcs7 = new PKCS7(rawSignature);
        pkcs7.verify(new byte[0]);
        SignerInfo[] infos = pkcs7.getSignerInfos();
        if (infos == null || infos.length != 1) {
            throw new IllegalArgumentException("BLOB signature currently only support single signer.");
        }
        X509Certificate cert = infos[0].getCertificate(pkcs7);
        PublicKey publicKey = cert.getPublicKey();
        List<CodeSigner> signers = JarSignature.extractCodeSigners(infos, pkcs7);
        Signature sig = JarSignature.getSignature(infos[0]);
        sig.initVerify(publicKey);
        return new JarSignature(sig, infos, signers);
    }

    public static JarSignature create(PrivateKey privateKey, X509Certificate[] chain) throws NoSuchAlgorithmException, InvalidKeyException {
        Signature signature = JarSignature.getSignature(privateKey.getAlgorithm());
        signature.initSign(privateKey);
        return new JarSignature(signature, chain);
    }

    private JarSignature(Signature signature, X509Certificate[] chain) {
        this.certChain = chain;
        this.signerInfos = null;
        this.codeSigners = null;
        this.sig = signature;
    }

    private JarSignature(Signature signature, SignerInfo[] infos, List<CodeSigner> signers) {
        this.certChain = null;
        this.signerInfos = infos;
        this.codeSigners = signers;
        this.sig = signature;
    }

    public boolean isValidationMode() {
        return this.certChain == null;
    }

    private static Signature getSignature(String keyAlgorithm) throws NoSuchAlgorithmException {
        if (keyAlgorithm.equalsIgnoreCase("DSA")) {
            return Signature.getInstance("SHA1withDSA");
        }
        if (keyAlgorithm.equalsIgnoreCase("RSA")) {
            return Signature.getInstance("SHA256withRSA");
        }
        if (keyAlgorithm.equalsIgnoreCase("EC")) {
            return Signature.getInstance("SHA256withECDSA");
        }
        throw new IllegalArgumentException("Key algorithm should be either DSA, RSA or EC");
    }

    private static Signature getSignature(SignerInfo info) throws NoSuchAlgorithmException {
        String digestAlgorithm = info.getDigestAlgorithmId().getName();
        String keyAlgorithm = info.getDigestEncryptionAlgorithmId().getName();
        String signatureAlgorithm = JarSignature.makeSigAlg(digestAlgorithm, keyAlgorithm);
        return Signature.getInstance(signatureAlgorithm);
    }

    String getSignatureAlgorithm() throws NoSuchAlgorithmException {
        return this.sig.getAlgorithm();
    }

    AlgorithmId getDigestAlgorithm() throws NoSuchAlgorithmException {
        String name = JarSignature.getDigAlgFromSigAlg(this.sig.getAlgorithm());
        return name != null ? AlgorithmId.get(name) : null;
    }

    AlgorithmId getKeyAlgorithm() throws NoSuchAlgorithmException {
        String name = JarSignature.getEncAlgFromSigAlg(this.sig.getAlgorithm());
        return name != null ? AlgorithmId.get(name) : null;
    }

    public byte[] getEncoded() throws NoSuchAlgorithmException, SignatureException, IOException {
        if (this.isValidationMode()) {
            throw new UnsupportedOperationException("Method is not for validation mode.");
        }
        AlgorithmId digestAlgId = this.getDigestAlgorithm();
        AlgorithmId[] digestAlgIds = new AlgorithmId[]{digestAlgId};
        ContentInfo contentInfo = new ContentInfo(ContentInfo.DATA_OID, null);
        Principal issuerName = this.certChain[0].getIssuerDN();
        BigInteger serialNumber = this.certChain[0].getSerialNumber();
        byte[] signature = this.sig.sign();
        SignerInfo signerInfo = new SignerInfo((X500Name)issuerName, serialNumber, digestAlgId, this.getKeyAlgorithm(), signature);
        SignerInfo[] signerInfos = new SignerInfo[]{signerInfo};
        PKCS7 pkcs7 = new PKCS7(digestAlgIds, contentInfo, this.certChain, signerInfos);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(8192);
        pkcs7.encodeSignedData(bos);
        return bos.toByteArray();
    }

    public InputStream updateWithZipEntry(String name, InputStream is) throws SignatureException {
        try {
            this.sig.update(name.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SignatureException(e);
        }
        return new ValidationStream(is);
    }

    public void update(byte[] v) throws SignatureException {
        this.sig.update(v);
    }

    public boolean isValid() {
        try {
            return this.sig.verify(this.signerInfos[0].getEncryptedDigest());
        }
        catch (Exception e) {
            if (Config.getDebug()) {
                Trace.ignored(e);
            }
            return false;
        }
    }

    public CodeSigner[] getCodeSigners() {
        return this.codeSigners.toArray(new CodeSigner[this.codeSigners.size()]);
    }

    private static List<CodeSigner> extractCodeSigners(SignerInfo[] infos, PKCS7 block) throws IOException, NoSuchAlgorithmException, SignatureException, CertificateException {
        ArrayList<CodeSigner> signers = new ArrayList<CodeSigner>();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
        for (SignerInfo info : infos) {
            ArrayList<X509Certificate> chain = info.getCertificateChain(block);
            CertPath certPath = certificateFactory.generateCertPath(chain);
            CodeSigner signer = new CodeSigner(certPath, JarSignature.getTimestamp(info, certificateFactory));
            signers.add(signer);
        }
        return signers;
    }

    private static Timestamp getTimestamp(SignerInfo info, CertificateFactory certificateFactory) throws IOException, NoSuchAlgorithmException, SignatureException, CertificateException {
        PKCS9Attribute timestampTokenAttr;
        Timestamp timestamp = null;
        PKCS9Attributes unsignedAttrs = info.getUnauthenticatedAttributes();
        if (unsignedAttrs != null && (timestampTokenAttr = unsignedAttrs.getAttribute("signatureTimestampToken")) != null) {
            PKCS7 timestampToken = new PKCS7((byte[])timestampTokenAttr.getValue());
            byte[] encodedTimestampTokenInfo = timestampToken.getContentInfo().getData();
            SignerInfo[] tsa = timestampToken.verify(encodedTimestampTokenInfo);
            ArrayList<X509Certificate> chain = tsa[0].getCertificateChain(timestampToken);
            CertPath tsaChain = certificateFactory.generateCertPath(chain);
            TimestampToken timestampTokenInfo = new TimestampToken(encodedTimestampTokenInfo);
            timestamp = new Timestamp(timestampTokenInfo.getDate(), tsaChain);
        }
        return timestamp;
    }

    private static String makeSigAlg(String digAlg, String encAlg) {
        if ((digAlg = digAlg.replace("-", "").toUpperCase(Locale.ENGLISH)).equalsIgnoreCase("SHA")) {
            digAlg = "SHA1";
        }
        if ((encAlg = encAlg.toUpperCase(Locale.ENGLISH)).equals("EC")) {
            encAlg = "ECDSA";
        }
        return digAlg + "with" + encAlg;
    }

    private static String getDigAlgFromSigAlg(String signatureAlgorithm) {
        int with = (signatureAlgorithm = signatureAlgorithm.toUpperCase(Locale.ENGLISH)).indexOf("WITH");
        if (with > 0) {
            return signatureAlgorithm.substring(0, with);
        }
        return null;
    }

    private static String getEncAlgFromSigAlg(String signatureAlgorithm) {
        int and;
        signatureAlgorithm = signatureAlgorithm.toUpperCase(Locale.ENGLISH);
        int with = signatureAlgorithm.indexOf("WITH");
        String keyAlgorithm = null;
        if (with > 0 && (keyAlgorithm = (and = signatureAlgorithm.indexOf("AND", with + 4)) > 0 ? signatureAlgorithm.substring(with + 4, and) : signatureAlgorithm.substring(with + 4)).equalsIgnoreCase("ECDSA")) {
            keyAlgorithm = "EC";
        }
        return keyAlgorithm;
    }

    private class ValidationStream
    extends InputStream {
        InputStream dataStream = null;

        public ValidationStream(InputStream is) {
            this.dataStream = is;
        }

        @Override
        public int read() throws IOException {
            int v;
            block3: {
                v = this.dataStream.read();
                if (v > -1) {
                    try {
                        JarSignature.this.sig.update((byte)v);
                    }
                    catch (SignatureException ex) {
                        if (!Config.getDebug()) break block3;
                        Trace.ignored(ex);
                    }
                }
            }
            return v;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            block3: {
                if ((len = this.dataStream.read(b, off, len)) > 0) {
                    try {
                        JarSignature.this.sig.update(b, off, len);
                    }
                    catch (SignatureException ex) {
                        if (!Config.getDebug()) break block3;
                        Trace.ignored(ex);
                    }
                }
            }
            return len;
        }

        @Override
        public void close() throws IOException {
            this.dataStream.close();
        }
    }
}

