/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security.ruleset;

import com.sun.deploy.ref.AppRef;
import com.sun.deploy.ref.CodeInstance;
import com.sun.deploy.ref.CodeRef;
import com.sun.deploy.security.ruleset.DRSResult;
import com.sun.deploy.security.ruleset.Rule;
import com.sun.deploy.security.ruleset.RuleSetParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DRSHelper {
    private final Rule[] rules;

    public DRSHelper(String xml) {
        this(new ByteArrayInputStream(xml.getBytes()));
    }

    public DRSHelper(InputStream is) {
        this.rules = new RuleSetParser().parse(is);
    }

    public Rule[] getRules() {
        if (this.rules != null) {
            return (Rule[])this.rules.clone();
        }
        return new Rule[0];
    }

    public Rule findRule(CodeInstance codeInstance) {
        return this.findRule(codeInstance.getAppRef(), codeInstance.getCodeRef());
    }

    public int findIndex(CodeInstance codeInstance) {
        return this.findIndex(codeInstance.getAppRef(), codeInstance.getCodeRef());
    }

    public Rule findRule(AppRef appRef, CodeRef codeRef) {
        for (int i = 0; i < this.rules.length; ++i) {
            if (!this.rules[i].getId().contains(appRef, codeRef)) continue;
            return this.rules[i];
        }
        return null;
    }

    public int findIndex(AppRef appRef, CodeRef codeRef) {
        for (int i = 0; i < this.rules.length; ++i) {
            if (!this.rules[i].getId().contains(appRef, codeRef)) continue;
            return i;
        }
        return -1;
    }

    public static DRSResult[] check(String xml, AppRef app, CodeRef[] code) {
        DRSResult[] results = new DRSResult[code.length];
        for (int i = 0; i < code.length; ++i) {
            results[i] = DRSHelper.check(xml, app, code[i]);
        }
        return results;
    }

    public static DRSResult check(String xml, AppRef app, CodeRef code) {
        try {
            DRSHelper helper = new DRSHelper(xml);
            return helper.check(app, code);
        }
        catch (Exception e) {
            return new DRSResult(e);
        }
    }

    public DRSResult check(AppRef app, CodeRef code) {
        for (int i = 0; i < this.rules.length; ++i) {
            if (!this.rules[i].getId().contains(app, code)) continue;
            return new DRSResult(this.rules[i].getAction(), i);
        }
        return new DRSResult();
    }
}

