/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security.ruleset;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.ruleset.Rule;
import com.sun.deploy.security.ruleset.RuleAction;
import com.sun.deploy.security.ruleset.RuleId;
import com.sun.deploy.security.ruleset.RuleParseException;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.GeneralUtil;
import com.sun.deploy.util.VersionID;
import com.sun.deploy.util.VersionString;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RuleSetParser
extends DefaultHandler {
    private List<Rule> ruleList = new ArrayList<Rule>();
    private String idTitle;
    private String idLocation;
    private String idCertAlgorithm;
    private String idCertHash;
    private String idChecksumAlgorithm;
    private String idChecksumHash;
    private String actionPerms;
    private String actionVersion;
    private boolean actionForced;
    private String actionMessage;
    private String drsVersion;
    private RuleAction actionRule;
    private ArrayList<String> idJnlpChecksum;
    private RuleId idRule;
    private boolean inRuleSet;
    private boolean inRule;
    private boolean inId;
    private boolean inMessage;
    private boolean inAction;
    private String customerStr;
    private String customerRecord;
    private String lastCharacters;

    public Rule[] parse(InputStream xmlIn) throws RuleParseException {
        Rule[] rules = new Rule[]{};
        SAXParserFactory spf = SAXParserFactory.newInstance("com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl", null);
        try {
            SAXParser sp = spf.newSAXParser();
            sp.parse(xmlIn, (DefaultHandler)this);
            rules = this.ruleList.toArray(new Rule[0]);
            if (this.drsVersion == null) {
                String msg = ResourceManager.getString("deployment.blocked.ruleset.spec.version", this.drsVersion);
                Trace.println("Deployment Rule Set parsing error: ruleset version required attribute missing.", TraceLevel.RULESET);
                throw new RuleParseException(msg, null, RuleParseException.REASON_INVALID_DRS_VERSION, 0);
            }
            VersionString version = new VersionString(this.drsVersion);
            if (!(version.contains(new VersionID("1.0")) || version.contains(new VersionID("1.1")) || version.contains(new VersionID("1.2")) || version.contains(new VersionID("1.3")))) {
                String msg = ResourceManager.getString("deployment.blocked.ruleset.spec.version", this.drsVersion);
                Trace.println("Deployment Rule Set parsing error: ruleset version: " + version + " not supported.", TraceLevel.RULESET);
                throw new RuleParseException(msg, null, RuleParseException.REASON_INVALID_DRS_VERSION, 0);
            }
        }
        catch (SAXException se) {
            Trace.println("exception parsing ruleset file: " + se, TraceLevel.RULESET);
            Trace.ignored(se);
            String msg = ResourceManager.getString("deployment.blocked.ruleset.exception");
            throw new RuleParseException(msg, (Throwable)se, RuleParseException.REASON_EXCEPTION, this.ruleList.size());
        }
        catch (ParserConfigurationException pce) {
            Trace.println("exception parsing ruleset file: " + pce, TraceLevel.RULESET);
            Trace.ignored(pce);
            String msg = ResourceManager.getString("deployment.blocked.ruleset.exception");
            throw new RuleParseException(msg, (Throwable)pce, RuleParseException.REASON_EXCEPTION, this.ruleList.size());
        }
        catch (IOException ioe) {
            Trace.println("exception parsing ruleset file: " + ioe, TraceLevel.RULESET);
            Trace.ignored(ioe);
            String msg = ResourceManager.getString("deployment.blocked.ruleset.exception");
            throw new RuleParseException(msg, (Throwable)ioe, RuleParseException.REASON_EXCEPTION, this.ruleList.size());
        }
        int len = rules.length;
        Trace.println("RuleSetParser.parse() returning " + len + " rules:", TraceLevel.RULESET);
        for (int i = 0; i < len; ++i) {
            Trace.println(rules[i].toString(), TraceLevel.RULESET);
        }
        return rules;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localeName, String elementName, Attributes attributes) throws SAXException {
        ArrayList<String> validAttributes = new ArrayList<String>();
        if (this.customerStr != null) {
            this.customerStr = this.customerStr + "<" + elementName;
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.customerStr = this.customerStr + " " + attributes.getQName(i) + "=\"" + attributes.getValue(i) + "\"";
            }
            this.customerStr = this.customerStr + ">";
        } else if (elementName.equalsIgnoreCase("ruleset")) {
            this.inRuleSet = true;
            this.drsVersion = attributes.getValue("version");
            validAttributes.add("version");
            validAttributes.add("href");
        } else if (elementName.equalsIgnoreCase("rule")) {
            if (!this.inRuleSet) {
                throw new SAXException("element " + elementName + " is invalid outsize of ruleset element.");
            }
            this.inRule = true;
            this.idRule = null;
            this.actionRule = null;
        } else if (elementName.equalsIgnoreCase("id")) {
            if (!this.inRule) {
                throw new SAXException("element " + elementName + " is invalid outsize of rule element.");
            }
            this.idLocation = attributes.getValue("location");
            validAttributes.add("location");
            this.idTitle = attributes.getValue("title");
            validAttributes.add("title");
            this.idCertHash = null;
            this.idCertAlgorithm = null;
            this.idChecksumHash = null;
            this.idChecksumAlgorithm = null;
            this.idJnlpChecksum = new ArrayList();
            this.inId = true;
        } else if (elementName.equalsIgnoreCase("action")) {
            if (!this.inRule) {
                throw new SAXException("element " + elementName + " is invalid outsize of rule element.");
            }
            this.inAction = true;
            this.actionPerms = attributes.getValue("permission");
            validAttributes.add("permission");
            if (!(this.actionPerms == null || this.actionPerms.equalsIgnoreCase("run") || this.actionPerms.equalsIgnoreCase("block") || this.actionPerms.equalsIgnoreCase("default"))) {
                throw new SAXException("value " + this.actionPerms + " is invalid value for permission attribute.");
            }
            this.actionVersion = attributes.getValue("version");
            validAttributes.add("version");
            if (!this.isValidJavaVersion(this.actionVersion)) {
                throw new SAXException("value " + this.actionVersion + " is invalid value for version attribute.");
            }
            boolean forced = "true".equalsIgnoreCase(attributes.getValue("force"));
            validAttributes.add("force");
            if (forced && this.actionVersion != null) {
                if (this.DRSVersionAtLeast11()) {
                    this.actionForced = true;
                } else {
                    Trace.println("WARNING: run rule version with force=true not used because DRS version is: " + this.drsVersion);
                }
            } else if (forced) {
                Trace.println("WARNING: run rule force set without version");
            }
        } else if (elementName.equalsIgnoreCase("certificate")) {
            if (!this.inId) throw new SAXException("element " + elementName + " is invalid outsize of id element.");
            this.idCertHash = attributes.getValue("hash");
            validAttributes.add("hash");
            if (this.idCertHash == null) {
                throw new SAXException("<certificate> element must have hash attribute.");
            }
            this.idCertHash = this.idCertHash.replaceAll(":", "");
            this.idCertAlgorithm = attributes.getValue("algorithm");
            validAttributes.add("algorithm");
        } else if (elementName.equalsIgnoreCase("checksum")) {
            if (!this.inId) throw new SAXException("element " + elementName + " is invalid outsize of id element.");
            if (!this.DRSVersionAtLeast12()) throw new SAXException("element " + elementName + " is invalid in DRS version " + this.drsVersion);
            this.idChecksumHash = attributes.getValue("hash");
            validAttributes.add("hash");
            if (this.idChecksumHash == null) {
                throw new SAXException("<checksum> element must have hash attribute.");
            }
            String algorithm = attributes.getValue("algorithm");
            if (algorithm == null || algorithm.equalsIgnoreCase("SHA-256")) {
                this.idChecksumAlgorithm = algorithm;
            } else {
                Trace.println("Warning: Unexpected value \"" + algorithm + "\" for algorithm attribute in element \"" + elementName + "\" found when processing the Deployment Rule Set.");
            }
            validAttributes.add("algorithm");
        } else if (elementName.equalsIgnoreCase("message")) {
            if (!this.DRSVersionAtLeast12() && !this.inAction) {
                throw new SAXException("element " + elementName + " is invalid outsize of action element.");
            }
            String locale = attributes.getValue("locale");
            validAttributes.add("locale");
            if (locale == null || GeneralUtil.matchLocale(locale, Locale.getDefault())) {
                this.inMessage = true;
            }
        } else if (elementName.equalsIgnoreCase("jnlp-checksum")) {
            if (!this.inId || this.idLocation == null) throw new SAXException("element " + elementName + " is invalid outsize of location based id element.");
            String hash = attributes.getValue("hash");
            validAttributes.add("hash");
            if (hash == null || this.idJnlpChecksum == null) throw new SAXException("<jnlp-checksum> element must have hash attribute.");
            this.idJnlpChecksum.add(hash);
        } else if (elementName.equalsIgnoreCase("customer")) {
            this.customerStr = this.getIndent() + "<" + elementName;
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.customerStr = this.customerStr + " " + attributes.getQName(i) + "=\"" + attributes.getValue(i) + "\"";
            }
            this.customerStr = this.customerStr + ">";
        } else {
            Trace.println("Warning: Unexpected element \"" + elementName + "\" found when processing the Deployment Rule Set.  This may cause all applications to be blocked in a future release.");
        }
        if (this.customerStr != null) return;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String qName = attributes.getQName(i);
            if (validAttributes.contains(qName)) continue;
            Trace.println("Warning: Unexpected attribute \"" + qName + "\" for element \"" + elementName + "\" found when processing the Deployment Rule Set.");
        }
    }

    private boolean DRSVersionAtLeast11() {
        VersionString version = new VersionString("1.1+");
        return version.contains(this.drsVersion);
    }

    private boolean DRSVersionAtLeast12() {
        VersionString version = new VersionString("1.2+");
        return version.contains(this.drsVersion);
    }

    @Override
    public void endElement(String uri, String localeName, String elementName) throws SAXException {
        this.lastCharacters = null;
        if (this.customerStr != null) {
            if (elementName.equalsIgnoreCase("customer")) {
                this.customerStr = this.customerStr + "</" + elementName + ">";
                Trace.println(this.customerStr);
                this.addCustomerRecord(this.customerStr);
                this.customerStr = null;
            } else {
                this.customerStr = this.customerStr + "</" + elementName + ">";
            }
        } else if (elementName.equalsIgnoreCase("ruleset")) {
            this.inRuleSet = false;
        } else if (elementName.equalsIgnoreCase("rule")) {
            if (this.inRule) {
                if (this.idRule == null || this.actionRule == null) {
                    throw new SAXException("<rule> element must have both <id> and <action> sub-elements.");
                }
                this.validateRule(this.idRule, this.actionRule, this.ruleList.size());
                Rule rule = new Rule(this.idRule, this.actionRule, this.customerRecord);
                this.idRule = null;
                this.actionRule = null;
                this.customerRecord = null;
                this.ruleList.add(rule);
            }
            this.inRule = false;
        } else if (elementName.equalsIgnoreCase("id")) {
            String[] jnlpChecksum = null;
            if (this.idJnlpChecksum != null && !this.idJnlpChecksum.isEmpty()) {
                jnlpChecksum = this.idJnlpChecksum.toArray(new String[0]);
            }
            this.idRule = new RuleId(this.idTitle, this.idLocation, this.idCertAlgorithm, this.idCertHash, this.idChecksumAlgorithm, this.idChecksumHash, jnlpChecksum);
            this.idLocation = null;
            this.idTitle = null;
            this.idCertHash = null;
            this.idCertAlgorithm = null;
            this.idChecksumHash = null;
            this.idChecksumAlgorithm = null;
            this.idJnlpChecksum = null;
            this.inId = false;
        } else if (elementName.equalsIgnoreCase("action")) {
            this.inAction = false;
            this.actionRule = new RuleAction(this.actionPerms, this.actionVersion, this.actionForced, this.actionMessage);
            this.actionPerms = null;
            this.actionVersion = null;
            this.actionMessage = null;
            this.actionForced = false;
        } else if (!elementName.equalsIgnoreCase("certificate") && elementName.equalsIgnoreCase("message")) {
            this.inMessage = false;
        }
    }

    @Override
    public void ignorableWhitespace(char[] chars, int start, int length) throws SAXException {
        this.characters(chars, start, length);
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        String s = new String(chars, start, length);
        if (this.inMessage) {
            this.actionMessage = this.actionMessage == null ? s : this.actionMessage + s;
        } else if (this.customerStr != null) {
            this.customerStr = this.customerStr + s;
        } else {
            this.lastCharacters = s;
        }
    }

    private String getIndent() {
        if (this.lastCharacters == null) {
            return "";
        }
        int i = this.lastCharacters.lastIndexOf("\n");
        return i >= 0 && i < this.lastCharacters.length() - 1 ? this.lastCharacters.substring(i + 1) : this.lastCharacters;
    }

    private void validateRule(RuleId id, RuleAction action, int ruleIndex) throws RuleParseException {
        int len;
        boolean invalidRule = false;
        int reason = RuleParseException.REASON_UNKNOWN;
        if (action.isRun() && id.location == null && id.certHash == null && id.checksumHash == null) {
            Trace.println("Deployment Rule Set invalid rule: run rule must must have either location, certificate, or checksum.", TraceLevel.RULESET);
            invalidRule = true;
            reason = RuleParseException.REASON_INVALID_RUN_RULE;
        }
        if (action.isDefault() && id.title != null && id.location == null && id.certHash == null && id.checksumHash == null) {
            Trace.println("Deployment Rule Set invalid rule: default rule with title must have either location, certificate, or checksum.", TraceLevel.RULESET);
            invalidRule = true;
            reason = RuleParseException.REASON_INVALID_DEFAULT_RULE;
        }
        if (this.actionRule.isRun() && this.idLocation != null && this.idRule.certHash == null && this.idRule.checksumHash == null && !this.idLocation.startsWith("https")) {
            Trace.println("It is recommended to use https protocol when defining a run rule based solely on location", TraceLevel.RULESET);
        }
        if (!invalidRule && id.certHash != null) {
            len = id.certHash.length();
            String hash = id.certHash;
            if (len == 0) {
                Trace.println("Deployment Rule Set invalid rule: certificate hash empty String.", TraceLevel.RULESET);
                invalidRule = true;
                reason = RuleParseException.REASON_INVALID_CERT_HASH;
            } else if ((id.certAlgorithm == null || id.certAlgorithm.equals("SHA-256")) && len != 64) {
                Trace.println("Deployment Rule Set invalid rule: certificate hash for SHA-256 not 64 characters.", TraceLevel.RULESET);
                invalidRule = true;
                reason = RuleParseException.REASON_INVALID_CERT_HASH;
            }
        }
        if (!invalidRule && id.checksumHash != null && (len = id.checksumHash.length()) == 0) {
            Trace.println("Deployment Rule Set invalid rule: checksum hash empty String.", TraceLevel.RULESET);
            invalidRule = true;
            reason = RuleParseException.REASON_INVALID_CHECKSUM_HASH;
        }
        if (!invalidRule && id.jnlpHash != null) {
            for (String hash : id.jnlpHash) {
                int len2 = hash.length();
                if (len2 != 0) continue;
                Trace.println("Deployment Rule Set invalid rule: jnlp-checksum hash empty String.", TraceLevel.RULESET);
                invalidRule = true;
                reason = RuleParseException.REASON_INVALID_CHECKSUM_HASH;
            }
        }
        if (!invalidRule && id.title != null) {
            len = id.title.length();
            if (len == 0) {
                Trace.println("Deployment Rule Set invalid rule: title is empty String", TraceLevel.RULESET);
                invalidRule = true;
                reason = RuleParseException.REASON_INVALID_TITLE;
            } else if (len > 140) {
                Trace.println("Deployment Rule Set invalid rule: title exceeds 140 characters.", TraceLevel.RULESET);
                invalidRule = true;
                reason = RuleParseException.REASON_INVALID_TITLE;
            }
        }
        if (!invalidRule && id.location != null) {
            len = id.location.length();
            if (len > 256) {
                Trace.println("Deployment Rule Set invalid rule: location exceeds 256 characters.", TraceLevel.RULESET);
                invalidRule = true;
                reason = RuleParseException.REASON_INVALID_LOCATION;
            } else {
                String protocol = null;
                int colonIx = id.location.indexOf("://");
                if (colonIx > 0) {
                    protocol = id.location.substring(0, colonIx);
                }
                if (!(protocol == null || "http".equals(protocol) || "https".equals(protocol) || "file".equals(protocol))) {
                    Trace.println("Deployment Rule Set invalid rule: location uses invalid protocol: " + protocol, TraceLevel.RULESET);
                    invalidRule = true;
                    reason = RuleParseException.REASON_INVALID_LOCATION;
                }
            }
        }
        if (invalidRule) {
            String msg = ResourceManager.getString("deployment.blocked.ruleset.invalid.rule");
            Trace.println(msg, TraceLevel.RULESET);
            throw new RuleParseException(msg, null, reason, ruleIndex);
        }
    }

    private boolean isValidJavaVersion(String version) {
        if (version == null) {
            return true;
        }
        if (version.equals("SECURE")) {
            return true;
        }
        if (version.startsWith("SECURE-")) {
            char majorVersion;
            String platform = version.substring("SECURE-".length());
            if (platform == null) {
                return false;
            }
            if (platform.equals("9") || platform.startsWith("9.")) {
                return true;
            }
            return platform.length() >= 3 && platform.startsWith("1.") && (majorVersion = platform.charAt(2)) >= '3' && majorVersion <= '8';
        }
        VersionString vs = new VersionString(version);
        return vs != null;
    }

    private void addCustomerRecord(String s) {
        this.customerRecord = this.customerRecord == null ? s : this.customerRecord + "\n" + s;
    }
}

