/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.si;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.si.DeploySIListener;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SafeThreadFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.ArrayList;

public class SingleInstanceImpl {
    public static final String SI_FILEDIR = Config.getTempDirectory() + File.separator + "si" + File.separator;
    public static final String SI_MAGICWORD = "javaws.singleinstance.init";
    public static final String SI_MAGICWORD_OPENPRINT = "javaws.singleinstance.init.openprint";
    public static final String SI_ACK = "javaws.singleinstance.ack";
    public static final String SI_STOP = "javaws.singleinstance.stop";
    public static final String SI_EOF = "EOF";
    private ArrayList<DeploySIListener> _sil_list = new ArrayList();
    private static boolean _serverStarted = false;
    private Object _lock = new Object();
    private SingleInstanceServer _sis;
    private static int DEFAULT_FILESIZE = Integer.MAX_VALUE;
    private static final SecureRandom random = new SecureRandom();
    private static int _randomNumber;

    public static String getSingleInstanceFilePrefix(String url) {
        String filePrefix = url.replace('/', '_');
        filePrefix = filePrefix.replace(':', '_');
        return filePrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSingleInstanceListener(DeploySIListener sil, String id) {
        if (sil == null) {
            return;
        }
        ArrayList<DeploySIListener> arrayList = this._lock;
        synchronized (arrayList) {
            if (!_serverStarted) {
                Trace.println("unique id: " + id, TraceLevel.BASIC);
                try {
                    String sessionID = id + Platform.get().getSessionSpecificString();
                    this._sis = new SingleInstanceServer(sessionID, this);
                    this._sis.start();
                }
                catch (Exception e) {
                    Trace.println("addSingleInstanceListener failed", TraceLevel.BASIC);
                    Trace.ignoredException(e);
                    return;
                }
                _serverStarted = true;
            }
        }
        arrayList = this._sil_list;
        synchronized (arrayList) {
            if (!this._sil_list.contains(sil)) {
                this._sil_list.add(sil);
            }
        }
    }

    public boolean isSame(String inputString, String idString) {
        return true;
    }

    public String[] getArguments(String inputString, String idString) {
        String[] ret = new String[]{inputString};
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSingleInstanceListener(DeploySIListener sil) {
        ArrayList<DeploySIListener> arrayList = this._sil_list;
        synchronized (arrayList) {
            Object jnlpsil = sil.getSingleInstanceListener();
            Object cursil = null;
            int index = -1;
            for (int i = 0; i < this._sil_list.size(); ++i) {
                cursil = this._sil_list.get(i).getSingleInstanceListener();
                if (!cursil.equals(jnlpsil)) continue;
                index = i;
                break;
            }
            if (index < 0 || index >= this._sil_list.size()) {
                return;
            }
            this._sil_list.remove(index);
            if (this._sil_list.isEmpty()) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        try {
                            Socket s_socket = new Socket("127.0.0.1", SingleInstanceImpl.this._sis.getPort());
                            OutputStream os = s_socket.getOutputStream();
                            byte[] encoding = new byte[]{1};
                            os.write(encoding);
                            String charset = Charset.defaultCharset().name();
                            PrintStream out = new PrintStream(os, true, charset);
                            out.println(_randomNumber);
                            out.println(SingleInstanceImpl.SI_STOP);
                            out.flush();
                            s_socket.close();
                            _serverStarted = false;
                        }
                        catch (IOException ioe) {
                            Trace.ignoredException(ioe);
                        }
                        return null;
                    }
                });
            }
        }
    }

    private class SingleInstanceServerRunnable
    implements Runnable {
        ServerSocket _ss;
        int _port;
        String _idString;
        String[] _arguments;
        SingleInstanceImpl _impl;

        int getPort() {
            return this._port;
        }

        SingleInstanceServerRunnable(String idString, SingleInstanceImpl impl) throws IOException {
            this._idString = idString;
            this._impl = impl;
            this._ss = null;
            this._ss = new ServerSocket(0, 0, InetAddress.getByName("127.0.0.1"));
            this._port = this._ss.getLocalPort();
            Trace.println("server port at: " + this._port, TraceLevel.BASIC);
            this.createSingleInstanceFile(this._idString, this._port);
        }

        private String getSingleInstanceFilename(String id, int port) {
            String name = SI_FILEDIR + SingleInstanceImpl.getSingleInstanceFilePrefix(id) + "_" + port;
            Trace.println("getSingleInstanceFilename: " + name, TraceLevel.BASIC);
            return name;
        }

        private void removeSingleInstanceFile(String id, int port) {
            new File(this.getSingleInstanceFilename(id, port)).delete();
            Trace.println("removed SingleInstanceFile: " + this.getSingleInstanceFilename(id, port), TraceLevel.BASIC);
        }

        private void createSingleInstanceFile(final String id, int port) {
            String filename = this.getSingleInstanceFilename(id, port);
            final File siFile = new File(filename);
            final File siDir = new File(SI_FILEDIR);
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    siDir.mkdirs();
                    String[] fList = siDir.list();
                    if (fList != null) {
                        for (int i = 0; i < fList.length; ++i) {
                            if (!fList[i].startsWith(SingleInstanceImpl.getSingleInstanceFilePrefix(id))) continue;
                            Trace.println("file should be removed: " + SI_FILEDIR + fList[i], TraceLevel.BASIC);
                            new File(SI_FILEDIR + fList[i]).delete();
                        }
                    }
                    try {
                        siFile.createNewFile();
                        siFile.deleteOnExit();
                        PrintStream out = new PrintStream(new FileOutputStream(siFile));
                        _randomNumber = random.nextInt();
                        out.print(_randomNumber);
                        out.close();
                    }
                    catch (IOException ioe) {
                        Trace.ignoredException(ioe);
                    }
                    return null;
                }
            });
        }

        boolean isSameInstance(String inputString) {
            if (this._impl.isSame(inputString, this._idString)) {
                this._arguments = this._impl.getArguments(inputString, this._idString);
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() {
                    while (true) {
                        InputStream is = null;
                        Socket s = null;
                        String line = null;
                        Object recvString = "";
                        boolean sendAck = false;
                        int port = -1;
                        String charset = null;
                        try {
                            Trace.println("waiting connection", TraceLevel.BASIC);
                            s = SingleInstanceServerRunnable.this._ss.accept();
                            is = s.getInputStream();
                            int encoding = is.read();
                            if (encoding == 1) {
                                charset = Charset.defaultCharset().name();
                            } else if (encoding == 2) {
                                charset = "UTF-16LE";
                            } else {
                                Trace.println("SingleInstanceImpl - unknown encoding", TraceLevel.BASIC);
                                Void void_ = null;
                                return void_;
                            }
                            BufferedReader in = new BufferedReader(new InputStreamReader(is, charset));
                            line = in.readLine();
                            if (!line.equals(String.valueOf(_randomNumber))) {
                                SingleInstanceServerRunnable.this.removeSingleInstanceFile(SingleInstanceServerRunnable.this._idString, SingleInstanceServerRunnable.this._port);
                                SingleInstanceServerRunnable.this._ss.close();
                                _serverStarted = false;
                                Trace.println("Unexpected Error, SingleInstanceService disabled", TraceLevel.BASIC);
                                Void ioe = null;
                                return ioe;
                            }
                            line = in.readLine();
                            Trace.println("recv: " + line, TraceLevel.BASIC);
                            if (line.equals(SingleInstanceImpl.SI_MAGICWORD)) {
                                Trace.println("got magic word!!!", TraceLevel.BASIC);
                                while (true) {
                                    try {
                                        while ((line = in.readLine()) == null || !line.equals(SingleInstanceImpl.SI_EOF)) {
                                            recvString = (String)recvString + line;
                                        }
                                    }
                                    catch (IOException ioe) {
                                        Trace.ignoredException(ioe);
                                        continue;
                                    }
                                    break;
                                }
                                Trace.println((String)recvString, TraceLevel.BASIC);
                                if (!SingleInstanceServerRunnable.this.isSameInstance((String)recvString)) continue;
                                sendAck = true;
                                continue;
                            }
                            if (line.equals(SingleInstanceImpl.SI_STOP)) {
                                SingleInstanceServerRunnable.this.removeSingleInstanceFile(SingleInstanceServerRunnable.this._idString, SingleInstanceServerRunnable.this._port);
                                break;
                            }
                            if (!line.equals(SingleInstanceImpl.SI_MAGICWORD_OPENPRINT)) continue;
                            int i = 0;
                            SingleInstanceServerRunnable.this._arguments = new String[2];
                            Trace.println("GOT OPENPRINT MAGICWORD", TraceLevel.BASIC);
                            for (int j = 0; j < 3; ++j) {
                                try {
                                    line = in.readLine();
                                    if (line != null && line.equals(SingleInstanceImpl.SI_EOF)) break;
                                    Trace.println(line, TraceLevel.BASIC);
                                    if (i >= 2) continue;
                                    SingleInstanceServerRunnable.this._arguments[i] = line;
                                    ++i;
                                    continue;
                                }
                                catch (IOException ioe) {
                                    Trace.ignoredException(ioe);
                                }
                            }
                            if (i == 2) {
                                SingleInstanceManager.setActionName(SingleInstanceServerRunnable.this._arguments[0]);
                                SingleInstanceManager.setOpenPrintFilePath(SingleInstanceServerRunnable.this._arguments[1]);
                            }
                            sendAck = true;
                            continue;
                        }
                        catch (IOException ioe) {
                            Trace.ignoredException(ioe);
                            continue;
                        }
                        finally {
                            try {
                                if (sendAck) {
                                    for (int i = 0; i < SingleInstanceServerRunnable.this._arguments.length; ++i) {
                                        Trace.println("Starting new instance with arguments: " + SingleInstanceServerRunnable.this._arguments[i], TraceLevel.BASIC);
                                    }
                                    ArrayList silal = (ArrayList)SingleInstanceImpl.this._sil_list.clone();
                                    for (DeploySIListener sil : silal) {
                                        sil.newActivation(SingleInstanceServerRunnable.this._arguments);
                                    }
                                    Trace.println("sending out ACK..", TraceLevel.BASIC);
                                    PrintStream ps = new PrintStream(s.getOutputStream(), true, charset);
                                    ps.println(SingleInstanceImpl.SI_ACK);
                                    ps.flush();
                                }
                                if (s == null) continue;
                                s.close();
                            }
                            catch (IOException ioe) {
                                Trace.ignoredException(ioe);
                            }
                            continue;
                        }
                        break;
                    }
                    return null;
                }
            });
        }
    }

    class SingleInstanceServer {
        private final SingleInstanceServerRunnable sisr;
        private final Thread thread;

        public SingleInstanceServer(SingleInstanceServerRunnable sisr) throws IOException {
            this.thread = SafeThreadFactory.createThread(sisr);
            this.thread.setDaemon(true);
            this.sisr = sisr;
        }

        public SingleInstanceServer(String idString, SingleInstanceImpl impl) throws IOException {
            this(this$0.new SingleInstanceServerRunnable(idString, impl));
        }

        int getPort() {
            return this.sisr.getPort();
        }

        public void start() {
            this.thread.start();
        }
    }
}

