/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.si;

import com.sun.deploy.config.Platform;
import com.sun.deploy.si.SingleInstanceImpl;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.Charset;

public class SingleInstanceManager {
    private static final boolean DEBUG = false;
    private static String _idString;
    private static int _currPort;
    private static String _randomNumberString;
    private static String _openPrintFilePath;
    private static String _actionName;
    static final int ENCODING_PLATFORM = 1;
    static final int ENCODING_UNICODE = 2;
    static final String ENCODING_PLATFORM_NAME = "UTF-8";
    static final String ENCODING_UNICODE_NAME = "UTF-16LE";

    public static void setActionName(String s) {
        if (s == null || s.equals("-open") || s.equals("-print")) {
            _actionName = s;
        }
    }

    public static String getActionName() {
        return _actionName;
    }

    public static void setOpenPrintFilePath(String s) {
        _openPrintFilePath = s;
    }

    public static String getOpenPrintFilePath() {
        return _openPrintFilePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isServerRunning(String idString) {
        File siDir = new File(SingleInstanceImpl.SI_FILEDIR);
        String[] fList = siDir.list();
        if (fList != null) {
            for (int i = 0; i < fList.length; ++i) {
                if (!fList[i].startsWith(SingleInstanceImpl.getSingleInstanceFilePrefix(idString + Platform.get().getSessionSpecificString()))) continue;
                try {
                    _currPort = Integer.parseInt(fList[i].substring(fList[i].lastIndexOf(95) + 1));
                }
                catch (NumberFormatException nfe) {
                    Trace.ignoredException(nfe);
                    return false;
                }
                Trace.println("server running at port: " + _currPort);
                File siFile = new File(SingleInstanceImpl.SI_FILEDIR, fList[i]);
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new FileReader(siFile));
                    _randomNumberString = br.readLine();
                }
                catch (IOException ioe) {
                    Trace.ignoredException(ioe);
                }
                finally {
                    try {
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException ioe) {
                        Trace.ignoredException(ioe);
                    }
                }
                _idString = idString;
                return true;
            }
        }
        return false;
    }

    public static boolean connectToServer(String outputString) {
        Trace.println("connect to: " + _idString + " " + _currPort, TraceLevel.TEMP);
        if (_randomNumberString == null) {
            Trace.println("MAGIC number is null, bail out", TraceLevel.TEMP);
            return false;
        }
        try {
            Socket s_socket = new Socket("127.0.0.1", _currPort);
            OutputStream os = s_socket.getOutputStream();
            byte[] encoding = new byte[]{1};
            os.write(encoding);
            String encodingName = Charset.defaultCharset().name();
            PrintStream out = new PrintStream(os, true, encodingName);
            BufferedReader br = new BufferedReader(new InputStreamReader(s_socket.getInputStream(), encodingName));
            out.println(_randomNumberString);
            String openPrintFilePath = SingleInstanceManager.getOpenPrintFilePath();
            String actionName = SingleInstanceManager.getActionName();
            if (openPrintFilePath != null && actionName != null) {
                out.println("javaws.singleinstance.init.openprint");
                out.println(actionName);
                out.println(openPrintFilePath);
            } else {
                out.println("javaws.singleinstance.init");
                out.println(outputString);
            }
            out.println("EOF");
            out.flush();
            Trace.println("waiting for ack", TraceLevel.TEMP);
            int tries = 5;
            for (int i = 0; i < tries; ++i) {
                String str = br.readLine();
                if (str == null || !str.equals("javaws.singleinstance.ack")) continue;
                Trace.println("GOT ACK", TraceLevel.TEMP);
                s_socket.close();
                return true;
            }
            s_socket.close();
        }
        catch (ConnectException ce) {
            Trace.println("no server is running - continue launch!", TraceLevel.TEMP);
            return false;
        }
        catch (SocketException se) {
            Trace.println("no server is running - continue launch!", TraceLevel.TEMP);
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
        Trace.println("no ACK from server, bail out", TraceLevel.TEMP);
        return false;
    }

    static {
        _randomNumberString = null;
        _openPrintFilePath = null;
        _actionName = null;
    }
}

