/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.trace;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.LoggerTraceListener;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class FileTraceListener
implements TraceListener {
    private static FileTraceListener sharedInstance;
    private File logFile;
    private PrintStream fileTraceStream;
    private boolean append;

    public static synchronized FileTraceListener getOrCreateSharedInstance(File traceFile, File defaultDir, String prefix, String suffix, boolean append, boolean replace) {
        if (sharedInstance == null || replace) {
            traceFile = LoggerTraceListener.ensureLogFileAvailable(traceFile, defaultDir, prefix, suffix);
            sharedInstance = new FileTraceListener(traceFile, append);
        }
        return sharedInstance;
    }

    public FileTraceListener(File logFile, boolean append) {
        this.append = append;
        this.logFile = logFile;
        this.init();
    }

    private void init() {
        try {
            this.fileTraceStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.logFile.getPath(), this.append)));
            SimpleDateFormat formatter = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
            this.print("Log started: " + formatter.format(new Date()) + "\n");
            this.print(Trace.getIntro());
        }
        catch (IOException fnfe) {
            fnfe.printStackTrace();
        }
    }

    @Override
    public void print(String msg) {
        try {
            if (this.logFile.length() >= (long)(Config.getIntProperty("deployment.max.output.file.size") * 0x100000)) {
                int c;
                this.fileTraceStream.close();
                File tempTraceFile = File.createTempFile("javaws", ".temp", this.logFile.getParentFile());
                long size = this.logFile.length() / 4L;
                BufferedReader in = new BufferedReader(new FileReader(this.logFile));
                BufferedWriter out = new BufferedWriter(new FileWriter(tempTraceFile));
                in.skip(size * 3L);
                while ((c = in.read()) != -1) {
                    out.write(c);
                }
                in.close();
                out.close();
                if (this.logFile.delete()) {
                    tempTraceFile.renameTo(this.logFile);
                    this.init();
                }
            }
            this.fileTraceStream.print(msg);
            this.fileTraceStream.flush();
        }
        catch (IOException fnfe) {
            fnfe.printStackTrace();
        }
    }

    @Override
    public void flush() {
    }
}

